/*
 * Decompiled with CFR 0.152.
 */
package ergo.util;

import ergo.util.ParseException;
import ergo.util.ParsedMessage;

public class Position {
    public int row;
    public int column;
    private String name;

    private Position() {
    }

    public Position(int n, int n2) {
        this.row = n;
        this.column = n2;
    }

    public void setPosition(int n, int n2) {
        this.row = n;
        this.column = n2;
    }

    public Position(String string, int n) throws ParseException {
        ParsedMessage parsedMessage = new ParsedMessage(string, " %c%i");
        char c = ((Character)parsedMessage.matchAt(0)).charValue();
        this.row = (Integer)parsedMessage.matchAt(1) - 1;
        this.column = c - (c < 'J' ? 65 : 66);
        if (this.row < 0 || this.column < 0 || this.row >= n || this.column >= n) {
            throw new ParseException("Position string not within bounds");
        }
    }

    public String toString() {
        if (this.name == null) {
            this.name = "" + (char)(65 + (this.column < 8 ? this.column : this.column + 1)) + (this.row + 1);
        }
        return this.name;
    }

    public boolean equals(Position position) {
        return this.row == position.row && this.column == position.column;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Position)) {
            return false;
        }
        return this.equals((Position)object);
    }

    public int hashCode() {
        return this.row + 1000 * this.column;
    }

    public static String asSGF(int n, int n2, int n3) {
        int n4 = n3 < 26 ? n3 + 97 : n3 - 26 + 65;
        int n5 = n - 1 - n2;
        n5 = n5 < 26 ? n5 + 97 : n5 - 26 + 65;
        return "[" + (char)n4 + (char)n5 + "]";
    }

    public String asSGF(int n) {
        return Position.asSGF(n, this.row, this.column);
    }
}

