/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui.dlg;

import ergo.Ergo;
import ergo.server.ServerConnection;
import ergo.ui.dlg.ErgoDialog;
import ergo.util.Debug;
import ergo.util.Util;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.unitarou.ml.Message;

public class MatchDialog
extends ErgoDialog
implements ActionListener {
    private static final Message LB_MATCH = new Message(class$ergo$ui$dlg$MatchDialog == null ? (class$ergo$ui$dlg$MatchDialog = MatchDialog.class$("ergo.ui.dlg.MatchDialog")) : class$ergo$ui$dlg$MatchDialog, "lbMatch");
    private static final Message LB_DONE = new Message(class$ergo$ui$dlg$MatchDialog == null ? (class$ergo$ui$dlg$MatchDialog = MatchDialog.class$("ergo.ui.dlg.MatchDialog")) : class$ergo$ui$dlg$MatchDialog, "lbDone");
    private static final Message LB_DECLINE = new Message(class$ergo$ui$dlg$MatchDialog == null ? (class$ergo$ui$dlg$MatchDialog = MatchDialog.class$("ergo.ui.dlg.MatchDialog")) : class$ergo$ui$dlg$MatchDialog, "lbDecline");
    private static final Message LB_BLACK = new Message(class$ergo$ui$dlg$MatchDialog == null ? (class$ergo$ui$dlg$MatchDialog = MatchDialog.class$("ergo.ui.dlg.MatchDialog")) : class$ergo$ui$dlg$MatchDialog, "lbBlack");
    private static final Message LB_WHITE = new Message(class$ergo$ui$dlg$MatchDialog == null ? (class$ergo$ui$dlg$MatchDialog = MatchDialog.class$("ergo.ui.dlg.MatchDialog")) : class$ergo$ui$dlg$MatchDialog, "lbWhite");
    private static final Message LB_NONE = new Message(class$ergo$ui$dlg$MatchDialog == null ? (class$ergo$ui$dlg$MatchDialog = MatchDialog.class$("ergo.ui.dlg.MatchDialog")) : class$ergo$ui$dlg$MatchDialog, "lbNone");
    private static final Message LB_OPPONENT_NAME = new Message(class$ergo$ui$dlg$MatchDialog == null ? (class$ergo$ui$dlg$MatchDialog = MatchDialog.class$("ergo.ui.dlg.MatchDialog")) : class$ergo$ui$dlg$MatchDialog, "lbOpponentName");
    private static final Message LB_MY_COLOR = new Message(class$ergo$ui$dlg$MatchDialog == null ? (class$ergo$ui$dlg$MatchDialog = MatchDialog.class$("ergo.ui.dlg.MatchDialog")) : class$ergo$ui$dlg$MatchDialog, "lbMyColor");
    private static final Message LB_BOARD_SIZE = new Message(class$ergo$ui$dlg$MatchDialog == null ? (class$ergo$ui$dlg$MatchDialog = MatchDialog.class$("ergo.ui.dlg.MatchDialog")) : class$ergo$ui$dlg$MatchDialog, "lbBoardSize");
    private static final Message LB_INITIAL_TIME = new Message(class$ergo$ui$dlg$MatchDialog == null ? (class$ergo$ui$dlg$MatchDialog = MatchDialog.class$("ergo.ui.dlg.MatchDialog")) : class$ergo$ui$dlg$MatchDialog, "lbInitialTime");
    private static final Message LB_MINUTES = new Message(class$ergo$ui$dlg$MatchDialog == null ? (class$ergo$ui$dlg$MatchDialog = MatchDialog.class$("ergo.ui.dlg.MatchDialog")) : class$ergo$ui$dlg$MatchDialog, "lbMinutes");
    private static final Message LB_BYO_YOMI = new Message(class$ergo$ui$dlg$MatchDialog == null ? (class$ergo$ui$dlg$MatchDialog = MatchDialog.class$("ergo.ui.dlg.MatchDialog")) : class$ergo$ui$dlg$MatchDialog, "lbByoYomi");
    private static final Message LB_KOMI = new Message(class$ergo$ui$dlg$MatchDialog == null ? (class$ergo$ui$dlg$MatchDialog = MatchDialog.class$("ergo.ui.dlg.MatchDialog")) : class$ergo$ui$dlg$MatchDialog, "lbKomi");
    private static final Message LB_HANDICAP = new Message(class$ergo$ui$dlg$MatchDialog == null ? (class$ergo$ui$dlg$MatchDialog = MatchDialog.class$("ergo.ui.dlg.MatchDialog")) : class$ergo$ui$dlg$MatchDialog, "lbHandicap");
    private ServerConnection conn = null;
    private Panel topPanel = new Panel();
    private Panel bottomPanel = new Panel();
    private TextField opponentName = new TextField(15);
    private TextField komi = new TextField("6.5", 5);
    private TextField initialTime = new TextField("15", 5);
    private TextField byoTime = new TextField("15", 5);
    private TextField size = new TextField("19", 5);
    private Button doneButton = new Button(LB_DONE.get());
    private Button cancelButton = new Button(LB_CANCEL.get());
    private Button declineButton = new Button(LB_DECLINE.get());
    private Choice myColor = new Choice();
    private Choice handicapChooser = new Choice();
    private String username = null;
    static /* synthetic */ Class class$ergo$ui$dlg$MatchDialog;

    public MatchDialog(Frame frame, boolean bl) {
        super(frame, LB_MATCH.get(), false);
        this.doneButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        if (bl) {
            this.declineButton.addActionListener(this);
        }
        this.myColor.addItem(LB_BLACK.get());
        this.myColor.addItem(LB_WHITE.get());
        for (int i = 0; i <= 9; ++i) {
            this.handicapChooser.addItem(i == 0 ? LB_NONE.get() : String.valueOf(i));
        }
        this.handicapChooser.select(0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.topPanel.setLayout(gridBagLayout);
        Label label = new Label(LB_OPPONENT_NAME.get());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = -1;
        gridBagLayout.setConstraints(this.opponentName, gridBagConstraints);
        this.topPanel.add(this.opponentName);
        label = new Label(LB_MY_COLOR.get());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.myColor, gridBagConstraints);
        this.topPanel.add(this.myColor);
        label = new Label(LB_BOARD_SIZE.get());
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.size, gridBagConstraints);
        this.topPanel.add(this.size);
        label = new Label(LB_INITIAL_TIME.get());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.initialTime, gridBagConstraints);
        this.topPanel.add(this.initialTime);
        label = new Label(LB_MINUTES.get());
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        label = new Label(LB_BYO_YOMI.get());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.byoTime, gridBagConstraints);
        this.topPanel.add(this.byoTime);
        label = new Label(LB_MINUTES.get());
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        label = new Label(LB_KOMI.get());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.komi, gridBagConstraints);
        this.topPanel.add(this.komi);
        this.komi.setEnabled(false);
        label = new Label(LB_HANDICAP.get());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.handicapChooser, gridBagConstraints);
        this.topPanel.add(this.handicapChooser);
        this.handicapChooser.setEnabled(false);
        this.add("North", this.topPanel);
        this.bottomPanel.setLayout(new FlowLayout(2));
        this.bottomPanel.add(this.doneButton);
        if (bl) {
            this.bottomPanel.add(this.declineButton);
        }
        this.bottomPanel.add(this.cancelButton);
        this.add("South", this.bottomPanel);
        if (Util.isWindows()) {
            this.setSize(350, 220);
        } else {
            this.pack();
        }
    }

    public Component getInitialFocus() {
        if (this.opponentName.getText().trim().equals("")) {
            return this.opponentName;
        }
        return this.doneButton;
    }

    public String matchCommandString() {
        return "match " + this.opponentName() + " " + this.myColor() + " " + this.boardSize() + " " + this.initialTime() + " " + this.byoTime();
    }

    public String cgobanTellString() {
        return "tell " + this.opponentName() + " CLIENT: <Ergo " + Ergo.version() + "> match " + this.username + " wants handicap " + this.handicap() + ", komi " + this.komi();
    }

    public void open(ServerConnection serverConnection) {
        this.open(serverConnection, null, null, null, null, null, null);
    }

    public void open(ServerConnection serverConnection, String string, String string2, String string3, String string4, String string5, String string6) {
        String string7;
        this.conn = serverConnection;
        this.username = string;
        if (string2 != null) {
            this.opponentName.setText(string2);
        }
        if (string3 != null) {
            string7 = string3.trim();
            this.myColor.select(string7.equals("B") ? 0 : 1);
        }
        if (string4 != null) {
            string7 = string4.trim();
            this.size.setText(string7);
        }
        if (string5 != null) {
            this.initialTime.setText(string5.trim());
        }
        if (string6 != null) {
            this.byoTime.setText(string6.trim());
        }
        this.open();
    }

    private String opponentName() {
        String string = this.opponentName.getText().trim();
        return string.length() == 0 ? "?" : string;
    }

    public void setOpponent(String string) {
        this.opponentName.setText(string);
    }

    private String myColor() {
        switch (this.myColor.getSelectedIndex()) {
            case 0: {
                return "B";
            }
            case 1: {
                return "W";
            }
        }
        Debug.assertion(false, "Unknown choice, index=" + this.myColor.getSelectedIndex());
        return "B";
    }

    private String komi() {
        String string = this.komi.getText().trim();
        return string.length() == 0 ? "6.5" : string;
    }

    public void setKomi(String string) {
        if (string != null) {
            this.komi.setText(string);
        }
    }

    private String handicap() {
        return String.valueOf(this.handicapChooser.getSelectedIndex());
    }

    public void setHandicap(int n) {
        this.handicapChooser.select(n);
    }

    private String boardSize() {
        return this.size.getText().trim();
    }

    private String initialTime() {
        String string = this.initialTime.getText().trim();
        return string.length() == 0 ? "15" : string;
    }

    private String byoTime() {
        String string = this.byoTime.getText().trim();
        return string.length() == 0 ? "15" : string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cancelButton) {
            this.close();
        } else if (object == this.doneButton) {
            this.close();
            if (this.conn != null) {
                this.conn.send(this.matchCommandString());
            }
        } else if (object == this.declineButton) {
            this.close();
            if (this.conn != null) {
                this.conn.send("decline " + this.opponentName());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

