/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui.dlg;

import ergo.Ergo;
import ergo.server.ServerConnection;
import ergo.ui.Optionizable;
import ergo.ui.TerminalWindow;
import ergo.ui.dlg.ErgoDialog;
import ergo.ui.dlg.InformDialog;
import ergo.util.Util;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.unitarou.ml.Message;

public class LoginDialog
extends ErgoDialog
implements ActionListener,
Optionizable {
    private static final Message LB_LOGIN_TO = new Message(class$ergo$ui$dlg$LoginDialog == null ? (class$ergo$ui$dlg$LoginDialog = LoginDialog.class$("ergo.ui.dlg.LoginDialog")) : class$ergo$ui$dlg$LoginDialog, "lbLoginTo");
    private static final Message LB_LOGIN_NAME = new Message(class$ergo$ui$dlg$LoginDialog == null ? (class$ergo$ui$dlg$LoginDialog = LoginDialog.class$("ergo.ui.dlg.LoginDialog")) : class$ergo$ui$dlg$LoginDialog, "lbLoginName");
    private static final Message LB_PASSWORD = new Message(class$ergo$ui$dlg$LoginDialog == null ? (class$ergo$ui$dlg$LoginDialog = LoginDialog.class$("ergo.ui.dlg.LoginDialog")) : class$ergo$ui$dlg$LoginDialog, "lbPassword");
    private static final Message LB_INVALID_LOGIN = new Message(class$ergo$ui$dlg$LoginDialog == null ? (class$ergo$ui$dlg$LoginDialog = LoginDialog.class$("ergo.ui.dlg.LoginDialog")) : class$ergo$ui$dlg$LoginDialog, "lbInvalidLogin");
    private static final Message MSG_INVALID_LOGIN = new Message(class$ergo$ui$dlg$LoginDialog == null ? (class$ergo$ui$dlg$LoginDialog = LoginDialog.class$("ergo.ui.dlg.LoginDialog")) : class$ergo$ui$dlg$LoginDialog, "MsgInvalidLogin");
    private static final Message MSG_ENTER_UN_PW = new Message(class$ergo$ui$dlg$LoginDialog == null ? (class$ergo$ui$dlg$LoginDialog = LoginDialog.class$("ergo.ui.dlg.LoginDialog")) : class$ergo$ui$dlg$LoginDialog, "MsgEnterUnPw");
    private static final String nameString = "Login name";
    private static final String passString = "Password name";
    private final TextField login = new TextField(16);
    private final TextField password = new TextField(16);
    private final Button okButton = new Button("   OK   ");
    private final Button cancelButton = new Button(LB_CANCEL.get());
    private final TerminalWindow window;
    private final ServerConnection conn;
    public boolean hecho = false;
    public boolean passwordSent = false;
    static /* synthetic */ Class class$ergo$ui$dlg$LoginDialog;

    public LoginDialog(TerminalWindow terminalWindow, ServerConnection serverConnection) {
        super((Frame)terminalWindow, LB_LOGIN_TO.get(serverConnection.shortName()), true, false);
        Insets insets;
        Ergo.opser.expressOwnership(nameString, 9, null, "");
        Ergo.opser.expressOwnership(passString, 9, null, "");
        Ergo.opser.expressOwnership("Current Option Set", 1, this, new Integer(0));
        this.window = terminalWindow;
        this.conn = serverConnection;
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.login.addActionListener(this);
        this.password.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LoginDialog.this.conn.close();
            }
        });
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        int n = 10;
        int n2 = 3;
        int n3 = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = insets = new Insets(2, n, 2, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        insets.top = n;
        insets.right = 0;
        this.makeIt(panel, gridBagLayout, gridBagConstraints, new Label(LB_LOGIN_NAME.get()));
        insets.right = n;
        insets.left = n2;
        gridBagConstraints.gridwidth = 0;
        this.makeIt(panel, gridBagLayout, gridBagConstraints, this.login);
        gridBagConstraints.gridwidth = 1;
        insets.top = n3;
        insets.left = n;
        insets.bottom = n;
        insets.right = 0;
        this.makeIt(panel, gridBagLayout, gridBagConstraints, new Label(LB_PASSWORD.get()));
        insets.right = n;
        insets.left = n2;
        gridBagConstraints.gridwidth = 0;
        this.makeIt(panel, gridBagLayout, gridBagConstraints, this.password);
        this.password.setEchoChar('*');
        this.add("Center", panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(2));
        panel2.add(this.okButton);
        panel2.add(this.cancelButton);
        this.add("South", panel2);
        this.fillFields();
        if (Util.isWindows()) {
            this.setSize(250, 125);
        } else {
            this.pack();
        }
    }

    private void fillFields() {
        this.login.setText(Ergo.opser.getStringOption(nameString));
        this.password.setText(Ergo.opser.getStringOption(passString));
    }

    public void optionEvent(String string, Object object) {
        if (Ergo.opser.isSameKey("Current Option Set", string)) {
            this.fillFields();
        }
    }

    void makeIt(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void finish() {
        this.hecho = true;
        this.window.setAccountName(this.login.getText());
        this.conn.send(this.login.getText());
        if (Ergo.opser.getBooleanOption("Save Login Name and Password")) {
            Ergo.opser.updateOption(nameString, this.login.getText());
            Ergo.opser.updateOption(passString, this.password.getText());
        } else {
            Ergo.opser.updateOption(nameString, "");
            Ergo.opser.updateOption(passString, "");
        }
        this.close();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = this.login.getText().length();
        int n2 = this.password.getText().length();
        if (object == this.cancelButton) {
            this.conn.close();
            this.close();
        } else if (object == this.okButton) {
            if (n == 0) {
                String[] stringArray = new String[]{MSG_INVALID_LOGIN.get(), MSG_ENTER_UN_PW.get()};
                new InformDialog((Frame)this.window, LB_INVALID_LOGIN.get(), 1, stringArray).open();
            } else {
                this.finish();
            }
        } else if (n == 0) {
            this.login.requestFocus();
        } else if (n2 == 0) {
            this.password.requestFocus();
        } else if (object == this.login) {
            this.password.requestFocus();
            this.password.selectAll();
        } else if (object == this.password) {
            this.finish();
        }
    }

    public String getPassword() {
        return this.password.getText();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

