/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui.dlg;

import ergo.ui.GameWindow;
import ergo.ui.TerminalWindow;
import ergo.ui.dlg.ErgoDialog;
import ergo.util.Util;
import java.awt.Button;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.unitarou.ml.Message;

public class LocalGameDialog
extends ErgoDialog
implements ActionListener {
    private static final Message LB_LOCAL_GAME = new Message(class$ergo$ui$dlg$LocalGameDialog == null ? (class$ergo$ui$dlg$LocalGameDialog = LocalGameDialog.class$("ergo.ui.dlg.LocalGameDialog")) : class$ergo$ui$dlg$LocalGameDialog, "lbLocalGame");
    private static final Message LB_WHITE = new Message(class$ergo$ui$dlg$LocalGameDialog == null ? (class$ergo$ui$dlg$LocalGameDialog = LocalGameDialog.class$("ergo.ui.dlg.LocalGameDialog")) : class$ergo$ui$dlg$LocalGameDialog, "lbWhite");
    private static final Message LB_BLACK = new Message(class$ergo$ui$dlg$LocalGameDialog == null ? (class$ergo$ui$dlg$LocalGameDialog = LocalGameDialog.class$("ergo.ui.dlg.LocalGameDialog")) : class$ergo$ui$dlg$LocalGameDialog, "lbBlack");
    private static final Message LB_DONE = new Message(class$ergo$ui$dlg$LocalGameDialog == null ? (class$ergo$ui$dlg$LocalGameDialog = LocalGameDialog.class$("ergo.ui.dlg.LocalGameDialog")) : class$ergo$ui$dlg$LocalGameDialog, "lbDone");
    private static final Message LB_TIMED = new Message(class$ergo$ui$dlg$LocalGameDialog == null ? (class$ergo$ui$dlg$LocalGameDialog = LocalGameDialog.class$("ergo.ui.dlg.LocalGameDialog")) : class$ergo$ui$dlg$LocalGameDialog, "lbTimed");
    private static final Message LB_UNTIMED = new Message(class$ergo$ui$dlg$LocalGameDialog == null ? (class$ergo$ui$dlg$LocalGameDialog = LocalGameDialog.class$("ergo.ui.dlg.LocalGameDialog")) : class$ergo$ui$dlg$LocalGameDialog, "lbUntimed");
    private static final Message LB_WHITE_PLAYER_NAME = new Message(class$ergo$ui$dlg$LocalGameDialog == null ? (class$ergo$ui$dlg$LocalGameDialog = LocalGameDialog.class$("ergo.ui.dlg.LocalGameDialog")) : class$ergo$ui$dlg$LocalGameDialog, "lbWhitePlayerName");
    private static final Message LB_BLACK_PLAYER_NAME = new Message(class$ergo$ui$dlg$LocalGameDialog == null ? (class$ergo$ui$dlg$LocalGameDialog = LocalGameDialog.class$("ergo.ui.dlg.LocalGameDialog")) : class$ergo$ui$dlg$LocalGameDialog, "lbBlackPlayerName");
    private static final Message LB_GAME_SIZE = new Message(class$ergo$ui$dlg$LocalGameDialog == null ? (class$ergo$ui$dlg$LocalGameDialog = LocalGameDialog.class$("ergo.ui.dlg.LocalGameDialog")) : class$ergo$ui$dlg$LocalGameDialog, "lbGameSize");
    private static final Message LB_KOME = new Message(class$ergo$ui$dlg$LocalGameDialog == null ? (class$ergo$ui$dlg$LocalGameDialog = LocalGameDialog.class$("ergo.ui.dlg.LocalGameDialog")) : class$ergo$ui$dlg$LocalGameDialog, "lbKome");
    private static final Message LB_GAME_WILL_BE = new Message(class$ergo$ui$dlg$LocalGameDialog == null ? (class$ergo$ui$dlg$LocalGameDialog = LocalGameDialog.class$("ergo.ui.dlg.LocalGameDialog")) : class$ergo$ui$dlg$LocalGameDialog, "lbGameWillBe");
    private static final Message LB_INITIAL_TIME_LIMIT = new Message(class$ergo$ui$dlg$LocalGameDialog == null ? (class$ergo$ui$dlg$LocalGameDialog = LocalGameDialog.class$("ergo.ui.dlg.LocalGameDialog")) : class$ergo$ui$dlg$LocalGameDialog, "lbInitialTimeLimit");
    private static final Message LB_BYO_YOMI_TIME = new Message(class$ergo$ui$dlg$LocalGameDialog == null ? (class$ergo$ui$dlg$LocalGameDialog = LocalGameDialog.class$("ergo.ui.dlg.LocalGameDialog")) : class$ergo$ui$dlg$LocalGameDialog, "lbByoYomiTime");
    private final TerminalWindow window;
    private final Panel topPanel = new Panel();
    private final Panel bottomPanel = new Panel();
    private final TextField whiteName = new TextField(LB_WHITE.get(), 15);
    private final TextField blackName = new TextField(LB_BLACK.get(), 15);
    private final TextField komi = new TextField("6.5", 5);
    private final TextField time = new TextField("15", 5);
    private final TextField byotime = new TextField("15", 5);
    private final TextField size = new TextField("19", 5);
    private final Button doneButton = new Button(LB_DONE.get());
    private final Button cancelButton = new Button(LB_CANCEL.get());
    private final Choice timingChooser = new Choice();
    static /* synthetic */ Class class$ergo$ui$dlg$LocalGameDialog;

    public LocalGameDialog(TerminalWindow terminalWindow) {
        super(terminalWindow, LB_LOCAL_GAME.get(), true);
        this.window = terminalWindow;
        this.doneButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.timingChooser.addItem(LB_TIMED.get());
        this.timingChooser.addItem(LB_UNTIMED.get());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.topPanel.setLayout(gridBagLayout);
        Label label = new Label(LB_WHITE_PLAYER_NAME.get());
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.whiteName, gridBagConstraints);
        this.topPanel.add(this.whiteName);
        label = new Label(LB_BLACK_PLAYER_NAME.get());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.blackName, gridBagConstraints);
        this.topPanel.add(this.blackName);
        label = new Label(LB_GAME_SIZE.get());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.size, gridBagConstraints);
        this.topPanel.add(this.size);
        label = new Label(LB_KOME.get());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.komi, gridBagConstraints);
        this.topPanel.add(this.komi);
        label = new Label(LB_GAME_WILL_BE.get());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.timingChooser, gridBagConstraints);
        this.topPanel.add(this.timingChooser);
        label = new Label(LB_INITIAL_TIME_LIMIT.get());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.time, gridBagConstraints);
        this.topPanel.add(this.time);
        label = new Label(LB_BYO_YOMI_TIME.get());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.topPanel.add(label);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.byotime, gridBagConstraints);
        this.topPanel.add(this.byotime);
        this.add("North", this.topPanel);
        this.bottomPanel.setLayout(new FlowLayout(2));
        this.bottomPanel.add(this.doneButton);
        this.bottomPanel.add(this.cancelButton);
        this.add("South", this.bottomPanel);
        if (Util.isWindows()) {
            this.setSize(400, 220);
        } else {
            this.pack();
        }
    }

    public String whiteName() {
        String string = this.whiteName.getText();
        if (string.length() == 0) {
            string = LB_WHITE.get();
        }
        return string;
    }

    public String blackName() {
        String string = this.blackName.getText();
        if (string.length() == 0) {
            string = LB_BLACK.get();
        }
        return string;
    }

    public double komi() {
        String string = this.komi.getText();
        try {
            return new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 5.5;
        }
    }

    public int gameSize() {
        String string = this.size.getText().trim();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public boolean isTimed() {
        return this.timingChooser.getSelectedItem().equalsIgnoreCase(LB_TIMED.get());
    }

    public int initialTimeLimit() {
        try {
            return Integer.parseInt(this.time.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 15;
        }
    }

    public int byoTime() {
        try {
            return Integer.parseInt(this.byotime.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 15;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.close();
        if (object == this.doneButton) {
            GameWindow gameWindow = new GameWindow(this.gameSize(), this.whiteName(), null, this.blackName(), null, this.komi(), this.window);
            this.window.addGameWindow(gameWindow);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

