/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.ui.GameWindow;
import ergo.ui.WindowsMenuCommand;
import ergo.ui.WindowsMenuCommandSeparator;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;

class WindowRegistrar {
    private Vector menus = new Vector();
    private Vector frames = new Vector();
    private Hashtable map = new Hashtable();
    private WindowsMenuCommandSeparator separator = new WindowsMenuCommandSeparator(998, null);

    WindowRegistrar() {
    }

    private Menu menuAt(int n) {
        return (Menu)this.menus.elementAt(n);
    }

    private Frame frameAt(int n) {
        return (Frame)this.frames.elementAt(n);
    }

    private int find(Vector vector, Object object) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) != object) continue;
            return i;
        }
        return -1;
    }

    public synchronized void registerWindowsMenuCommand(WindowsMenuCommand windowsMenuCommand) {
        for (int i = 0; i < this.menus.size(); ++i) {
            Menu menu = this.menuAt(i);
            Frame frame = this.frameAt(i);
            if (windowsMenuCommand.appliesTo() != null && windowsMenuCommand.appliesTo() != frame.getClass()) continue;
            this.registerWindowsMenuCommandInternal(windowsMenuCommand, menu, frame);
        }
    }

    private void registerWindowsMenuCommandInternal(WindowsMenuCommand windowsMenuCommand, Menu menu, Frame frame) {
        Vector vector = (Vector)this.map.get(menu);
        if (this.find(vector, windowsMenuCommand) != -1) {
            return;
        }
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            WindowsMenuCommand windowsMenuCommand2 = (WindowsMenuCommand)vector.elementAt(i);
            if (windowsMenuCommand.menuPriority() < windowsMenuCommand2.menuPriority()) break;
            ++n;
        }
        if (windowsMenuCommand instanceof GameWindow && n > 0 && !(vector.elementAt(n - 1) instanceof WindowsMenuCommandSeparator) && !(vector.elementAt(n - 1) instanceof GameWindow)) {
            menu.insertSeparator(n);
            vector.insertElementAt(this.separator, n);
            ++n;
        }
        vector.insertElementAt(windowsMenuCommand, n);
        if (windowsMenuCommand.menuString() == null) {
            menu.insertSeparator(n);
        } else {
            MenuItem menuItem = windowsMenuCommand.menuShortcut() == null ? new MenuItem(windowsMenuCommand.menuString()) : new MenuItem(windowsMenuCommand.menuString(), windowsMenuCommand.menuShortcut());
            menuItem.addActionListener(new WindowsMenuCommandActionListener(windowsMenuCommand, frame));
            menu.insert(menuItem, n);
        }
    }

    public void deregisterWindowsMenuCommand(WindowsMenuCommand windowsMenuCommand) {
        for (int i = 0; i < this.menus.size(); ++i) {
            Menu menu = this.menuAt(i);
            Vector vector = (Vector)this.map.get(menu);
            int n = this.find(vector, windowsMenuCommand);
            if (n == -1) continue;
            vector.removeElementAt(n);
            menu.remove(n);
            if (n <= 0 || !(vector.elementAt(n - 1) instanceof WindowsMenuCommandSeparator) || !(windowsMenuCommand instanceof GameWindow) || n < vector.size() && vector.elementAt(n) instanceof GameWindow) continue;
            vector.removeElementAt(n - 1);
            menu.remove(n - 1);
        }
    }

    public void updateWindowTitle(WindowsMenuCommand windowsMenuCommand) {
        for (int i = 0; i < this.menus.size(); ++i) {
            MenuItem menuItem;
            int n;
            Menu menu = this.menuAt(i);
            Vector vector = (Vector)this.map.get(this.menuAt(i));
            if (vector == null || (n = this.find(vector, windowsMenuCommand)) == -1 || (menuItem = menu.getItem(n)) == null) continue;
            menuItem.setLabel(windowsMenuCommand.menuString());
        }
    }

    private void menuManufac(Menu menu, Frame frame) {
        if (this.menus.size() > 0) {
            Vector vector;
            Menu menu2 = null;
            for (int i = 0; i < this.menus.size(); ++i) {
                Frame frame2 = this.frameAt(i);
                if (this.menuAt(i) == menu || frame2.getClass() != frame.getClass()) continue;
                menu2 = this.menuAt(i);
                break;
            }
            if (menu2 == null) {
                menu2 = this.menuAt(0);
            }
            if ((vector = (Vector)this.map.get(menu2)) != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    WindowsMenuCommand windowsMenuCommand = (WindowsMenuCommand)vector.elementAt(i);
                    if (windowsMenuCommand == null) continue;
                    this.registerWindowsMenuCommand(windowsMenuCommand);
                }
            }
        }
    }

    public Menu registerMenu(Menu menu, Frame frame) {
        this.menus.addElement(menu);
        this.frames.addElement(frame);
        this.map.put(menu, new Vector());
        this.menuManufac(menu, frame);
        return menu;
    }

    public void releaseMenu(Menu menu) {
        for (int i = 0; i < this.menus.size(); ++i) {
            if (this.menuAt(i) != menu) continue;
            this.menus.removeElementAt(i);
            this.frames.removeElementAt(i);
        }
    }

    class WindowsMenuCommandActionListener
    implements ActionListener {
        WindowsMenuCommand cmd;
        Frame frame;

        WindowsMenuCommandActionListener(WindowsMenuCommand windowsMenuCommand, Frame frame) {
            this.cmd = windowsMenuCommand;
            this.frame = frame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.cmd.menuSelect(this.frame);
        }
    }
}

