/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.Ergo;
import ergo.server.SimpleServerConnection;
import ergo.ui.ErgoCanvas;
import ergo.ui.MenuCommand;
import ergo.ui.Optionizable;
import ergo.ui.PopupContributor;
import ergo.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PopupMenu;

class TimerCanvas
extends ErgoCanvas
implements Optionizable,
PopupContributor {
    private Timer timer = new Timer(1000);
    private int seconds = 0;
    private int threshold = 60;
    private int stones = -1;
    private String widthString = "-0:00:00 (25)";
    private Image offscreen;
    private char[] buffer = new char[13];
    private String timerString = "Timer font";
    private Font timerFont = null;
    private boolean addtime;
    private SimpleServerConnection conn;
    private AddtimeCommand addtime1 = null;
    private AddtimeCommand addtime2 = null;
    private AddtimeCommand addtime5 = null;

    private TimerCanvas() {
    }

    public TimerCanvas(SimpleServerConnection simpleServerConnection, boolean bl) {
        this.conn = simpleServerConnection;
        this.addtime = bl;
        try {
            Ergo.opser.expressOwnership(this.timerString, 5, this, null);
            this.timerFont = Ergo.opser.getFontOption(this.timerString);
        }
        catch (Exception exception) {
            this.timerFont = new Font("SansSerif", 0, 18);
        }
        this.timer.start();
        this.stopTicking();
        this.setFont(this.timerFont);
    }

    public void commitSuicide() {
        this.startTicking();
        this.timer.stop();
    }

    public void optionEvent(String string, Object object) {
        if (Ergo.opser.isSameKey(string, this.timerString)) {
            this.timerFont = (Font)object;
            this.setFont(this.timerFont);
        }
    }

    public void setTime(int n, int n2) {
        this.seconds = n;
        this.stones = n2;
        this.repaint();
    }

    public void stopTicking() {
        this.timer.suspend();
    }

    public void startTicking() {
        this.timer.resume();
    }

    private int toChars(char[] cArray, int n) {
        try {
            int n2 = Math.abs(n);
            int n3 = cArray.length - 1;
            int n4 = n2 / 3600;
            int n5 = n2 % 3600;
            int n6 = n5 / 60;
            int n7 = n5 % 60;
            cArray[n3--] = Util.DIGITS[n7 % 10];
            cArray[n3--] = Util.DIGITS[n7 / 10];
            cArray[n3--] = 58;
            cArray[n3--] = Util.DIGITS[n6 % 10];
            cArray[n3--] = Util.DIGITS[n6 / 10];
            if (n4 > 0) {
                cArray[n3--] = 58;
                String string = Integer.toString(n4);
                for (int i = string.length() - 1; i >= 0; --i) {
                    cArray[n3--] = string.charAt(i);
                }
            }
            if (n < 0) {
                cArray[n3--] = 45;
            }
            return n3 + 1;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Graphics graphics2 = null;
        if (this.getSize().width != this.width || this.getSize().height != this.height) {
            this.width = this.getSize().width;
            this.height = this.getSize().height;
            if (this.offscreen != null) {
                this.offscreen.flush();
            }
            this.offscreen = this.createImage(this.width, this.height);
            graphics2 = this.offscreen.getGraphics();
        }
        if (graphics2 == null) {
            graphics2 = this.offscreen.getGraphics();
        }
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, this.width, this.height);
        FontMetrics fontMetrics = graphics2.getFontMetrics();
        int n = fontMetrics.getHeight();
        graphics2.setColor(this.getForeground());
        int n2 = (this.height - n) / 2 + fontMetrics.getAscent();
        int n3 = 0;
        if (this.seconds <= 60) {
            graphics2.setColor(Color.red);
        }
        int n4 = Math.max(0, this.toChars(this.buffer, this.seconds));
        graphics2.drawChars(this.buffer, n4, this.buffer.length - n4, n3, n2);
        int n5 = n3 + fontMetrics.charsWidth(this.buffer, n4, this.buffer.length - n4);
        graphics2.setColor(this.getForeground());
        if (this.stones != -1) {
            graphics2.drawString(" (" + this.stones + ")", n5, n2);
        }
        graphics.drawImage(this.offscreen, 0, 0, this);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        dimension.width = fontMetrics.stringWidth(this.widthString);
        dimension.height = fontMetrics.getHeight() + 4;
        return dimension;
    }

    public int getStoneDiameter() {
        return this.getFontMetrics(this.getFont()).getHeight() + 2;
    }

    public void tick(Timer timer) {
        --this.seconds;
        this.repaint();
    }

    public boolean allowMoreItems(Component component) {
        return true;
    }

    public void populatePopupMenu(PopupMenu popupMenu, Component component, int n, int n2) {
        if (this.addtime) {
            if (popupMenu.countItems() > 0) {
                popupMenu.addSeparator();
            }
            if (this.addtime1 == null) {
                this.addtime1 = new AddtimeCommand(1);
                this.addtime2 = new AddtimeCommand(2);
                this.addtime5 = new AddtimeCommand(5);
            }
            popupMenu.add(this.addtime1);
            popupMenu.add(this.addtime2);
            popupMenu.add(this.addtime5);
        }
    }

    private class AddtimeCommand
    extends MenuCommand {
        int minutes;

        public AddtimeCommand(int n) {
            super("addtime " + n);
            this.minutes = n;
        }

        public void executeCommand(Object object) {
            TimerCanvas.this.conn.send("addtime " + this.minutes, true);
        }
    }

    class Timer
    extends Thread {
        private int interval;

        public Timer(int n) {
            this.interval = n;
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                try {
                    Timer.sleep(this.interval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                TimerCanvas.this.tick(this);
            }
        }
    }
}

