/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.ui.History;
import ergo.ui.HistoryElement;
import ergo.util.Debug;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.util.Vector;

class TextCanvas
extends Canvas {
    private Insets insets = new Insets(1, 3, 1, 3);
    private boolean border = false;
    private int rows;
    private int cols;
    private int width = -1;
    private int height = -1;
    private int insideWidth = -1;
    private int maxLineWidth = 0;
    private Image offscreen = null;
    private Graphics offg = null;
    private boolean wrap = true;
    private History history;
    private int histSize;
    private int histMax;
    private int tabWidth = 60;
    private int historyLines = 0;
    private Font font = new Font("Monospaced", 0, 12);
    private int hbot;
    private int lbot;
    private int bottomLine;
    private int ymin = -1;
    private int ymax = -1;
    private boolean valid = false;

    public TextCanvas(String string, int n, int n2, int n3, int n4, boolean bl) {
        this.rows = n;
        this.cols = n2;
        this.histSize = n3;
        this.histMax = n4;
        this.wrap = bl;
        this.clearHistory();
        if (string != null) {
            this.appendText(string);
        }
    }

    private boolean isInitialized() {
        return this.width != -1;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        if (insets != null) {
            this.insets = insets;
        }
    }

    public void setBorder(boolean bl) {
        this.border = bl;
    }

    public void setFont(Font font) {
        if (font != null) {
            super.setFont(font);
            this.font = font;
            if (this.offg != null) {
                this.offg.setFont(font);
            }
        } else {
            Debug.println("Error: Attempt to set font to null (ignored).");
            Debug.backtrace();
        }
    }

    public int getMaxLineWidth() {
        return this.maxLineWidth;
    }

    public int getHistoryLines() {
        return this.historyLines;
    }

    public int getBottomDisplayedLine() {
        return Math.max(0, this.bottomLine);
    }

    private Dimension getMySize(int n, int n2) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        int n3 = fontMetrics.getHeight();
        int n4 = fontMetrics.charWidth('m');
        Insets insets = this.getInsets();
        return new Dimension(insets.top + insets.bottom + n4 * n2, insets.left + insets.right + n3 * n);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMySize(this.rows, this.cols);
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getMySize(3, 10);
    }

    public void clearHistory() {
        this.history = new History(this.histSize, this.histSize * 2);
        if (this.offg != null) {
            this.clearCanvas(this.offg);
        }
        this.historyLines = 0;
        this.lbot = 0;
        this.hbot = 0;
        this.bottomLine = -1;
    }

    private short[] computeLines(HistoryElement historyElement, FontMetrics fontMetrics) {
        short[] sArray = historyElement.getLines();
        if (sArray == null) {
            char c;
            if (fontMetrics == null) {
                fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
            }
            int[] nArray = fontMetrics.getWidths();
            Vector<Short> vector = new Vector<Short>(2, 2);
            int n = 0;
            short s = 0;
            char[] cArray = historyElement.getChars();
            short s2 = 0;
            for (short s3 = 0; s3 < cArray.length; s3 = (short)((short)(s3 + 1))) {
                c = cArray[s3];
                int n2 = c < '\u0100' ? nArray[c] : fontMetrics.charWidth(19968);
                n += n2;
                if (s3 - s <= 0) continue;
                boolean bl = Character.isWhitespace(c);
                if (n >= this.insideWidth) {
                    if (s != 0 && !bl) {
                        vector.addElement(new Short(s));
                        s3 = s;
                    } else {
                        vector.addElement(new Short(s3));
                        s2 = s3;
                    }
                    this.maxLineWidth = Math.max(this.maxLineWidth, n - n2);
                    n = 0;
                }
                if (!bl) continue;
                s = s3;
            }
            sArray = new short[vector.size()];
            for (c = '\u0000'; c < sArray.length; ++c) {
                sArray[c] = (Short)vector.elementAt(c);
            }
            historyElement.setLines(sArray);
            this.historyLines += sArray.length;
        }
        return sArray;
    }

    private int numLines(HistoryElement historyElement, FontMetrics fontMetrics) {
        if (this.wrap) {
            short[] sArray = this.computeLines(historyElement, fontMetrics);
            return sArray.length + 1;
        }
        return 1;
    }

    private void invalidateHistory() {
        this.history.invalidate();
        this.maxLineWidth = 0;
        this.historyLines = this.history.size();
    }

    public void scrollTo(int n) {
        int n2 = this.wrap ? this.historyLines - 1 : this.history.size() - 1;
        n = Math.max(0, Math.min(n, n2));
        if (this.wrap) {
            int[] nArray = this.findLineRelative(this.hbot, this.lbot, n - this.bottomLine);
            this.hbot = nArray[0];
            this.lbot = nArray[1];
            this.bottomLine = nArray[2];
        } else {
            this.bottomLine = n;
            this.hbot = n;
            this.lbot = 0;
        }
        this.redisplay();
    }

    public void pageUp() {
        this.moveViewportUp(this.rows - 1);
    }

    public void pageDown() {
        this.moveViewportDown(this.rows - 1);
    }

    private int[] findLineRelative(int n, int n2, int n3) {
        int[] nArray = new int[3];
        int n4 = n3;
        if (!this.wrap) {
            nArray[0] = Math.min(Math.max(0, n + n3), this.history.size() - 1);
            nArray[1] = 0;
            nArray[2] = nArray[0];
        } else {
            HistoryElement historyElement = this.history.elementAt(n);
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.offg.getFont());
            int n5 = this.history.size();
            if (n3 > 0) {
                while (n3 > 0) {
                    --n3;
                    if (++n2 >= this.numLines(historyElement, fontMetrics)) {
                        n2 = 0;
                        if (++n >= n5) {
                            n = n5 - 1;
                            n2 = this.numLines(historyElement, fontMetrics) - 1;
                            ++n3;
                            break;
                        }
                    }
                    historyElement = this.history.elementAt(n);
                }
            } else {
                while (n3 < 0) {
                    ++n3;
                    if (--n2 >= 0) continue;
                    if (--n < 0) {
                        n = 0;
                        n2 = 0;
                        --n3;
                        break;
                    }
                    historyElement = this.history.elementAt(n);
                    n2 = this.numLines(historyElement, fontMetrics) - 1;
                }
            }
            nArray[0] = n;
            nArray[1] = n2;
            nArray[2] = this.bottomLine + (n4 - n3);
        }
        return nArray;
    }

    public void moveViewportDown(int n) {
        if (this.history.size() > 0) {
            int[] nArray = this.findLineRelative(this.hbot, this.lbot, n);
            this.hbot = nArray[0];
            this.lbot = nArray[1];
            this.bottomLine = nArray[2];
            this.redisplay();
        }
    }

    public void moveViewportUp(int n) {
        if (this.bottomLine - n < this.rows - 1) {
            this.moveViewportToBeginning();
        } else {
            this.moveViewportDown(-n);
        }
    }

    public void moveViewportToBeginning() {
        this.bottomLine = 0;
        this.lbot = 0;
        this.hbot = 0;
        this.scrollTo(this.rows - 1);
    }

    public void moveViewportToEnd() {
        this.hbot = this.history.size() - 1;
        HistoryElement historyElement = this.history.elementAt(this.hbot);
        this.lbot = this.numLines(historyElement, Toolkit.getDefaultToolkit().getFontMetrics(this.getFont())) - 1;
        this.bottomLine = this.historyLines;
        this.redisplay();
    }

    private boolean atBottom() {
        int n = this.history.endIndex();
        if (n == -1 || !this.isInitialized()) {
            return true;
        }
        return n == this.hbot && this.lbot + 1 == this.numLines(this.history.elementAt(n), null);
    }

    private String expandTabs(String string) {
        int n = string.indexOf(9);
        if (n == -1) {
            return string;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 20);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '\t') {
                int n3 = 8 - stringBuffer.length() % 8;
                for (int j = 0; j < n3; ++j) {
                    stringBuffer.append(' ');
                }
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendLine(String string, boolean bl, Color color) {
        TextCanvas textCanvas = this;
        synchronized (textCanvas) {
            string = this.expandTabs(string);
            HistoryElement historyElement = new HistoryElement(string, color);
            if (this.offg == null) {
                this.hbot = this.history.addElement(historyElement);
            } else if (!this.atBottom()) {
                this.history.addElement(historyElement);
            } else {
                this.hbot = this.history.addElement(historyElement);
                int n = this.numLines(historyElement, Toolkit.getDefaultToolkit().getFontMetrics(this.offg.getFont()));
                this.bottomLine += n;
                this.lbot = this.wrap ? n - 1 : 0;
            }
            ++this.historyLines;
            if (bl) {
                this.repaint();
            }
        }
    }

    public void appendText(String string) {
        this.appendText(string, Color.black);
    }

    public void appendText(String string, Color color) {
        int n = 0;
        int n2 = string.length();
        for (int i = n; i <= n2; ++i) {
            if (i >= n2) {
                this.appendLine(string.substring(n), true, color);
                continue;
            }
            if (string.charAt(i) != '\n') continue;
            this.appendLine(string.substring(n, i), true, color);
            if (i + 1 >= n2) break;
            n = i + 1;
        }
    }

    public void insertText(String string, int n) {
    }

    public void replaceText(String string, int n, int n2) {
    }

    public void clearCanvas(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(this.getForeground());
        if (this.border) {
            graphics.drawRect(0, 0, this.width, this.height);
        }
    }

    public void redisplay() {
        if (this.offg != null) {
            this.redisplay(this.offg, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redisplay(Graphics graphics, boolean bl) {
        if (graphics == null) {
            return;
        }
        TextCanvas textCanvas = this;
        synchronized (textCanvas) {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(graphics.getFont());
            int n = fontMetrics.getHeight();
            int n2 = this.ymax;
            this.clearCanvas(graphics);
            for (int i = this.hbot; n2 >= this.ymin && this.history.size() > 0 && i >= 0; --i) {
                HistoryElement historyElement = this.history.elementAt(i);
                graphics.setColor(historyElement.color);
                if (this.wrap) {
                    int n3;
                    for (int j = n3 = i == this.hbot ? this.lbot : this.numLines(historyElement, fontMetrics) - 1; n2 >= this.ymin && j >= 0; n2 -= n, --j) {
                        int n4 = historyElement.getLineOffset(j);
                        int n5 = historyElement.getLineLength(j);
                        char[] cArray = historyElement.getChars();
                        graphics.drawChars(cArray, n4, n5, this.insets.left, n2);
                    }
                    continue;
                }
                char[] cArray = historyElement.getChars();
                graphics.drawChars(cArray, 0, cArray.length, this.insets.left, n2);
                n2 -= n;
            }
            graphics.setColor(this.getForeground());
            if (bl) {
                this.valid = true;
                this.repaint();
            }
        }
    }

    public synchronized void update(Graphics graphics) {
        if (this.getSize().width != this.width || this.getSize().height != this.height) {
            if (this.getSize().width != this.width) {
                this.invalidateHistory();
            }
            this.width = this.getSize().width;
            this.height = this.getSize().height;
            this.insideWidth = this.width - this.insets.left - this.insets.right;
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
            this.ymin = this.insets.top + fontMetrics.getAscent() + 1;
            this.ymax = this.height - fontMetrics.getDescent() - this.insets.bottom;
            this.rows = (this.ymax - (this.ymin - 1)) / fontMetrics.getHeight() + 1;
            if (this.atBottom() && this.history.size() > 0) {
                this.hbot = this.history.endIndex();
                this.lbot = this.numLines(this.history.elementAt(this.hbot), null) - 1;
            }
            if (this.offscreen != null) {
                this.offscreen.flush();
            }
            this.offscreen = this.createImage(this.width, this.height);
            this.offg = this.offscreen.getGraphics();
            this.offg.setFont(this.font);
            this.valid = false;
        }
        if (!this.valid) {
            this.redisplay(this.offg, false);
        } else {
            this.valid = false;
        }
        if (graphics != null) {
            graphics.drawImage(this.offscreen, 0, 0, this);
        }
    }

    public synchronized void paint(Graphics graphics) {
        if (graphics != null) {
            this.update(graphics);
        }
    }

    public void save(PrintWriter printWriter) {
        this.history.save(printWriter);
    }
}

