/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.ui.TextCanvas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseListener;
import java.io.PrintWriter;

public class TextArea
extends Panel
implements AdjustmentListener {
    private TextCanvas canvas;
    private Scrollbar vscroll;
    private Scrollbar hscroll = null;
    private String vscrollPosition = "East";

    protected TextArea() {
    }

    public TextArea(int n, int n2, String string, boolean bl) {
        this.canvas = new TextCanvas(string, n, n2, 1000, 10000, bl);
        this.canvas.setInsets(new Insets(1, 3, 1, 1));
        this.canvas.setBorder(true);
        this.vscroll = new Scrollbar(1, 0, n, 0, n);
        this.vscroll.addAdjustmentListener(this);
        this.setLayout(new BorderLayout());
        this.add("Center", this.canvas);
        this.add(this.vscrollPosition, this.vscroll);
        if (!bl) {
            int n3 = this.canvas.getSize().width;
            this.hscroll = new Scrollbar(0, 0, n3, 0, n3);
            this.hscroll.addAdjustmentListener(this);
            this.add("South", this.hscroll);
        }
        if (string != null) {
            this.appendText(string);
        }
    }

    public TextArea(int n, int n2) {
        this(n, n2, null, false);
    }

    public TextArea(String string, int n, int n2) {
        this(n, n2, string, false);
    }

    public void insertText(String string, int n) {
    }

    private void setScrollValues(Scrollbar scrollbar, int n, int n2, int n3, int n4) {
        scrollbar.setValues(n, n2, n3, n4);
    }

    public void appendText(String string) {
        this.appendText(string, this.canvas.getForeground());
    }

    public void appendText(String string, Color color) {
        this.canvas.appendText(string, color);
        this.updateScrollValues();
    }

    public void setText(String string) {
        this.canvas.clearHistory();
        this.appendText(string);
    }

    public void clearAll() {
        this.canvas.clearHistory();
        this.updateScrollValues();
        this.canvas.repaint();
    }

    private void updateScrollValues() {
        int n = this.canvas.getRows();
        int n2 = this.canvas.getBottomDisplayedLine();
        this.setScrollValues(this.vscroll, Math.max(0, n2 - n + 1), n, 0, Math.max(n, this.canvas.getHistoryLines()));
        this.vscroll.setBlockIncrement(this.canvas.getRows());
        if (this.hscroll != null) {
            int n3 = this.canvas.getSize().width;
            int n4 = this.canvas.getMaxLineWidth();
            this.setScrollValues(this.hscroll, this.hscroll.getValue(), n3, 0, n4);
        }
    }

    public void replaceText(String string, int n, int n2) {
    }

    public int getRows() {
        return this.canvas.getRows();
    }

    public int getColumns() {
        return this.canvas.getColumns();
    }

    public void setEditable(boolean bl) {
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.vscroll.getPreferredSize();
        Dimension dimension2 = this.canvas.getPreferredSize();
        Dimension dimension3 = null;
        if (this.hscroll == null) {
            dimension3 = new Dimension(dimension.width + dimension2.width, dimension2.height);
        } else {
            Dimension dimension4 = this.hscroll.getPreferredSize();
            dimension3 = new Dimension(dimension.width + dimension2.width, dimension2.height + dimension4.height);
        }
        return dimension3;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setColorVec(Color[] colorArray) {
        this.canvas.setForeground(colorArray[0]);
        this.canvas.setBackground(colorArray[1]);
        this.repaint();
    }

    public void setFont(Font font) {
        this.canvas.setFont(font);
        this.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getAdjustable() == this.vscroll) {
            switch (adjustmentEvent.getAdjustmentType()) {
                case 1: {
                    this.canvas.moveViewportDown(1);
                    break;
                }
                case 2: {
                    this.canvas.moveViewportUp(1);
                    break;
                }
                case 4: {
                    this.canvas.pageDown();
                    break;
                }
                case 3: {
                    this.canvas.pageUp();
                    break;
                }
                case 5: {
                    this.canvas.scrollTo(adjustmentEvent.getValue() + this.canvas.getRows() - 1);
                }
            }
            this.updateScrollValues();
        }
    }

    public void save(PrintWriter printWriter) {
        this.canvas.save(printWriter);
    }

    public void addMouseListener(MouseListener mouseListener2) {
        this.canvas.addMouseListener(mouseListener2);
    }
}

