/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.Ergo;
import ergo.logic.Game;
import ergo.logic.Move;
import ergo.logic.RemovalMove;
import ergo.logic.SGF;
import ergo.server.GoServer;
import ergo.server.ServerConnection;
import ergo.ui.AbstractMenuListener;
import ergo.ui.Focusable;
import ergo.ui.FontSpec;
import ergo.ui.GameWindow;
import ergo.ui.GoClient;
import ergo.ui.MenuCommand;
import ergo.ui.Optionizable;
import ergo.ui.OutputFocus;
import ergo.ui.PopupContributor;
import ergo.ui.PopupController;
import ergo.ui.PositionListener;
import ergo.ui.TextArea;
import ergo.ui.TextColorManager;
import ergo.ui.WindowRegistrar;
import ergo.ui.WindowsMenuCommand;
import ergo.ui.dlg.AboutDialog;
import ergo.ui.dlg.InformDialog;
import ergo.ui.dlg.LocalGameDialog;
import ergo.ui.dlg.LoginDialog;
import ergo.ui.dlg.MatchDialog;
import ergo.ui.dlg.NewServerDialog;
import ergo.ui.dlg.ObserveDialog;
import ergo.ui.dlg.YNCDialog;
import ergo.ui.urCheckboxListener;
import ergo.ui.urMenuBar;
import ergo.util.CommandHistory;
import ergo.util.Debug;
import ergo.util.ErgoException;
import ergo.util.ParseException;
import ergo.util.ParsedMessage;
import ergo.util.Position;
import ergo.util.Util;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import nom.rb.common.MosaicConstraints;
import nom.rb.common.MosaicLayout;
import nom.rb.common.MosaicPanel;
import org.unitarou.ml.Message;

public class TerminalWindow
extends Frame
implements Runnable,
Focusable,
WindowsMenuCommand,
Optionizable,
GoClient,
PopupContributor {
    public static final Color tellColor = Color.magenta;
    public static final Color yellColor = Color.blue;
    public static final Color shoutColor = Color.black;
    public static final Color kibitzColor = new Color(0, 100, 0);
    public static final Color warningColor = Color.black;
    public static final Color commandColor = Color.red;
    private static final String serverString = "Server";
    private static final String widthString = "Main window width";
    private static final String heightString = "Main area height";
    private static final String mheightString = "Message area height";
    private static final String exitString = "Save Options on Exit";
    private static final String mainposString = "Main Window Position";
    private static final Message LB_FILE = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbFile");
    private static final Message LB_CONNECT = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbConnect");
    private static final Message LB_NEW = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbNew");
    private static final Message LB_DISCONNECT = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbDisconnect");
    private static final Message LB_SAVE_TERMINAL_OUTPUT = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbSaveTerminalOutput");
    private static final Message LB_SAVE_ERROR = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbSaveError");
    private static final Message LB_LOAD_SGF = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbLoadSgf");
    private static final Message MSG_INVALID_SGF_FILE = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "msgInvalidSgfFile");
    private static final Message LB_ASK_QUIT = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbAskQuit");
    private static final Message MSG_ASK_QUIT = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "msgAskQuit");
    private static final Message LB_CLEAR_TERMINAL_OUTPUT = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbClearTerminalOutput");
    private static final Message LB_OPEN_GAME = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbOpenGame");
    private static final Message LB_EXIT = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbExit");
    private static final Message LB_PLAY = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbPlay");
    private static final Message LB_OBSERVE_GAME = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbObserveGame");
    private static final Message LB_REQUEST_MATCH = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbRequestMatch");
    private static final Message LB_AUTOMATCH = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbAutomatch");
    private static final Message LB_LOCAL_GAME = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbLocalGame");
    private static final Message LB_OPTIONS = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbOptions");
    private static final Message LB_SOUND = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbSound");
    private static final Message LB_SAVE_OPTIONS = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbSave");
    private static final Message LB_DEBUG = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbDebug");
    private static final Message LB_GENERAL = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbGeneral");
    private static final Message LB_GAME_LOGIC = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbGameLogic");
    private static final Message LB_RAW_MODE = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbRawMode");
    private static final Message LB_WINDOW = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbWindow");
    private static final Message LB_HELP = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbHelp");
    private static final Message LB_ABOUT_ERGO = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbAboutErgo");
    private static final Message LB_BROWSE_DOCUMENTATION = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbBrouseDocumentation");
    private static final Message MSG_NO_SAVE_NEW_SERVER = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "msgNoSaveNewServer");
    private static final Message MSG_UNABLE_TO_OPEN_CONNECTION = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "msgUnableToOpenConnection");
    private static final Message LB_WHO_VIEW = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbWhoView");
    private static final Message LB_GAME_VIEW = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbGameView");
    private static final Message MSG_CANT_WRITE_INIT_FILE_FROM_APPLET = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "msgCantWriteInitFileFromApplet");
    private static final Message LB_ERROR = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbError");
    private static final Message MSG_ERROR_NO_CONNECTION = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "msgErrorNoConnection");
    private static final Message MSG_ERROR_LOST_KIBITS_WINDOW = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "msgErrorLostKibitsWindow");
    private static final Message LB_LOGIN_TO = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbLoginTo");
    private static final Message FMT_YELL = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "fmtYell");
    private static final Message LB_TERMINAL_VIEW = new Message(class$ergo$ui$TerminalWindow == null ? (class$ergo$ui$TerminalWindow = TerminalWindow.class$("ergo.ui.TerminalWindow")) : class$ergo$ui$TerminalWindow, "lbTerminalView");
    private PopupController popupControl;
    private PopupHandler popupHandler;
    private CommandHistory commandHistory = new CommandHistory();
    public static WindowRegistrar registrar = new WindowRegistrar();
    private Vector focusOrder = null;
    private String accountName = null;
    private String rank = null;
    private Ergo ergo = null;
    private ServerConnection conn;
    private Vector gameWindows = new Vector();
    private ObserveDialog observeDialog;
    private String defaultDirectory = null;
    private LoginDialog loginDialog = null;
    private urMenuBar menuBar;
    private Menu goConnectSubmenu;
    private MenuItem newServerItem;
    private MenuItem disconnectItem;
    private MenuItem saveOutputItem;
    private MenuItem clearOutputItem;
    private MenuItem loadItem;
    private MenuItem observeItem;
    private MenuItem matchItem;
    private MenuItem automatchItem;
    private MenuItem localGameItem;
    private CheckboxMenuItem soundItem;
    private MenuItem saveOptionsItem;
    private Menu debugMenu;
    private CheckboxMenuItem debugItem;
    private CheckboxMenuItem logicItem;
    private CheckboxMenuItem rawItem;
    private boolean rawMode;
    private Menu windowsMenu;
    private Menu helpMenu;
    private MenuItem aboutItem;
    private MenuItem docItem;
    private TextField inputField;
    private TextArea mainArea;
    private TextArea messageArea;
    private boolean soundEnabled;
    private Vector terminals = new Vector();
    static /* synthetic */ Class class$ergo$ui$TerminalWindow;

    public TerminalWindow(Ergo ergo, GoServer goServer, boolean bl) {
        this.init_options();
        this.init_menus();
        this.conn = new ServerConnection(this);
        if (bl && goServer != null) {
            this.conn.open(goServer);
        }
        this.ergo = ergo;
        Debug.setDebug(Ergo.opser.getBooleanOption("Debug Mode"));
        this.popupControl = new PopupController(this, LB_OPTIONS.get());
        this.popupHandler = new PopupHandler();
        this.populateServers();
        if (goServer != null) {
            this.goConnectSubmenu.add(new GoServerMenuItem(goServer));
        }
        int n = Ergo.opser.getIntegerOption(widthString);
        this.inputField = new TextField(n);
        this.mainArea = new TextArea(Ergo.opser.getIntegerOption(heightString), n, null, true);
        this.messageArea = new TextArea(Ergo.opser.getIntegerOption(mheightString), n);
        this.inputField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = TerminalWindow.this.inputField.getText();
                TerminalWindow.this.inputField.setText("");
                TerminalWindow.this.processCommand(string.trim(), null);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TerminalWindow.this.exit();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                TerminalWindow.this.inputField.requestFocus();
            }
        });
        this.inputField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 38: {
                        String string = TerminalWindow.this.commandHistory.getPreviousElement();
                        if (string == null) break;
                        TerminalWindow.this.inputField.setText(string);
                        TerminalWindow.this.inputField.setCaretPosition(string.length());
                        break;
                    }
                    case 40: {
                        String string = TerminalWindow.this.commandHistory.getNextElement();
                        if (string == null) break;
                        TerminalWindow.this.inputField.setText(string);
                        TerminalWindow.this.inputField.setCaretPosition(string.length());
                    }
                }
            }
        });
        if (this.conn == null || !this.conn.isConnected()) {
            this.noteDisconnected();
        }
        this.init_layout();
        Font font = Ergo.opser.getFontOption("Text Window Font");
        Color[] colorArray = TextColorManager.getColorVec();
        this.mainArea.setFont(font);
        this.mainArea.setColorVec(colorArray);
        this.mainArea.setEditable(false);
        this.messageArea.setFont(font);
        this.messageArea.setColorVec(colorArray);
        this.messageArea.setEditable(false);
        this.mainArea.addMouseListener(this.popupControl);
        this.messageArea.addMouseListener(this.popupControl);
    }

    public void addServer(GoServer goServer, boolean bl) {
        this.goConnectSubmenu.add(new GoServerMenuItem(goServer));
        if (bl) {
            try {
                int n = Ergo.opser.getOptionSize(serverString);
                Ergo.opser.updateOption(serverString, n, goServer);
            }
            catch (ErgoException ergoException) {
                this.displayString(MSG_NO_SAVE_NEW_SERVER.get(ergoException));
            }
        }
    }

    private void init_options() {
        try {
            Ergo.opser.expressOwnership("Save Login Name and Password", 2, null, new Boolean(true));
            Ergo.opser.expressOwnership(serverString, 3, this, null);
            Ergo.opser.expressOwnership("Sound", 2, this, new Boolean(false));
            Ergo.opser.expressOwnership(exitString, 2, this, new Boolean(true));
            Ergo.opser.expressOwnership(widthString, 1, this, new Integer(80));
            Ergo.opser.expressOwnership(heightString, 1, this, new Integer(25));
            Ergo.opser.expressOwnership(mheightString, 1, this, new Integer(8));
            Ergo.opser.expressOwnership("Text Window Font", 5, this, new FontSpec("Monospaced", "plain", "12"));
            Ergo.opser.expressOwnership("Info Window Font", 5, this, null);
            Ergo.opser.expressOwnership("Debug Mode", 2, null, new Boolean(Debug.getDebug()));
            Ergo.opser.expressOwnership("Debug Menu", 2, null, new Boolean(Debug.getDebug()));
            PositionListener positionListener = new PositionListener(mainposString, this, new Point(10, 10), Ergo.opser);
            TextColorManager.expressAll(this, 2);
            Ergo.opser.expressOwnership(Ergo.opser.savingString, 2, this, null);
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
        }
    }

    private void init_menus() {
        this.menuBar = new urMenuBar(this);
        menuListener menuListener2 = new menuListener();
        checkboxListener checkboxListener2 = new checkboxListener();
        Menu menu = this.menuBar.generate(LB_FILE.get());
        this.goConnectSubmenu = menuListener2.generateMenu(menu, LB_CONNECT.get());
        this.newServerItem = menuListener2.generateWithSep(this.goConnectSubmenu, LB_NEW.get());
        this.disconnectItem = new MenuCommand(LB_DISCONNECT.get(), new MenuShortcut(113)){

            public void executeCommand(Object object) {
                TerminalWindow.this.send("quit");
            }
        };
        menu.add(this.disconnectItem);
        this.saveOutputItem = menuListener2.generate(menu, LB_SAVE_TERMINAL_OUTPUT.get(), new MenuShortcut(115));
        this.clearOutputItem = menuListener2.generate(menu, LB_CLEAR_TERMINAL_OUTPUT.get());
        this.loadItem = menuListener2.generateWithSep(menu, LB_OPEN_GAME.get(), new MenuShortcut(111, true));
        menu.add(new MenuCommand(LB_EXIT.get(), new MenuShortcut(113, true)){

            public void executeCommand(Object object) {
                TerminalWindow.this.exit();
            }
        });
        Menu menu2 = this.menuBar.generate(LB_PLAY.get());
        this.observeItem = menuListener2.generate(menu2, LB_OBSERVE_GAME.get(), new MenuShortcut(111));
        this.matchItem = menuListener2.generate(menu2, LB_REQUEST_MATCH.get(), new MenuShortcut(109));
        this.automatchItem = menuListener2.generate(menu2, LB_AUTOMATCH.get());
        this.localGameItem = menuListener2.generate(menu2, LB_LOCAL_GAME.get(), new MenuShortcut(108));
        Menu menu3 = this.menuBar.generate(LB_OPTIONS.get());
        this.soundItem = checkboxListener2.generate(menu3, LB_SOUND.get());
        this.saveOptionsItem = menuListener2.generate(menu3, LB_SAVE_OPTIONS.get());
        this.debugMenu = new Menu(LB_DEBUG.get());
        this.debugItem = checkboxListener2.generate(this.debugMenu, LB_GENERAL.get());
        this.logicItem = checkboxListener2.generate(this.debugMenu, LB_GAME_LOGIC.get());
        this.rawItem = checkboxListener2.generate(this.debugMenu, LB_RAW_MODE.get());
        this.rawMode = false;
        this.windowsMenu = registrar.registerMenu(this.menuBar.generate(LB_WINDOW.get()), this);
        this.helpMenu = new Menu(LB_HELP.get());
        this.aboutItem = menuListener2.generate(this.helpMenu, LB_ABOUT_ERGO.get());
        this.docItem = menuListener2.generate(this.helpMenu, LB_BROWSE_DOCUMENTATION.get());
        this.menuBar.setHelpMenu(this.helpMenu);
        this.soundEnabled = Ergo.opser.getBooleanOption("Sound");
        this.soundItem.setState(this.soundEnabled);
        registrar.registerWindowsMenuCommand(this);
        if (Ergo.opser.getBooleanOption("Debug Menu")) {
            this.debugMenu.add(this.debugItem);
            this.debugMenu.add(this.logicItem);
            this.debugMenu.add(this.rawItem);
            this.debugItem.setState(Debug.getDebug());
            this.logicItem.setState(Debug.debugGameLogicp);
            this.rawItem.setState(this.rawMode);
            this.menuBar.add(this.debugMenu);
        }
        this.automatchItem.setEnabled(false);
        if (Ergo.inApplet) {
            this.helpMenu.add(this.docItem);
            this.saveOutputItem.setEnabled(false);
            this.loadItem.setEnabled(false);
            this.saveOptionsItem.setEnabled(false);
        } else {
            this.docItem.setEnabled(false);
            this.soundItem.setState(false);
            this.soundItem.setEnabled(false);
            this.helpMenu.add(this.aboutItem);
        }
        this.setMenuBar(this.menuBar);
    }

    private void init_layout() {
        MosaicPanel mosaicPanel = new MosaicPanel();
        MosaicLayout mosaicLayout = new MosaicLayout();
        mosaicPanel.setLayout(mosaicLayout);
        mosaicLayout.setPos(0, 0);
        mosaicPanel.add("", this.messageArea);
        mosaicLayout.setPos(0, 1);
        mosaicPanel.add("", this.mainArea);
        MosaicConstraints mosaicConstraints = new MosaicConstraints(0, 2, 1.0);
        mosaicLayout.setConstraints(this.messageArea, mosaicConstraints);
        mosaicLayout.setConstraints(this.mainArea, mosaicConstraints);
        this.setLayout(new BorderLayout());
        this.add("Center", mosaicPanel);
        this.add("South", this.inputField);
    }

    public void run() {
        this.updateTitle();
        this.pack();
        this.show();
        this.setEnabled(true);
        this.inputField.requestFocus();
    }

    public boolean allowMoreItems(Component component) {
        return true;
    }

    public void populatePopupMenu(PopupMenu popupMenu, Component component, int n, int n2) {
        this.popupHandler.populatePopup(popupMenu, component, n, n2);
    }

    public void optionEvent(String string, Object object) {
        if (string == Ergo.opser.savingString) {
            Ergo.opser.updateOption(widthString, new Integer(this.mainArea.getColumns()));
        } else if (!Ergo.opser.isSameKey(string, serverString)) {
            if (Ergo.opser.isSameKey(string, "Sound")) {
                Boolean bl = (Boolean)object;
                this.soundEnabled = bl;
                this.soundItem.setState(this.soundEnabled);
            } else if (Ergo.opser.isSameKey(string, "Text Window Font")) {
                Font font = ((FontSpec)object).getFont();
                this.mainArea.setFont(font);
                this.messageArea.setFont(font);
            } else if (TextColorManager.isColorString(string)) {
                this.mainArea.setColorVec(TextColorManager.getColorVec());
                this.messageArea.setColorVec(TextColorManager.getColorVec());
            }
        }
    }

    private void populateServers() {
        try {
            int n = Ergo.opser.getOptionSize(serverString);
            for (int i = 0; i < n; ++i) {
                Object object = Ergo.opser.getOption(serverString, i);
                if (object == null) {
                    Debug.println("Warning: Go Server numbers are not continuous in .ini file");
                    continue;
                }
                GoServer goServer = (GoServer)object;
                GoServerMenuItem goServerMenuItem = new GoServerMenuItem(goServer);
                if (i <= 9) {
                    goServerMenuItem.setShortcut(new MenuShortcut(49 + i));
                }
                this.goConnectSubmenu.add(goServerMenuItem);
            }
        }
        catch (Exception exception) {
            Debug.println("Error finding Go Servers: " + exception);
        }
    }

    public void addOutputFocus(OutputFocus outputFocus) {
        Debug.assertion(outputFocus != null, "output focus is null");
        for (int i = 0; i < this.terminals.size(); ++i) {
            if (outputFocus != this.terminals.elementAt(i)) continue;
            return;
        }
        this.terminals.addElement(outputFocus);
    }

    public void removeOutputFocus(OutputFocus outputFocus) {
        for (int i = 0; i < this.terminals.size(); ++i) {
            OutputFocus outputFocus2 = (OutputFocus)this.terminals.elementAt(i);
            if (outputFocus != outputFocus2) continue;
            outputFocus2.noteFocusLost();
            this.terminals.removeElementAt(i);
        }
    }

    public void displayString(String string) {
        this.displayStringInternal(string, this.mainArea, true, null);
    }

    public void displayString(String string, Color color) {
        this.displayStringInternal(string, this.mainArea, true, color);
    }

    public void noteFocusLost() {
    }

    private void displayStringInternal(String string, TextArea textArea, boolean bl, Color color) {
        if (textArea == null) {
            textArea = this.mainArea;
        }
        if (color == null) {
            color = textArea.getForeground();
        }
        if (bl) {
            for (int i = 0; i < this.terminals.size(); ++i) {
                OutputFocus outputFocus = (OutputFocus)this.terminals.elementAt(i);
                outputFocus.displayString(string, color);
            }
        }
        textArea.appendText(string, color);
    }

    public void addGameWindow(GameWindow gameWindow) {
        this.gameWindows.addElement(gameWindow);
        new Thread(gameWindow).start();
        registrar.registerWindowsMenuCommand(gameWindow);
        if (this.conn.control != null) {
            this.conn.control.sgc.inform(gameWindow);
        }
    }

    public void removeGameWindow(GameWindow gameWindow) {
        this.removeOutputFocus(gameWindow);
        this.gameWindows.removeElement(gameWindow);
        registrar.deregisterWindowsMenuCommand(gameWindow);
        if (this.conn.control != null) {
            this.conn.control.sgc.uninform(gameWindow);
        }
        gameWindow.commitSuicide();
    }

    public void adjournAll() {
        for (int i = 0; i < this.gameWindows.size(); ++i) {
            ((GameWindow)this.gameWindows.elementAt(i)).adjourn();
        }
    }

    public GameWindow getGameWindowByName(String string, String string2) {
        return this.getGameWindowByName(string, string2, -1);
    }

    public GameWindow getGameWindowByName(String string, String string2, int n) {
        Enumeration enumeration = this.gameWindows.elements();
        while (enumeration.hasMoreElements()) {
            GameWindow gameWindow = (GameWindow)enumeration.nextElement();
            if (!gameWindow.game.whiteName.equals(string) || !gameWindow.game.blackName.equals(string2)) continue;
            if (n > 0) {
                GameWindow gameWindow2 = this.getGameWindowByNumber(n);
                if (gameWindow2 != null && gameWindow2 != gameWindow) {
                    gameWindow2.gameNumber = 0;
                }
                String string3 = gameWindow.title();
                if (gameWindow.gameNumber != n) {
                    gameWindow.gameNumber = n;
                    gameWindow.updateTitle();
                    registrar.updateWindowTitle(gameWindow);
                }
            }
            return gameWindow;
        }
        return null;
    }

    public GameWindow getGameWindowByNumber(int n) {
        GameWindow gameWindow = null;
        Enumeration enumeration = this.gameWindows.elements();
        while (enumeration.hasMoreElements()) {
            GameWindow gameWindow2 = (GameWindow)enumeration.nextElement();
            if (gameWindow2.gameNumber != n) continue;
            if (gameWindow2.isOnServer()) {
                gameWindow = gameWindow2;
                continue;
            }
            if (gameWindow != null) continue;
            gameWindow = gameWindow2;
        }
        return gameWindow;
    }

    public GameWindow getGameBeingPlayed() {
        Enumeration enumeration = this.gameWindows.elements();
        while (enumeration.hasMoreElements()) {
            GameWindow gameWindow = (GameWindow)enumeration.nextElement();
            if (!gameWindow.isParticipating()) continue;
            return gameWindow;
        }
        return null;
    }

    private void send(String string) {
        if (this.conn != null && this.conn.isConnected()) {
            this.conn.send(string);
        } else {
            this.displayString(string);
            this.displayString(MSG_ERROR_NO_CONNECTION.get());
        }
    }

    private void processKibitzCommand(String string, ParsedMessage parsedMessage, GameWindow gameWindow, boolean bl) {
        String string2 = parsedMessage.rest();
        int n = gameWindow == null ? -1 : gameWindow.gameNumber;
        try {
            parsedMessage.continueParse("%i ");
            n = (Integer)parsedMessage.matchAt(1);
            string2 = parsedMessage.rest();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        GameWindow gameWindow2 = this.getGameWindowByNumber(n);
        if (gameWindow2 == null) {
            gameWindow2 = gameWindow;
        }
        if (gameWindow2 == null) {
            GameWindow gameWindow3 = null;
            int n2 = 0;
            for (int i = 0; i < this.gameWindows.size(); ++i) {
                GameWindow gameWindow4 = (GameWindow)this.gameWindows.elementAt(i);
                if (gameWindow4.gameStatus == 1 || gameWindow4.gameStatus == 2) continue;
                gameWindow3 = gameWindow4;
                ++n2;
            }
            if (n2 == 1) {
                gameWindow2 = gameWindow3;
            } else {
                this.displayString(MSG_ERROR_LOST_KIBITS_WINDOW.get());
            }
        }
        if (gameWindow2 != null) {
            if (!bl && gameWindow2.isNetGame()) {
                this.conn.send("kibitz " + gameWindow2.gameNumber + " " + string2, false);
            }
            if (bl || !gameWindow2.isNetGame() || !gameWindow2.isTeachingGame() || !gameWindow2.isParticipating()) {
                gameWindow2.addKibitz(this.getAccountName(), this.getRank(), string2, bl);
            }
        } else {
            this.send(string);
        }
    }

    private void processGameArgCommand(String string, ParsedMessage parsedMessage, GameWindow gameWindow) {
        if (gameWindow == null) {
            this.send(string);
        } else {
            String string2 = parsedMessage.rest();
            boolean bl = false;
            for (int i = 0; i < string2.length(); ++i) {
                if (Character.isWhitespace(string2.charAt(i))) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.send(string);
            } else {
                this.send(string + " " + gameWindow.gameNumber);
            }
        }
    }

    private boolean isWord(String string, String string2, String string3) {
        if (this.conn == null || !this.conn.isConnected() || !this.conn.server.matchCase()) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
            string3 = string3.toLowerCase();
        }
        return string2.startsWith(string) && string.startsWith(string3);
    }

    private boolean stringEqual(String string, String string2) {
        return this.conn == null || !this.conn.isConnected() || !this.conn.server.matchCase() ? string.equalsIgnoreCase(string2) : string.equals(string2);
    }

    public void processCommand(String string, GameWindow gameWindow) {
        CommandHistory commandHistory;
        CommandHistory commandHistory2 = commandHistory = gameWindow == null ? this.commandHistory : gameWindow.getCommandHistory();
        if (commandHistory != null && string != null && !"".equals(string)) {
            commandHistory.addElement(string);
        }
        try {
            ParsedMessage parsedMessage = new ParsedMessage(string, " %s ");
            String string2 = (String)parsedMessage.matchAt(0);
            if ("'".equals(string2) || this.isWord(string2, "kibitz ", "kib")) {
                this.processKibitzCommand(string, parsedMessage, gameWindow, false);
            } else if (this.stringEqual("say", string2)) {
                this.conn.send(string);
                GameWindow gameWindow2 = this.getGameBeingPlayed();
                if (gameWindow2 != null && !gameWindow2.isTeachingGame()) {
                    gameWindow2.addKibitz1("*" + this.getAccountName() + "*: " + parsedMessage.rest(), false);
                }
            } else if (this.stringEqual(string2, "all")) {
                this.processGameArgCommand(string, parsedMessage, gameWindow);
            } else if (this.stringEqual(string2, "time")) {
                this.processGameArgCommand(string, parsedMessage, gameWindow);
            } else if (this.stringEqual(string2, "moves")) {
                this.processGameArgCommand(string, parsedMessage, gameWindow);
            } else if (this.stringEqual(string2, "score")) {
                this.processGameArgCommand(string, parsedMessage, gameWindow);
            } else if (this.isWord(string2, "localkibitz ", "loc") || this.stringEqual(string2, "lkib") || "$".equals(string2)) {
                this.processKibitzCommand(string, parsedMessage, gameWindow, true);
            } else {
                this.send(string);
            }
        }
        catch (ParseException parseException) {
            this.send(string);
        }
    }

    public boolean getSoundEnabled() {
        return this.soundEnabled;
    }

    public void setDefaultDirectory(String string) {
        this.defaultDirectory = string;
    }

    public String getDefaultDirectory() {
        return this.defaultDirectory;
    }

    public boolean saveTerminalOutput(TextArea textArea) {
        FileDialog fileDialog = new FileDialog((Frame)this, LB_SAVE_TERMINAL_OUTPUT.get(), 1);
        if (this.getDefaultDirectory() != null) {
            fileDialog.setDirectory(this.getDefaultDirectory());
        }
        fileDialog.setFile("output.txt");
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return true;
        }
        String string = fileDialog.getDirectory() + fileDialog.getFile();
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            textArea.save(printWriter);
            printWriter.close();
            this.setDefaultDirectory(fileDialog.getDirectory());
            return false;
        }
        catch (IOException iOException) {
            this.displayString(LB_SAVE_ERROR.get(iOException));
            return false;
        }
    }

    public void load() {
        FileDialog fileDialog = new FileDialog((Frame)this, LB_LOAD_SGF.get());
        if (this.defaultDirectory != null) {
            fileDialog.setDirectory(this.getDefaultDirectory());
        }
        fileDialog.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith("sgf");
            }
        });
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            this.setDefaultDirectory(fileDialog.getDirectory());
            string = fileDialog.getDirectory() + string;
            SGF sGF = new SGF(this);
            try {
                Vector vector = sGF.readSGFFile(string);
                for (int i = 0; i < vector.size(); ++i) {
                    Game game = (Game)vector.elementAt(i);
                    GameWindow gameWindow = new GameWindow(game, this);
                    game.setWindow(gameWindow);
                    this.addGameWindow(gameWindow);
                    gameWindow.setKibitzState(true, true);
                }
            }
            catch (Exception exception) {
                Debug.backtrace(exception);
                new InformDialog((Frame)this, LB_ERROR.get(), MSG_INVALID_SGF_FILE.get(exception.getMessage())).open();
            }
        }
    }

    private void exit() {
        if (this.conn.isConnected()) {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    if ("Yes".equalsIgnoreCase(string)) {
                        TerminalWindow.this.actuallyExit();
                    }
                }
            };
            new YNCDialog(this, LB_ASK_QUIT.get(), true, MSG_ASK_QUIT.get(this.conn), actionListener, false).open();
        } else {
            this.actuallyExit();
        }
    }

    private void actuallyExit() {
        if (this.conn.isConnected()) {
            this.conn.close();
        }
        if (Ergo.inApplet) {
            this.setVisible(false);
        } else {
            if (Ergo.opser.getBooleanOption(exitString)) {
                Ergo.opser.rewriteFile();
            }
            System.exit(0);
        }
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            super.setVisible(bl);
            for (int i = 0; i < this.gameWindows.size(); ++i) {
                ((GameWindow)this.gameWindows.elementAt(i)).setVisible(bl);
            }
        }
    }

    public String getRank() {
        return this.rank;
    }

    public String toString() {
        String string = "hErgo " + Ergo.version();
        if (this.conn != null) {
            string = string + "  (";
            if (this.getAccountName() != null) {
                string = string + this.getAccountName() + " on ";
            }
            string = string + this.conn.toString() + ")";
        }
        return string;
    }

    public void startLocalGame() {
        LocalGameDialog localGameDialog = new LocalGameDialog(this);
        localGameDialog.open();
    }

    public void displayNoiseString(String string) {
        this.displayStringInternal(string, this.messageArea, false, null);
    }

    public void displayShout(String string) {
        this.displayString(string, shoutColor);
    }

    public void updateTitle() {
        this.setTitle(this.toString());
    }

    public YNCDialog openYNCDialog(String string, boolean bl, String string2, String string3, String string4, String string5, ActionListener actionListener) {
        YNCDialog yNCDialog = new YNCDialog(this, string, bl, string2, string3, string4, string5, actionListener);
        yNCDialog.open();
        return yNCDialog;
    }

    public void noteConnected() {
        this.goConnectSubmenu.setEnabled(false);
        this.disconnectItem.setEnabled(true);
        this.matchItem.setEnabled(true);
        this.observeItem.setEnabled(true);
    }

    public void noteDisconnected() {
        this.setAccountName(null);
        this.adjournAll();
        this.updateTitle();
        this.goConnectSubmenu.setEnabled(true);
        this.disconnectItem.setEnabled(false);
        this.matchItem.setEnabled(false);
        this.observeItem.setEnabled(false);
    }

    public void beep() {
        if (this.getSoundEnabled()) {
            Util.beep();
        }
    }

    public void updateGameStatus(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        GameWindow gameWindow = this.getGameWindowByNumber(n);
        Debug.assertion(gameWindow != null, "gwin != null");
        gameWindow.updateTimers(n2, n3, n4, n5, n6, n7);
    }

    public boolean isDisplayingGame(String string, String string2, int n) {
        return null != this.getGameWindowByName(string, string2, n);
    }

    public GameWindow createGame(int n, String string, String string2, String string3, String string4, double d) {
        GameWindow gameWindow = new GameWindow(n, string, string2, string3, string4, d, this);
        this.addGameWindow(gameWindow);
        return gameWindow;
    }

    public void placeMove(String string, String string2, int n, Move move, boolean bl) {
        GameWindow gameWindow = this.getGameWindowByName(string, string2, n);
        if (gameWindow != null) {
            gameWindow.placeMove(move, bl);
        }
    }

    public void resignGame(String string, String string2, int n, String string3) {
        GameWindow gameWindow = this.getGameWindowByName(string, string2, n);
        if (gameWindow != null) {
            gameWindow.resign(string3);
        }
    }

    public void adjournGame(String string, String string2, int n) {
        GameWindow gameWindow = this.getGameWindowByName(string, string2, n);
        if (gameWindow != null) {
            gameWindow.adjourn();
        }
    }

    public void undoMove() {
        this.undoMoveInternal(this.getGameBeingPlayed());
    }

    public void undoMove(String string, String string2, int n) {
        this.undoMoveInternal(this.getGameWindowByName(string, string2, n));
    }

    private void undoMoveInternal(GameWindow gameWindow) {
        if (gameWindow != null) {
            gameWindow.undo();
            gameWindow.game.ss.emit();
        } else {
            Debug.println("handleUndo: game window not found!");
        }
    }

    public void setKomi(double d, int n) {
        GameWindow gameWindow;
        GameWindow gameWindow2 = gameWindow = n == -1 ? this.getGameBeingPlayed() : this.getGameWindowByNumber(n);
        if (gameWindow != null) {
            gameWindow.game.setKomi(d);
            gameWindow.refresh();
        }
    }

    public void removeGroupAt(String string) {
        GameWindow gameWindow = this.getGameBeingPlayed();
        if (gameWindow != null) {
            try {
                Position position = new Position(string, gameWindow.game.size());
                Move move = gameWindow.game.finalServerMove();
                gameWindow.placeMove(new RemovalMove(move, position, move.moveNumber() + 1, false), true);
                gameWindow.game.ss.emit();
                return;
            }
            catch (ParseException parseException) {
                Debug.backtrace(parseException);
            }
        }
    }

    public boolean getRawMode() {
        return this.rawMode;
    }

    public void displayString(String string, Color color, boolean bl) {
        if (bl || !this.rawMode) {
            this.displayStringInternal(string, this.mainArea, true, color);
        }
    }

    public void displayStringInActiveGame(String string) {
        GameWindow gameWindow = this.getGameBeingPlayed();
        if (gameWindow != null) {
            gameWindow.displayString(string);
        } else {
            this.displayString(string);
        }
    }

    public void displayWarning(String string) {
        this.displayString(string, warningColor);
    }

    public void displayCommand(String string) {
        this.displayString(string, commandColor);
    }

    public void displayLoginDialog() {
        if (this.loginDialog == null) {
            this.loginDialog = new LoginDialog(this, this.conn);
        }
        this.loginDialog.hecho = false;
        this.loginDialog.passwordSent = false;
        if (!this.loginDialog.isShowing()) {
            this.loginDialog.setTitle(LB_LOGIN_TO.get(this.conn.shortName()));
            this.loginDialog.open();
        }
    }

    public void displayKibitz(String string, String string2, int n, String string3, String string4, String string5) {
        GameWindow gameWindow = this.getGameWindowByName(string, string2, n);
        if (gameWindow != null) {
            gameWindow.addKibitz(string3, string4, string5, false);
        } else {
            Debug.println("game window for kibitz not found");
        }
    }

    public void displayMatchRequest(String string, String string2, String string3, String string4, String string5) {
        MatchDialog matchDialog = new MatchDialog((Frame)this, true);
        matchDialog.open(this.conn, this.getAccountName(), string, string2, string3, string4, string5);
    }

    public void unobserveGame(int n) {
        GameWindow gameWindow = this.getGameWindowByNumber(n);
        if (gameWindow != null) {
            gameWindow.adjourn();
            this.removeGameWindow(gameWindow);
        }
    }

    public void makeGameFree(int n) {
        GameWindow gameWindow;
        GameWindow gameWindow2 = gameWindow = n == -1 ? this.getGameBeingPlayed() : this.getGameWindowByNumber(n);
        if (gameWindow != null) {
            gameWindow.setOurColor(12);
        }
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String string) {
        this.accountName = string;
        this.updateTitle();
    }

    public void setAccountRank(String string) {
        this.rank = string;
    }

    public void displayYell(String string, String string2) {
        this.displayString(FMT_YELL.get(new Object[]{string, string2}), yellColor);
    }

    public void displayTell(String string) {
        this.displayString(string, tellColor);
    }

    public void displaySay(String string) {
        GameWindow gameWindow = this.getGameBeingPlayed();
        if (gameWindow == null) {
            this.displayString(string, kibitzColor);
        } else {
            gameWindow.addKibitz1(string, false);
        }
    }

    public boolean loginDialogExists() {
        return this.loginDialog != null;
    }

    public boolean loginDialogDone() {
        return this.loginDialog.hecho;
    }

    public boolean passwordSent() {
        return this.loginDialog.passwordSent;
    }

    public void sendPassword() {
        this.conn.send(this.loginDialog.getPassword(), false);
        this.loginDialog.passwordSent = true;
    }

    public GameWindow addGameWindow(int n, String string, String string2, String string3, String string4, double d, int n2, int n3, int n4, boolean bl) {
        GameWindow gameWindow = new GameWindow(n, string, string2, string3, string4, d, this, this.conn, n2, n3, n4, bl);
        this.addGameWindow(gameWindow);
        return gameWindow;
    }

    public Component initialFocus() {
        return this.inputField;
    }

    public void focusOn(Component component) {
        if (component != null) {
            component.requestFocus();
            if (component instanceof TextField && ((TextField)component).getText().length() > 0) {
                ((TextField)component).selectAll();
            }
        }
    }

    public Vector focusOrder() {
        if (this.focusOrder == null) {
            this.focusOrder = new Vector(1);
            this.focusOrder.addElement(this.inputField);
        }
        return this.focusOrder;
    }

    public String menuString() {
        return LB_TERMINAL_VIEW.get();
    }

    public MenuShortcut menuShortcut() {
        return new MenuShortcut(116);
    }

    public int menuPriority() {
        return 100;
    }

    public void menuSelect(Frame frame) {
        this.toFront();
        this.setVisible(true);
        this.inputField.requestFocus();
    }

    public Class appliesTo() {
        return null;
    }

    public void thwak() {
        this.ergo.thwak();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Message access$600() {
        return LB_WHO_VIEW;
    }

    static /* synthetic */ Message access$700() {
        return LB_GAME_VIEW;
    }

    class checkboxListener
    extends urCheckboxListener {
        checkboxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == TerminalWindow.this.debugItem) {
                boolean bl = TerminalWindow.this.debugItem.getState();
                Debug.setDebug(bl);
                Ergo.opser.updateOption("Debug Mode", new Boolean(bl));
            } else if (object == TerminalWindow.this.rawItem) {
                TerminalWindow.this.rawMode = !TerminalWindow.this.rawMode;
                TerminalWindow.this.rawItem.setState(TerminalWindow.this.rawMode);
            } else if (object == TerminalWindow.this.logicItem) {
                Debug.debugGameLogicp = !Debug.debugGameLogicp;
                TerminalWindow.this.logicItem.setState(Debug.debugGameLogicp);
            } else if (object == TerminalWindow.this.soundItem) {
                TerminalWindow.this.soundEnabled = !TerminalWindow.this.soundEnabled;
                Ergo.opser.updateOption("Sound", new Boolean(TerminalWindow.this.soundEnabled));
                TerminalWindow.this.soundItem.setState(TerminalWindow.this.soundEnabled);
            }
        }
    }

    class menuListener
    extends AbstractMenuListener {
        menuListener() {
        }

        public void itemSelected(MenuItem menuItem) {
            if (menuItem == TerminalWindow.this.loadItem) {
                TerminalWindow.this.load();
            } else if (menuItem == TerminalWindow.this.saveOutputItem) {
                TerminalWindow.this.saveTerminalOutput(TerminalWindow.this.mainArea);
            } else if (menuItem == TerminalWindow.this.clearOutputItem) {
                TerminalWindow.this.mainArea.clearAll();
                TerminalWindow.this.messageArea.clearAll();
            } else if (menuItem == TerminalWindow.this.observeItem) {
                if (TerminalWindow.this.observeDialog == null) {
                    TerminalWindow.this.observeDialog = new ObserveDialog(TerminalWindow.this, TerminalWindow.this.conn);
                }
                TerminalWindow.this.observeDialog.show();
            } else if (menuItem == TerminalWindow.this.matchItem) {
                new MatchDialog((Frame)TerminalWindow.this, false).open(TerminalWindow.this.conn);
            } else if (menuItem == TerminalWindow.this.localGameItem) {
                TerminalWindow.this.startLocalGame();
            } else if (menuItem == TerminalWindow.this.saveOptionsItem) {
                String string;
                String string2 = string = Ergo.inApplet ? MSG_CANT_WRITE_INIT_FILE_FROM_APPLET.get() : Ergo.opser.rewriteFile();
                if (string != null) {
                    new InformDialog((Frame)TerminalWindow.this, LB_ERROR.get(), string).open();
                }
            } else if (menuItem == TerminalWindow.this.aboutItem) {
                new AboutDialog((Frame)TerminalWindow.this, LB_ABOUT_ERGO.get()).open();
            } else if (menuItem == TerminalWindow.this.docItem) {
                if (Ergo.inApplet) {
                    TerminalWindow.this.ergo.getAppletContext().showDocument(TerminalWindow.this.ergo.getDocumentBase(), "doc.html");
                }
            } else if (menuItem == TerminalWindow.this.newServerItem) {
                new NewServerDialog(TerminalWindow.this).open();
            }
        }
    }

    class PopupHandler
    implements ActionListener {
        private MenuItem who_view = new MenuItem(TerminalWindow.access$600().get());
        private MenuItem games_view = new MenuItem(TerminalWindow.access$700().get());

        PopupHandler() {
        }

        public void populatePopup(PopupMenu popupMenu, Component component, int n, int n2) {
            popupMenu.add(this.games_view);
            popupMenu.add(this.who_view);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(this.who_view.getLabel())) {
                TerminalWindow.this.conn.send("who", false);
            } else if (string.equals(this.games_view.getLabel())) {
                TerminalWindow.this.conn.send("games", false);
            }
        }
    }

    class GoServerMenuItem
    extends MenuItem
    implements ActionListener {
        GoServer server;

        GoServerMenuItem(GoServer goServer) {
            super(goServer.toString());
            this.server = goServer;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!TerminalWindow.this.conn.open(this.server)) {
                TerminalWindow.this.displayString(MSG_UNABLE_TO_OPEN_CONNECTION.get(this.server.name));
            }
        }
    }
}

