/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Vector;

class RowLayout
implements LayoutManager2 {
    public static final int TOP = 1;
    public static final int CENTER = 2;
    public static final int BOTTOM = 3;
    private Vector specs = new Vector(5, 10);
    private int defaultAlignment = 1;
    private int defaultVSpace = 0;
    private int margin = 1;
    private boolean equalizeHeights = false;
    private int maxHeight = 0;

    public RowLayout(int n, int n2, int n3, boolean bl) {
        if (n == 1 || n == 2 || n == 3) {
            this.defaultAlignment = n;
        }
        this.defaultVSpace = n2;
        this.margin = n3;
        this.equalizeHeights = bl;
    }

    public RowLayout() {
    }

    public Constraint makeConstraint(int n, int n2, boolean bl) {
        return new Constraint(n, n2, bl);
    }

    private Component getComponent(Vector vector) {
        return (Component)vector.elementAt(0);
    }

    private Constraint getConstraint(Vector vector) {
        return (Constraint)vector.elementAt(1);
    }

    public void addLayoutComponent(Component component, Object object) {
        this.removeLayoutComponent(component);
        Constraint constraint = !(object instanceof Constraint) ? new Constraint() : (Constraint)object;
        Vector<Object> vector = new Vector<Object>(2);
        vector.addElement(component);
        vector.addElement(constraint);
        this.specs.addElement(vector);
    }

    public void removeLayoutComponent(Component component) {
        for (int i = 0; i < this.specs.size(); ++i) {
            Vector vector = (Vector)this.specs.elementAt(i);
            if (vector.elementAt(0) != component) continue;
            this.specs.removeElementAt(i);
            return;
        }
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Vector vector;
        int n;
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        int n2 = insets.left + this.margin;
        int n3 = insets.top + this.margin;
        int n4 = dimension.width - insets.right - this.margin;
        if (this.equalizeHeights) {
            for (n = 0; n < this.specs.size(); ++n) {
                vector = (Vector)this.specs.elementAt(n);
                this.maxHeight = Math.max(this.maxHeight, this.getComponent((Vector)vector).getPreferredSize().height);
            }
        }
        for (n = 0; n < this.specs.size(); ++n) {
            vector = (Vector)this.specs.elementAt(n);
            Component component = this.getComponent(vector);
            Constraint constraint = this.getConstraint(vector);
            if (!component.isVisible()) continue;
            int n5 = n3;
            int n6 = constraint.alignment;
            int n7 = constraint.spacing;
            Dimension dimension2 = component.getPreferredSize();
            int n8 = dimension2.height;
            if (!constraint.fixedHeight) {
                n8 = Math.max(this.maxHeight, n8);
            }
            if (n6 == 2) {
                n5 += (dimension.height - n3 - insets.bottom - n8 - this.margin) / 2;
            } else if (n6 == 3) {
                n5 = dimension.height - insets.bottom - this.margin - n8;
            }
            if (n7 < 0) {
                n4 -= dimension2.width + n7;
                component.setBounds(n2, n5, dimension2.width, n8);
                continue;
            }
            component.setBounds(n2, n5, dimension2.width, n8);
            n2 += dimension2.width + n7;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, "min");
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, "pref");
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.getLayoutSize(container, "max");
    }

    private Dimension getLayoutSize(Container container, String string) {
        Dimension dimension = new Dimension(0, 0);
        Insets insets = container.getInsets();
        for (int i = 0; i < this.specs.size(); ++i) {
            Vector vector = (Vector)this.specs.elementAt(i);
            Component component = this.getComponent(vector);
            Constraint constraint = this.getConstraint(vector);
            if (!component.isVisible()) continue;
            Dimension dimension2 = "pref".equals(string) ? component.getPreferredSize() : ("min".equals(string) ? component.getMinimumSize() : component.getMaximumSize());
            dimension.width += dimension2.width + constraint.spacing;
            dimension.height = Math.max(this.maxHeight, Math.max(dimension.height, dimension2.height));
        }
        dimension.width += insets.left + insets.right + this.margin * 2;
        dimension.height += insets.top + insets.bottom + this.margin * 2;
        return dimension;
    }

    class Constraint {
        int alignment;
        int spacing;
        boolean fixedHeight;

        Constraint() {
            this.alignment = RowLayout.this.defaultAlignment;
            this.spacing = RowLayout.this.defaultVSpace;
            this.fixedHeight = false;
        }

        Constraint(int n, int n2, boolean bl) {
            this.alignment = RowLayout.this.defaultAlignment;
            this.spacing = RowLayout.this.defaultVSpace;
            this.fixedHeight = false;
            this.alignment = n;
            this.spacing = n2;
            this.fixedHeight = bl;
        }
    }
}

