/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import java.awt.image.MemoryImageSource;

class RawImage {
    int[] data;
    int width;
    int height;
    private int xorig;
    private int yorig;
    private MemoryImageSource mis;

    public RawImage() {
        this.width = 0;
        this.height = 0;
    }

    public RawImage(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.data = new int[this.width * this.height];
        this.init();
    }

    public RawImage(int[] nArray, int n) {
        this.data = nArray;
        this.width = n;
        this.height = this.data.length / this.width;
        this.init();
    }

    public RawImage reinit(int n, int n2) {
        if (this.width != n || this.height != n2) {
            this.width = n;
            this.height = n2;
            this.data = new int[this.width * this.height];
            this.init();
        } else {
            this.blank(0);
        }
        return this;
    }

    public RawImage bclone() {
        return new RawImage(this.width, this.height);
    }

    private void init() {
        this.mis = new MemoryImageSource(this.width, this.height, this.data, 0, this.width);
        this.mis.setAnimated(true);
        this.mis.setFullBufferUpdates(true);
    }

    public void setorig(int n, int n2) {
        this.xorig = n;
        this.yorig = n2;
    }

    public void setpixel(int n, int n2, int n3) {
        int n4 = n2 + this.xorig;
        int n5 = n3 + this.yorig;
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 >= this.width) {
            n4 = this.width - 1;
        }
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 >= this.height) {
            n5 = this.height - 1;
        }
        this.data[n4 + n5 * this.width] = n;
    }

    public void setband(int n, int n2, int n3, int n4) {
        int n5 = n2 + this.xorig;
        int n6 = n3 + this.xorig;
        int n7 = n4 + this.yorig;
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 >= this.width) {
            n5 = this.width - 1;
        }
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 >= this.width) {
            n6 = this.width - 1;
        }
        if (n7 < 0) {
            n7 = 0;
        } else if (n7 >= this.height) {
            n7 = this.height - 1;
        }
        for (int i = n5; i <= n6; ++i) {
            this.data[i + n7 * this.width] = n;
        }
    }

    public RawImage blank(int n) {
        int n2 = this.data.length;
        for (int i = 0; i < n2; ++i) {
            this.data[i] = n;
        }
        return this;
    }

    public MemoryImageSource mis() {
        return this.mis;
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                string = string + (this.data[j + this.width * i] & 0xFF) + " ";
            }
            string = string + "\n";
        }
        return string;
    }
}

