/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.server.GoServer;
import ergo.ui.ColorSpec;
import ergo.ui.FontManager;
import ergo.ui.FontSpec;
import ergo.ui.OptionHandler;
import ergo.ui.OptionStorage;
import ergo.ui.Optionizable;
import ergo.util.Debug;
import ergo.util.ErgoException;
import ergo.util.ParseException;
import ergo.util.ParsedMessage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class Optionizer
implements Optionizable {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_INTEGER = 1;
    public static final int TYPE_BOOLEAN = 2;
    public static final int TYPE_SERVER = 3;
    public static final int TYPE_COLOR = 4;
    public static final int TYPE_FONT = 5;
    public static final int TYPE_SIZE = 6;
    public static final int TYPE_POSITION = 7;
    public static final int TYPE_BOUNDS = 8;
    public static final int TYPE_STRING = 9;
    public static final String s = " ";
    private static final String specialLine = "### User Editable Options are probably all above this line";
    private OptionHandler[] handlers = new OptionHandler[]{null, new handleInteger(), new handleBoolean(), new handleServer(), new handleColor(), new handleFont(), new handleSize(), new handlePosition(), new handleRectangle(), new handleString()};
    public static final String currentString = "Current Option Set";
    private Hashtable optionmap = new Hashtable();
    private int currentset = 0;
    private String initFile = null;
    private static Boolean T = new Boolean(true);
    private static Boolean F = new Boolean(false);
    Dimension desktopSize = new Dimension(800, 600);
    private Rectangle desktopRect;
    private String defaultString = "Default Font";
    private String formatString = "Format";
    public final String savingString = ":Saving";
    public String textcolString = "Text Window Color";
    public String textbackString = "Text Window Background Color";
    public String texthighbackString = "Text Window Highlight Background Color";
    public String texthighString = "Text Window Highlight Color";
    iniParse iniParser = new iniParse();
    Cascader cascader = new Cascader();

    private osEnumeration storages() {
        return new osEnumeration(this.optionmap.elements());
    }

    public Optionizer() {
        this.expressOwnership(currentString, 1, this, new Integer(0));
        this.expressOwnership(this.defaultString, 5, null, null);
        this.expressOwnership(this.formatString, 1, this, new Integer(1));
        this.expressOwnership(":Saving", 2, null, T);
        try {
            this.desktopSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
            this.desktopSize = new Dimension(800, 600);
        }
        this.desktopRect = new Rectangle(this.desktopSize);
    }

    public void optionEvent(String string, Object object) {
        if (this.isSameKey(string, currentString)) {
            this.currentset = (Integer)object;
        } else if (this.isSameKey(string, this.formatString)) {
            int n = (Integer)object;
            if (n != 1) {
                System.out.println("Error: Invalid init file format: " + object);
            }
            if (n == 0) {
                System.out.println("To migrate from format 0, make the following changes:");
                System.out.println("1. Place numbers ascending from 0 in square brackets after server names,");
                System.out.println("   -- e.g. server[2]: NNGS nngs.cosmic.org 9696 NNGS");
                System.out.println("You may also remove hyphens from key names.");
            }
        }
    }

    public void setInitFile(String string) {
        this.initFile = string;
    }

    public boolean isSameKey(String string, String string2) {
        return string.equalsIgnoreCase(string2);
    }

    private OptionStorage lookup(String string) {
        return (OptionStorage)this.optionmap.get(string.toLowerCase());
    }

    private String hyphenMap(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '-') continue;
            stringBuffer.setCharAt(i, ' ');
        }
        return stringBuffer.toString().toLowerCase();
    }

    public void inSuck(InputStream inputStream) throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (!this.iniParser.parseLine(string)) continue;
            OptionStorage optionStorage = this.lookup(this.iniParser.keyword);
            if (optionStorage == null) {
                optionStorage = this.allocateQuietly(this.iniParser.keyword, this.iniParser.originalkeyword);
            }
            if (optionStorage.type == -1) {
                optionStorage.applyData(this.iniParser.number, this.iniParser.value);
                continue;
            }
            Object object = this.handlers[optionStorage.type].handle(this.iniParser.keyword, this.iniParser.value);
            this.updateOption(this.iniParser.keyword, this.iniParser.number, object);
            optionStorage.internaldefault = true;
        }
    }

    private void unsetAllFlags() {
        osEnumeration osEnumeration2 = this.storages();
        while (osEnumeration2.hasMoreElements()) {
            osEnumeration2.nextElement().unsetAllFlags();
        }
    }

    private void calcallhighs() {
        osEnumeration osEnumeration2 = this.storages();
        while (osEnumeration2.hasMoreElements()) {
            osEnumeration2.nextElement().calchighestseen();
        }
    }

    private Boolean opposite(boolean bl) {
        if (bl) {
            return F;
        }
        return T;
    }

    public String rewriteFile() {
        Object object;
        Object object2;
        Object object3;
        this.unsetAllFlags();
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(this.initFile);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
            return "Couldn't reopen INI file for reading";
        }
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (!this.iniParser.parseLine(string)) continue;
                object3 = this.lookup(this.iniParser.keyword);
                ((OptionStorage)object3).setFlagAt(this.iniParser.number);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
            return "Couldn't read INI file " + this.initFile;
        }
        this.calcallhighs();
        this.unsetAllFlags();
        this.updateOption(":Saving", this.opposite(this.getBooleanOption(":Saving")));
        boolean bl = false;
        try {
            fileInputStream = new FileInputStream(this.initFile);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            if (fileInputStream == null || bufferedReader == null) {
                throw new Exception("Baam.");
            }
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
            return "Couldn't reopen INI file for reading";
        }
        object3 = new File(this.initFile);
        String string = ((File)object3).getParent();
        File file = new File(string, "OPSINI.TMP");
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            printWriter = new PrintWriter(fileOutputStream);
            if (fileOutputStream == null || printWriter == null) {
                throw new Exception("Boom.");
            }
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
            return "Couldn't open temporary file " + file + " for writing";
        }
        try {
            while ((object2 = bufferedReader.readLine()) != null) {
                if (((String)object2).equals(specialLine)) {
                    bl = true;
                }
                if (!this.iniParser.parseLine((String)object2)) {
                    printWriter.println((String)object2);
                    continue;
                }
                object = this.lookup(this.iniParser.keyword);
                if (((OptionStorage)object).dataAt(this.iniParser.number) != null && !((OptionStorage)object).internaldefault) {
                    this.writeOption(printWriter, (OptionStorage)object, this.iniParser.keyword, this.iniParser.number);
                } else {
                    printWriter.println((String)object2);
                }
                if (this.iniParser.number != ((OptionStorage)object).highestseen) continue;
                this.writeOptions(printWriter, (OptionStorage)object, this.iniParser.keyword);
            }
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
            return "Failed to reread INI file";
        }
        object2 = this.optionmap.keys();
        if (!bl) {
            printWriter.println();
            printWriter.println(specialLine);
            printWriter.println();
        }
        while (object2.hasMoreElements()) {
            OptionStorage optionStorage;
            object = (String)object2.nextElement();
            if (this.isSameKey((String)object, ":Saving") || (optionStorage = this.lookup((String)object)) == null) continue;
            this.writeOptions(printWriter, optionStorage, (String)object);
        }
        try {
            if (printWriter.checkError()) {
                return "Unknown error while writing init file";
            }
            bufferedReader.close();
            printWriter.close();
            boolean bl2 = ((File)object3).delete();
            if (!bl2) {
                return "Failed to delete old INI file " + ((File)object3).getName();
            }
            boolean bl3 = file.renameTo((File)object3);
            if (!bl3) {
                return "Failed to rename temporary INI file " + file.getName();
            }
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
            return "Failed to finish rewriting INI file.";
        }
        return null;
    }

    private void writeOptions(PrintWriter printWriter, OptionStorage optionStorage, String string) {
        for (int i = 0; i < optionStorage.size(); ++i) {
            if (!(optionStorage.dataAt(i) != null & !optionStorage.flagAt(i) & !optionStorage.internaldefault)) continue;
            this.writeOption(printWriter, optionStorage, string, i);
        }
    }

    private void writeOption(PrintWriter printWriter, OptionStorage optionStorage, String string, int n) {
        if (optionStorage.originalkeyword != null) {
            printWriter.print(optionStorage.originalkeyword);
        } else {
            printWriter.print(string);
        }
        if (optionStorage.size() > 1) {
            printWriter.print("[" + n + "]");
        }
        printWriter.print(": ");
        if (optionStorage.type == -1) {
            printWriter.println(optionStorage.dataAt(n));
        } else {
            printWriter.println(this.handlers[optionStorage.type].render(optionStorage.dataAt(n)));
        }
        optionStorage.setFlagAt(n);
    }

    public void updateOption(String string, int n, Object object) {
        OptionStorage optionStorage = this.lookup(string);
        if (object != null && object.equals(optionStorage.dataAt(n))) {
            return;
        }
        optionStorage.internaldefault = false;
        optionStorage.applyData(n, object);
        if (n == this.currentset) {
            for (int i = 0; i < optionStorage.targets.size(); ++i) {
                optionStorage.targets.optionizableAt(i).optionEvent(string, object);
            }
        }
    }

    public void updateOption(String string, Object object) {
        this.updateOption(string, this.currentset, object);
    }

    public Object getOption(String string) throws ErgoException {
        return this.getOption(string, this.currentset);
    }

    public Object getOption(String string, int n) {
        OptionStorage optionStorage = this.lookup(string);
        Debug.assertion(optionStorage != null && optionStorage.type != -1, "Option \"" + string + "\" requested before initialised.");
        if (n >= optionStorage.size() || optionStorage.dataAt(n) == null) {
            return optionStorage.dataAt(0);
        }
        return optionStorage.dataAt(n);
    }

    public int getIntegerOption(String string) {
        try {
            Integer n = (Integer)this.getOption(string);
            if (n != null) {
                return n;
            }
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
        }
        return 10;
    }

    public boolean getBooleanOption(String string) {
        try {
            Boolean bl = (Boolean)this.getOption(string);
            if (bl != null) {
                return bl;
            }
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
        }
        return false;
    }

    public Color getColorOption(String string) {
        try {
            ColorSpec colorSpec = (ColorSpec)this.getOption(string);
            if (colorSpec != null) {
                return colorSpec.getColor();
            }
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
        }
        return Color.white;
    }

    public Font getFontOption(String string) {
        try {
            Object object = this.getOption(string);
            FontSpec fontSpec = (FontSpec)object;
            if (fontSpec != null) {
                return fontSpec.getFont();
            }
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
        }
        return FontManager.getDefaultFont();
    }

    public Point getNextCascade(Dimension dimension) {
        return this.cascader.getNext(dimension);
    }

    public Dimension getSizeOption(String string) {
        Dimension dimension = null;
        try {
            dimension = (Dimension)this.getOption(string);
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
        }
        if (dimension == null) {
            return null;
        }
        if (dimension.width > this.desktopSize.width) {
            dimension.width = this.desktopSize.width;
        }
        if (dimension.height > this.desktopSize.height) {
            dimension.height = this.desktopSize.height;
        }
        return dimension;
    }

    public Point getPointOption(String string) {
        Point point = null;
        try {
            point = (Point)this.getOption(string);
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
        }
        if (point == null) {
            return new Point(0, 0);
        }
        return point;
    }

    public Rectangle getRectangleOption(String string) {
        Rectangle rectangle = null;
        try {
            rectangle = (Rectangle)this.getOption(string);
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
        }
        if (rectangle == null) {
            return null;
        }
        return rectangle.intersection(this.desktopRect);
    }

    public String getStringOption(String string) {
        try {
            String string2 = (String)this.getOption(string);
            if (string2 == null) {
                return "";
            }
            return string2;
        }
        catch (ErgoException ergoException) {
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
        }
        return "";
    }

    public int getOptionSize(String string) throws ErgoException {
        OptionStorage optionStorage = this.lookup(string);
        if (optionStorage == null) {
            throw new ErgoException("Option " + string + " not known in size.");
        }
        return optionStorage.size();
    }

    private OptionStorage allocateQuietly(String string, String string2) {
        OptionStorage optionStorage = new OptionStorage(string2);
        this.optionmap.put(string.toLowerCase(), optionStorage);
        return optionStorage;
    }

    public void expressOwnership(String string, int n, Optionizable optionizable, Object object) {
        OptionStorage optionStorage = this.lookup(string);
        if (optionStorage == null) {
            optionStorage = this.allocateQuietly(string, null);
            optionStorage.applyData(0, object);
            optionStorage.type = n;
        } else if (optionStorage.type == -1) {
            optionStorage.type = n;
            for (int i = 0; i < optionStorage.size(); ++i) {
                if (optionStorage.dataAt(i) == null) continue;
                try {
                    optionStorage.sosAt((int)i).data = this.handlers[n].handle(string, (String)optionStorage.dataAt(i));
                    continue;
                }
                catch (ParseException parseException) {
                    Debug.backtrace(parseException);
                }
            }
        } else {
            Debug.assertion(optionStorage.type == n, "Inconsistent types requested for options " + string);
        }
        if (optionStorage.sosAt((int)0).data == null) {
            optionStorage.sosAt((int)0).data = object;
        }
        if (optionizable != null) {
            optionStorage.targets.addElement(optionizable);
        }
    }

    public void disclaimOwnership(String string, Optionizable optionizable) {
        OptionStorage optionStorage = this.lookup(string);
        optionStorage.targets.removeElement(optionizable);
    }

    class handleString
    extends OptionHandler {
        handleString() {
        }

        public Object handle(String string, String string2) throws ParseException {
            ParsedMessage parsedMessage = new ParsedMessage(string2, " %s");
            return parsedMessage.stringAt(0);
        }
    }

    class handleRectangle
    extends OptionHandler {
        handleRectangle() {
        }

        public Object handle(String string, String string2) throws ParseException {
            ParsedMessage parsedMessage = new ParsedMessage(string2, " %i %i %i $i");
            Rectangle rectangle = new Rectangle(parsedMessage.intAt(0), parsedMessage.intAt(1), parsedMessage.intAt(2), parsedMessage.intAt(3));
            return rectangle;
        }

        public String render(Object object) {
            Rectangle rectangle = (Rectangle)object;
            return rectangle.x + Optionizer.s + rectangle.y + Optionizer.s + rectangle.width + rectangle.height;
        }
    }

    class handlePosition
    extends OptionHandler {
        handlePosition() {
        }

        public Object handle(String string, String string2) throws ParseException {
            ParsedMessage parsedMessage = new ParsedMessage(string2, " %i %i");
            Point point = new Point(parsedMessage.intAt(0), parsedMessage.intAt(1));
            return point;
        }

        public String render(Object object) {
            Point point = (Point)object;
            return point.x + Optionizer.s + point.y;
        }
    }

    class handleSize
    extends OptionHandler {
        handleSize() {
        }

        public Object handle(String string, String string2) throws ParseException {
            ParsedMessage parsedMessage = new ParsedMessage(string2, " %i %i");
            Dimension dimension = new Dimension(parsedMessage.intAt(0), parsedMessage.intAt(1));
            return dimension;
        }

        public String render(Object object) {
            Dimension dimension = (Dimension)object;
            return dimension.width + Optionizer.s + dimension.height;
        }
    }

    class handleFont
    extends OptionHandler {
        handleFont() {
        }

        public Object handle(String string, String string2) throws ParseException {
            ParsedMessage parsedMessage = new ParsedMessage(string2, " %s %s %s");
            FontSpec fontSpec = new FontSpec(parsedMessage.stringAt(0), parsedMessage.stringAt(1), parsedMessage.stringAt(2));
            if (string.equalsIgnoreCase(Optionizer.this.defaultString)) {
                FontManager.setDefaultFont(fontSpec.getFont());
            }
            return fontSpec;
        }
    }

    class handleColor
    extends OptionHandler {
        handleColor() {
        }

        public Object handle(String string, String string2) throws ParseException {
            ColorSpec colorSpec = new ColorSpec(string2);
            return colorSpec;
        }

        public String render(Object object) {
            ColorSpec colorSpec = (ColorSpec)object;
            return colorSpec.render();
        }
    }

    class handleServer
    extends OptionHandler {
        handleServer() {
        }

        public Object handle(String string, String string2) throws ParseException {
            ParsedMessage parsedMessage = new ParsedMessage(string2, " %s %s %i %s");
            GoServer goServer = new GoServer(parsedMessage.stringAt(1), parsedMessage.intAt(2), parsedMessage.stringAt(0), parsedMessage.stringAt(3));
            return goServer;
        }

        public String render(Object object) {
            GoServer goServer = (GoServer)object;
            return goServer.shortName() + Optionizer.s + goServer.name + Optionizer.s + goServer.port + Optionizer.s + goServer.typeString();
        }
    }

    class handleBoolean
    extends OptionHandler {
        handleBoolean() {
        }

        public Object handle(String string, String string2) throws ParseException {
            ParsedMessage parsedMessage = new ParsedMessage(string2, " %s");
            String string3 = parsedMessage.stringAt(0);
            Boolean bl = string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("on") || string3.equalsIgnoreCase("yes") || string3.equalsIgnoreCase("y") ? T : F;
            return bl;
        }
    }

    class handleInteger
    extends OptionHandler {
        handleInteger() {
        }

        public Object handle(String string, String string2) throws ParseException {
            ParsedMessage parsedMessage = new ParsedMessage(string2, " %i");
            Integer n = (Integer)parsedMessage.matchAt(0);
            return n;
        }
    }

    class Cascader {
        private final int firsty = 0;
        private final int firstx = 0;
        private final int diaginc = 50;
        private final int xinc = 100;
        private int currx = 0;
        private int lastnum = -1;

        Cascader() {
        }

        private void setToPos(Point point) {
            point.x = this.currx + this.lastnum * 50;
            point.y = 0 + this.lastnum * 50;
        }

        public Point getNext(Dimension dimension) {
            ++this.lastnum;
            Point point = new Point();
            this.setToPos(point);
            if (dimension.height + point.y > Optionizer.this.desktopSize.height) {
                this.lastnum = 0;
                this.currx += 100;
            }
            this.setToPos(point);
            if (dimension.width + point.x > Optionizer.this.desktopSize.width) {
                this.currx = 0;
                this.lastnum = 0;
            }
            this.setToPos(point);
            return point;
        }
    }

    class iniParse {
        String keyword;
        String originalkeyword;
        String value;
        int number;

        iniParse() {
        }

        boolean parseLine(String string) throws Exception {
            int n;
            int n2;
            int n3;
            int n4 = string.indexOf(35);
            int n5 = string.indexOf(58);
            int n6 = string.indexOf(91);
            int n7 = string.indexOf(93);
            boolean bl = false;
            if (n5 == -1) {
                return false;
            }
            if (n4 > -1) {
                if (n4 < n5) {
                    return false;
                }
                if (n6 > n5) {
                    bl = true;
                }
            } else if (n6 > -1) {
                bl = true;
            }
            int n8 = 0;
            if (bl) {
                if (n7 < n6) {
                    Debug.println("Incorrect option number in ini file: " + string);
                    return false;
                }
                n8 = n6 - 1;
            } else {
                n8 = n5 - 1;
            }
            for (n3 = 0; n3 < n5 && Character.isWhitespace(string.charAt(n3)); ++n3) {
            }
            for (n2 = n8; n2 >= 0 && Character.isWhitespace(string.charAt(n2)); --n2) {
            }
            if (n2 < n3) {
                Debug.println("No keyword found: " + string);
                return false;
            }
            int n9 = string.length();
            for (n = n5 + 1; n < n9 && Character.isWhitespace(string.charAt(n)); ++n) {
            }
            if (n == n9) {
                Debug.println("No value found: " + string);
                return false;
            }
            this.number = 0;
            if (bl) {
                try {
                    this.number = Integer.parseInt(string.substring(n6 + 1, n7));
                }
                catch (Exception exception) {
                    Debug.println("Incorrect numeric format in ini file: " + string);
                    return false;
                }
            }
            this.originalkeyword = this.keyword = string.substring(n3, n2 + 1);
            this.keyword = Optionizer.this.hyphenMap(this.keyword);
            this.value = string.substring(n);
            return true;
        }
    }

    class osEnumeration {
        Enumeration e;

        boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        OptionStorage nextElement() {
            return (OptionStorage)this.e.nextElement();
        }

        osEnumeration(Enumeration enumeration) {
            this.e = enumeration;
        }
    }
}

