/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.ui.MultiCallBackable;
import ergo.util.Debug;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.util.Hashtable;
import java.util.Vector;

public class MultiBox
extends Panel {
    private MultiCallBackable mcb;
    private String[] Format;
    private String[] Widther;
    private String[] Headings;
    private int sortMethod;
    private int columns;
    private int[] pixposition;
    private int toplinepix;
    private int lineheight;
    private boolean initted = false;
    public Font listFont = new Font("Dialog", 0, 14);
    public Color unselectedText = Color.black;
    public Color unselectedBackground = Color.white;
    public Color selectedBackground = Color.darkGray;
    public Color selectedText = Color.white;
    private int GUTTER = 10;
    private int vislines;
    public Scrollbar hScroll;
    public Scrollbar vScroll;
    public MultiListCanvas listCanvas;
    public MultiHeadingCanvas headingCanvas;
    private int selectedIndex = -1;
    private Vector lineDatap = new Vector();
    private Hashtable reverseLook = new Hashtable(20);
    private static final int EXTRA_HEIGHT = 4;
    private static final int BAR_HEIGHT = 2;
    private static final int LIP = 3;
    private static final int BITMAP_YINC = 10;
    private static final int BITMAP_YINIT = 20;

    public int columns() {
        return this.columns;
    }

    public int toplinepix() {
        return this.toplinepix;
    }

    public int lineheight() {
        return this.lineheight;
    }

    public int pixwidth() {
        return this.pixposition[this.columns];
    }

    public int pixheight() {
        return this.lineheight * this.lines();
    }

    public int pixposition(int n) {
        return this.pixposition[n];
    }

    public int scroll_increment() {
        return this.lineheight();
    }

    public void setColorVec(Color[] colorArray) {
        this.unselectedText = colorArray[0];
        this.unselectedBackground = colorArray[1];
        this.selectedText = colorArray[2];
        this.selectedBackground = colorArray[3];
        this.listCanvas.repaint();
        this.headingCanvas.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.listFont = font;
        this.calcColumns();
        this.listCanvas.reJig();
        this.headingCanvas.reJig();
        this.invalidate();
    }

    public int gutter() {
        return this.GUTTER;
    }

    public int visLines() {
        return this.vislines;
    }

    public void setVisLines(int n) {
        this.vislines = n;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public int lines() {
        return this.lineDatap.size();
    }

    public LineData reverseLook(Object object) {
        return (LineData)this.reverseLook.get(object);
    }

    public LineData lineDataAt(int n) {
        return (LineData)this.lineDatap.elementAt(n);
    }

    public String fieldAt(int n, int n2) {
        return this.lineDataAt((int)n).fields[n2];
    }

    public String headingAt(int n) {
        return this.Headings[n];
    }

    public String formatAt(int n) {
        return this.Format[n];
    }

    public MultiBox(MultiCallBackable multiCallBackable, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2) throws Exception {
        this.mcb = multiCallBackable;
        this.vislines = n;
        this.Format = stringArray;
        this.Widther = stringArray2;
        this.Headings = stringArray3;
        this.sortMethod = n2;
        this.init();
    }

    private void calcColumns() {
        FontMetrics fontMetrics = this.getFontMetrics(this.listFont);
        if (fontMetrics == null) {
            return;
        }
        this.pixposition[0] = this.GUTTER / 2;
        for (int i = 1; i <= this.columns; ++i) {
            int n = this.pixposition[i - 1];
            this.pixposition[i] = n + Math.max(fontMetrics.stringWidth(this.Headings[i - 1]), fontMetrics.stringWidth(this.Widther[i - 1])) + this.GUTTER;
        }
        int n = this.columns;
        this.pixposition[n] = this.pixposition[n] - this.GUTTER / 2;
        this.lineheight = fontMetrics.getHeight();
        this.toplinepix = fontMetrics.getLeading() + fontMetrics.getAscent();
    }

    private boolean init() {
        this.columns = this.Format.length;
        Debug.assertion(this.Format.length == this.Widther.length && this.Format.length == this.Headings.length, "MultiBox: Mismatch of argument lengths");
        this.pixposition = new int[this.columns + 1];
        this.calcColumns();
        this.hScroll = new Scrollbar(0);
        this.vScroll = new Scrollbar(1);
        this.listCanvas = new MultiListCanvas(this);
        this.listCanvas.addMouseListener(new mouseListener());
        this.headingCanvas = new MultiHeadingCanvas(this);
        this.setLayout(new BorderLayout());
        this.add("North", this.headingCanvas);
        this.add("Center", this.listCanvas);
        this.add("East", this.vScroll);
        this.add("South", this.hScroll);
        this.initted = true;
        return this.initted;
    }

    private boolean insertion() {
        boolean bl = false;
        for (int i = 1; i < this.lineDatap.size(); ++i) {
            int n;
            LineData lineData = this.lineDataAt(i);
            for (n = i; n > 0 && this.mcb.compare(this.sortMethod, this.lineDataAt((int)(n - 1)).theUseful, lineData.theUseful) > 0; --n) {
                bl = true;
                this.lineDatap.setElementAt(this.lineDataAt(n - 1), n);
            }
            this.lineDatap.setElementAt(lineData, n);
        }
        if (bl) {
            this.listCanvas.updateInternal();
        }
        return bl;
    }

    public void reSort(int n) {
        this.sortMethod = n;
    }

    public void insertEntry(Object object, String[] stringArray, boolean bl) {
        LineData lineData = new LineData(object, stringArray);
        this.lineDatap.addElement(lineData);
        this.reverseLook.put(object, lineData);
        if (!bl && !this.insertion()) {
            this.listCanvas.updateInternal();
        }
        this.listCanvas.reVScroll();
    }

    public void removeEntry(Object object, boolean bl) {
        LineData lineData = this.reverseLook(object);
        this.lineDatap.removeElement(lineData);
        this.reverseLook.remove(object);
        if (!bl) {
            this.listCanvas.updateInternal();
            this.listCanvas.reVScroll();
        }
    }

    public void updateEntry(Object object, String[] stringArray) {
        int n;
        LineData lineData = this.reverseLook(object);
        for (n = 0; n < stringArray.length; ++n) {
            lineData.fields[n] = stringArray[n];
        }
        if (!this.insertion()) {
            for (n = 0; n < this.lines() && this.lineDataAt(n) != lineData; ++n) {
            }
            this.listCanvas.updateLine(n);
        }
    }

    public void refresh() {
        this.insertion();
        this.listCanvas.updateInternal();
        this.listCanvas.reVScroll();
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.hScroll) {
            switch (event.id) {
                case 601: 
                case 602: 
                case 603: 
                case 604: 
                case 605: {
                    int n = (Integer)event.arg;
                    this.listCanvas.scroll(n, 0);
                    this.headingCanvas.scroll(n);
                }
            }
            return true;
        }
        if (event.target == this.vScroll) {
            switch (event.id) {
                case 601: 
                case 602: 
                case 603: 
                case 604: 
                case 605: {
                    int n = (Integer)event.arg;
                    this.listCanvas.scroll(0, n);
                }
            }
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        return this.mcb.actionOn(event, object);
    }

    private class MultiListCanvas
    extends Canvas {
        private MultiBox parent;
        private Graphics offg;
        private Image offi;
        private int xoffset;
        private int yoffset;
        private Dimension preferredSize = new Dimension();
        private int bitmapheight = 20;
        private Image hatcher;
        private Image hatchers;

        private int yoffset() {
            return this.yoffset;
        }

        private int xoffset() {
            return this.xoffset;
        }

        private MultiListCanvas(MultiBox multiBox2) {
            this.parent = multiBox2;
            this.addComponentListener(new sizeListener());
        }

        private void expandInternal() {
            this.bitmapheight += 10;
            this.allocateOff();
        }

        private void allocateOff() {
            this.offi = this.createImage(this.parent.pixwidth(), this.parent.lineheight() * this.bitmapheight);
            if (this.offi == null) {
                return;
            }
            int n = this.parent.pixposition(1) - this.parent.gutter();
            int n2 = this.parent.lineheight();
            int[] nArray = new int[n * n2];
            int[] nArray2 = new int[n * n2];
            int n3 = this.parent.unselectedText.getRGB();
            int n4 = this.parent.selectedText.getRGB();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    if ((i + j) % 5 != 0) continue;
                    nArray[i * n + j] = n3;
                    nArray2[i * n + j] = n4;
                }
            }
            this.hatcher = this.createImage(new MemoryImageSource(n, n2, nArray, 0, n));
            this.hatchers = this.createImage(new MemoryImageSource(n, n2, nArray2, 0, n));
            this.offg = this.offi.getGraphics();
            this.offg.setFont(this.parent.listFont);
            this.updateInternal();
        }

        private void reJig() {
            this.allocateOff();
            this.repaint();
        }

        private void updateInternal() {
            this.getPreferredSize();
            this.updateInternal(0, this.parent.lines() - 1);
        }

        private void updateLine(int n) {
            if (n < 0 || n >= this.parent.lines()) {
                return;
            }
            this.updateInternal(n, n);
        }

        private void updateInternal(int n, int n2) {
            int n3;
            if (this.offg == null || n2 - n < 0) {
                return;
            }
            this.getPreferredSize();
            if (this.parent.lines() > this.bitmapheight) {
                this.expandInternal();
                n = 0;
                n2 = this.parent.lines() - 1;
            }
            int n4 = this.parent.getSelectedIndex();
            this.offg.setColor(this.parent.unselectedBackground);
            if (n4 >= n && n4 <= n2) {
                this.offg.fillRect(0, n * this.parent.lineheight(), this.preferredSize.width, (n4 - n) * this.parent.lineheight());
                this.offg.fillRect(0, (n4 + 1) * this.parent.lineheight(), this.preferredSize.width, (n2 - n4) * this.parent.lineheight());
                this.offg.setColor(this.parent.selectedBackground);
                this.offg.fillRect(0, n4 * this.parent.lineheight(), this.preferredSize.width, this.parent.lineheight());
            } else {
                this.offg.fillRect(0, n * this.parent.lineheight(), this.preferredSize.width, (1 + n2 - n) * this.parent.lineheight());
            }
            this.offg.setColor(this.parent.unselectedText);
            FontMetrics fontMetrics = this.getFontMetrics(this.parent.listFont);
            for (n3 = n; n3 <= n2; ++n3) {
                if (n3 == n4) {
                    this.offg.setColor(this.parent.selectedText);
                }
                if (this.parent.fieldAt(n3, this.parent.columns()) != null) {
                    if (n3 == n4) {
                        this.offg.drawImage(this.hatchers, 0, n3 * this.parent.lineheight(), this);
                    } else {
                        this.offg.drawImage(this.hatcher, 0, n3 * this.parent.lineheight(), this);
                    }
                }
                for (int i = 0; i < this.parent.columns(); ++i) {
                    int n5 = this.parent.pixposition(i);
                    String string = this.parent.formatAt(i);
                    if (string.equals("r")) {
                        n5 = this.parent.pixposition(i + 1) - this.parent.gutter() - fontMetrics.stringWidth(this.parent.fieldAt(n3, i));
                    }
                    this.offg.drawString(this.parent.fieldAt(n3, i), n5, this.parent.toplinepix() + n3 * this.parent.lineheight());
                }
                if (n3 != n4) continue;
                this.offg.setColor(this.parent.unselectedText);
            }
            n3 = n * this.parent.lineheight() - this.yoffset;
            if (n2 == this.parent.lines() - 1) {
                this.repaint(0 - this.xoffset, n3, this.getSize().width, this.getSize().height - n3);
            } else {
                this.repaint(0 - this.xoffset, n3, this.getSize().width, (1 + n2 - n) * this.parent.lineheight());
            }
        }

        public void update(Graphics graphics) {
            int n;
            if (graphics == null) {
                return;
            }
            int n2 = this.getSize().width;
            int n3 = this.getSize().height;
            if (this.offi == null) {
                this.allocateOff();
            }
            if (n2 > this.parent.pixwidth()) {
                n = this.parent.pixwidth() - this.xoffset;
                int n4 = n2 - this.parent.pixwidth();
                int n5 = this.parent.getSelectedIndex();
                graphics.setColor(this.parent.unselectedBackground);
                if (n5 >= 0) {
                    graphics.fillRect(n, -this.yoffset, n4, n5 * this.parent.lineheight());
                    graphics.fillRect(n, (n5 + 1) * this.parent.lineheight() - this.yoffset, n4, (this.parent.lines() - n5) * this.parent.lineheight());
                    graphics.setColor(this.parent.selectedBackground);
                    graphics.fillRect(n, n5 * this.parent.lineheight() - this.yoffset, n4, this.parent.lineheight());
                } else {
                    graphics.fillRect(n, -this.yoffset, n4, this.parent.pixheight());
                }
            }
            if (n3 > (n = this.parent.pixheight() - this.yoffset)) {
                graphics.setColor(this.parent.unselectedBackground);
                graphics.fillRect(0, n, n2, n3 - n);
            }
            Rectangle rectangle = new Rectangle(-this.xoffset, -this.yoffset, this.parent.pixwidth(), this.parent.pixheight());
            Rectangle rectangle2 = graphics.getClipBounds();
            if (rectangle2 == null) {
                return;
            }
            rectangle = rectangle.intersection(graphics.getClipBounds());
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.drawImage(this.offi, -this.xoffset, -this.yoffset, null);
        }

        public void paint(Graphics graphics) {
            this.update(graphics);
        }

        private void scroll(int n, int n2) {
            int n3 = this.parent.scroll_increment();
            this.xoffset = n * n3;
            this.yoffset = n2 * n3;
            this.repaint();
        }

        public Dimension getPreferredSize() {
            this.preferredSize.height = this.parent.lineheight() * this.parent.visLines();
            this.preferredSize.width = this.parent.pixwidth();
            return this.preferredSize;
        }

        private void reVScroll() {
            int n = this.getSize().height;
            int n2 = this.parent.scroll_increment();
            int n3 = this.parent.pixheight();
            if (this.yoffset > n3) {
                this.yoffset = n3;
            }
            if (this.yoffset < 0) {
                this.yoffset = 0;
            }
            this.parent.vScroll.setValues(this.yoffset / n2, n / n2, 0, n3 / n2);
            this.parent.vScroll.setBlockIncrement(Math.max(1, (n - this.parent.lineheight()) / n2));
            this.parent.setVisLines(this.getSize().height / this.parent.lineheight());
        }

        class sizeListener
        extends ComponentAdapter {
            sizeListener() {
            }

            public void componentResized(ComponentEvent componentEvent) {
                Rectangle rectangle = MultiListCanvas.this.getBounds();
                int n = MultiListCanvas.this.parent.pixwidth();
                if (MultiListCanvas.this.xoffset > n) {
                    MultiListCanvas.this.xoffset = n;
                }
                if (MultiListCanvas.this.xoffset < 0) {
                    MultiListCanvas.this.xoffset = 0;
                }
                ((MultiListCanvas)MultiListCanvas.this).parent.hScroll.setValues(MultiListCanvas.this.xoffset, rectangle.width, 0, n);
                ((MultiListCanvas)MultiListCanvas.this).parent.hScroll.setBlockIncrement(rectangle.width);
                MultiListCanvas.this.reVScroll();
                MultiListCanvas.this.update(MultiListCanvas.this.getGraphics());
            }
        }
    }

    class LineData {
        Object theUseful;
        String[] fields;

        LineData(Object object, String[] stringArray) {
            this.theUseful = object;
            this.fields = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.fields[i] = stringArray[i];
            }
        }
    }

    class MultiHeadingCanvas
    extends Canvas {
        private MultiBox parent;
        private Graphics offg;
        private Image offi;
        private int xoffset;
        private Dimension preferredSize = new Dimension();
        private int width;
        private int height;

        public void scroll(int n) {
            this.xoffset = n * this.parent.scroll_increment();
            this.repaint(0, 0, this.width, this.height);
        }

        MultiHeadingCanvas(MultiBox multiBox2) {
            this.parent = multiBox2;
        }

        public void updateInternal() {
            this.getPreferredSize();
            this.offg.setColor(this.parent.unselectedBackground);
            this.offg.fillRect(0, 0, this.preferredSize.width, this.preferredSize.height);
            FontMetrics fontMetrics = this.offg.getFontMetrics();
            for (int i = 0; i < this.parent.columns(); ++i) {
                this.offg.setColor(this.parent.unselectedText);
                this.offg.drawString(this.parent.headingAt(i), this.parent.pixposition(i), this.parent.toplinepix());
                int n = fontMetrics.stringWidth(this.parent.headingAt(i));
                this.offg.setColor(this.parent.selectedBackground);
                this.offg.drawLine(this.parent.pixposition(i) + 3, this.preferredSize.height - 2, this.parent.pixposition(i) + n - 3, this.preferredSize.height - 2);
            }
        }

        public void reJig() {
            this.offi = null;
            this.repaint();
        }

        public void update(Graphics graphics) {
            if (graphics == null) {
                return;
            }
            if (this.offi == null) {
                this.offi = this.createImage(this.parent.pixwidth(), this.parent.lineheight() + 4);
                this.offg = this.offi.getGraphics();
                this.offg.setFont(this.parent.listFont);
                this.updateInternal();
            }
            int n = this.parent.listCanvas.getSize().width;
            this.width = this.getSize().width;
            this.height = this.getSize().height;
            graphics.clipRect(0, 0, n, this.height);
            if (this.offi != null) {
                graphics.drawImage(this.offi, -this.xoffset, 0, null);
            }
            if (n > this.parent.pixwidth()) {
                graphics.setColor(this.parent.unselectedBackground);
                graphics.fillRect(this.parent.pixwidth() + this.xoffset, 0, n - this.parent.pixwidth(), this.parent.lineheight() + 4);
            }
        }

        public void paint(Graphics graphics) {
            this.update(graphics);
        }

        public Dimension getPreferredSize() {
            this.preferredSize.width = this.parent.pixwidth();
            this.preferredSize.height = this.parent.lineheight() + 4;
            return this.preferredSize;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    class mouseListener
    extends MouseAdapter {
        mouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            int n2 = (mouseEvent.getY() + MultiBox.this.listCanvas.yoffset()) / MultiBox.this.lineheight;
            int n3 = mouseEvent.getX() + MultiBox.this.listCanvas.xoffset();
            for (n = 0; n < MultiBox.this.columns; ++n) {
                if (n3 >= MultiBox.this.pixposition[n]) continue;
                --n;
                break;
            }
            if (n2 >= MultiBox.this.lines()) {
                n2 = -1;
            }
            if (n2 != MultiBox.this.selectedIndex) {
                int n4 = MultiBox.this.selectedIndex;
                MultiBox.this.selectedIndex = n2;
                MultiBox.this.listCanvas.updateLine(n4);
                MultiBox.this.listCanvas.updateLine(MultiBox.this.selectedIndex);
            }
            if (n2 < MultiBox.this.lines() && n2 >= 0) {
                MultiBox.this.mcb.eventOn(MultiBox.this.lineDataAt((int)n2).theUseful, mouseEvent, n);
            }
        }
    }
}

