/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.ui.GrayFilter;
import ergo.ui.ImageLabel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.net.URL;

public class ImageButton
extends ImageLabel
implements MouseListener {
    protected static final int defaultBorderWidth = 3;
    protected static final Color defaultBorderColor = new Color(160, 160, 160);
    private boolean mouseIsDown = false;
    private int darkness = -5263441;
    private Image grayImage = null;

    public ImageButton() {
        this.initialize();
    }

    public ImageButton(String string) {
        super(string);
        this.initialize();
    }

    public ImageButton(URL uRL) {
        super(uRL);
        this.initialize();
    }

    public ImageButton(URL uRL, String string) {
        super(uRL, string);
        this.initialize();
    }

    public ImageButton(Image image) {
        super(image);
        this.initialize();
    }

    private void initialize() {
        this.setBorders();
        this.addMouseListener(this);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.grayImage == null) {
            this.createGrayImage(graphics);
        }
        this.drawBorder(true);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseIsDown = true;
        Graphics graphics = this.getGraphics();
        int n = this.getBorder();
        if (this.hasExplicitSize()) {
            graphics.drawImage(this.grayImage, n, n, this.getWidth() - 2 * n, this.getHeight() - 2 * n, this);
        } else {
            graphics.drawImage(this.grayImage, n, n, this);
        }
        this.drawBorder(false);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseIsDown = false;
        if (this.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.paint(this.getGraphics());
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mouseIsDown) {
            this.paint(this.getGraphics());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public int getDarkness() {
        return this.darkness;
    }

    public void setDarkness(int n) {
        this.darkness = n;
    }

    public Image getGrayImage() {
        return this.grayImage;
    }

    public void setGrayImage(Image image) {
        this.grayImage = image;
    }

    private void drawBorder(boolean bl) {
        Graphics graphics = this.getGraphics();
        graphics.setColor(this.getBorderColor());
        int n = 0;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = this.getBorder();
        for (int i = 0; i < n5; ++i) {
            graphics.draw3DRect(n, n2, n3, n4, bl);
            ++n;
            ++n2;
            n3 -= 2;
            n4 -= 2;
        }
    }

    private void setBorders() {
        this.setBorder(3);
        this.setBorderColor(defaultBorderColor);
    }

    private void createGrayImage(Graphics graphics) {
        GrayFilter grayFilter = new GrayFilter(this.darkness);
        FilteredImageSource filteredImageSource = new FilteredImageSource(this.getImage().getSource(), grayFilter);
        this.grayImage = this.createImage(filteredImageSource);
        int n = this.getBorder();
        if (this.hasExplicitSize()) {
            this.prepareImage(this.grayImage, this.getWidth() - 2 * n, this.getHeight() - 2 * n, this);
        } else {
            this.prepareImage(this.grayImage, this);
        }
        super.paint(graphics);
    }
}

