/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.ui.FontSpec;
import ergo.util.Debug;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.NoSuchElementException;

class FontManager {
    private static Font defaultFont = new Font("SansSerif", 0, 12);
    private static FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(defaultFont);

    FontManager() {
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static void setDefaultFont(Font font) {
        if (font != null) {
            defaultFont = font;
        }
    }

    public static FontMetrics getFontMetrics() {
        return metrics;
    }

    public static boolean isValidFontName(String string) {
        String[] stringArray = Toolkit.getDefaultToolkit().getFontList();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static Font resolve(FontSpec fontSpec) {
        try {
            String string = defaultFont.getName();
            int n = defaultFont.getStyle();
            int n2 = defaultFont.getSize();
            if (!"*".equalsIgnoreCase(fontSpec.getName())) {
                if (FontManager.isValidFontName(fontSpec.getName())) {
                    string = fontSpec.getName();
                } else if (fontSpec.getName().equalsIgnoreCase("Monospaced") && FontManager.isValidFontName("Courier")) {
                    string = "Courier";
                } else if (fontSpec.getName().equalsIgnoreCase("SansSerif") && FontManager.isValidFontName("Helvetica")) {
                    string = "Helvetica";
                } else if (fontSpec.getName().equalsIgnoreCase("Serif") && FontManager.isValidFontName("TimesRoman")) {
                    string = "TimesRoman";
                } else {
                    Debug.println("Unrecognized font name (" + fontSpec.getName() + ") in FontSpec.  Using default.");
                }
            }
            if ("PLAIN".equalsIgnoreCase(fontSpec.getStyle())) {
                n = 0;
            } else if ("BOLD".equalsIgnoreCase(fontSpec.getStyle())) {
                n = 1;
            } else if ("ITALIC".equalsIgnoreCase(fontSpec.getStyle())) {
                n = 2;
            } else if ("BOLDITALIC".equalsIgnoreCase(fontSpec.getStyle())) {
                n = 3;
            } else if (!"*".equalsIgnoreCase(fontSpec.getStyle())) {
                Debug.println("Unrecognized font style (" + fontSpec.getStyle() + ") in FontSpec.  Using default.");
            }
            if (!"*".equalsIgnoreCase(fontSpec.getSize())) {
                try {
                    int n3 = Integer.valueOf(fontSpec.getSize());
                    char c = fontSpec.getSize().charAt(0);
                    if (c == '-') {
                        n2 -= n3;
                    } else if (c == '+') {
                        n2 += n3;
                    } else if (n3 < 3 || n3 > 32) {
                        Debug.println("Invalid font size (" + fontSpec.getSize() + ") in FontSpec.  Using default.");
                    } else {
                        n2 = n3;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.println("Illegal font size (" + fontSpec.getSize() + ") specified in FontSpec.  Using default.");
                }
            }
            return new Font(string, n, n2);
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultFont;
        }
    }
}

