/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.Ergo;
import ergo.ui.ColorSpec;
import ergo.ui.ErgoCanvas;
import ergo.ui.GameWindow;
import ergo.ui.Optionizable;
import ergo.ui.Optionizer;
import ergo.util.Debug;
import ergo.util.Util;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class CoordinateCanvas
extends ErgoCanvas
implements Optionizable {
    private static final char[] temp = new char[2];
    private GameWindow gwin;
    private String position;
    private int gameSize;
    private int pad = 2;
    private String coordinateString = "Coordinate font";
    private Font coordinateFont = null;
    private Optionizer opser = Ergo.opser;

    CoordinateCanvas(String string, GameWindow gameWindow) {
        try {
            this.opser.expressOwnership(this.coordinateString, 5, this, null);
            this.coordinateFont = Ergo.opser.getFontOption(this.coordinateString);
            this.opser.expressOwnership("Game Window Background Color", 4, this, new ColorSpec("255 255 230"));
            this.setBackground(this.opser.getColorOption("Game Window Background Color"));
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
        }
        this.position = string;
        this.gwin = gameWindow;
        this.gameSize = gameWindow.game.size();
        this.setFont(this.coordinateFont);
    }

    public void optionEvent(String string, Object object) {
        if (this.opser.isSameKey(string, this.coordinateString)) {
            this.coordinateFont = (Font)object;
            this.setFont(this.coordinateFont);
        } else if (this.opser.isSameKey(string, "Game Window Background Color")) {
            this.setBackground(this.opser.getColorOption("Game Window Background Color"));
            this.repaint();
        }
    }

    public void update(Graphics graphics) {
        this.redisplay(graphics, false);
    }

    public void paint(Graphics graphics) {
        this.redisplay(graphics, true);
    }

    private void redisplay(Graphics graphics, boolean bl) {
        block4: {
            int n;
            int n2;
            FontMetrics fontMetrics;
            block5: {
                if (!this.needsRedisplay && !bl && this.getSize().height == this.height && this.getSize().width == this.width) break block4;
                this.width = this.getSize().width;
                this.height = this.getSize().height;
                fontMetrics = graphics.getFontMetrics();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.width, this.height);
                graphics.setColor(this.getForeground());
                n2 = ((this.isVertical() ? this.height : this.width) - 2 * this.gwin.getBevelWidth()) / this.gameSize;
                n = (this.isVertical() ? (n2 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() : n2 / 2) + this.gwin.getBevelWidth();
                if (!this.isHorizontal()) break block5;
                int n3 = this.position.equalsIgnoreCase("South") ? fontMetrics.getAscent() + this.pad : this.height - fontMetrics.getDescent() - this.pad;
                for (int i = 0; i < this.gameSize; ++i) {
                    int n4 = i < 25 ? i : i - 25;
                    int n5 = 65 + (n4 <= 7 ? n4 : n4 + 1);
                    CoordinateCanvas.temp[0] = i < 25 ? (char)n5 : Character.toLowerCase((char)n5);
                    graphics.drawChars(temp, 0, 1, n + i * n2, n3);
                }
                break block4;
            }
            if (!this.isVertical()) break block4;
            for (int i = this.gameSize; i > 0; --i) {
                CoordinateCanvas.temp[0] = i < 10 ? 32 : Util.DIGITS[i / 10];
                CoordinateCanvas.temp[1] = Util.DIGITS[i % 10];
                int n6 = n + (this.gameSize - i) * n2;
                if (this.position.equalsIgnoreCase("East")) {
                    if (i < 10) {
                        graphics.drawChars(temp, 1, 1, this.pad, n6);
                        continue;
                    }
                    graphics.drawChars(temp, 0, 2, this.pad, n6);
                    continue;
                }
                graphics.drawChars(temp, 0, 2, this.width - fontMetrics.charsWidth(temp, 0, 2) - this.pad, n6);
            }
        }
    }

    private boolean isVertical() {
        return this.position.equalsIgnoreCase("East") || this.position.equalsIgnoreCase("West");
    }

    private boolean isHorizontal() {
        return this.position.equalsIgnoreCase("South") || this.position.equalsIgnoreCase("North");
    }

    private Dimension sizeForFont(Font font) {
        Dimension dimension = new Dimension();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (this.isVertical()) {
            dimension.width = fontMetrics.stringWidth("19");
            dimension.height = fontMetrics.getHeight() * this.gameSize;
        } else {
            dimension.width = fontMetrics.stringWidth("A") * this.gameSize;
            dimension.height = fontMetrics.getHeight();
        }
        dimension.width += this.pad * 2;
        dimension.height += this.pad * 2;
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.sizeForFont(this.getFont());
    }
}

