/*
 * Decompiled with CFR 0.152.
 */
package ergo.ui;

import ergo.Ergo;
import ergo.logic.GameResultMove;
import ergo.logic.Move;
import ergo.logic.StoneMove;
import ergo.logic.StoneStasher;
import ergo.ui.Circle;
import ergo.ui.ColorSpec;
import ergo.ui.ErgoCanvas;
import ergo.ui.GameWindow;
import ergo.ui.ImArith;
import ergo.ui.Line;
import ergo.ui.OodInnaBox;
import ergo.ui.Optionizable;
import ergo.ui.Optionizer;
import ergo.ui.RawImage;
import ergo.ui.Refreshable;
import ergo.ui.StoneMaker;
import ergo.ui.Styles;
import ergo.ui.UpdatableBoard;
import ergo.ui.WoodGenerator;
import ergo.util.Debug;
import ergo.util.ILMV;
import ergo.util.Position;
import ergo.util.PositionVector;
import ergo.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class BoardCanvas
extends ErgoCanvas
implements Optionizable,
Refreshable,
UpdatableBoard,
Styles {
    private static final int PREFERRED_CELL_SIZE = 19;
    private Color blackColor = Color.black;
    private Color whiteColor = Color.white;
    private GameWindow gwin;
    private StoneStasher ss;
    private int gameSize;
    private Move currentMove;
    private Position koPosition;
    private int xoffset;
    private int yoffset;
    private int sideSize;
    private int cellSize;
    private Image offscreen;
    private Graphics offg;
    private Graphics staticg;
    private String variationfontString = "Variation font";
    private Color boardColor;
    private int boardStyle;
    private Font variationFont;
    private boolean showVariations;
    private Optionizer opser = Ergo.opser;
    private StarPoints starpoints = new StarPoints();
    private Circle circle = new Circle();
    private Line line = new Line();
    private RawImage oodboard;
    private RawImage whiteStone;
    private RawImage blackStone;
    private RawImage whiteShadowStone;
    private RawImage blackShadowStone;
    private RawImage hoshi;
    private Image hoshiIm;
    private RawImage tempblit = new RawImage();
    private Image tempblitIm;
    PositionVector decorations = new PositionVector();
    Position boundTL = new Position(-1, -1);
    Position boundBR = new Position(-1, -1);
    private boolean regenerateRequired = false;
    private Position previousShadow = new Position(-1, -1);
    private static StoneMove tempMove;
    private static ILMV tempILMV;
    private static Position tempPosition;

    public int getBevelWidth() {
        return 5 + (19 - this.gameSize) / 2;
    }

    BoardCanvas(GameWindow gameWindow, int n, StoneStasher stoneStasher) {
        this.gwin = gameWindow;
        this.gameSize = n;
        this.ss = stoneStasher;
        this.currentMove = this.ss.getCurrentMove();
        this.ss.associateUpdatable(this);
        try {
            this.opser.expressOwnership(this.variationfontString, 5, this, null);
            this.opser.expressOwnership("Game Window Variation Letters", 2, this, new Boolean(true));
            this.opser.expressOwnership("Board Color", 4, this, new ColorSpec("213 182 85"));
            this.opser.expressOwnership("Stone Style", 1, this, new Integer(2));
            this.opser.expressOwnership("Board Style", 1, this, new Integer(1));
        }
        catch (Exception exception) {
            Debug.backtrace(exception);
        }
        this.variationFont = this.opser.getFontOption(this.variationfontString);
        this.setFont(this.variationFont);
        this.boardColor = this.opser.getColorOption("Board Color");
        this.boardStyle = this.opser.getIntegerOption("Board Style");
        this.setBackground(this.boardColor);
        this.setForeground(Color.black);
        this.showVariations = this.opser.getBooleanOption("Game Window Variation Letters");
        this.addMouseListener(new mouseListener());
        this.addMouseMotionListener(new mouseMotionListener());
    }

    public boolean isReady() {
        return this.offscreen != null && this.offg != null && this.whiteStone != null && this.blackStone != null && this.whiteShadowStone != null && this.blackShadowStone != null && this.hoshiIm != null;
    }

    public Dimension getMinimumSize() {
        int n = this.gameSize * 5;
        return new Dimension(n, n);
    }

    public Dimension getPreferredSize() {
        int n = this.gameSize * 19;
        return new Dimension(n, n);
    }

    public void optionEvent(String string, Object object) {
        if (this.opser.isSameKey(string, this.variationfontString)) {
            this.variationFont = (Font)object;
            this.setFont(this.variationFont);
        } else if (this.opser.isSameKey(string, "Game Window Variation Letters")) {
            this.showVariations = this.opser.getBooleanOption("Game Window Variation Letters");
            this.refreshLocal();
        } else if (this.opser.isSameKey(string, "Board Color")) {
            this.boardColor = this.opser.getColorOption("Board Color");
            this.refreshLocal();
        } else if (this.opser.isSameKey(string, "Stone Style")) {
            this.stoneManufac();
            this.refreshLocal();
        } else if (this.opser.isSameKey(string, "Board Style")) {
            this.boardStyle = this.opser.getIntegerOption("Board Style");
            if (this.boardStyle == 0) {
                this.setWoodBoard(null);
                this.refreshLocal();
            } else {
                this.setWoodBoard(WoodGenerator.request(this.sideSize, this.getBevelWidth(), this));
                if (this.oodboard != null) {
                    this.refreshLocal();
                }
            }
        }
    }

    private Color codeToColor(int n) {
        switch (n) {
            case 1: 
            case 4: {
                return this.whiteColor;
            }
            case 0: 
            case 5: {
                return this.blackColor;
            }
        }
        return this.getForeground();
    }

    private final int coltox(int n) {
        return this.xoffset + n * this.cellSize;
    }

    public final int xtocol(int n) {
        return (n - this.xoffset) / this.cellSize;
    }

    private final int rowtoy(int n) {
        return this.yoffset + (this.gameSize - n - 1) * this.cellSize;
    }

    public final int ytorow(int n) {
        return this.gameSize - (n - this.yoffset) / this.cellSize - 1;
    }

    private void blitIt(int n, int n2) {
        int n3 = this.coltox(n2);
        int n4 = this.rowtoy(n);
        this.tempblit.mis().newPixels();
        this.offg.drawImage(this.tempblitIm, n3, n4, this);
    }

    private void makeEmptyImage(int n, int n2) {
        this.makeEmptyImage(n, n2, false);
    }

    private void makeEmptyImage(int n, int n2, boolean bl) {
        if (this.boardStyle == 0 || this.oodboard == null) {
            this.tempblit.blank(this.boardColor.getRGB());
        } else {
            ImArith.apsubio(this.tempblit, this.oodboard, this.coltox(n2), this.rowtoy(n));
        }
        int n3 = 0;
        int n4 = this.cellSize - 1;
        int n5 = 0;
        int n6 = this.cellSize - 1;
        if (n2 == 0) {
            n3 = this.cellSize / 2;
        }
        if (n == 0) {
            n6 = this.cellSize / 2;
        }
        if (n2 == this.gameSize - 1) {
            n4 = this.cellSize / 2;
        }
        if (n == this.gameSize - 1) {
            n5 = this.cellSize / 2;
        }
        int n7 = -16777216;
        this.line.line(this.tempblit, n7, n3, this.cellSize / 2, n4, this.cellSize / 2);
        this.line.line(this.tempblit, n7, this.cellSize / 2, n5, this.cellSize / 2, n6);
        if (this.starpoints.isStarPoint(n, n2) && !bl) {
            ImArith.api(this.tempblit, this.hoshi);
        }
    }

    private void stoneManufac() {
        int n = this.opser.getIntegerOption("Stone Style");
        double d = 0.0;
        int n2 = 0;
        int n3 = 0;
        if (this.currentBoardStyle() == 1) {
            n2 = OodInnaBox.getDarkColor();
            n3 = OodInnaBox.getAverageColor();
            d = -0.5;
        } else {
            n2 = n3 = this.boardColor.getRGB();
            d = 0.0;
        }
        this.whiteStone = StoneMaker.makeStoneImage(1, false, this.cellSize, n, n2, d);
        this.blackStone = StoneMaker.makeStoneImage(0, false, this.cellSize, n, n3, 0.0);
        this.whiteShadowStone = StoneMaker.makeStoneImage(1, true, this.cellSize, n, n2, d);
        this.blackShadowStone = StoneMaker.makeStoneImage(0, true, this.cellSize, n, n3, 0.0);
        this.hoshi = new RawImage(this.cellSize, this.cellSize);
        this.circle.fillcirc(this.hoshi, -16777216, 4);
        this.hoshiIm = this.createImage(this.hoshi.mis());
    }

    private void drawGrid(Graphics graphics) {
        int n;
        graphics.setColor(this.getForeground());
        int n2 = this.yoffset + this.cellSize / 2;
        int n3 = n2 + (this.gameSize - 1) * this.cellSize;
        int n4 = this.xoffset + this.cellSize / 2;
        int n5 = n4 + (this.gameSize - 1) * this.cellSize;
        for (int i = 0; i < this.gameSize; ++i) {
            n = n2 + i * this.cellSize;
            int n6 = n4 + i * this.cellSize;
            graphics.drawLine(n4, n, n5, n);
            graphics.drawLine(n6, n2, n6, n3);
        }
        PositionVector positionVector = this.starpoints.points();
        if (positionVector != null) {
            for (n = 0; n < positionVector.size(); ++n) {
                this.drawStarPoint(graphics, positionVector.elementAt(n));
            }
        }
    }

    private void drawStarPoint(Graphics graphics, Position position) {
        this.drawStarPoint(graphics, position.row, position.column);
    }

    private void drawStarPoint(Graphics graphics, int n, int n2) {
        int n3 = this.coltox(n2);
        int n4 = this.rowtoy(n);
        graphics.drawImage(this.hoshiIm, n3, n4, this);
    }

    private void drawStone(Graphics graphics, Position position, int n) {
        this.drawStone(graphics, position.row, position.column, n);
    }

    private void drawStone(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.coltox(n2);
        int n5 = this.rowtoy(n);
        switch (n3) {
            case 1: {
                this.makeEmptyImage(n, n2);
                ImArith.api(this.tempblit, this.whiteStone);
                this.blitIt(n, n2);
                break;
            }
            case 0: {
                this.makeEmptyImage(n, n2);
                ImArith.api(this.tempblit, this.blackStone);
                this.blitIt(n, n2);
                break;
            }
            case 11: {
                this.makeEmptyImage(n, n2);
                ImArith.api(this.tempblit, this.whiteShadowStone);
                this.blitIt(n, n2);
                break;
            }
            case 10: {
                this.makeEmptyImage(n, n2);
                ImArith.api(this.tempblit, this.blackShadowStone);
                this.blitIt(n, n2);
                break;
            }
            case 4: 
            case 5: {
                this.eraseStone(graphics, n, n2);
                int n6 = this.cellSize / 4;
                int n7 = n6 * 2;
                graphics.setColor(this.codeToColor(n3));
                graphics.fillRect(n4 + n6, n5 + n6, n7, n7);
                graphics.setColor(Color.darkGray);
                graphics.drawRect(n4 + n6, n5 + n6, n7, n7);
                break;
            }
            case 3: {
                this.eraseStone(graphics, n, n2);
            }
        }
    }

    private void eraseStone(Graphics graphics, int n, int n2) {
        this.makeEmptyImage(n, n2);
        this.blitIt(n, n2);
    }

    private void eraseStone(Graphics graphics, Position position) {
        this.eraseStone(graphics, position.row, position.column);
    }

    private void highlightMove(Graphics graphics, StoneMove stoneMove) {
        double d = 0.707;
        int n = this.cellSize % 2 == 0 ? 1 : 0;
        int n2 = (int)((double)(this.cellSize - 7) * d) / 2;
        int n3 = this.coltox(stoneMove.position().column) + this.cellSize / 2;
        int n4 = this.rowtoy(stoneMove.position().row) + this.cellSize / 2;
        graphics.setColor(this.codeToColor(stoneMove.color() == 1 ? 0 : 1));
        graphics.drawLine(n3 - n2 - n, n4 - n2 - n, n3 + n2, n4 + n2);
        graphics.drawLine(n3 + n2, n4 - n2 - n, n3 - n2 - n, n4 + n2);
    }

    private void drawLetter(Graphics graphics, Position position, char[] cArray) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        int n = fontMetrics.charsWidth(cArray, 0, 1);
        int n2 = Math.max(0, this.cellSize - n) / 2;
        int n3 = this.coltox(position.column) + n2;
        int n4 = fontMetrics.getHeight();
        int n5 = Math.max(0, this.cellSize - n4) / 2;
        int n6 = this.rowtoy(position.row) + n5;
        int n7 = n6 + fontMetrics.getAscent();
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setClip(n3, n6, n, n4);
        this.makeEmptyImage(position.row, position.column, true);
        this.blitIt(position.row, position.column);
        if (rectangle == null) {
            graphics.setClip(0, 0, this.width, this.height);
        } else {
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.boardStyle == 0 || this.oodboard == null) {
            graphics.setColor(this.getForeground());
        } else {
            graphics.setColor(Color.white);
        }
        graphics.drawChars(cArray, 0, 1, n3, n7);
    }

    private void highlightCurrentMove(Graphics graphics) {
        if (this.currentMove instanceof StoneMove) {
            StoneMove stoneMove = (StoneMove)this.currentMove;
            this.highlightMove(graphics, stoneMove);
            this.invalidateInternal(stoneMove.position().row, stoneMove.position().column);
            this.decorations.addElement(stoneMove.position());
        }
    }

    private void drawVariations(Graphics graphics) {
        this.gwin.updateVariationsMenu();
        if (this.currentMove != null && graphics != null) {
            Move move;
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            int n = -1;
            while ((move = this.currentMove.variationAt(n)) != null) {
                PositionVector positionVector = move.placedPositions(this.gameSize);
                char[] cArray = new char[]{(char)(n + 1 + 97)};
                if (positionVector != null) {
                    for (int i = 0; i < positionVector.size(); ++i) {
                        Position position = positionVector.elementAt(i);
                        this.invalidateInternal(position.row, position.column);
                        this.decorations.addElement(position);
                        this.drawLetter(graphics, position, cArray);
                    }
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawAll(Graphics graphics) {
        int n = this.currentBoardStyle();
        if (n == 0) {
            graphics.setColor(this.boardColor);
            graphics.fillRect(0, 0, this.width, this.height);
        } else {
            Image image = this.createImage(this.oodboard.mis());
            graphics.drawImage(image, 0, 0, null);
            image.flush();
        }
        this.drawGrid(graphics);
        boolean bl = this.currentMove instanceof GameResultMove;
        StoneStasher stoneStasher = this.ss;
        synchronized (stoneStasher) {
            for (int i = 0; i < this.gameSize; ++i) {
                for (int j = 0; j < this.gameSize; ++j) {
                    if (bl) {
                        this.reflect(i, j, this.ss.readAnyStone(i, j));
                        continue;
                    }
                    int n2 = this.ss.readStone(i, j);
                    if (n2 == 3) continue;
                    this.reflect(i, j, n2);
                }
            }
        }
        this.decorateStone(graphics);
    }

    private void decorateStone(Graphics graphics) {
        if (this.showVariations) {
            this.drawVariations(graphics);
        }
        this.highlightCurrentMove(graphics);
    }

    public void reflect(int n, int n2, int n3) {
        this.drawStone(this.offg, n, n2, n3);
        this.invalidateInternal(n, n2);
    }

    public void setKoPosition(Position position) {
        this.koPosition = position;
    }

    private void reflectis(Position position) {
        int n = this.ss.readAnyStone(position.row, position.column);
        this.drawStone(this.offg, position.row, position.column, n);
        this.invalidateInternal(position.row, position.column);
        if (this.decorations.isMember(position)) {
            this.decorateStone(this.offg);
        }
        this.updateInternal();
    }

    private void invalidateInternal(int n, int n2) {
        if (this.boundTL.row == -1) {
            this.boundTL.row = this.boundBR.row = n;
            this.boundTL.column = this.boundBR.column = n2;
        } else {
            this.boundTL.row = Math.max(this.boundTL.row, n);
            this.boundBR.row = Math.min(this.boundBR.row, n);
            this.boundTL.column = Math.min(this.boundTL.column, n2);
            this.boundBR.column = Math.max(this.boundBR.column, n2);
        }
    }

    public void updateInternal() {
        if (this.boundTL.row != -1) {
            if (this.staticg != null) {
                this.staticg.setClip(this.coltox(this.boundTL.column), this.rowtoy(this.boundTL.row), this.coltox(this.boundBR.column + 1) - this.coltox(this.boundTL.column), this.rowtoy(this.boundBR.row) - this.rowtoy(this.boundTL.row + 1));
                this.update(this.staticg);
            }
            this.boundTL.row = -1;
        }
    }

    public void noteMove(Move move) {
        this.currentMove = move;
        for (int i = this.decorations.size() - 1; i >= 0; --i) {
            int n = this.decorations.elementAt((int)i).row;
            int n2 = this.decorations.elementAt((int)i).column;
            this.reflect(n, n2, this.ss.readAnyStone(n, n2));
            this.updateInternal();
            this.decorations.removeElementAt(i);
        }
        this.decorateStone(this.offg);
    }

    public void update(Graphics graphics) {
        if (this.getSize().width != this.width || this.getSize().height != this.height) {
            WoodGenerator.release(this.sideSize);
            this.width = this.getSize().width;
            this.height = this.getSize().height;
            this.sideSize = Math.min(this.width, this.height);
            this.xoffset = (this.width - this.sideSize) / 2 + this.getBevelWidth();
            this.yoffset = (this.height - this.sideSize) / 2 + this.getBevelWidth();
            this.cellSize = (this.sideSize - 2 * this.getBevelWidth()) / this.gameSize;
            this.oodboard = WoodGenerator.request(this.sideSize, this.getBevelWidth(), this);
            if (this.offscreen != null) {
                this.offscreen.flush();
            }
            this.offscreen = this.createImage(this.sideSize, this.sideSize);
            this.tempblit.reinit(this.cellSize, this.cellSize);
            this.tempblitIm = this.createImage(this.tempblit.mis());
            if (this.offg != null) {
                this.offg.dispose();
            }
            this.offg = this.offscreen.getGraphics();
            if (this.staticg != null) {
                this.staticg.dispose();
            }
            this.staticg = this.getGraphics();
            this.regenerateRequired = true;
        }
        if (this.regenerateRequired) {
            this.regenerateRequired = false;
            this.stoneManufac();
            this.drawAll(this.offg);
            this.decorateStone(this.offg);
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    private boolean mouseCommon(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        if (this.cellSize == 0) {
            return true;
        }
        int n3 = Move.nextColor(this.currentMove.color());
        boolean bl5 = this.gwin.game.scoringMode() || this.gwin.ourColor() == n3 || this.gwin.isTeachingGame();
        int n4 = this.xtocol(n);
        int n5 = this.ytorow(n2);
        boolean bl6 = true;
        if (n4 < 0 || n5 < 0 || n4 >= this.gameSize || n5 >= this.gameSize || bl) {
            bl6 = false;
        }
        boolean bl7 = bl6 && this.ss.readStone(n5, n4) == 3;
        boolean bl8 = bl6 && (this.gwin.isLocalGame() || this.gwin.isBrowsing() || this.gwin.isParticipating() && bl5 && bl6 && (!this.gwin.game.scoringMode() || this.gwin.isBrowsing() || !bl7) && !(this.currentMove instanceof GameResultMove));
        boolean bl9 = bl4 = bl6 && bl8;
        if (bl2 || bl) {
            if (bl4 && this.previousShadow.row == n5 && this.previousShadow.column == n4) {
                return true;
            }
            if (this.previousShadow.row != -1) {
                this.reflectis(this.previousShadow);
            }
            boolean bl10 = false;
            if (bl4) {
                tempPosition.setPosition(n5, n4);
                if (tempMove == null) {
                    tempMove = new StoneMove(this.currentMove, 0, this.currentMove.moveNumber() + 1, n3, false, tempPosition);
                } else {
                    tempMove.reseatforShadow(tempPosition, n3, this.currentMove, this.currentMove.moveNumber() + 1);
                }
                bl10 = tempMove.isLegal(this.gwin.game, true, tempILMV);
            }
            if (bl10) {
                if (n3 == 0) {
                    this.drawStone(this.offg, n5, n4, 10);
                } else if (n3 == 1) {
                    this.drawStone(this.offg, n5, n4, 11);
                }
                this.invalidateInternal(n5, n4);
                this.updateInternal();
                this.previousShadow.row = n5;
                this.previousShadow.column = n4;
            } else {
                this.previousShadow.row = -1;
            }
        } else if (bl3 && bl8) {
            this.gwin.placeMove(n5, n4);
            this.ss.emit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWoodBoard(RawImage rawImage) {
        StoneStasher stoneStasher = this.ss;
        synchronized (stoneStasher) {
            this.oodboard = rawImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int currentBoardStyle() {
        StoneStasher stoneStasher = this.ss;
        synchronized (stoneStasher) {
            return this.oodboard == null && this.boardStyle == 1 ? 0 : this.boardStyle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshLocal() {
        StoneStasher stoneStasher = this.ss;
        synchronized (stoneStasher) {
            this.oodboard = WoodGenerator.request(this.sideSize, this.getBevelWidth(), this);
            this.regenerateRequired = true;
        }
        this.repaint();
    }

    static {
        tempILMV = new ILMV();
        tempPosition = new Position(0, 0);
    }

    class mouseListener
    extends MouseAdapter {
        mouseListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (Util.isUnix()) {
                if ((mouseEvent.getModifiers() & 4) == 0) {
                    BoardCanvas.this.mouseCommon(mouseEvent.getX(), mouseEvent.getY(), false, false, true);
                }
            } else if (!mouseEvent.isPopupTrigger()) {
                BoardCanvas.this.mouseCommon(mouseEvent.getX(), mouseEvent.getY(), false, false, true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BoardCanvas.this.mouseCommon(mouseEvent.getX(), mouseEvent.getY(), true, false, false);
        }
    }

    class mouseMotionListener
    extends MouseMotionAdapter {
        mouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            BoardCanvas.this.mouseCommon(mouseEvent.getX(), mouseEvent.getY(), false, true, false);
        }
    }

    class StarPoints {
        private PositionVector starPoints;

        StarPoints() {
        }

        public boolean isStarPoint(int n, int n2) {
            this.points();
            for (int i = 0; i < this.starPoints.size(); ++i) {
                Position position = this.starPoints.elementAt(i);
                if (position.column != n2 || position.row != n) continue;
                return true;
            }
            return false;
        }

        public PositionVector points() {
            int n;
            if (this.starPoints != null) {
                return this.starPoints;
            }
            int n2 = 3;
            int n3 = 6;
            switch (BoardCanvas.this.gameSize) {
                case 8: {
                    n2 = 2;
                    n3 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    n3 = 4;
                    break;
                }
                default: {
                    if (BoardCanvas.this.gameSize <= 9) break;
                    n3 = BoardCanvas.this.gameSize % 2 == 0 ? BoardCanvas.this.gameSize - 7 : (BoardCanvas.this.gameSize - 7) / 2;
                }
            }
            this.starPoints = new PositionVector(9);
            for (n = n2; n <= BoardCanvas.this.gameSize - n2; n += n3) {
                for (int i = n2; i <= BoardCanvas.this.gameSize - n2; i += n3) {
                    this.starPoints.addElement(new Position(n, i));
                }
            }
            if (BoardCanvas.this.gameSize % 2 == 1 && !this.starPoints.isMember(n = BoardCanvas.this.gameSize / 2, n)) {
                this.starPoints.addElement(new Position(n, n));
            }
            return this.starPoints;
        }
    }
}

