/*
 * Decompiled with CFR 0.152.
 */
package ergo.server;

import ergo.server.Rank;
import ergo.util.Debug;
import ergo.util.ParseException;

public class ServerPlayer {
    public String name;
    public Rank rank;
    Idle idle;
    public String flags = "??";
    public String playing = "--";
    public String observing = "--";
    public static final int SEC = 0;
    public static final int MIN = 1;
    public static final int HR = 2;

    public void imbue(String string, String string2, String string3, String string4, String string5, String string6) throws ParseException {
        Debug.assertion(this.name == null || this.name.equals(string4), "Cannot change player name");
        this.name = string4;
        this.rank = new Rank(string6);
        this.idle = new Idle(string5);
        this.flags = string;
        this.playing = string3;
        this.observing = string2;
    }

    public void imbue(String string, String string2) throws ParseException {
        Debug.assertion(this.name == null || this.name.equals(string), "Cannot change player name");
        this.name = string;
        this.rank = new Rank(string2);
    }

    public String[] render() {
        String string = this.flags;
        if (this.flags.length() > 1 && this.flags.charAt(0) == ' ') {
            string = this.flags.substring(1);
        }
        String[] stringArray = new String[]{this.name, this.rank.render(), this.idle == null ? "0s" : this.idle.render(), string, "  " + this.playing, "  " + this.observing, null};
        return stringArray;
    }

    class Idle {
        private int numeric;

        Idle(String string) throws ParseException {
            int n;
            char c;
            try {
                c = string.charAt(string.length() - 1);
                n = Integer.parseInt(string.substring(0, string.length() - 1));
            }
            catch (Exception exception) {
                throw new ParseException("Illegal Time Format");
            }
            switch (c) {
                case 's': {
                    this.numeric = n;
                    break;
                }
                case 'm': {
                    this.numeric = n * 60;
                    break;
                }
                case 'h': {
                    this.numeric = n * 3600;
                    break;
                }
                default: {
                    throw new ParseException("Illegal Time Format");
                }
            }
        }

        public int compareTo(Idle idle) {
            if (this.numeric < idle.numeric) {
                return 1;
            }
            if (this.numeric == idle.numeric) {
                return 0;
            }
            return -1;
        }

        String render() {
            if (this.numeric < 60) {
                return Integer.toString(this.numeric) + "s";
            }
            if (this.numeric < 3600) {
                return Integer.toString(this.numeric / 60) + "m";
            }
            return Integer.toString(this.numeric / 3600) + "h";
        }
    }
}

