/*
 * Decompiled with CFR 0.152.
 */
package ergo.server;

import ergo.logic.GameResultMove;
import ergo.logic.HandicapMove;
import ergo.logic.Move;
import ergo.logic.PassMove;
import ergo.logic.StoneMove;
import ergo.server.ServerConnection;
import ergo.server.ServerPlayer;
import ergo.ui.GameWindow;
import ergo.ui.GoClient;
import ergo.ui.ServerGameContainer;
import ergo.ui.ServerPlayerContainer;
import ergo.util.Debug;
import ergo.util.ErgoException;
import ergo.util.ParseException;
import ergo.util.ParsedMessage;
import ergo.util.Position;
import java.awt.EventQueue;
import java.io.IOException;

public class Controller
extends Thread {
    private GoClient client;
    private ServerConnection conn;
    public ServerPlayerContainer spc;
    public ServerGameContainer sgc;
    private boolean readingHelpFile = false;
    private boolean loggedIn = false;
    private boolean lookForPlayerStats = false;
    private boolean receiveQuit_ = false;
    int prevmess = -1;
    private boolean countergames = false;
    int whostate = 0;
    private ParsedMessage previousKibitz;
    private ParsedMessage handleMovesMessage;
    private GameWindow handleMovesWindow;
    private int handleMovesGame = -1;
    private int waitingMoveNumber = -1;
    private boolean seenmoveone = false;
    private GameWindow waitingGameWindow = null;
    private int previousPrompt = 0;
    protected int[][] gameResult = null;
    protected String gameResultWhite = null;
    protected String gameResultBlack = null;
    private String gameResultWR = null;
    private String gameResultBR = null;
    private double gameResultKomi = 5.5;

    public Controller(ServerConnection serverConnection, GoClient goClient) {
        this.conn = serverConnection;
        this.client = goClient;
    }

    public void quit() {
        this.receiveQuit_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                this.spc = new ServerPlayerContainer(this, this.conn, this.client);
                this.sgc = new ServerGameContainer(this, this.conn, this.client);
            }
            catch (RuntimeException runtimeException) {
                Debug.backtrace(runtimeException);
            }
            while (!this.receiveQuit_) {
                try {
                    if (!this.conn.isConnected()) {
                        Debug.println("Controller killing itself.");
                        this.stop();
                        continue;
                    }
                    String string = this.conn.readLine();
                    if (this.client.getRawMode()) {
                        this.client.displayString(string, null, true);
                    }
                    if (this.conn.scanningForLogin() && "Login:".regionMatches(true, 0, string, 0, 6)) {
                        this.client.displayString("Login: ");
                        this.client.displayLoginDialog();
                        continue;
                    }
                    if (this.conn.scanningForLogin() && string.equalsIgnoreCase("password:") && this.client.loginDialogExists() && this.client.loginDialogDone()) {
                        this.client.displayString(string);
                        if (this.client.passwordSent()) continue;
                        this.client.sendPassword();
                        continue;
                    }
                    if (this.readingHelpFile) {
                        if (string.startsWith("8 File") || string.startsWith("25 File")) {
                            this.readingHelpFile = false;
                            continue;
                        }
                        this.client.displayString(string, null, false);
                        continue;
                    }
                    this.dispatchMessage(string);
                }
                catch (IOException iOException) {
                    System.err.println("I/O failed on the connection to server");
                    this.conn.close();
                }
                catch (Exception exception) {
                    Debug.backtrace(exception);
                }
            }
        }
        finally {
            this.spc.destroy();
            this.sgc.destroy();
        }
    }

    public boolean isEmptyString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void skipwhite(ParsedMessage parsedMessage) {
        try {
            parsedMessage.continueParse(" ");
        }
        catch (ErgoException ergoException) {
            // empty catch block
        }
    }

    private void noteLoggedIn() {
        if (!this.loggedIn) {
            this.client.displayWarning("My dog has fleas.");
            this.loggedIn = true;
            this.conn.send("toggle client on", false);
            if (this.conn.server.isIGStype()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.conn.send("toggle quiet off", false);
            if (this.conn.server.isIGStype()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.conn.send("toggle verbose off", false);
            this.conn.stopScanningForLogin();
            if (this.conn.server.isNNGStype()) {
                this.conn.send("client 6", false);
            }
            if (this.conn.server.isIGStype()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.lookForPlayerStats = true;
            this.conn.send("stats", false);
        }
    }

    private void dispatchMessage(final String string) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                block3: {
                    try {
                        ParsedMessage parsedMessage = new ParsedMessage(string, "%i% ");
                        Controller.this.dispatchMessageImpl(parsedMessage);
                    }
                    catch (ErgoException ergoException) {
                        if (!Controller.this.loggedIn && Controller.this.client.loginDialogExists() && (string.startsWith(Controller.this.conn.shortName()) || string.startsWith("#>"))) {
                            Controller.this.noteLoggedIn();
                        }
                        if (Controller.this.isEmptyString(string)) break block3;
                        Controller.this.client.displayString(string, null, false);
                    }
                }
            }
        });
    }

    private void dispatchMessageImpl(ParsedMessage parsedMessage) throws ErgoException {
        int n = parsedMessage.intAt(0);
        switch (n) {
            case 15: {
                this.handleMove(parsedMessage);
                break;
            }
            case 1: {
                this.handlePrompt(parsedMessage);
                break;
            }
            case 9: {
                this.handleInfo(parsedMessage);
                break;
            }
            case 7: {
                this.handleGames(parsedMessage);
                break;
            }
            case 21: {
                this.handleShout(parsedMessage);
                break;
            }
            case 8: 
            case 25: {
                this.readingHelpFile = !this.readingHelpFile;
                break;
            }
            case 28: {
                this.handleUndo(parsedMessage);
                break;
            }
            case 39: {
                this.noteLoggedIn();
                break;
            }
            case 20: 
            case 22: {
                this.handleScore(parsedMessage);
                break;
            }
            case 32: {
                this.handleYell(parsedMessage);
                break;
            }
            case 11: {
                this.handleKibitz(parsedMessage);
                break;
            }
            case 24: {
                this.handleTell(parsedMessage);
                break;
            }
            case 5: {
                this.client.displayWarning(parsedMessage.rest());
                if (!"Invalid password".regionMatches(true, 0, parsedMessage.rest(), 0, 15)) break;
                this.client.displayString("Login: ");
                this.client.displayLoginDialog();
                break;
            }
            case 27: {
                this.handleWho(parsedMessage);
                break;
            }
            case 4: {
                this.client.displayWarning(parsedMessage.rest());
                break;
            }
            case 19: {
                this.handleSay(parsedMessage);
                break;
            }
            case 2: {
                this.client.beep();
                break;
            }
            default: {
                this.client.displayString(parsedMessage.rest());
            }
        }
        if (this.prevmess == 7 && n != 7) {
            if (this.countergames) {
                this.countergames = false;
            } else {
                this.spc.update();
                this.sgc.update();
                this.sgc.show();
            }
        }
        if (this.waitingMoveNumber > -1 && this.seenmoveone && n != 15) {
            this.visifyPendingGame();
        }
        this.prevmess = n;
    }

    private void handleWho(ParsedMessage parsedMessage) {
        if (parsedMessage.continueParseQuietly(" Info Name Idle Rank | Info Name Idle Rank ") != null) {
            this.whostate = 1;
            this.spc.clear();
            return;
        }
        if (parsedMessage.continueParseQuietly(" ******** %i Players %i Total Games %s ") != null) {
            this.spc.update();
            this.spc.show();
            this.whostate = 0;
        } else {
            try {
                int n = 0;
                while (true) {
                    block8: {
                        parsedMessage.continueParse("% %c%c %s %s %s %s %s ");
                        String string = new String(((Character)parsedMessage.matchAt(n + 1)).toString() + ((Character)parsedMessage.matchAt(n + 2)).toString());
                        try {
                            this.spc.apply(string, parsedMessage.stringAt(n + 3), parsedMessage.stringAt(n + 4), parsedMessage.stringAt(n + 5), parsedMessage.stringAt(n + 6), parsedMessage.stringAt(n + 7), true);
                        }
                        catch (Exception exception) {
                            if (exception instanceof ParseException) break block8;
                            Debug.println("Failed to parse " + parsedMessage.message());
                            Debug.backtrace(exception);
                        }
                    }
                    parsedMessage.continueParse("|% ");
                    n += 7;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void handleKibitz(ParsedMessage parsedMessage) {
        try {
            parsedMessage.continueParse(" Kibitz %a [ %w ]: Game %a vs %a [ %i ]");
            this.previousKibitz = parsedMessage;
        }
        catch (ParseException parseException) {
            if (this.previousKibitz == null) {
                Debug.backtrace(parseException);
            } else {
                try {
                    String string = this.previousKibitz.stringAt(1);
                    String string2 = this.previousKibitz.stringAt(2);
                    String string3 = this.previousKibitz.stringAt(3);
                    String string4 = this.previousKibitz.stringAt(4);
                    int n = this.previousKibitz.intAt(5);
                    this.skipwhite(parsedMessage);
                    this.client.displayKibitz(string3, string4, n, string, string2, parsedMessage.rest());
                }
                catch (ParseException parseException2) {
                    Debug.backtrace(parseException2);
                }
            }
            this.previousKibitz = null;
        }
    }

    private void handleSay(ParsedMessage parsedMessage) {
        this.client.displaySay(parsedMessage.rest());
    }

    private void handleInfo(ParsedMessage parsedMessage) {
        ParsedMessage parsedMessage2;
        Object var2_2 = null;
        String string = parsedMessage.rest();
        this.client.displayString(string);
        if (string.startsWith("\u0007")) {
            this.client.beep();
            return;
        }
        if (this.previousPrompt == 7) {
            try {
                parsedMessage2 = new ParsedMessage(string, " Removing @ %a");
                this.client.removeGroupAt(parsedMessage2.stringAt(0));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        try {
            parsedMessage2 = null;
            try {
                parsedMessage2 = new ParsedMessage(string, " Set the komi to %f");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (parsedMessage2 == null) {
                try {
                    parsedMessage2 = new ParsedMessage(string, " Komi is now set to %f");
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (parsedMessage2 == null) {
                parsedMessage2 = new ParsedMessage(string, " Komi set to %f in match %i");
                double d = parsedMessage2.doubleAt(0);
                int n = parsedMessage2.intAt(1);
                this.client.setKomi(d, n);
                return;
            }
            this.client.setKomi(parsedMessage2.doubleAt(0), -1);
            return;
        }
        catch (ParseException parseException) {
            try {
                ParsedMessage parsedMessage3 = new ParsedMessage(string, " Use <match %s %s %s %s %i");
                this.client.displayMatchRequest(parsedMessage3.stringAt(0), parsedMessage3.stringAt(1), parsedMessage3.stringAt(2), parsedMessage3.stringAt(3), ((Integer)parsedMessage3.matchAt(4)).toString());
                return;
            }
            catch (ParseException parseException2) {
                try {
                    ParsedMessage parsedMessage4 = new ParsedMessage(string, " Removing game %i from ob");
                    this.client.unobserveGame(parsedMessage4.intAt(0));
                    return;
                }
                catch (ParseException parseException3) {
                    String string2 = "This is now a FREE, UNRATED teaching game.";
                    if (string.regionMatches(true, 0, string2, 0, string2.length())) {
                        this.client.makeGameFree(-1);
                    }
                    if (this.lookForPlayerStats) {
                        try {
                            ParsedMessage parsedMessage5 = new ParsedMessage(string, " Player: %s");
                            String string3 = parsedMessage5.stringAt(0);
                            if (this.client.getAccountName().equalsIgnoreCase(string3)) {
                                this.client.setAccountName(string3);
                            }
                            return;
                        }
                        catch (ParseException parseException4) {
                            try {
                                ParsedMessage parsedMessage6 = new ParsedMessage(string, " Rating: %s ");
                                this.client.setAccountRank(parsedMessage6.stringAt(0));
                                this.lookForPlayerStats = false;
                                return;
                            }
                            catch (ParseException parseException5) {
                                try {
                                    ParsedMessage parsedMessage7 = new ParsedMessage(string, " Rank: %s ");
                                    this.client.setAccountRank(parsedMessage7.stringAt(0));
                                    this.lookForPlayerStats = false;
                                    return;
                                }
                                catch (ParseException parseException6) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    try {
                        ParsedMessage parsedMessage8 = new ParsedMessage(string, " Ratings update: You are now %s");
                        this.client.setAccountRank(parsedMessage8.stringAt(0));
                        Debug.println("Rank set to " + parsedMessage8.stringAt(0));
                        return;
                    }
                    catch (ParseException parseException7) {
                        if (string.startsWith("Board is restored to what it was when you started scoring")) {
                            this.client.getGameBeingPlayed().undoDuringServerScoring();
                        }
                        return;
                    }
                }
            }
        }
    }

    private void handleTell(ParsedMessage parsedMessage) {
        String string = parsedMessage.rest();
        this.client.displayTell(string);
    }

    private void visifyPendingGame() {
        if (this.waitingGameWindow == null) {
            return;
        }
        this.waitingMoveNumber = -1;
        this.seenmoveone = false;
        this.waitingGameWindow.game.ss.setQuiet(false);
    }

    protected void handleMove(ParsedMessage parsedMessage) throws ErgoException {
        this.skipwhite(parsedMessage);
        String string = parsedMessage.rest();
        if (string.regionMatches(true, 0, "Game", 0, 4)) {
            this.handleMovesMessage = parsedMessage;
            try {
                parsedMessage.continueParse("Game %i %c: %s (%i %i %i) vs %s (%i %i %i)");
                int n = parsedMessage.intAt(1);
                String string2 = parsedMessage.stringAt(3);
                String string3 = parsedMessage.stringAt(7);
                this.handleMovesWindow = this.client.getGameWindowByName(string2, string3, n);
                if (this.handleMovesWindow == null) {
                    if (this.handleMovesGame == -1) {
                        this.handleMovesGame = n;
                        this.conn.send("games " + n, false);
                    }
                    return;
                }
                if (this.waitingMoveNumber > -1 && this.seenmoveone) {
                    this.visifyPendingGame();
                }
                this.handleMovesWindow.updateTimers(parsedMessage.intAt(4), parsedMessage.intAt(5), parsedMessage.intAt(6), parsedMessage.intAt(8), parsedMessage.intAt(9), parsedMessage.intAt(10));
            }
            catch (ErgoException ergoException) {
                Debug.backtrace(ergoException);
                this.handleMovesMessage = null;
            }
        } else {
            if (this.handleMovesMessage == null || this.handleMovesWindow == null) {
                return;
            }
            try {
                Move move;
                String string4;
                parsedMessage.continueParse("%i(%c): %a");
                int n = parsedMessage.intAt(1);
                char c = ((Character)parsedMessage.matchAt(2)).charValue();
                int n2 = c == 'B' ? 0 : 1;
                int n3 = c == 'B' ? 5 : 9;
                int n4 = this.handleMovesMessage.intAt(n3);
                Move move2 = this.handleMovesWindow.game.finalServerMove();
                if (n != move2.moveNumber() + 1) {
                    this.handleMovesWindow.ensureActive();
                    return;
                }
                if (this.waitingMoveNumber > -1 && this.handleMovesWindow == this.waitingGameWindow) {
                    if (n == 1) {
                        this.seenmoveone = true;
                    }
                    if (n >= this.waitingMoveNumber - 1) {
                        this.visifyPendingGame();
                    }
                }
                if ((string4 = parsedMessage.stringAt(3)).regionMatches(true, 0, "ha", 0, 2)) {
                    parsedMessage.continueParse(" %i");
                    int n5 = parsedMessage.intAt(4);
                    move = new HandicapMove(move2, n4, n, false, n5, this.handleMovesWindow.game.size());
                } else if (string4.regionMatches(true, 0, "pa", 0, 2)) {
                    move = new PassMove(move2, n4, n, n2, false);
                } else {
                    Position position = new Position(string4, this.handleMovesWindow.game.size());
                    move = new StoneMove(move2, n4, n, n2, false, position);
                }
                this.handleMovesWindow.placeMove(move, true);
                this.handleMovesWindow.game.ss.emit();
            }
            catch (ParseException parseException) {
                Debug.backtrace(parseException);
            }
        }
    }

    protected void handleGames(ParsedMessage parsedMessage) {
        this.skipwhite(parsedMessage);
        String string = parsedMessage.rest();
        if (string.indexOf("white name") != -1 && this.handleMovesGame == -1) {
            this.sgc.clear();
        }
        try {
            parsedMessage.continueParse("[ %i ] %s [ %w ] vs. %s [ %w ] ( %i %i %i %f %i %w ) ( %i )");
            int n = parsedMessage.intAt(1);
            String string2 = parsedMessage.stringAt(2);
            String string3 = parsedMessage.stringAt(4);
            String string4 = parsedMessage.stringAt(11);
            String string5 = this.client.getAccountName();
            boolean bl = string4.indexOf("T") != -1;
            boolean bl2 = string4.indexOf("F") != -1;
            boolean bl3 = string2.equals(string5) || string3.equals(string5);
            int n2 = -1;
            if (string2.equals(string3) && string2.equals(string5) || bl3 && bl) {
                n2 = 12;
            } else if (string2.equals(string5)) {
                n2 = 1;
            } else if (string3.equals(string5)) {
                n2 = 0;
            }
            GameWindow gameWindow = this.client.getGameWindowByName(string2, string3, n);
            String string6 = parsedMessage.stringAt(3);
            String string7 = parsedMessage.stringAt(5);
            int n3 = parsedMessage.intAt(7);
            int n4 = parsedMessage.intAt(8);
            double d = parsedMessage.doubleAt(9);
            int n5 = parsedMessage.intAt(10);
            this.sgc.apply(parsedMessage.stringAt(1), string2, string6, string3, string7, parsedMessage.stringAt(6), parsedMessage.stringAt(7), parsedMessage.stringAt(8), parsedMessage.stringAt(9), parsedMessage.stringAt(10), string4, parsedMessage.stringAt(12), true);
            if (this.handleMovesGame != -1) {
                this.countergames = true;
                gameWindow = this.client.addGameWindow(n3, string2, string6, string3, string7, d, n, n2, n5, bl2);
                this.conn.send("moves " + n, false);
                int n6 = parsedMessage.intAt(6);
                if (n6 > 0) {
                    this.waitingGameWindow = gameWindow;
                    this.waitingMoveNumber = n6;
                    gameWindow.game.ss.setQuiet(true);
                    this.seenmoveone = false;
                }
                this.handleMovesGame = -1;
            }
        }
        catch (ErgoException ergoException) {
            // empty catch block
        }
    }

    protected void handlePrompt(ParsedMessage parsedMessage) {
        try {
            parsedMessage.continueParse(" %i");
            int n = parsedMessage.intAt(1);
            switch (n) {
                case 1: {
                    this.client.displayString("Password: ", null, true);
                    if (!this.client.loginDialogExists() || !this.client.loginDialogDone() || this.client.passwordSent()) break;
                    this.client.sendPassword();
                    break;
                }
                case 7: {
                    if (n != this.previousPrompt && this.conn.server.isNNGStype()) {
                        GameWindow gameWindow = this.client.getGameBeingPlayed();
                        Move move = gameWindow.game.finalServerMove();
                        int n2 = move.moveNumber() + 1;
                        int n3 = Move.nextColor(move.color());
                        PassMove passMove = new PassMove(move, 0, n2, n3, false);
                        this.handleMovesWindow.placeMove(passMove, true);
                    }
                    this.client.displayStringInActiveGame("Enter dead group:");
                    break;
                }
                default: {
                    this.conn.stopScanningForLogin();
                }
            }
            this.previousPrompt = n;
        }
        catch (ErgoException ergoException) {
            // empty catch block
        }
    }

    protected void handleUndo(ParsedMessage parsedMessage) {
        try {
            parsedMessage.continueParse(" Undo in game %i: %a vs %a: %a");
            int n = parsedMessage.intAt(1);
            String string = parsedMessage.stringAt(2);
            String string2 = parsedMessage.stringAt(3);
            this.client.undoMove(string, string2, n);
        }
        catch (ParseException parseException) {
            this.client.undoMove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleShout(ParsedMessage parsedMessage) {
        this.skipwhite(parsedMessage);
        String string = parsedMessage.rest();
        switch (string.charAt(0)) {
            case '{': {
                try {
                    if (string.regionMatches(true, 0, "{Game ", 0, 6)) {
                        parsedMessage.continueParse("{Game %i: %a vs %a ");
                        int n = parsedMessage.intAt(1);
                        String string2 = parsedMessage.stringAt(2);
                        String string3 = parsedMessage.stringAt(3);
                        String string4 = parsedMessage.rest();
                        if (string4.indexOf("adjourned.}") != -1) {
                            this.client.adjournGame(string2, string3, n);
                            this.sgc.disapply(n, string2, string3);
                            break;
                        }
                        String string5 = "";
                        String string6 = "";
                        if (string4.indexOf(" B ") != -1) {
                            if (this.client.isDisplayingGame(string2, string3, n)) {
                                try {
                                    ParsedMessage parsedMessage2 = new ParsedMessage(string4, " : %s %s %s %f %s %f");
                                    double d = parsedMessage2.doubleAt(3);
                                    double d2 = parsedMessage2.doubleAt(5);
                                    string5 = "" + Math.abs(d - d2);
                                    string6 = d < d2 ? "B" : "W";
                                    this.client.resignGame(string2, string3, n, string6 + "+" + string5);
                                }
                                catch (ParseException parseException) {
                                    Debug.backtrace(parseException);
                                }
                            }
                            this.sgc.disapply(n, string2, string3);
                            break;
                        }
                        if (string4.indexOf("resigns.}") != -1) {
                            string5 = "Resign";
                            string6 = string4.indexOf("White") != -1 ? "B" : "W";
                            this.client.resignGame(string2, string3, n, string6 + "+" + string5);
                            this.sgc.disapply(n, string2, string3);
                            break;
                        }
                        if (string4.indexOf("forfeit") != -1 || string4.indexOf("Time") != -1) {
                            string5 = "Time";
                            string6 = string4.indexOf("White") != -1 ? "B" : "W";
                            this.client.resignGame(string2, string3, n, string6 + "+" + string5);
                            this.sgc.disapply(n, string2, string3);
                            break;
                        }
                        if (string4.indexOf("@ Move") != -1) {
                            if (this.client.isDisplayingGame(string2, string3, n)) {
                                this.conn.send("observe " + n);
                            }
                            parsedMessage.continueParse("@ Move %i");
                            ServerPlayer serverPlayer = this.spc.byName(string2);
                            ServerPlayer serverPlayer2 = this.spc.byName(string3);
                            String string7 = serverPlayer == null ? "??" : serverPlayer.rank.render();
                            String string8 = serverPlayer2 == null ? "??" : serverPlayer2.rank.render();
                            this.sgc.apply(parsedMessage.stringAt(1), string2, string7, string3, string8, parsedMessage.stringAt(4));
                        }
                    }
                    if (string.regionMatches(true, 0, "{Match ", 0, 7)) {
                        parsedMessage.continueParse("{Match %i: %s [ %w ] vs. %s [ %w ]");
                        this.sgc.apply(parsedMessage.stringAt(1), parsedMessage.stringAt(2), parsedMessage.stringAt(3), parsedMessage.stringAt(4), parsedMessage.stringAt(5));
                        break;
                    }
                    if (string.indexOf(" has connected.}") != -1) {
                        parsedMessage.continueParse("{%s [ %w ]");
                        this.spc.apply(parsedMessage.stringAt(1), parsedMessage.stringAt(2));
                        break;
                    }
                    if (string.indexOf(" has disconnected}") == -1) break;
                    parsedMessage.continueParse("{%s");
                    ServerPlayer serverPlayer = this.spc.byName(parsedMessage.stringAt(1));
                    this.spc.removePlayer(serverPlayer, false);
                    break;
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace(System.out);
                    break;
                }
                finally {
                    this.client.displayNoiseString(string);
                }
            }
            case '!': {
                this.client.displayShout(string);
                break;
            }
            default: {
                this.client.displayNoiseString(string);
            }
        }
    }

    protected void handleScore(ParsedMessage parsedMessage) {
        String string = parsedMessage.rest();
        try {
            char c;
            int n;
            parsedMessage.continueParse(" %i: %a");
            int n2 = parsedMessage.intAt(1);
            String string2 = parsedMessage.stringAt(2);
            int n3 = string2.length();
            if (this.gameResult == null) {
                this.gameResult = new int[n3][n3];
                for (n = 0; n < n3; ++n) {
                    for (c = '\u0000'; c < n3; ++c) {
                        this.gameResult[n][c] = -1;
                    }
                }
            }
            for (n = 0; n < n3 && Character.isDigit(c = string2.charAt(n)); ++n) {
                this.gameResult[n3 - n - 1][n2] = Character.digit(c, 10);
            }
            n = this.gameResultBlack != null && this.gameResultWhite != null ? 1 : 0;
            block7: for (c = '\u0000'; c < n3; ++c) {
                for (int i = 0; i < n3; ++i) {
                    if (this.gameResult[c][i] != -1) continue;
                    n = 0;
                    break block7;
                }
            }
            if (n != 0) {
                GameWindow gameWindow = this.client.getGameWindowByName(this.gameResultWhite, this.gameResultBlack, -1);
                if (gameWindow == null) {
                    gameWindow = this.client.createGame(n3, this.gameResultWhite, this.gameResultWR, this.gameResultBlack, this.gameResultBR, this.gameResultKomi);
                }
                this.client.placeMove(this.gameResultWhite, this.gameResultBlack, -1, new GameResultMove(gameWindow.game.finalServerMove(), this.gameResult), false);
                this.gameResult = null;
                this.gameResultBlack = null;
                this.gameResultWhite = null;
                this.gameResultWR = null;
                this.gameResultBR = null;
            }
        }
        catch (ParseException parseException) {
            try {
                ParsedMessage parsedMessage2 = new ParsedMessage(string, " %a %s %i %i %i %c %f %i");
                if (this.gameResultWhite == null) {
                    this.gameResultWhite = parsedMessage2.stringAt(0);
                    this.gameResultWR = parsedMessage2.stringAt(1);
                    this.gameResultKomi = parsedMessage2.doubleAt(6);
                } else if (this.gameResultBlack == null) {
                    this.gameResultBlack = parsedMessage2.stringAt(0);
                    this.gameResultBR = parsedMessage2.stringAt(1);
                }
            }
            catch (ParseException parseException2) {
                // empty catch block
            }
        }
    }

    protected void handleYell(ParsedMessage parsedMessage) {
        try {
            parsedMessage.continueParse(" %s ");
            String string = parsedMessage.stringAt(1);
            String string2 = parsedMessage.rest();
            string = string.substring(0, string.length() - 1);
            this.client.displayYell(string, string2);
        }
        catch (ParseException parseException) {
            this.client.displayString(parsedMessage.rest());
        }
    }
}

