/*
 * Decompiled with CFR 0.152.
 */
package ergo.logic;

import ergo.logic.Game;
import ergo.logic.Move;
import ergo.logic.RootMove;
import ergo.util.ILMV;
import ergo.util.Position;
import ergo.util.PositionVector;
import ergo.util.SimpleGroup;
import ergo.util.SimpleGroupVector;
import java.io.PrintWriter;

public class StoneMove
extends Move {
    protected PositionVector placedPositions = new PositionVector(1, 0);
    protected Position position;
    protected SimpleGroupVector capturedGroups;

    public StoneMove(Move move, int n, int n2, int n3, boolean bl, Position position) {
        super(move, n, n2, n3, bl);
        this.position = position;
        this.placedPositions.addElement(this.position);
    }

    public StoneMove(Move move, int n, int n2, int n3, boolean bl, int n4, int n5) {
        super(move, n, n2, n3, bl);
        this.position = new Position(n4, n5);
        this.placedPositions.addElement(this.position);
    }

    public void reseatforShadow(Position position, int n, Move move, int n2) {
        this.position = position;
        this.color = n;
        this.parent = move;
        this.moveNumber = n2;
    }

    public Position position() {
        return this.position;
    }

    public PositionVector placedPositions(int n) {
        return this.placedPositions;
    }

    public int numberOfStones() {
        return 1;
    }

    public SimpleGroupVector capturedGroups() {
        return this.capturedGroups;
    }

    public String toString() {
        return this.position.toString();
    }

    public boolean equals(Move move) {
        return move instanceof StoneMove && this.position.equals(((StoneMove)move).position());
    }

    public void writeSGF(PrintWriter printWriter, Game game, int n) {
        if (!(this.parent instanceof RootMove)) {
            printWriter.print(";");
        }
        printWriter.print((this.color == 0 ? "B" : "W") + this.position.asSGF(game.size()));
        if (game.isNetGame()) {
            this.writeTimeLeft(printWriter);
        }
        super.writeSGF(printWriter, game, n);
    }

    public boolean occupiesPosition(Position position) {
        return this.position.equals(position);
    }

    public SimpleGroupVector newGroups(Game game) {
        SimpleGroupVector simpleGroupVector = new SimpleGroupVector(1);
        simpleGroupVector.addElement(game.composeGroups(game.groupsAbutting(this.position, this.color), this.color, this.position));
        return simpleGroupVector;
    }

    public boolean isLegal(Game game, boolean bl, ILMV iLMV) {
        int n = this.position.row;
        int n2 = this.position.column;
        if (!super.isLegal(game, bl, iLMV)) {
            return false;
        }
        if (game.stoneAt(n, n2) != 3) {
            iLMV.failureReason = "Position is occupied.";
            return false;
        }
        if (game.koPosition() != null && this.position.equals(game.koPosition())) {
            iLMV.failureReason = "Position is ko.";
            return false;
        }
        if (bl && game.numberOfLiberties(this.position) > 0) {
            return true;
        }
        boolean bl2 = false;
        iLMV.opponentGroups = game.groupsAbutting(this.position, Move.nextColor(this.color));
        if (iLMV.opponentGroups != null) {
            for (int i = 0; i < iLMV.opponentGroups.size(); ++i) {
                SimpleGroup simpleGroup = iLMV.opponentGroups.elementAt(i);
                if (simpleGroup.numberOfLiberties() != 1) continue;
                if (bl) {
                    return true;
                }
                if (!bl2) {
                    this.capturedGroups = new SimpleGroupVector(1, 2);
                }
                this.capturedGroups.addElement(simpleGroup);
                bl2 = true;
            }
        }
        iLMV.newGroups = this.newGroups(game);
        if (bl2 || iLMV.newGroups.elementAt(0).numberOfLiberties() > 0) {
            return true;
        }
        iLMV.failureReason = "Play into death";
        return false;
    }
}

