/*
 * Decompiled with CFR 0.152.
 */
package ergo.logic;

import ergo.logic.Game;
import ergo.logic.Move;
import ergo.util.ILMV;
import ergo.util.Position;
import ergo.util.PositionVector;
import ergo.util.SimpleGroup;
import ergo.util.SimpleGroupVector;
import java.io.PrintWriter;

public class RemovalMove
extends Move {
    Position pos;
    SimpleGroupVector capturedGroups = new SimpleGroupVector(1);

    public RemovalMove(Move move, Position position, int n, boolean bl) {
        super(move, move.timeLeft, n, move.nextColor(), bl);
        this.pos = position;
    }

    public String toString() {
        return "Removed " + this.pos + " group";
    }

    public PositionVector placedPositions(int n) {
        return null;
    }

    public boolean isLegal(Game game, boolean bl, ILMV iLMV) {
        SimpleGroup simpleGroup = game.groupAt(this.pos.row, this.pos.column);
        if (simpleGroup == null) {
            iLMV.failureReason = "No group to remove at " + this.pos + ".";
            return false;
        }
        this.capturedGroups.addElement(simpleGroup);
        return true;
    }

    public boolean equals(Move move) {
        return false;
    }

    public int numberOfStones() {
        return 0;
    }

    public SimpleGroupVector capturedGroups() {
        return this.capturedGroups;
    }

    public boolean occupiesPosition(Position position) {
        return false;
    }

    public void writeSGF(PrintWriter printWriter, Game game, int n) {
        printWriter.print(";C[Ergo: " + this + "]");
        super.writeSGF(printWriter, game, n);
    }
}

