/*
 * Decompiled with CFR 0.152.
 */
package ergo.logic;

import ergo.logic.Game;
import ergo.logic.SGF;
import ergo.logic.StoneStasher;
import ergo.util.Debug;
import ergo.util.ILMV;
import ergo.util.Position;
import ergo.util.PositionVector;
import ergo.util.SimpleGroupVector;
import java.io.PrintWriter;
import java.util.Vector;

public abstract class Move {
    public static final int BLACK = 0;
    public static final int WHITE = 1;
    public static final int EMPTY = 3;
    public static final int WHITETERRITORY = 4;
    public static final int BLACKTERRITORY = 5;
    public static final int SEEN = 6;
    public static final int NONE = 7;
    public static final int BLACKSHADOW = 10;
    public static final int WHITESHADOW = 11;
    public static final int BOTH = 12;
    protected Move parent;
    protected Move child;
    protected int color;
    protected boolean isVariation;
    protected Vector kibitzes;
    protected Vector variations;
    protected int timeLeft = -1;
    protected int moveNumber;
    protected boolean isCommitted = false;
    protected Vector unhandledSGFproperties = null;

    Move() {
    }

    Move(Move move, int n, int n2, int n3, boolean bl) {
        this.parent = move;
        if (move == null && n3 != 1 || move != null && n3 != move.nextColor()) {
            Debug.println("Incorrect color for move #" + n2);
        }
        if (move != null && n2 != move.moveNumber() + 1) {
            Debug.println("Move numbers not in sequence: " + n2);
        }
        this.color = move == null ? 1 : move.nextColor();
        this.timeLeft = n;
        this.moveNumber = n2;
        this.isVariation = bl;
    }

    public int moveNumber() {
        return this.moveNumber;
    }

    public Move child() {
        return this.child;
    }

    public void setChild(Move move) {
        this.child = move;
    }

    public Move parent() {
        return this.parent;
    }

    public int color() {
        return this.color;
    }

    public Vector kibitzes() {
        return this.kibitzes;
    }

    public boolean hasKibitzes() {
        return this.kibitzes != null && this.kibitzes.size() > 0;
    }

    public SimpleGroupVector newGroups(Game game) {
        return null;
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public void commit() {
        this.isCommitted = true;
        this.link();
    }

    public void addSGFproperty(String string, Vector vector) {
        if (this.unhandledSGFproperties == null) {
            this.unhandledSGFproperties = new Vector(2, 4);
        }
        Vector<Object> vector2 = new Vector<Object>(2);
        vector2.addElement(string);
        vector2.addElement(vector);
        this.unhandledSGFproperties.addElement(vector2);
    }

    public void link() {
        if (this.parent == null) {
            Debug.println("Error: Attempt to link move with null parent.");
        } else if (this.parent.child() == null) {
            this.parent.setChild(this);
        } else if (this.equals(this.parent.child())) {
            Move move = this.parent.child();
            this.parent.setChild(this);
            this.child = move.child();
            int n = 0;
            while (move.variationAt(n) != null) {
                this.addVariation(move.variationAt(n));
                ++n;
            }
        } else if (!this.isVariation) {
            if (this.parent.child().isVariation) {
                this.parent.addVariation(this.parent.child());
                this.parent.setChild(this);
            } else {
                Debug.println("Attempt to link two server moves to the same parent.  Not linking move.");
            }
        } else {
            this.parent.addVariation(this);
        }
    }

    public Move variationAt(int n) {
        if (n == -1) {
            return this.child;
        }
        if (this.variations == null || this.variations.size() <= n) {
            return null;
        }
        return (Move)this.variations.elementAt(n);
    }

    public Move variationAt(Position position) {
        int n = -1;
        while (this.variationAt(n) != null) {
            if (this.variationAt(n).occupiesPosition(position)) {
                return this.variationAt(n);
            }
            ++n;
        }
        return null;
    }

    public boolean isVariation() {
        return this.isVariation;
    }

    public boolean isVariation(Move move) {
        if (this.variations != null) {
            for (int i = 0; i < this.variations.size(); ++i) {
                if (move != this.variationAt(i)) continue;
                return true;
            }
        }
        return false;
    }

    public void setIsVariation(boolean bl) {
        this.isVariation = bl;
    }

    public void addVariation(Move move) {
        if (this.variations == null) {
            this.variations = new Vector(1, 3);
        }
        for (int i = 0; i < this.variations.size(); ++i) {
            if (!move.equals(this.variationAt(i))) continue;
            this.variations.setElementAt(move, i);
            return;
        }
        this.variations.addElement(move);
    }

    public boolean removeVariation(Move move) {
        if (move == this.child) {
            if (this.variations != null && this.variations.size() > 0) {
                this.child = this.variationAt(0);
                this.variations.removeElementAt(0);
            } else {
                this.child = null;
            }
            return true;
        }
        if (this.variations != null) {
            for (int i = 0; i < this.variations.size(); ++i) {
                if (move != this.variationAt(i)) continue;
                this.variations.removeElementAt(i);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isBranch() {
        return this.variations != null && this.variations.size() != 0;
    }

    public String toVariationString() {
        StringBuffer stringBuffer = new StringBuffer(" at move #" + (this.moveNumber() + 1) + " -- " + Character.toLowerCase(this.colorToChar(this.color())) + " " + this.toString());
        Move move = this;
        while (move.child() != null) {
            move = move.child();
            stringBuffer.append(", " + Character.toLowerCase(this.colorToChar(move.color())) + " " + move.toString());
        }
        return stringBuffer.toString();
    }

    public int nextColor() {
        return Move.nextColor(this.color);
    }

    public static int nextColor(int n) {
        return n == 1 ? 0 : 1;
    }

    public void addKibitz(String string) {
        if (string != null) {
            if (this.kibitzes == null) {
                this.kibitzes = new Vector(4, 4);
            }
            this.kibitzes.addElement(string);
        }
    }

    public Move finalMove(boolean bl) {
        Move move = this;
        Move move2;
        while (!((move2 = move.child()) == null || bl && move2.isVariation)) {
            move = move2;
        }
        return move;
    }

    public void noteMovePlaced(StoneStasher stoneStasher) {
    }

    public void noteMoveUndone(StoneStasher stoneStasher) {
    }

    public abstract PositionVector placedPositions(int var1);

    public abstract SimpleGroupVector capturedGroups();

    public abstract int numberOfStones();

    public abstract boolean equals(Move var1);

    public abstract boolean occupiesPosition(Position var1);

    public boolean isLegal(Game game, boolean bl, ILMV iLMV) {
        if (this.parent == null) {
            iLMV.failureReason = "Move has no parent.";
            return false;
        }
        if (this.moveNumber == this.parent.moveNumber()) {
            return false;
        }
        if (this.moveNumber != this.parent.moveNumber() + 1) {
            iLMV.failureReason = "Move numbers out of order. (" + this.parent.moveNumber() + " " + this.moveNumber + ")";
            return false;
        }
        if (this.color == this.parent.color()) {
            iLMV.failureReason = "Color is same as parent move's color.";
            return false;
        }
        return true;
    }

    public String colorToString(int n) {
        return n == 0 ? "Black" : "White";
    }

    public char colorToChar(int n) {
        return this.colorToString(n).charAt(0);
    }

    protected void writeTimeLeft(PrintWriter printWriter) {
        if (this.timeLeft != -1) {
            printWriter.print(this.colorToChar(this.color) + "L[" + this.timeLeft + "]");
        }
    }

    public void writeSGF(PrintWriter printWriter, Game game, int n) {
        int n2;
        if (this.kibitzes != null && this.kibitzes.size() > 0) {
            printWriter.print("\nC[");
            for (n2 = 0; n2 < this.kibitzes.size(); ++n2) {
                SGF.writeText(printWriter, (String)this.kibitzes.elementAt(n2));
                if (n2 == this.kibitzes.size() - 1) continue;
                printWriter.print("\n");
            }
            printWriter.print("]\n");
            n = 4;
        }
        if (this.variations != null && this.variations.size() > 0) {
            n2 = -1;
            while (this.variationAt(n2) != null) {
                printWriter.print("\n(");
                this.variationAt(n2).writeSGF(printWriter, game, 4);
                printWriter.print(")");
                ++n2;
            }
        } else if (this.child != null) {
            if (n <= 0) {
                printWriter.print("\n");
            }
            this.child.writeSGF(printWriter, game, n <= 0 ? 4 : n - 1);
        }
    }

    public void print() {
        if (!this.isVariation) {
            System.out.println();
        }
        System.out.print(this + " ");
        if (this.variations != null && this.variations.size() > 0) {
            System.out.print(" (");
            for (int i = 0; i < this.variations.size(); ++i) {
                Move move = this.variationAt(i);
                move.print();
            }
            System.out.print(")");
        }
        if (this.child != null) {
            this.child.print();
        }
    }
}

