/*
 * Decompiled with CFR 0.152.
 */
package ergo.logic;

import ergo.logic.Game;
import ergo.logic.Move;
import ergo.logic.RootMove;
import ergo.util.ILMV;
import ergo.util.Position;
import ergo.util.PositionVector;
import ergo.util.SimpleGroup;
import ergo.util.SimpleGroupVector;
import java.io.PrintWriter;

public class HandicapMove
extends Move {
    int stones;
    PositionVector positions;

    public HandicapMove(Move move, int n, int n2, boolean bl, int n3, int n4) {
        super(move, n, n2, 0, bl);
        this.stones = n3;
        this.placedPositions(n4);
    }

    public HandicapMove(Move move, int n, int n2, boolean bl, PositionVector positionVector) {
        super(move, n, n2, 0, bl);
        this.stones = positionVector.size();
        this.positions = positionVector;
    }

    public void writeSGF(PrintWriter printWriter, Game game, int n) {
        if (!(this.parent instanceof RootMove)) {
            printWriter.print(";");
        }
        if (this.stones >= 2) {
            printWriter.print("HA[" + this.stones + "]AB");
            for (int i = 0; i < this.positions.size(); ++i) {
                printWriter.print(this.positions.elementAt(i).asSGF(game.size()));
            }
            printWriter.print("\n");
            n = 4;
        }
        if (game.isNetGame()) {
            this.writeTimeLeft(printWriter);
        }
        super.writeSGF(printWriter, game, n);
    }

    public boolean isLegal(Game game, boolean bl, ILMV iLMV) {
        if (!super.isLegal(game, bl, iLMV)) {
            return false;
        }
        if (this.parent instanceof RootMove) {
            if (!bl) {
                iLMV.newGroups = new SimpleGroupVector(this.stones);
                for (int i = 0; i < this.positions.size(); ++i) {
                    SimpleGroup simpleGroup = new SimpleGroup(this.color);
                    Position position = this.positions.elementAt(i);
                    PositionVector positionVector = game.getLiberties(position);
                    simpleGroup.addPosition(position);
                    for (int j = 0; j < positionVector.size(); ++j) {
                        simpleGroup.addLiberty(positionVector.elementAt(j));
                    }
                    iLMV.newGroups.addElement(simpleGroup);
                }
            }
            return true;
        }
        iLMV.failureReason = "A handicap may only be placed on the first move.";
        return false;
    }

    public PositionVector placedPositions(int n) {
        if (this.positions == null) {
            this.positions = new PositionVector(this.stones);
            int n2 = n == 9 ? 2 : 3;
            int n3 = n - n2 - 1;
            int n4 = n / 2;
            this.positions.addElement(new Position(n3, n3));
            if (this.stones >= 2) {
                this.positions.addElement(new Position(n2, n2));
            }
            if (this.stones >= 3) {
                this.positions.addElement(new Position(n3, n2));
            }
            if (this.stones >= 4) {
                this.positions.addElement(new Position(n2, n3));
                if (this.stones % 2 == 1) {
                    this.positions.addElement(new Position(n4, n4));
                }
            }
            if (this.stones >= 6) {
                this.positions.addElement(new Position(n4, n2));
                this.positions.addElement(new Position(n4, n3));
            }
            if (this.stones >= 8) {
                this.positions.addElement(new Position(n2, n4));
                this.positions.addElement(new Position(n3, n4));
            }
        }
        return this.positions;
    }

    public PositionVector placedPositions() {
        return this.positions;
    }

    public SimpleGroupVector capturedGroups() {
        return null;
    }

    public int numberOfStones() {
        return this.stones;
    }

    public String toString() {
        return "Handicap " + this.stones;
    }

    public boolean equals(Move move) {
        return move instanceof HandicapMove && this.numberOfStones() == move.numberOfStones();
    }

    public boolean occupiesPosition(Position position) {
        for (int i = 0; i < this.positions.size(); ++i) {
            if (!position.equals(this.positions.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public SimpleGroupVector newGroups(Game game) {
        SimpleGroupVector simpleGroupVector = new SimpleGroupVector(this.stones);
        for (int i = 0; i < this.stones; ++i) {
            simpleGroupVector.addElement(game.composeGroups(game.groupsAbutting(this.positions.elementAt(i), this.color), this.color, this.positions.elementAt(i)));
        }
        return simpleGroupVector;
    }
}

