/*
 * Decompiled with CFR 0.152.
 */
package ergo.logic;

import ergo.logic.Game;
import ergo.logic.Move;
import ergo.logic.RootMove;
import ergo.logic.StoneStasher;
import ergo.util.Debug;
import ergo.util.ILMV;
import ergo.util.Position;
import ergo.util.PositionVector;
import ergo.util.SimpleGroupVector;
import java.io.PrintWriter;

public final class GameResultMove
extends Move {
    private int[][] result = null;
    private int[][] saved = null;

    public GameResultMove(Move move, int[][] nArray) {
        super(move, 0, move.moveNumber() + 1, Move.nextColor(move.color()), false);
        this.result = nArray;
    }

    public int[][] result() {
        return this.result;
    }

    public void noteMovePlaced(StoneStasher stoneStasher) {
        if (this.saved == null) {
            this.saved = new int[this.result.length][this.result[0].length];
        }
        Debug.println("GameResultMove.noteMovePlaced");
        for (int i = 0; i < this.result.length; ++i) {
            for (int j = 0; j < this.result[0].length; ++j) {
                this.saved[i][j] = stoneStasher.readAnyStone(i, j);
                stoneStasher.writeStone(i, j, this.result[i][j]);
            }
        }
        stoneStasher.emit();
    }

    public void noteMoveUndone(StoneStasher stoneStasher) {
        for (int i = 0; i < this.saved.length; ++i) {
            for (int j = 0; j < this.saved[0].length; ++j) {
                stoneStasher.writeStone(i, j, this.saved[i][j]);
            }
        }
        stoneStasher.emit();
    }

    public boolean isLegal(Game game, boolean bl, ILMV iLMV) {
        return true;
    }

    public void writeSGF(PrintWriter printWriter, Game game, int n) {
        if (!(this.parent instanceof RootMove)) {
            printWriter.print(";");
        }
        if (this.result != null) {
            this.writeTerritory(printWriter, 4, "WhiteTerritory", game);
            this.writeTerritory(printWriter, 5, "BlackTerritory", game);
        }
        super.writeSGF(printWriter, game, 4);
    }

    private void writeTerritory(PrintWriter printWriter, int n, String string, Game game) {
        boolean bl = game.getCurrentMove() == this;
        boolean bl2 = false;
        int n2 = game.size();
        int n3 = 10;
        int n4 = 0;
        StoneStasher stoneStasher = game.ss;
        printWriter.println();
        for (int i = 0; i < this.result.length; ++i) {
            for (int j = 0; j < this.result[0].length; ++j) {
                int n5;
                int n6 = n5 = bl ? stoneStasher.readAnyStone(i, j) : this.result[i][j];
                if (n5 != n) continue;
                if (!bl2) {
                    printWriter.print(string);
                    bl2 = true;
                }
                printWriter.print(Position.asSGF(n2, i, j));
                n4 = (n4 + 1) % n3;
                if (n4 != 0) continue;
                printWriter.println();
            }
        }
    }

    public String toString() {
        return "Final Result";
    }

    public PositionVector placedPositions(int n) {
        return null;
    }

    public boolean equals(Move move) {
        return move == this;
    }

    public SimpleGroupVector capturedGroups() {
        return null;
    }

    public int numberOfStones() {
        return 0;
    }

    public boolean occupiesPosition(Position position) {
        return false;
    }
}

