/*
 * HDigestUtils.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.fw.util;

import org.apache.commons.codec.digest.DigestUtils;

/**
 * nbVsNXłB
 * 
 * @version 2.1
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.1
 */
public class HDigestUtils {

    /**
     * 32̃nbVlɕϊ܂B
     * @param str 
     * @return nbV
     * @since 2.1
     */
    public static String hash32(String str) {
        return md5(str);
    }
    
    /**
     * 40̃nbVlɕϊ܂B
     * @param str 
     * @return nbV
     * @since 2.1
     */
    public static String hash40(String str) {
        return sha1(str);
    }
    
    /**
     * 64̃nbVlɕϊ܂B
     * @param str 
     * @return nbV
     * @since 2.1
     */
    public static String hash64(String str) {
        return sha256(str);
    }
    
    /**
     * 96̃nbVlɕϊ܂B
     * @param str 
     * @return nbV
     * @since 2.1
     */
    public static String hash96(String str) {
        return sha384(str);
    }

    /**
     * 128̃nbVlɕϊ܂B
     * @param str 
     * @return nbV
     * @since 2.1
     */
    public static String hash128(String str) {
        return sha512(str);
    }

    /**
     * MD5ŃnbV܂B
     * @param str 
     * @return nbV
     * @since 2.1
     */
    public static String md5(String str) {
        //null̏ꍇ
        if (str == null) {
            return str;
        //󕶎̏ꍇ
        } else if (str.length() == 0) {
            return str;
        }
        //MD5ŃnbV
        String hash = DigestUtils.md5Hex(str);
        return hash;
    }

    /**
     * SHA-1ŃnbV܂B
     * @param str 
     * @return nbV
     * @since 2.1
     */
    public static String sha1(String str) {
        //null̏ꍇ
        if (str == null) {
            return str;
        //󕶎̏ꍇ
        } else if (str.length() == 0) {
            return str;
        }
        //SHA-1ŃnbV
        String hash = DigestUtils.shaHex(str);
        return hash;
    }

    /**
     * SHA-256ŃnbV܂B
     * @param str 
     * @return nbV
     * @since 2.1
     */
    public static String sha256(String str) {
        //null̏ꍇ
        if (str == null) {
            return str;
        //󕶎̏ꍇ
        } else if (str.length() == 0) {
            return str;
        }
        //SHA-256ŃnbV
        String hash = DigestUtils.sha256Hex(str);
        return hash;
    }

    /**
     * SHA-384ŃnbV܂B
     * @param str 
     * @return nbV
     * @since 2.1
     */
    public static String sha384(String str) {
        //null̏ꍇ
        if (str == null) {
            return str;
        //󕶎̏ꍇ
        } else if (str.length() == 0) {
            return str;
        }
        //SHA-384ŃnbV
        String hash = DigestUtils.sha384Hex(str);
        return hash;
    }

    /**
     * SHA-512ŃnbV܂B
     * @param str 
     * @return nbV
     * @since 2.1
     */
    public static String sha512(String str) {
        //null̏ꍇ
        if (str == null) {
            return str;
        //󕶎̏ꍇ
        } else if (str.length() == 0) {
            return str;
        }
        //SHA-512ŃnbV
        String hash = DigestUtils.sha512Hex(str);
        return hash;
    }

}
