/*
 * HFException.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.fw;

/**
 * ʂ̗ONXłB
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public abstract class HException extends Exception implements HThrowable {

    private static final long serialVersionUID = -8361281152208541935L;

    /** G[R[h */
    protected String errorCode = null;

    /** G[bZ[W */
    protected String message = null;

    /**
     * RXgN^
     * @param message bZ[W
     * @since 2.0
     */
    public HException(String message) {
        super(message);
        this.message = message;
    }
    
    /**
     * RXgN^B
     * @param cause ̗O
     * @since 2.0
     */
    public HException(Throwable cause) {
        super(cause);
    }

    /**
     * RXgN^B
     * @param cause ̗O
     * @since 2.0
     */
    public HException(String message, Throwable cause) {
        super(message, cause);
        this.message = message;
    }

    /**
     * RXgN^B
     * @since 2.0
     */
    public HException() {
        super();
    }

    /**
     * RXgN^B
     * @param errorCode G[R[h
     * @param message bZ[W
     * @since 2.0
     */
    public HException(Class cls, String errorCode) {
        super();
        this.errorCode = errorCode;
        this.message = getMessage(cls, this.errorCode);
    }

    /**
     * RXgN^B
     * @param errorCode G[R[h
     * @param cause ̗O
     * @since 2.0
     */
    public HException(Class cls, String errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
        this.message = getMessage(cls, this.errorCode);
    }

    /**
     * G[R[h擾܂B
     * @return G[R[h
     * @since 2.0
     */
    public String getErrorCode() {
        return this.errorCode;
    }

    /**
     * bZ[W擾܂B
     * @return bZ[W
     * @since 2.0
     * @see java.lang.Throwable#getMessage()
     */
    public String getMessage() {
        return (this.message == null) ? super.getMessage() : this.message;
    }

    /**
     * G[R[hG[bZ[W擾܂B
     * @param errorCode G[R[h
     * @return 擾G[bZ[W
     * @since 2.0
     */
    protected String getMessage(Class cls, String errorCode) {
        if (cls == null) {
            return ResourceManager.getException().getString(errorCode);            
        } else {
            return ResourceManager.getException().getString(cls, errorCode);            
        }
    }

}
