/**
 * 
 */
package jp.hrtdotnet.fw;

import junit.framework.TestCase;

public class HExceptionTest extends TestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.fw.HException#HException(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testHExceptionString() {
        String msg = "testmsg";
        HExceptionTest1 e = new HExceptionTest1(msg);
        assertEquals(msg, e.getMessage());
    }

    /**
     * {@link jp.hrtdotnet.fw.HException#HException(java.lang.Throwable)} ̂߂̃eXgE\bhB
     */
    public void testHExceptionThrowable() {
        String msg = "e1-msg";
        Exception e1 = new Exception(msg);
        HExceptionTest1 e = new HExceptionTest1(e1);
        assertEquals("java.lang.Exception: " + msg, e.getMessage());
    }

    /**
     * {@link jp.hrtdotnet.fw.HException#HException(java.lang.String, java.lang.Throwable)} ̂߂̃eXgE\bhB
     */
    public void testHExceptionStringThrowable() {
        String msg1 = "e1-msg1";
        String msg2 = "e1-msg2";
        Exception e1 = new Exception(msg1);
        HExceptionTest1 e = new HExceptionTest1(msg2, e1);
        assertEquals(msg2, e.getMessage());
    }

    /**
     * {@link jp.hrtdotnet.fw.HException#HException()} ̂߂̃eXgE\bhB
     */
    public void testHException() {
        HExceptionTest1 e = new HExceptionTest1();
        assertEquals(null, e.getMessage());
    }

    /**
     * {@link jp.hrtdotnet.fw.HException#HException(java.lang.Class, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testHExceptionClassString() {
        String msg1 = "e1-msg1";
        String errorCode = "test1";
        Exception e1 = new Exception(msg1);
        HExceptionTest1 e = new HExceptionTest1(this.getClass(), errorCode, e1);
        assertEquals("eXgP", e.getMessage());
        assertEquals("test1", e.getErrorCode());
    }

    /**
     * {@link jp.hrtdotnet.fw.HException#HException(java.lang.Class, java.lang.String, java.lang.Throwable)} ̂߂̃eXgE\bhB
     */
    public void testHExceptionClassStringThrowable() {
        String errorCode = "test2";
        HExceptionTest1 e = new HExceptionTest1(this.getClass(), errorCode);
        assertEquals("eXgQ", e.getMessage());
        assertEquals("test2", e.getErrorCode());
    }

    /**
     * {@link jp.hrtdotnet.fw.HException#getErrorCode()} ̂߂̃eXgE\bhB
     */
    public void testGetErrorCode() {
        String errorCode = "test3";
        HExceptionTest1 e = new HExceptionTest1(this.getClass(), errorCode);
        assertEquals("test3", e.getErrorCode());
    }

    /**
     * {@link jp.hrtdotnet.fw.HException#getMessage()} ̂߂̃eXgE\bhB
     */
    public void testGetMessage() {
        String errorCode = "test4";
        HExceptionTest1 e = new HExceptionTest1(this.getClass(), errorCode);
        assertEquals("eXgS", e.getMessage());
    }

    /**
     * {@link jp.hrtdotnet.fw.HException#getMessage(java.lang.Class, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testGetMessageClassString() {
        String errorCode = "test5";
        HExceptionTest1 e = new HExceptionTest1(this.getClass(), errorCode);
        assertEquals("eXgT", e.getMessage(this.getClass(), errorCode));

        errorCode = "test6";
        e = new HExceptionTest1(this.getClass(), errorCode);
        assertEquals("eXgU", e.getMessage(null, errorCode));
    }

    class HExceptionTest1 extends HException {

        /**
         * 
         */
        private static final long serialVersionUID = -5775772247392081859L;

        public HExceptionTest1() {
            super();
        }

        public HExceptionTest1(Class cls, String errorCode, Throwable cause) {
            super(cls, errorCode, cause);
        }

        public HExceptionTest1(Class cls, String errorCode) {
            super(cls, errorCode);
        }

        public HExceptionTest1(String message, Throwable cause) {
            super(message, cause);
        }

        public HExceptionTest1(String message) {
            super(message);
        }

        public HExceptionTest1(Throwable cause) {
            super(cause);
        }        
    
    }
    
}
