/*
 * HPasswordDigest.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.fw.util.password;

import jp.hrtdotnet.fw.util.HDigestUtils;

/**
 * nbVɂpX[ḧÍsNXłB
 * ̈Í͈̂ߌɖ߂Ƃ͂ł܂B
 * @version 2.1
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.1
 */
public class HPasswordDigest extends HPassword {

    /** 32oCg̈Í */
    public static final int BYTE32 = 1;
    /** 40oCg̈Í */
    public static final int BYTE40 = 2;
    /** 64oCg̈Í */
    public static final int BYTE64 = 3;
    /** 96oCg̈Í */
    public static final int BYTE96 = 4;
    /** 128oCg̈Í */
    public static final int BYTE128 = 5;

    private int byteParam = 0;
    
    /**
     * RXgN^B
     * @param byteParam Í(nbV)̃oCgl
     * @since 2.1
     */
    public HPasswordDigest(int byteParam) {
        if (byteParam == BYTE32) {
        } else if (byteParam == BYTE40) {
        } else if (byteParam == BYTE64) {
        } else if (byteParam == BYTE96) {
        } else if (byteParam == BYTE128) {
        } else {
            throw new IllegalArgumentException("byteParam is invalid.");
        }
        this.byteParam = byteParam;
    }

    /**
     * nbVɂpX[ḧÍs܂B
     * ̈Í͈̂ߌɖ߂Ƃ͂ł܂B
     * @param str 
     * @return Í
     * @since 2.1
     */
    public String encrypt(String str) {
        String enc = null;
        if (this.byteParam == BYTE32) {
            enc = HDigestUtils.hash32(str);
        } else if (this.byteParam == BYTE40) {
            enc = HDigestUtils.hash40(str);
        } else if (this.byteParam == BYTE64) {
            enc = HDigestUtils.hash64(str);
        } else if (this.byteParam == BYTE96) {
            enc = HDigestUtils.hash96(str);
        } else if (this.byteParam == BYTE128) {
            enc = HDigestUtils.hash128(str);
        }
        return enc;
    }

}
