/*
 * HDNFw.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.fw;


import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

/**
 * HDNFw ̏`ĂNXłB
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
class HDNFw {
    
    public static void main(String[] args) throws IOException {

        String SignatureVersion;
        String Author;
        String ExtensionName;
        String MainClass;
        String ImplementationVersion;
        String ImplementationTitle;
        String ImplementationVendor;
        String ImplementationURL;
        String SpecificationVersion;
        String SpecificationTitle;
        String SpecificationVendor;
        
        JarFile jar = null;
        jar = new JarFile(System.getProperty("java.class.path"));
        Attributes attributes = jar.getManifest().getMainAttributes();

        ExtensionName = attributes.getValue("Extension-Name");
        SignatureVersion = attributes.getValue("Signature-Version");
        MainClass = attributes.getValue("Main-Class");
        Author = attributes.getValue("Author");
        ImplementationVersion = attributes.getValue("Implementation-Version");
        ImplementationTitle = attributes.getValue("Implementation-Title");
        ImplementationVendor = attributes.getValue("Implementation-Vendor");
        ImplementationURL = attributes.getValue("Implementation-URL");
        SpecificationVersion = attributes.getValue("Specification-Version");
        SpecificationTitle = attributes.getValue("Specification-Title");
        SpecificationVendor = attributes.getValue("Specification-Vendor");
        

        System.out.println("hdnfw informations.");
        System.out.println("Name:        " + ExtensionName);
        System.out.println("Version:     " + SignatureVersion);
        System.out.println("MainClass:   " + MainClass);
        System.out.println("Author:      " + Author);
        System.out.println("");
        System.out.println("hdnfw's specification informations.");
        System.out.println("Title:       " + SpecificationTitle);
        System.out.println("Version:     " + SpecificationVersion);
        System.out.println("Vender:      " + SpecificationVendor);
        System.out.println("");
        System.out.println("hdnfw's implementation informations.");
        System.out.println("Title:       " + ImplementationTitle);
        System.out.println("Version:     " + ImplementationVersion);
        System.out.println("Vender:      " + ImplementationVendor);
        System.out.println("URL:         " + ImplementationURL);
    }

}
