package jp.hrtdotnet.java.util;

import jp.hrtdotnet.java.util.StringUtil;
import junit.framework.TestCase;

public class StringUtilTest extends TestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    
    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#isAlphabet(char)} ̂߂̃eXgE\bhB
     */
    public void testIsAlphabet_Char() {
        assertTrue(StringUtil.isAlphabet('a'));
        assertTrue(StringUtil.isAlphabet('b'));
        assertTrue(StringUtil.isAlphabet('c'));
        assertTrue(StringUtil.isAlphabet('d'));
        assertTrue(StringUtil.isAlphabet('e'));
        assertTrue(StringUtil.isAlphabet('f'));
        assertTrue(StringUtil.isAlphabet('g'));
        assertTrue(StringUtil.isAlphabet('h'));
        assertTrue(StringUtil.isAlphabet('i'));
        assertTrue(StringUtil.isAlphabet('j'));
        assertTrue(StringUtil.isAlphabet('k'));
        assertTrue(StringUtil.isAlphabet('l'));
        assertTrue(StringUtil.isAlphabet('m'));
        assertTrue(StringUtil.isAlphabet('n'));
        assertTrue(StringUtil.isAlphabet('o'));
        assertTrue(StringUtil.isAlphabet('p'));
        assertTrue(StringUtil.isAlphabet('q'));
        assertTrue(StringUtil.isAlphabet('r'));
        assertTrue(StringUtil.isAlphabet('s'));
        assertTrue(StringUtil.isAlphabet('t'));
        assertTrue(StringUtil.isAlphabet('u'));
        assertTrue(StringUtil.isAlphabet('w'));
        assertTrue(StringUtil.isAlphabet('x'));
        assertTrue(StringUtil.isAlphabet('y'));
        assertTrue(StringUtil.isAlphabet('z'));

        assertTrue(StringUtil.isAlphabet('A'));
        assertTrue(StringUtil.isAlphabet('B'));
        assertTrue(StringUtil.isAlphabet('C'));
        assertTrue(StringUtil.isAlphabet('D'));
        assertTrue(StringUtil.isAlphabet('E'));
        assertTrue(StringUtil.isAlphabet('F'));
        assertTrue(StringUtil.isAlphabet('G'));
        assertTrue(StringUtil.isAlphabet('H'));
        assertTrue(StringUtil.isAlphabet('I'));
        assertTrue(StringUtil.isAlphabet('J'));
        assertTrue(StringUtil.isAlphabet('K'));
        assertTrue(StringUtil.isAlphabet('L'));
        assertTrue(StringUtil.isAlphabet('M'));
        assertTrue(StringUtil.isAlphabet('N'));
        assertTrue(StringUtil.isAlphabet('O'));
        assertTrue(StringUtil.isAlphabet('P'));
        assertTrue(StringUtil.isAlphabet('Q'));
        assertTrue(StringUtil.isAlphabet('R'));
        assertTrue(StringUtil.isAlphabet('S'));
        assertTrue(StringUtil.isAlphabet('T'));
        assertTrue(StringUtil.isAlphabet('U'));
        assertTrue(StringUtil.isAlphabet('W'));
        assertTrue(StringUtil.isAlphabet('X'));
        assertTrue(StringUtil.isAlphabet('Y'));
        assertTrue(StringUtil.isAlphabet('Z'));

        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));
        assertTrue(StringUtil.isAlphabet(''));

        assertTrue(StringUtil.isAlphabet('`'));
        assertTrue(StringUtil.isAlphabet('a'));
        assertTrue(StringUtil.isAlphabet('b'));
        assertTrue(StringUtil.isAlphabet('c'));
        assertTrue(StringUtil.isAlphabet('d'));
        assertTrue(StringUtil.isAlphabet('e'));
        assertTrue(StringUtil.isAlphabet('f'));
        assertTrue(StringUtil.isAlphabet('g'));
        assertTrue(StringUtil.isAlphabet('h'));
        assertTrue(StringUtil.isAlphabet('i'));
        assertTrue(StringUtil.isAlphabet('j'));
        assertTrue(StringUtil.isAlphabet('k'));
        assertTrue(StringUtil.isAlphabet('l'));
        assertTrue(StringUtil.isAlphabet('m'));
        assertTrue(StringUtil.isAlphabet('n'));
        assertTrue(StringUtil.isAlphabet('o'));
        assertTrue(StringUtil.isAlphabet('p'));
        assertTrue(StringUtil.isAlphabet('q'));
        assertTrue(StringUtil.isAlphabet('r'));
        assertTrue(StringUtil.isAlphabet('s'));
        assertTrue(StringUtil.isAlphabet('t'));
        assertTrue(StringUtil.isAlphabet('v'));
        assertTrue(StringUtil.isAlphabet('w'));
        assertTrue(StringUtil.isAlphabet('x'));
        assertTrue(StringUtil.isAlphabet('y'));

        assertFalse(StringUtil.isAlphabet('1'));
    }    

    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#isAlphabet(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testIsAlphabet_String() {
        assertTrue(StringUtil.isAlphabet("aAcdfjhaskl"));
        assertFalse(StringUtil.isAlphabet("asdasd1sdakjdlk"));
        assertFalse(StringUtil.isAlphabet(""));
        assertFalse(StringUtil.isAlphabet(null));
    }


    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#includeChar(java.lang.String, char)} ̂߂̃eXgE\bhB
     */
    public void testIncludeChar_StringChar() {
        assertTrue(StringUtil.includeChar("abcdef", 'd'));
        assertFalse(StringUtil.includeChar("abcdef", 'D'));        
        assertFalse(StringUtil.includeChar(null, 'D'));        
        assertFalse(StringUtil.includeChar("", 'D'));        
    }
    
    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#includeChar(java.lang.String, char, boolean)} ̂߂̃eXgE\bhB
     */
    public void testIncludeChar_StringCharBoolean() {
        assertTrue(StringUtil.includeChar("abcdef", 'd', true));
        assertFalse(StringUtil.includeChar("abcdef", 'D', true));                
        assertTrue(StringUtil.includeChar("abcdef", 'd', false));
        assertTrue(StringUtil.includeChar("abcdef", 'D', false));                
        assertFalse(StringUtil.includeChar("abcdef", 'l',  true));                
        assertFalse(StringUtil.includeChar("", 'l',  true));                
        assertFalse(StringUtil.includeChar(null, 'l',  true));                
    }

    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#checkFrontSpace(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testCheckFrontSpace_String() {
        assertTrue(StringUtil.checkFrontSpace(" aaaa"));
        assertFalse(StringUtil.checkFrontSpace("@aaaa"));
    }

    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#checkFrontSpace(java.lang.String, boolean)} ̂߂̃eXgE\bhB
     */
    public void testCheckFrontSpace_StringBoolean() {
        assertTrue(StringUtil.checkFrontSpace(" aaaa", true));
        assertTrue(StringUtil.checkFrontSpace("@aaaa", true));
        assertFalse(StringUtil.checkFrontSpace("abcdef", true));                
        assertTrue(StringUtil.checkFrontSpace(" aaaa", false));
        assertFalse(StringUtil.checkFrontSpace("@aaaa", false));
        assertFalse(StringUtil.checkFrontSpace("abcdef", false));                
        assertFalse(StringUtil.checkFrontSpace(null, true));
    }

    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#checkRearSpace(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testCheckRearSpace_String() {
        assertTrue(StringUtil.checkRearSpace("aaaa "));
        assertFalse(StringUtil.checkRearSpace("aaaa@"));
    }

    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#checkRearSpace(java.lang.String, boolean)} ̂߂̃eXgE\bhB
     */
    public void testCheckRearSpace_StringBoolean() {
        assertTrue(StringUtil.checkRearSpace("aaaa ", true));
        assertTrue(StringUtil.checkRearSpace("aaaa@", true));
        assertFalse(StringUtil.checkRearSpace("abcdef", true));                
        assertTrue(StringUtil.checkRearSpace("aaaa ", false));
        assertFalse(StringUtil.checkRearSpace("aaaa@", false));
        assertFalse(StringUtil.checkRearSpace("abcdef", false));                
        assertFalse(StringUtil.checkRearSpace(null, true));
    }

    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#toSingleByteChar(char)} ̂߂̃eXgE\bhB
     */
    public void testToSingleByteChar() {
        assertEquals(StringUtil.toSingleByteChar('`'), 'A');
        assertEquals(StringUtil.toSingleByteChar('a'), 'B');
        assertEquals(StringUtil.toSingleByteChar('b'), 'C');
        assertEquals(StringUtil.toSingleByteChar('c'), 'D');
        assertEquals(StringUtil.toSingleByteChar('d'), 'E');
        assertEquals(StringUtil.toSingleByteChar('e'), 'F');
        assertEquals(StringUtil.toSingleByteChar('f'), 'G');
        assertEquals(StringUtil.toSingleByteChar('g'), 'H');
        assertEquals(StringUtil.toSingleByteChar('h'), 'I');
        assertEquals(StringUtil.toSingleByteChar('i'), 'J');
        assertEquals(StringUtil.toSingleByteChar('j'), 'K');
        assertEquals(StringUtil.toSingleByteChar('k'), 'L');
        assertEquals(StringUtil.toSingleByteChar('l'), 'M');
        assertEquals(StringUtil.toSingleByteChar('m'), 'N');
        assertEquals(StringUtil.toSingleByteChar('n'), 'O');
        assertEquals(StringUtil.toSingleByteChar('o'), 'P');
        assertEquals(StringUtil.toSingleByteChar('p'), 'Q');
        assertEquals(StringUtil.toSingleByteChar('q'), 'R');
        assertEquals(StringUtil.toSingleByteChar('r'), 'S');
        assertEquals(StringUtil.toSingleByteChar('s'), 'T');
        assertEquals(StringUtil.toSingleByteChar('t'), 'U');
        assertEquals(StringUtil.toSingleByteChar('u'), 'V');
        assertEquals(StringUtil.toSingleByteChar('v'), 'W');
        assertEquals(StringUtil.toSingleByteChar('w'), 'X');
        assertEquals(StringUtil.toSingleByteChar('x'), 'Y');
        assertEquals(StringUtil.toSingleByteChar('y'), 'Z');

        assertEquals(StringUtil.toSingleByteChar(''), 'a');
        assertEquals(StringUtil.toSingleByteChar(''), 'b');
        assertEquals(StringUtil.toSingleByteChar(''), 'c');
        assertEquals(StringUtil.toSingleByteChar(''), 'd');
        assertEquals(StringUtil.toSingleByteChar(''), 'e');
        assertEquals(StringUtil.toSingleByteChar(''), 'f');
        assertEquals(StringUtil.toSingleByteChar(''), 'g');
        assertEquals(StringUtil.toSingleByteChar(''), 'h');
        assertEquals(StringUtil.toSingleByteChar(''), 'i');
        assertEquals(StringUtil.toSingleByteChar(''), 'j');
        assertEquals(StringUtil.toSingleByteChar(''), 'k');
        assertEquals(StringUtil.toSingleByteChar(''), 'l');
        assertEquals(StringUtil.toSingleByteChar(''), 'm');
        assertEquals(StringUtil.toSingleByteChar(''), 'n');
        assertEquals(StringUtil.toSingleByteChar(''), 'o');
        assertEquals(StringUtil.toSingleByteChar(''), 'p');
        assertEquals(StringUtil.toSingleByteChar(''), 'q');
        assertEquals(StringUtil.toSingleByteChar(''), 'r');
        assertEquals(StringUtil.toSingleByteChar(''), 's');
        assertEquals(StringUtil.toSingleByteChar(''), 't');
        assertEquals(StringUtil.toSingleByteChar(''), 'u');
        assertEquals(StringUtil.toSingleByteChar(''), 'v');
        assertEquals(StringUtil.toSingleByteChar(''), 'w');
        assertEquals(StringUtil.toSingleByteChar(''), 'x');
        assertEquals(StringUtil.toSingleByteChar(''), 'y');
        assertEquals(StringUtil.toSingleByteChar(''), 'z');

        assertEquals(StringUtil.toSingleByteChar('O'), '0');
        assertEquals(StringUtil.toSingleByteChar('P'), '1');
        assertEquals(StringUtil.toSingleByteChar('Q'), '2');
        assertEquals(StringUtil.toSingleByteChar('R'), '3');
        assertEquals(StringUtil.toSingleByteChar('S'), '4');
        assertEquals(StringUtil.toSingleByteChar('T'), '5');
        assertEquals(StringUtil.toSingleByteChar('U'), '6');
        assertEquals(StringUtil.toSingleByteChar('V'), '7');
        assertEquals(StringUtil.toSingleByteChar('W'), '8');
        assertEquals(StringUtil.toSingleByteChar('X'), '9');

        assertEquals(StringUtil.toSingleByteChar('|'), '-');

        try {
            StringUtil.toSingleByteChar('F');
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#toSingleByteString(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testToSingleByteString() {
        assertEquals(StringUtil.toSingleByteString("`aCc"), "ABCD");
        try {
            StringUtil.toSingleByteString("``");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            StringUtil.toSingleByteString("");
            fail();
        } catch (IllegalArgumentException e) {
        }
        try {
            StringUtil.toSingleByteString(null);
            fail();
        } catch (NullPointerException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#toUnicodeHexMultiByte(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testToUnicodeHexMultiByte() {
        assertEquals(StringUtil.toUnicodeHexMultiByte("``AA"), "\\uff21\\uff21AA");
        assertEquals(StringUtil.toUnicodeHexMultiByte("````"), "\\uff21\\uff21\\uff21\\uff21");
        assertEquals(StringUtil.toUnicodeHexMultiByte("AAAA"), "AAAA");
        assertEquals(StringUtil.toUnicodeHexMultiByte(""), "");
        assertNull(StringUtil.toUnicodeHexMultiByte(null));                
    }

    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#toUnicodeHex(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testToUnicodeHex() {
        assertEquals(StringUtil.toUnicodeHex("``AA"), "\\uff21\\uff21\\u0041\\u0041");
    }

    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#toUnicodeString(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testToUnicodeString() {
        assertEquals(StringUtil.toUnicodeString("\\uff21\\uff21\\u0041\\u0041"), "``AA");
        assertEquals(StringUtil.toUnicodeString("\\uff21\\uff21\\u0041\\u004"), "``A\\u004");
        assertEquals(StringUtil.toUnicodeString("\\uff21\\uff21\\u004\\u0041"), "``\\u004A");
        assertEquals(StringUtil.toUnicodeString("\\uff21\\uff21\\uuuuuuuuu0041\\u0041"), "``AA");
        assertEquals(StringUtil.toUnicodeString(""), "");        
        assertNull(StringUtil.toUnicodeString(null));        
    }

    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#csvSplit(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testCsvSplit_StringString() {
        String[] array = StringUtil.csvSplit("123,456,789", ",");
        String[] array2 = new String[] { "123", "456", "789" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }

        array = StringUtil.csvSplit("", ",");
        array2 = new String[] { "" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }
        
        array = StringUtil.csvSplit("\"123,456\",789", ",");
        array2 = new String[] { "123,456", "789" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }
    
        array = StringUtil.csvSplit("\"12\"\"3\"\",456\",789", ",");
        array2 = new String[]{"12\"3\",456","789"};
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }
        
        array = StringUtil.csvSplit("\"\",", ",");
        array2 = new String[] { "\"", "" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }

        array = StringUtil.csvSplit(null, ",");
        assertNull(array);
        
        array = StringUtil.csvSplit("\"\"", ",");
        array2 = new String[] { "\"" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }

        array = StringUtil.csvSplit("\"123,456,789", ",");
        array2 = new String[] { "123,456,789" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }
        
        array = StringUtil.csvSplit("123,\"456,789\"", ",");
        array2 = new String[] { "123","456,789" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }

        array = StringUtil.csvSplit("123,\"456,789", ",");
        array2 = new String[] { "123","456,789" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }

    }

    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#csvSplit(java.lang.String, java.lang.String, char)} ̂߂̃eXgE\bhB
     */
    public void testCsvSplit_StringStringChar() {
        String[] array = StringUtil.csvSplit("123,456,789", ",", '\'');
        String[] array2 = new String[] { "123", "456", "789" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }

        array = StringUtil.csvSplit("", ",", '\'');
        array2 = new String[] { "" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }
        
        array = StringUtil.csvSplit("\'123,456\',789", ",", '\'');
        array2 = new String[] { "123,456", "789" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }
    
        array = StringUtil.csvSplit("\'12\'\'3\'\',456\',789", ",", '\'');
        array2 = new String[]{"12\'3\',456","789"};
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }
        
        array = StringUtil.csvSplit("\'\',", ",", '\'');
        array2 = new String[] { "\'", "" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }

        array = StringUtil.csvSplit(null, ",", '\'');
        assertNull(array);
        
        array = StringUtil.csvSplit("\'\'", ",", '\'');
        array2 = new String[] { "\'" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }

        array = StringUtil.csvSplit("\'123,456,789", ",", '\'');
        array2 = new String[] { "123,456,789" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }
        
        array = StringUtil.csvSplit("123,\'456,789\'", ",", '\'');
        array2 = new String[] { "123","456,789" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }

        array = StringUtil.csvSplit("123,\'456,789", ",", '\'');
        array2 = new String[] { "123","456,789" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#split(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSplit() {

        String[] array = StringUtil.split("12*34*56", "*");
        String[] array2 = new String[] { "12","34","56" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }

        array = StringUtil.split("12**34**56", "**");
        array2 = new String[] { "12","34","56" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }

        array = StringUtil.split("", "delim");
        array2 = new String[] { "" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }

        array = StringUtil.split("delim", "delim");
        array2 = new String[] { "" };
        for (int i = 0; i < array.length; i++) {
            assertEquals(array[i], array2[i]);
        }

        try {
            StringUtil.split(null, "delim");
            fail();
        } catch (NullPointerException e) {
        }

        try {
            StringUtil.split("moji", null);
            fail();
        } catch (NullPointerException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#toBinaryString(int)} ̂߂̃eXgE\bhB
     */
    public void testToBinaryString() {
        assertEquals("00000000000000000000000000001010", StringUtil.toBinaryString(10));
        assertEquals("00000000000000000000000000001011", StringUtil.toBinaryString(11));
        assertEquals("11111111111111111111111111111111", StringUtil.toBinaryString(-1));
    }
    
    /**
     * {@link jp.hrtdotnet.java.util.StringUtil#completeZero(int, int)} ̂߂̃eXgE\bhB
     */
    public void testCompleteZero() {
        assertEquals("00012345", StringUtil.completeZero(12345, 8));

        try {
            StringUtil.completeZero(12345, -8);
            fail();
        } catch (IllegalArgumentException e) {            
        }
    }

}
