/*
 * Operation.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

/**
 * NXIuWFNg̑܂B
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class Operation {

    /** CqɎgȂlłB */
    public static final int UNDEFINED         = 0x00000000;
    /** public Cq\ int lłB */
    public static final int PUBLIC           = 0x00000001;
    /** private Cq\ int lłB */
    public static final int PRIVATE          = 0x00000002;
    /** protected Cq\ int lłB */
    public static final int PROTECTED        = 0x00000004;
    /** static Cq\ int lłB */
    public static final int STATIC           = 0x00000008;
    /** final Cq\ int lłB */
    public static final int FINAL            = 0x00000010;
    /** synchronized Cq\ int lłB */
    public static final int SYNCHRONIZED     = 0x00000020;
    /** volatile Cq\ int lłB */
    public static final int VOLATILE         = 0x00000040;
    /** transient Cq\ int lłB */
    public static final int TRANSIENT        = 0x0000008;
    /** native Cq\ int lłB */
    public static final int NATIVE           = 0x00000100;
    /** interface Cq\ int lłB */
    public static final int INTERFACE        = 0x00000200;
    /** abstract Cq\ int lłB */
    public static final int ABSTRACT         = 0x00000400;
    /** strictfp Cq\ int lłB */
    public static final int STRICT           = 0x00000800;

    
    
    /**
     * w肵NX̃IuWFNg𐶐܂B
     * 
     * @param classPath NXpX
     * @param parameterTypes RXgN^̌^̃NXz
     * @param initargs RXgN^̃IuWFNgz
     * @return IuWFNg
     * @throws IllegalArgumentException
     *          RXgN^ɗ^IuWFNg̈sȏꍇ
     * @throws InstantiationException
     *          RXgN^abstractłꍇ
     * @throws IllegalAccessException
     *          CqȂǂ̎wŃANZX̂߃RXgN^ɃANZXłȂꍇ
     * @throws InvocationTargetException
     *          RXgN^OX[ꍇ
     * @throws SecurityException
     *          ւ̃ANZXۂꂽꍇ
     * @throws NoSuchMethodException
     *          vRXgN^ꍇ
     * @throws ClassNotFoundException
     *          NX݂Ȃꍇ
     * @since 2.0
     */
    public static Object newInstance(String classPath, Class[] parameterTypes, Object[] initargs)
        throws IllegalArgumentException, InstantiationException, IllegalAccessException,
                InvocationTargetException, SecurityException, NoSuchMethodException,
                ClassNotFoundException {
        Class c = Class.forName(classPath);
        Constructor constructor = c.getConstructor(parameterTypes);
        return constructor.newInstance(initargs);
    }

    /**
     * w肵NX̃IuWFNg𐶐܂B
     * ̃\bhŃIuWFNg쐬ꍇ͗OX[܂B
     * 
     * @param classPath NXpX
     * @param parameterTypes RXgN^̌^̃NXz
     * @param initargs RXgN^̈ɗ^IuWFNgz
     * @return IuWFNg
     * @since 2.0
     */
    public static Object newInstanceIgnoreError(String classPath, Class[] parameterTypes, Object[] initargs) {        
        Object o = null;
        try {
            o = newInstance(classPath, parameterTypes, initargs);
        } catch (Throwable e) {
        }
        return o;
    }

    /**
     * w肵\bhs܂B
     * 
     * @param methodName \bh̖O
     * @param argTypes \bḧ̌^̃NXz
     * @param obj \bhsIuWFNg
     * @param args \bḧɗ^IuWFNgz
     * @return s\bh̖߂l
     * @throws SecurityException
     *          ւ̃ANZXۂꂽꍇ
     * @throws NoSuchMethodException
     *          \bhȂꍇ
     * @throws IllegalArgumentException
     *          \bḧƂĕsȏꍇ
     * @throws IllegalAccessException
     *          CqȂǂŃ\bhɃANZXłȂꍇ
     * @throws InvocationTargetException
     *          \bhOX[ꍇ
     * @since 2.0
     */
    public static Object invokeMethod (String methodName, Class[] argTypes, Object obj, Object[] args)
        throws SecurityException, NoSuchMethodException, IllegalArgumentException,
            IllegalAccessException, InvocationTargetException {
        return invoke(obj.getClass(), methodName, argTypes, obj, args);
    }

    /**
     * static\bhs܂B
     * 
     * @param classPath NXpX
     * @param methodName \bh̖O
     * @param argTypes \bḧ̌^̃NXz
     * @param args \bḧɗ^IuWFNgz
     * @return s\bh̖߂l
     * @throws SecurityException
     *          ւ̃ANZXۂꂽꍇ
     * @throws NoSuchMethodException
     *          \bhȂꍇ
     * @throws IllegalArgumentException
     *          \bḧƂĕsȏꍇ
     * @throws IllegalAccessException
     *          CqȂǂŃ\bhɃANZXłȂꍇ
     * @throws InvocationTargetException
     *          \bhOX[ꍇ
     * @throws ClassNotFoundException
     *          NX݂Ȃꍇ
     *          
     * @since 2.0
     */
    public static Object invokeStaticMethod(String classPath, String methodName, Class[] argTypes, Object[] args)
        throws SecurityException, NoSuchMethodException, IllegalArgumentException,
            IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class c = Class.forName(classPath);
        return invoke(c, methodName, argTypes, null, args);
    }
    
    /**
     * static\bhs܂B
     * 
     * @param c NX
     * @param methodName \bh̖O
     * @param argTypes \bḧ̌^̃NXz
     * @param args \bḧɗ^IuWFNgz
     * @return s\bh̖߂l
     * @throws SecurityException
     *          ւ̃ANZXۂꂽꍇ
     * @throws NoSuchMethodException
     *          \bhȂꍇ
     * @throws IllegalArgumentException
     *          \bḧƂĕsȏꍇ
     * @throws IllegalAccessException
     *          CqȂǂŃ\bhɃANZXłȂꍇ
     * @throws InvocationTargetException
     *          \bhOX[ꍇ
     * @since 2.0
     */
    public static Object invokeStaticMethod(Class c, String methodName, Class[] argTypes, Object[] args)
        throws SecurityException, NoSuchMethodException, IllegalArgumentException,
            IllegalAccessException, InvocationTargetException {
        return invoke(c, methodName, argTypes, null, args);
    }
    
    
    
    /**
     * w肵񂩂n܂ public \bhAĎs܂B
     * static, CX^X\bhƂɎs܂B
     * Ώۃ\bhsɔO͖ꎟ̃\bh̎sɈڂ܂B
     * <br>
     * Ȃs郁\bh̃IuWFNg͈RXgN^琶ꂽ
     * IuWFNgɌ܂B
     * 
     * @param cls s郁\bh̃NX
     *         w肳ꂽNẌȂRXgN^̃IuWFNgB
     * @param startStr s郁\bh̑O
     * 
     * @throws NoSuchMethodException nullRXgN^݂Ȃꍇ
     * @throws SecurityException ZLeB}l[WLƂȂĂCX^X̐s\bh̎擾ۂꂽꍇ
     * @throws InvocationTargetException s\bhOX[ꍇ
     * @throws IllegalAccessException clsɎw肵NXA܂͂nullRXgN^ɃANZXłȂA
     *                                  ܂̗RŎs\bhɃANZXłȂꍇ
     * @throws InstantiationException CX^X̐Ɏsꍇ
     * @throws IllegalArgumentException startStr󕶎ȂǕsȏꍇ
     * @throws NullPointerException clsAstartStrnull̏ꍇ
     * 
     * @since 2.0
     */
    public static void invokeMethodRun(Class cls, String startStr)
        throws SecurityException, IllegalArgumentException, NoSuchMethodException,
            InstantiationException, IllegalAccessException, InvocationTargetException, NullPointerException {
        invokeMethodRun(cls, startStr, null, null, UNDEFINED);
    }

    /**
     * w肵񂩂n܂public\bhAĎs܂B
     * static,CX^X\bhƂɎs܂B
     * Ώۃ\bhsɔO͖ꎟ̃\bh̎sɈڂ܂B
     * <br>
     * s郁\bh̃IuWFNg͈RXgN^琶ꂽIuWFNgɌ܂B
     * <br><br>
     * \bhsOɎs郁\bhwł܂B
     * Õ\bh͎s\bhstaticłstatic̃\bhA
     * CX^Xł΃CX^X̃\bhs܂B
     * <br>
     * ȂOɎs郁\bh͈̃\bhɌ܂B
     * 
     * @param cls s郁\bh̃NX
     * @param startStr s郁\bh̑O
     * @param setUpStr \bhsOɎs\bh̖O
     * @param tearDownStr \bhsɎs郁\bh̖O
     * 
     * @throws NoSuchMethodException nullRXgN^݂Ȃꍇ
     * @throws SecurityException ZLeB}l[WLƂȂĂCX^X̐s\bh̎擾ۂꂽꍇ
     * @throws InvocationTargetException s\bhOX[ꍇ
     * @throws IllegalAccessException clsɎw肵NXA܂͂nullRXgN^ɃANZXłȂA
     *                                  ܂̗RŎs\bhɃANZXłȂꍇ
     * @throws InstantiationException CX^X̐Ɏsꍇ
     * @throws IllegalArgumentException startStr󕶎ȂǕsȏꍇ
     * @throws NullPointerException clsAstartStrnull̏ꍇ
     * 
     * @since 2.0
     */

    public static void invokeMethodRun(Class cls, String startStr, String setUpStr, String tearDownStr)
        throws SecurityException, IllegalArgumentException, NoSuchMethodException,
                InstantiationException, IllegalAccessException, InvocationTargetException, NullPointerException {
        invokeMethodRun(cls, startStr, setUpStr, tearDownStr, UNDEFINED);
    }
    

    /**
     * w肵񂩂n܂public\bhAĎs܂B
     * static,CX^X\bhƂɎs܂B
     * Ώۃ\bhsɔO͖ꎟ̃\bh̎sɈڂ܂B
     * <br>
     * s郁\bh̃IuWFNg͈RXgN^琶ꂽIuWFNgɌ܂B
     * <br><br>
     * \bhsOɎs郁\bhs郁\bh̏Cqwł܂B
     * Õ\bh͎s\bhstaticłstatic̃\bhA
     * CX^Xł΃CX^X̃\bhs܂B
     * <br>
     * ȂOɎs郁\bh͈̃\bhɌ܂B
     * Cqw肵ꍇAw肳ꂽCq܂ރ\bĥ݂s܂B
     * Cq\萔͓NXɗpӂĂȉ̒ʂłB
     * <ul>
     * <li>UNDEFINED : Cqw肵܂B</li>
     * <li>PUBLIC : public Cq\܂B</li>
     * <li>PRIVATE : privateCq\܂B</li>
     * <li>PROTECTED : protected Cq\܂B</li>
     * <li>STATIC : static Cq\܂B</li>
     * <li>FINAL : final Cq\܂B</li>
     * <li>SYNCHRONIZED : synchronized Cq\܂B</li>
     * <li>VOLATILE : volatile Cq\܂B</li>
     * <li>TRANSIENT : transient Cq\܂B</li>
     * <li>NATIVE : native Cq\܂B</li>
     * <li>INTERFACE : interface Cq\܂B</li>
     * <li>ABSTRACT : abstract Cq\܂B</li>
     * <li>STRICT : strictfp Cq\܂B</li>
     * </ul>
     * 
     * @param cls s郁\bh̃NX
     * @param startStr s郁\bh̑OB
     * @param setUpStr \bhsOɎs\bh̖O
     * @param tearDownStr \bhsɎs郁\bh̖O
     * @param isMod s郁\bh̏Cq
     * 
     * @throws NoSuchMethodException nullRXgN^݂Ȃꍇ
     * @throws SecurityException ZLeB}l[WLƂȂĂCX^X̐s\bh̎擾ۂꂽꍇ
     * @throws InvocationTargetException s\bhOX[ꍇ
     * @throws IllegalAccessException clsɎw肵NXA܂͂nullRXgN^ɃANZXłȂA
     *                                  ܂̗RŎs\bhɃANZXłȂꍇ
     * @throws InstantiationException CX^X̐Ɏsꍇ
     * @throws IllegalArgumentException startStr󕶎ȂǕsȏꍇ
     * @throws NullPointerException clsAstartStrnull̏ꍇ
     * 
     * @since 2.0
     */
    public static void invokeMethodRun(Class cls, String startStr, String setUpStr, String tearDownStr, int isMod)
        throws SecurityException, NoSuchMethodException, IllegalArgumentException,
                InstantiationException, IllegalAccessException, InvocationTargetException, NullPointerException {

        if (cls == null) {
            throw new NullPointerException("Class-object is null.");
        }
        
        // Object 
        Constructor constructor = cls.getConstructor(new Class[] {});
        Object obj = constructor.newInstance(new Object[] {});

        invokeAllPublicMethodRun(cls, obj, startStr, setUpStr, tearDownStr, isMod, UNDEFINED);
    }


    /**
     * w肵񂩂n܂publicCX^X\bhAĎs܂B
     * static\bh͎s܂B
     * Ώۃ\bhsɔO͖ꎟ̃\bh̎sɈڂ܂B
     * 
     * @param obj s郁\bh̃IuWFNg
     * @param startStr s郁\bh̑O
     * 
     * @throws InvocationTargetException s\bhOX[ꍇ
     * @throws IllegalAccessException ̗RŎs\bhɃANZXłȂꍇ
     * @throws IllegalArgumentException startStr󕶎ȂǕsȏꍇ
     * @throws NullPointerException objAstartStrnullłꍇ
     * 
     * @since 2.0
     */
    public static void invokeMethodRun(Object obj, String startStr)
        throws IllegalArgumentException, NullPointerException, IllegalAccessException,
                InvocationTargetException {
        invokeMethodRun(obj, startStr, null, null, UNDEFINED);
    }
    
    
    /**
     * w肵񂩂n܂publicCX^X\bhAĎs܂B
     * static\bh͎s܂B
     * Ώۃ\bhsɔO͖ꎟ̃\bh̎sɈڂ܂B
     * <br><br>
     * \bhsOɎs郁\bhwł܂B
     * Õ\bhstatic\bh̏ꍇ͎s܂B
     * <br>
     * ȂOɎs郁\bh͈̃\bhɌ܂B
     * 
     * @param obj s郁\bh̃IuWFNg
     * @param startStr s郁\bh̑O
     * @param setUpStr \bhsOɎs\bh̖O
     * @param tearDownStr \bhsɎs郁\bh̖O
     * 
     * @throws InvocationTargetException s\bhOX[ꍇ
     * @throws IllegalAccessException ̗RŎs\bhɃANZXłȂꍇ
     * @throws IllegalArgumentException startStr󕶎ȂǕsȏꍇ
     * @throws NullPointerException objAstartStrnullłꍇ
     * 
     * @since 2.0
     */
    public static void invokeMethodRun(Object obj, String startStr, String setUpStr, String tearDownStr)
        throws IllegalArgumentException, NullPointerException, IllegalAccessException, InvocationTargetException
    {
        invokeMethodRun(obj, startStr, setUpStr, tearDownStr, UNDEFINED);
    }    

    /**
     * w肵񂩂n܂publicCX^X\bhAĎs܂B
     * static\bh͎s܂B
     * Ώۃ\bhsɔO͖ꎟ̃\bh̎sɈڂ܂B
     * <br><br>
     * \bhsOɎs郁\bhs郁\bh̏Cqwł܂B
     * Õ\bhstatic\bh̏ꍇ͎s܂B
     * <br>
     * ȂOɎs郁\bh͈̃\bhɌ܂B
     * <br><br>
     * Cqw肵ꍇAw肳ꂽCq܂ރ\bĥ݂s܂B
     * Cq\萔͓NXɗpӂĂȉ̒ʂłB
     * <ul>
     * <li>UNDEFINED : Cqw肵܂B</li>
     * <li>PUBLIC : public Cq\܂B</li>
     * <li>PRIVATE : privateCq\܂B</li>
     * <li>PROTECTED : protected Cq\܂B</li>
     * <li>STATIC : static Cq\܂B</li>
     * <li>FINAL : final Cq\܂B</li>
     * <li>SYNCHRONIZED : synchronized Cq\܂B</li>
     * <li>VOLATILE : volatile Cq\܂B</li>
     * <li>TRANSIENT : transient Cq\܂B</li>
     * <li>NATIVE : native Cq\܂B</li>
     * <li>INTERFACE : interface Cq\܂B</li>
     * <li>ABSTRACT : abstract Cq\܂B</li>
     * <li>STRICT : strictfp Cq\܂B</li>
     * </ul>
     * 
     * @param obj s郁\bh̃IuWFNg
     * @param startStr s郁\bh̑O
     * @param setUpStr \bhsOɎs\bh̖O
     * @param tearDownStr \bhsɎs郁\bh̖O
     * @param isMod s郁\bh̏Cq
     * 
     * @throws InvocationTargetException s\bhOX[ꍇ
     * @throws IllegalAccessException ̗RŎs\bhɃANZXłȂꍇ
     * @throws IllegalArgumentException startStr󕶎ȂǕsȏꍇ
     * @throws NullPointerException objAstartStrnullłꍇ
     * 
     * @since 2.0
     */
    public static void invokeMethodRun(Object obj, String startStr, String setUpStr, String tearDownStr, int isMod) throws IllegalArgumentException, NullPointerException, IllegalAccessException, InvocationTargetException
    {
        if (obj == null) {
            throw new NullPointerException("Object-object is null.");
        }

        Class cls = obj.getClass();
        invokeAllPublicMethodRun(cls, obj, startStr, setUpStr, tearDownStr, isMod, STATIC);

    }
    
    
    /**
     * w肵񂩂n܂public static\bhAĎs܂B
     * CX^X\bh͎s܂B
     * Ώۃ\bhsɔO͖ꎟ̃\bh̎sɈڂ܂B
     * 
     * @param cls s郁\bh̃NX
     * @param startStr s郁\bh̑O
     * 
     * @throws InvocationTargetException s\bhOX[ꍇ
     * @throws IllegalAccessException ̗RŎs\bhɃANZXłȂꍇ
     * @throws IllegalArgumentException startStr󕶎ȂǕsȏꍇ
     * @throws NullPointerException clsAstartStrnullłꍇ
     * 
     * @since 2.0
     */
    public static void invokeStaticMethodRun(Class cls, String startStr)
        throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NullPointerException {
        invokeStaticMethodRun(cls, startStr, null, null, 0);
    }

    
    /**
     * w肵񂩂n܂ public static \bhAĎs܂B
     * CX^X\bh͎s܂B
     * Ώۃ\bhsɔO͖ꎟ̃\bh̎sɈڂ܂B
     * <br><br>
     * \bhsOɎs郁\bhwł܂B
     * Õ\bhCX^X\bh̏ꍇ͎s܂B
     * <br>
     * ȂOɎs郁\bh͈̃\bhɌ܂B
     * 
     * @param cls s郁\bh̃NX
     * @param startStr s郁\bh̑O
     * @param setUpStr \bhsOɎs\bh̖O
     * @param tearDownStr \bhsɎs郁\bh̖O
     * 
     * @throws InvocationTargetException s\bhOX[ꍇ
     * @throws IllegalAccessException ̗RŎs\bhɃANZXłȂꍇ
     * @throws IllegalArgumentException startStr󕶎ȂǕsȏꍇ
     * @throws NullPointerException clsAstartStrnullłꍇ
     * 
     * @since 2.0
     */
    public static void invokeStaticMethodRun(Class cls, String startStr, String setUpStr, String tearDownStr) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException
    {
        invokeStaticMethodRun(cls, startStr, null, null, 0);
    }

    
    /**
     * w肵񂩂n܂public static\bhAĎs܂B
     * CX^X\bh͎s܂B
     * Ώۃ\bhsɔO͖ꎟ̃\bh̎sɈڂ܂B
     * <br><br>
     * \bhsOɎs郁\bhs郁\bh̏Cqwł܂B
     * Õ\bhCX^X\bh̏ꍇ͎s܂B
     * <br><br>
     * Cqw肵ꍇAw肳ꂽCq܂ރ\bĥ݂s܂B
     * Cq\萔͓NXɗpӂĂȉ̒ʂłB
     * <ul>
     * <li>UNDEFINED : Cqw肵܂B</li>
     * <li>PUBLIC : public Cq\܂B</li>
     * <li>PRIVATE : privateCq\܂B</li>
     * <li>PROTECTED : protected Cq\܂B</li>
     * <li>STATIC : static Cq\܂B</li>
     * <li>FINAL : final Cq\܂B</li>
     * <li>SYNCHRONIZED : synchronized Cq\܂B</li>
     * <li>VOLATILE : volatile Cq\܂B</li>
     * <li>TRANSIENT : transient Cq\܂B</li>
     * <li>NATIVE : native Cq\܂B</li>
     * <li>INTERFACE : interface Cq\܂B</li>
     * <li>ABSTRACT : abstract Cq\܂B</li>
     * <li>STRICT : strictfp Cq\܂B</li>
     * </ul>
     * 
     * @param cls s郁\bh̃NX
     * @param startStr s郁\bh̑O
     * @param setUpStr \bhsOɎs\bh̖O
     * @param tearDownStr \bhsɎs郁\bh̖O
     * @param isMod s郁\bh̏Cq
     * 
     * @throws InvocationTargetException s\bhOX[ꍇ
     * @throws IllegalAccessException ̗RŎs\bhɃANZXłȂꍇ
     * @throws IllegalArgumentException startStr󕶎ȂǕsȏꍇ
     * @throws NullPointerException clsAstartStrnullłꍇ
     * @since 2.0
     */
    public static void invokeStaticMethodRun(Class cls, String startStr, String setUpStr, String tearDownStr, int isMod) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (cls == null) {
            throw new NullPointerException("Class-object is null.");
        }
        invokeAllPublicMethodRun(cls, null, startStr, setUpStr, tearDownStr, STATIC, UNDEFINED);
    }

    
    /**
     * w肵IuWFNg̃g[X܂B
     * 
     * @param out o͐
     * @param o g[XIuWFNg
     * @since 1.0
     */
    public static void variableTrace(PrintStream out, Object o) {
        if (out == null) {
            throw new NullPointerException("PrintStream is null.");
        }
        
        if (o == null) {
            out.println("object is null.");
        }
        String[] array = getVariables(o);
        
        if (array.length == 0) {
            out.println(o.getClass().getName() + " have not a variable.");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; i++) {
            sb.append(array[i] + ", ");
        }
        out.println(sb.toString());
        out.flush();
    }

    /**
     * w肵IuWFNg̃g[X܂B
     * 
     * @param out o͐
     * @param o g[XIuWFNg
     * @since 1.0
     */
    public static void variableTrace(PrintWriter out, Object o) {        
        if (out == null) {
            throw new NullPointerException("PrintWriter is null.");
        }
        
        if (o == null) {
            out.println("object is null.");
        }
        String[] array = getVariables(o);
        
        if (array.length == 0) {
            out.println(o.getClass().getName() + " have not a variable.");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; i++) {
            sb.append(array[i] + ", ");
        }
        out.println(sb.toString());
        out.flush();
    }

    /**
     * w肵Cq܂܂Ă邩𔻒肵܂B
     * ʒlJava 1.4.2_11łMethodNXŒ`Ă̂ƓlłANXł`Ă܂B
     * 
     * @param mod Ώۂ̃NX⃁oiϐE\bhj̏Cq
     * @param isMod ܂܂邩肷Cq̎ʒl
     * @return Cq܂܂ĂꍇtrueA܂܂ĂȂꍇfalse
     * @since 2.0
     */
    public static boolean isModifier(int mod, int isMod) {
        
        if ((isMod & PUBLIC) != 0) {
            if (!Modifier.isPublic(mod)) {
                return false;
            }
        }

        if ((isMod & PROTECTED) != 0) {
            if (!Modifier.isProtected(mod)) {
                return false;
            }
        }

        if ((isMod & PRIVATE) != 0) {
            if (!Modifier.isPrivate(mod)) {
                return false;
            }
        }

        if ((isMod & ABSTRACT) != 0) {
            if (!Modifier.isAbstract(mod)) {
                return false;
            }
        }

        if ((isMod & STATIC) != 0) {
            if (!Modifier.isStatic(mod)) {
                return false;
            }
        }

        if ((isMod & FINAL) != 0) {
            if (!Modifier.isFinal(mod)) {
                return false;
            }
        }

        if ((isMod & TRANSIENT) != 0) {
            if (!Modifier.isTransient(mod)) {
                return false;
            }
        }

        if ((isMod & VOLATILE) != 0) {
            if (!Modifier.isVolatile(mod)) {
                return false;
            }
        }

        if ((isMod & SYNCHRONIZED) != 0) {
            if (!Modifier.isSynchronized(mod)) {
                return false;
            }
        }

        if ((isMod & NATIVE) != 0) {
            if (!Modifier.isNative(mod)) {
                return false;
            }
        }

        if ((isMod & STRICT) != 0) {
            if (!Modifier.isStrict(mod)) {
                return false;
            }
        }

        if ((isMod & INTERFACE) != 0) {
            if (!Modifier.isInterface(mod)) {
                return false;
            }
        }
        
        return true;
    }


    /**
     * w肵\bhs܂B
     * @param c
     * @param methodName
     * @param argTypes
     * @param obj
     * @param args
     * @return
     * @throws SecurityException
     * @throws NoSuchMethodException
     * @throws IllegalArgumentException
     * @throws IllegalAccessException
     * @throws InvocationTargetException
     */
    private static Object invoke(Class c, String methodName, Class[] argTypes, Object obj, Object[] args)
            throws SecurityException, NoSuchMethodException, IllegalArgumentException,
            IllegalAccessException, InvocationTargetException
    {
        Method m = c.getMethod(methodName, argTypes);
        return m.invoke(obj, args);
    }


    /**
     * w肵NX̑SĂpublic\bhs܂B
     * @param cls
     * @param obj
     * @param startStr
     * @param setUpStr
     * @param tearDownStr
     * @param isMod
     * @param unMod
     * @throws InvocationTargetException 
     * @throws IllegalAccessException 
     * @throws IllegalArgumentException 
     * @throws NullPointerException
     */
    private static void invokeAllPublicMethodRun(Class cls, Object obj, String startStr,
            String setUpStr, String tearDownStr, int isMod, int unMod)
        throws IllegalArgumentException, IllegalAccessException, InvocationTargetException,
                NullPointerException {

        if (startStr == null) {
            throw new NullPointerException("Start-string is null.");
        } else if (startStr.length() == 0) {            
            throw new IllegalArgumentException("Start-string is empty.");
        }

        Method setUp = null;
        if (setUpStr != null && setUpStr.length() != 0) {
            try {
                setUp = cls.getMethod(setUpStr, null);
            } catch (Exception e) {
                setUp = null;
            }
        }

        Method tearDown = null;
        if (tearDownStr != null && tearDownStr.length() != 0) {
            try {
                tearDown = cls.getMethod(tearDownStr, null);
            } catch (Exception e) {
                tearDown = null;
            }
        }

        // Method s
        Method[] m = cls.getMethods();
        for (int i = 0; i < m.length; i++) {
            if (m[i].getName().startsWith(startStr)) {
                int mod = m[i].getModifiers();
                if (isMod != UNDEFINED) {
                    if (!isModifier(mod, isMod)) {
                        continue;
                    }
                }
                
                if (unMod != UNDEFINED) {
                    if (isModifier(mod, unMod)) {
                        continue;
                    }
                }
                
                if (m[i].getParameterTypes().length == 0) {
                    if (setUp != null) {
                        if (eqaulsModifier(mod, setUp.getModifiers())) {
                            setUp.invoke(obj, null);
                        }
                    }

                    try {
                        m[i].invoke(obj, null);
                    } catch (Exception e) {
                        // \bhss͖
                    }

                    if (tearDown != null) {
                        if (eqaulsModifier(mod, tearDown.getModifiers())) {
                            tearDown.invoke(obj, null);
                        }
                    }
                }
            }
        }
    }
    
    private static String[] getVariables(Object obj) {
        Class cls = obj.getClass();
        Field[] fields = cls.getFields();
        List l = new ArrayList();
        for (int i = 0; i < fields.length; i++) {
            try {
                l.add(fields[i].getName() + "=" + fields[i].get(obj));
            } catch (IllegalArgumentException e) {
                // g[XpȂ̂Ŗ
            } catch (IllegalAccessException e) {
                // g[XpȂ̂Ŗ
            }
        }
        return (String[])l.toArray(new String[0]);
    }

    private static boolean eqaulsModifier(int mod, int mod2) {
        if (Modifier.isStatic(mod)) {
            if (Modifier.isStatic(mod)) {
                return true;
            }
        } else {
            if (!Modifier.isStatic(mod)) {
                return true;
            }            
        }
        return false;
    }

}
