/*
 * HProperties.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

import jp.hrtdotnet.java.io.HDirectory;
import jp.hrtdotnet.java.io.HFile;

/**
 * PropertiesNXgvpeBNXłB
 * ̃NXł̓vpeBLinkedHashMap𗘗p邱Ƃœo^Ԃێ܂B
 * <br><br>
 * gꂽ@\͈ȉ̒ʂłB
 * <ul>
 * <li>LinkedHashMapŊǗ</li>
 * <li>vpeB̃t@Co͂ŒǋL</li>
 * </ul>
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class HProperties extends Properties {

    private static final long serialVersionUID = 8613893331398624211L;
    protected Map map = Collections.synchronizedMap(new LinkedHashMap());

    /**
     * RXgN^B
     * @since 2.0
     */
    public HProperties() {
        this(null);
    }

    /**
     * RXgN^B
     * @param prop ̃vpeBIuWFNg
     * @since 2.0
     */
    public HProperties(HProperties prop) {
        super();
        if (prop != null) {
            Enumeration e = prop.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.setProperty(key, prop.getProperty(key));
            }
        }
    }

    /**
     * vpeBڂ̃L[ƒlo^܂B
     * @param key L[
     * @param value IuWFNg
     * @return o^ꂽIuWFNg
     * @since 2.0
     */
    public synchronized Object setProperty(String key, String value) {
        return put(key, value);
    }

    /**
     * @deprecated OgĂ͂Ȃ܂B
     * {@link #setProperty(String, String) setProperty(String, String)} 𗘗pĂB
     * @since 2.0
     */
    public synchronized Object put(Object key, Object value){
        return map.put(key, value);
    }
    

    /**
     * @deprecated OgĂ͂Ȃ܂B
     * {@link #propertyNames() propertyNames()} 𗘗pĂB
     * @since 2.0
     */
    public synchronized Enumeration keys(){
        return Collections.enumeration(map.keySet());
    }

    /**
     * <p>
     * vpeBڂƂēo^ĂL[̗񋓑̂擾܂B
     * </p>
     * @return L[̗񋓑
     * @since 2.0
     */
    public synchronized Enumeration propertyNames(){
        return keys();
    }

    /**
     * L[Ƀ}bvĂvpeBl擾܂B
     * 
     * @param key L[
     * @return L[Ƀ}bvĂvpeBl
     * @since 2.0
     */
    public String getProperty(String key) {
        return (String)get(key);
    }

    /**
     * L[Ƀ}bvĂvpeBl擾܂B
     * w肵L[ɑΉvpeBlo^ĂȂꍇ͎w肵ftHgԂ܂B

     * @param key L[
     * @param defaultValue ftHg
     * @return L[Ƀ}bvĂvpeBl
     * @since 2.0
     */
    public String getProperty(String key, String defaultValue) {
        String value = getProperty(key);
        if(value == null) return defaultValue;
        return value;
    }
    
    /**
     * @deprecated OgĂ͂Ȃ܂B
     * {@link #getProperty(String) getProperty(String)} 𗘗pĂB
     *          
     * @since 2.0
     */
    public Object get(Object key){
        return map.get(key);
    }

    
    /**
     * vpeBt@Cɏo͂܂B
     * w肵vpeBt@Cłɑ݂ĂāA
     * vpeB񂪐ݒ肳Ăꍇ͂̏̓}[W܂B
     * vpeBt@C̃L[Ɠ̃L[̃vpeB񂪃IuWFNg
     * o^Ăꍇ̓IuWFNg̃vpeBŏ㏑܂B
     * 
     * @param filePath vpeBt@CpX
     * @param header wb_
     * @throws NullPointerException
     *          filePathnull̏ꍇ
     * @throws FileNotFoundException
     *          t@C݂ĂȂꍇ
     * @throws IOException
     *          vpeBt@Cɏ߂Ȃꍇ
     * @throws ClassCastException
     *          PropertiesIuWFNgɁAStringł͂ȂL[܂͒li[Ăꍇ 
     *          
     * @since 2.0
     */
    public void store(String filePath, String header) throws IOException {
        store(filePath, header, true);
    }
    
    /**
     * vpeBt@Cɏo͂܂B
     * w肵vpeBt@Cłɑ݂Ăꍇ
     * t@C̏㏑邩vpeB̃}[W邩w肵܂B
     * }[W̏ꍇAvpeBt@C̃L[Ɠ̃L[̃vpeB
     * IuWFNgɓo^Ăꍇ̓IuWFNg̃vpeBŏ㏑܂B
     * 
     * @param filePath vpeBt@CpX
     * @param header wb_
     * @param b }[WtrueA㏑false
     * @throws NullPointerException
     *          filePathnull̏ꍇ
     * @throws FileNotFoundException
     *          t@C݂ĂȂꍇ
     * @throws IOException
     *          vpeBt@Cɏ߂Ȃꍇ
     * @throws ClassCastException
     *          PropertiesIuWFNgɁAStringł͂ȂL[܂͒li[Ăꍇ 
     * @since 2.0
     */
    public void store(String filePath, String header, boolean b) throws IOException {

        if (filePath == null) {
            throw new NullPointerException("filePath == null");
        }
        
        HProperties prop = new HProperties();
        if (b) {
            InputStream is = null;
            try {
                is = new FileInputStream(filePath);
                prop.load(is);
            } finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        prop.map.putAll(map);

        OutputStream os = null;
        try {
            HFile f = null;
            f = new HFile(filePath);
            HDirectory d = new HDirectory(f.getParent());
            if(!d.exists()) {
                d.mkdirs();
            }
            os = new FileOutputStream(f);
            prop.store(os, header);
        } finally {
            if (os != null) {
                os.close();
            }
        }
    }
    
    /**
     * PropertiesNXstore\bhƓ܂B
     * }[W͂܂B
     * 
     * @param out vpeBt@CpX
     * @param header wb_
     * @throws IOException
     *          ̃vpeBXgw肵o̓Xg[ɏŁAIOException X[ꂽꍇ 
     * @throws ClassCastException
     *           Properties IuWFNgɁAString ł͂ȂL[܂͒li[Ăꍇ 
     * @throws NullPointerException 
     *          outnull̏ꍇ
     * @since 2.0
     */
    public void store(OutputStream out, String header) throws IOException {        
        super.store(out, header);
    }
    

    /**
     * w肳ꂽo̓Xg[ɁAvpeBXgo͂܂B
     * ̃\bh̓fobOɗp܂B
     * 
     * @param out o̓Xg[
     * @since 2.0
     */
    public void list(PrintStream out) {
        out.println("-- listing properties --");
        LinkedHashMap map = new LinkedHashMap();
        enumerate(map);
        for (Enumeration e = Collections.enumeration(map.keySet()); e.hasMoreElements() ;) {
            String key = (String)e.nextElement();
            String value = (String)map.get(key);
            out.println(key + "=" + value);
        }
        out.flush();
    }

    /**
     * w肳ꂽo̓Xg[ɁAvpeBXgo͂܂B
     * ̃\bh̓fobOɗp܂B
     * 
     * @param out o̓Xg[
     * @since 2.0
     */
    public void list(PrintWriter out) {
        out.println("-- listing properties --");
        LinkedHashMap map = new LinkedHashMap();
        enumerate(map);
        for (Enumeration e = Collections.enumeration(map.keySet()); e.hasMoreElements() ;) {
            String key = (String)e.nextElement();
            String value = (String)map.get(key);
            out.println(key + "=" + value);
        }
        out.flush();
    }
    
    private synchronized void enumerate(Map m) {
        for (Enumeration e = keys() ; e.hasMoreElements() ;) {
            String key = (String)e.nextElement();
            m.put(key, get(key));
        }
    }
}
