/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class Operation {
    public static final int UNDEFINED = 0;
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 8;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;

    public static Object newInstance(String classPath, Class[] parameterTypes, Object[] initargs) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException, ClassNotFoundException {
        Class<?> c = Class.forName(classPath);
        Constructor<?> constructor = c.getConstructor(parameterTypes);
        return constructor.newInstance(initargs);
    }

    public static Object newInstanceIgnoreError(String classPath, Class[] parameterTypes, Object[] initargs) {
        Object o = null;
        try {
            o = Operation.newInstance(classPath, parameterTypes, initargs);
        }
        catch (Throwable e) {
            // empty catch block
        }
        return o;
    }

    public static Object invokeMethod(String methodName, Class[] argTypes, Object obj, Object[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return Operation.invoke(obj.getClass(), methodName, argTypes, obj, args);
    }

    public static Object invokeStaticMethod(String classPath, String methodName, Class[] argTypes, Object[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> c = Class.forName(classPath);
        return Operation.invoke(c, methodName, argTypes, null, args);
    }

    public static Object invokeStaticMethod(Class c, String methodName, Class[] argTypes, Object[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return Operation.invoke(c, methodName, argTypes, null, args);
    }

    public static void invokeMethodRun(Class cls, String startStr) throws SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NullPointerException {
        Operation.invokeMethodRun(cls, startStr, null, null, 0);
    }

    public static void invokeMethodRun(Class cls, String startStr, String setUpStr, String tearDownStr) throws SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NullPointerException {
        Operation.invokeMethodRun(cls, startStr, setUpStr, tearDownStr, 0);
    }

    public static void invokeMethodRun(Class cls, String startStr, String setUpStr, String tearDownStr, int isMod) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, NullPointerException {
        if (cls == null) {
            throw new NullPointerException("Class-object is null.");
        }
        Constructor constructor = cls.getConstructor(new Class[0]);
        Object obj = constructor.newInstance(new Object[0]);
        Operation.invokeAllPublicMethodRun(cls, obj, startStr, setUpStr, tearDownStr, isMod, 0);
    }

    public static void invokeMethodRun(Object obj, String startStr) throws IllegalArgumentException, NullPointerException, IllegalAccessException, InvocationTargetException {
        Operation.invokeMethodRun(obj, startStr, null, null, 0);
    }

    public static void invokeMethodRun(Object obj, String startStr, String setUpStr, String tearDownStr) throws IllegalArgumentException, NullPointerException, IllegalAccessException, InvocationTargetException {
        Operation.invokeMethodRun(obj, startStr, setUpStr, tearDownStr, 0);
    }

    public static void invokeMethodRun(Object obj, String startStr, String setUpStr, String tearDownStr, int isMod) throws IllegalArgumentException, NullPointerException, IllegalAccessException, InvocationTargetException {
        if (obj == null) {
            throw new NullPointerException("Object-object is null.");
        }
        Class<?> cls = obj.getClass();
        Operation.invokeAllPublicMethodRun(cls, obj, startStr, setUpStr, tearDownStr, isMod, 8);
    }

    public static void invokeStaticMethodRun(Class cls, String startStr) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NullPointerException {
        Operation.invokeStaticMethodRun(cls, startStr, null, null, 0);
    }

    public static void invokeStaticMethodRun(Class cls, String startStr, String setUpStr, String tearDownStr) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Operation.invokeStaticMethodRun(cls, startStr, null, null, 0);
    }

    public static void invokeStaticMethodRun(Class cls, String startStr, String setUpStr, String tearDownStr, int isMod) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (cls == null) {
            throw new NullPointerException("Class-object is null.");
        }
        Operation.invokeAllPublicMethodRun(cls, null, startStr, setUpStr, tearDownStr, 8, 0);
    }

    public static void variableTrace(PrintStream out, Object o) {
        String[] array;
        if (out == null) {
            throw new NullPointerException("PrintStream is null.");
        }
        if (o == null) {
            out.println("object is null.");
        }
        if ((array = Operation.getVariables(o)).length == 0) {
            out.println(o.getClass().getName() + " have not a variable.");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i] + ", ");
        }
        out.println(sb.toString());
        out.flush();
    }

    public static void variableTrace(PrintWriter out, Object o) {
        String[] array;
        if (out == null) {
            throw new NullPointerException("PrintWriter is null.");
        }
        if (o == null) {
            out.println("object is null.");
        }
        if ((array = Operation.getVariables(o)).length == 0) {
            out.println(o.getClass().getName() + " have not a variable.");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i] + ", ");
        }
        out.println(sb.toString());
        out.flush();
    }

    public static boolean isModifier(int mod, int isMod) {
        if ((isMod & 1) != 0 && !Modifier.isPublic(mod)) {
            return false;
        }
        if ((isMod & 4) != 0 && !Modifier.isProtected(mod)) {
            return false;
        }
        if ((isMod & 2) != 0 && !Modifier.isPrivate(mod)) {
            return false;
        }
        if ((isMod & 0x400) != 0 && !Modifier.isAbstract(mod)) {
            return false;
        }
        if ((isMod & 8) != 0 && !Modifier.isStatic(mod)) {
            return false;
        }
        if ((isMod & 0x10) != 0 && !Modifier.isFinal(mod)) {
            return false;
        }
        if ((isMod & 8) != 0 && !Modifier.isTransient(mod)) {
            return false;
        }
        if ((isMod & 0x40) != 0 && !Modifier.isVolatile(mod)) {
            return false;
        }
        if ((isMod & 0x20) != 0 && !Modifier.isSynchronized(mod)) {
            return false;
        }
        if ((isMod & 0x100) != 0 && !Modifier.isNative(mod)) {
            return false;
        }
        if ((isMod & 0x800) != 0 && !Modifier.isStrict(mod)) {
            return false;
        }
        return (isMod & 0x200) == 0 || Modifier.isInterface(mod);
    }

    private static Object invoke(Class c, String methodName, Class[] argTypes, Object obj, Object[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method m = c.getMethod(methodName, argTypes);
        return m.invoke(obj, args);
    }

    private static void invokeAllPublicMethodRun(Class cls, Object obj, String startStr, String setUpStr, String tearDownStr, int isMod, int unMod) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NullPointerException {
        if (startStr == null) {
            throw new NullPointerException("Start-string is null.");
        }
        if (startStr.length() == 0) {
            throw new IllegalArgumentException("Start-string is empty.");
        }
        Method setUp = null;
        if (setUpStr != null && setUpStr.length() != 0) {
            try {
                setUp = cls.getMethod(setUpStr, null);
            }
            catch (Exception e) {
                setUp = null;
            }
        }
        Method tearDown = null;
        if (tearDownStr != null && tearDownStr.length() != 0) {
            try {
                tearDown = cls.getMethod(tearDownStr, null);
            }
            catch (Exception e) {
                tearDown = null;
            }
        }
        Method[] m = cls.getMethods();
        for (int i = 0; i < m.length; ++i) {
            if (!m[i].getName().startsWith(startStr)) continue;
            int mod = m[i].getModifiers();
            if (isMod != 0 && !Operation.isModifier(mod, isMod) || unMod != 0 && Operation.isModifier(mod, unMod) || m[i].getParameterTypes().length != 0) continue;
            if (setUp != null && Operation.eqaulsModifier(mod, setUp.getModifiers())) {
                setUp.invoke(obj, null);
            }
            try {
                m[i].invoke(obj, null);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tearDown == null || !Operation.eqaulsModifier(mod, tearDown.getModifiers())) continue;
            tearDown.invoke(obj, null);
        }
    }

    private static String[] getVariables(Object obj) {
        Class<?> cls = obj.getClass();
        Field[] fields = cls.getFields();
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < fields.length; ++i) {
            try {
                l.add(fields[i].getName() + "=" + fields[i].get(obj));
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return l.toArray(new String[0]);
    }

    private static boolean eqaulsModifier(int mod, int mod2) {
        return Modifier.isStatic(mod) ? Modifier.isStatic(mod) : !Modifier.isStatic(mod);
    }
}

