/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import jp.hrtdotnet.java.net.NetUtil;

public class WakeOnLan {
    public static void execute(String ipAddress, int port, String macAddress) throws UnknownHostException, SocketException, IOException {
        byte[] magicPacket = WakeOnLan.createMagicPacket(macAddress);
        WakeOnLan.executeMagicPacket(ipAddress, port, magicPacket);
    }

    public static void execute(String ipAddress, int port, String macAddress, String delim) throws UnknownHostException, SocketException, IOException {
        byte[] magicPacket = WakeOnLan.createMagicPacket(macAddress, delim);
        WakeOnLan.executeMagicPacket(ipAddress, port, magicPacket);
    }

    public static void execute(String host, int port, byte[] macAddress) throws UnknownHostException, SocketException, IOException {
        byte[] magicPacket = WakeOnLan.createMagicPacket(macAddress);
        WakeOnLan.executeMagicPacket(host, port, magicPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void executeMagicPacket(String host, int port, byte[] magicPacket) throws UnknownHostException, SecurityException, SocketException, IOException {
        if (magicPacket == null) {
            throw new NullPointerException("MagicPacket is null.");
        }
        InetAddress inetAddress = null;
        DatagramPacket packet = null;
        DatagramSocket socket = null;
        try {
            inetAddress = InetAddress.getByName(host);
            packet = new DatagramPacket(magicPacket, magicPacket.length, inetAddress, port);
            socket = new DatagramSocket();
            socket.send(packet);
            Object var7_6 = null;
            if (socket != null && !socket.isClosed()) {
                socket.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (socket != null && !socket.isClosed()) {
                socket.close();
            }
            throw throwable;
        }
    }

    protected static byte[] createMagicPacket(String macAddress) {
        byte[] macAddressBytes = NetUtil.octetMacAddress(macAddress);
        return WakeOnLan.createMagicPacket(macAddressBytes);
    }

    protected static byte[] createMagicPacket(String macAddress, String delim) {
        byte[] macAddressBytes = NetUtil.octetMacAddress(macAddress, delim);
        return WakeOnLan.createMagicPacket(macAddressBytes);
    }

    protected static byte[] createMagicPacket(byte[] macAddress) {
        int i;
        int macAddressLength = 6;
        if (macAddress == null) {
            throw new NullPointerException("Mac-Address is null.");
        }
        if (macAddress.length != macAddressLength) {
            throw new IllegalArgumentException("Mac-Address-length is invalid.");
        }
        byte[] magicPacket = new byte[macAddressLength + macAddressLength * 16];
        for (i = 0; i < macAddressLength; ++i) {
            magicPacket[i] = -1;
        }
        for (i = 1; i <= 16; ++i) {
            System.arraycopy(macAddress, 0, magicPacket, i * macAddressLength, macAddressLength);
        }
        return magicPacket;
    }
}

