package jp.hrtdotnet.java.util;

import junit.framework.TestCase;

public class IntegerUtilTest extends TestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }
    
    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#isBitFlag(int, int)} ̂߂̃eXgE\bhB
     */
    public void testIsBitFlag() {
        assertTrue(IntegerUtil.isBitFlag(0x01010101, 0x00010000));
        assertFalse(IntegerUtil.isBitFlag(0x01010101, 0x10010000));
        assertFalse(IntegerUtil.isBitFlag(0x01010101, 0x10101010));
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#setBitFlag(int, int, boolean)} ̂߂̃eXgE\bhB
     */
    public void testSetBitFlag_IntIntBoolean() {
        int x = IntegerUtil.setBitFlag(0x01010101, 0x01100101, true);
        assertEquals(0x01110101, x);

        x = IntegerUtil.setBitFlag(0x01010101, 0x01100101, false);
        assertEquals(0x00010000, x);
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#setBitFlag(int, int)} ̂߂̃eXgE\bhB
     */
    public void testSetBitFlag_IntInt() {
        int x = IntegerUtil.setBitFlag(0x01010101, 0x01100101);
        assertEquals(0x00110000, x);
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#toNumber(char)} ̂߂̃eXgE\bhB
     */
    public void testToNumber() {
        assertEquals(IntegerUtil.toNumber('0'), 0);
        assertEquals(IntegerUtil.toNumber('1'), 1);
        assertEquals(IntegerUtil.toNumber('2'), 2);
        assertEquals(IntegerUtil.toNumber('3'), 3);
        assertEquals(IntegerUtil.toNumber('4'), 4);
        assertEquals(IntegerUtil.toNumber('5'), 5);
        assertEquals(IntegerUtil.toNumber('6'), 6);
        assertEquals(IntegerUtil.toNumber('7'), 7);
        assertEquals(IntegerUtil.toNumber('8'), 8);
        assertEquals(IntegerUtil.toNumber('9'), 9);

        try {
            IntegerUtil.toNumber('-');
            fail();
        } catch(NumberFormatException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#toInt(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testToInt_String() {
        assertEquals(IntegerUtil.toInt("1"), 1);
        try {
            IntegerUtil.toInt("not int");
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#toIntIgnoreError(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testToIntIgnoreError() {
        assertEquals(IntegerUtil.toIntIgnoreError("1"), 1);
        assertEquals(IntegerUtil.toIntIgnoreError("not int"), 0);
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#toInt(java.lang.String, int)} ̂߂̃eXgE\bhB
     */
    public void testToInt_StringInt() {
        assertEquals(IntegerUtil.toInt("1", 5), 1);
        assertEquals(IntegerUtil.toInt("not int", 5), 5);
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#toNatural(java.lang.String, int)} ̂߂̃eXgE\bhB
     */
    public void testToNatural_StringInt() {
        assertEquals(IntegerUtil.toNatural("1", 5), 1);
        assertEquals(IntegerUtil.toNatural("-1", 5), 5);
        try {
            IntegerUtil.toNatural("1", -1);
            fail();
        } catch (IllegalArgumentException e) {
        }        
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#toNatural(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testToNatural_String() {
        assertEquals(IntegerUtil.toNatural("1"), 1);
        assertEquals(IntegerUtil.toNatural("0001"), 1);
        try {
            IntegerUtil.toNatural("-1");
            fail();
        } catch (IllegalArgumentException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#toNaturalIgnoreError(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testToNaturalIgnoreError() {
        assertEquals(IntegerUtil.toNaturalIgnoreError("1"), 1);
        assertEquals(IntegerUtil.toNaturalIgnoreError("-1"), 0);
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#isInteger(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testIsInteger() {
        assertTrue(IntegerUtil.isInteger("111111"));
        assertTrue(IntegerUtil.isInteger("-111111"));
        assertTrue(IntegerUtil.isInteger("-PPPPPP1PPPPPPPP"));
        assertFalse(IntegerUtil.isInteger(null));
        assertFalse(IntegerUtil.isInteger(""));
        assertFalse(IntegerUtil.isInteger("|1111111"));
        assertFalse(IntegerUtil.isInteger(""));
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#isIntegerSingleByte(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testIsIntegerSingleByte() {
        assertTrue(IntegerUtil.isIntegerSingleByte("111111"));
        assertTrue(IntegerUtil.isIntegerSingleByte("-111111"));
        assertFalse(IntegerUtil.isIntegerSingleByte("-PPPPPPP1PPPPPPP"));
        assertFalse(IntegerUtil.isIntegerSingleByte(null));
        assertFalse(IntegerUtil.isIntegerSingleByte(""));
        assertFalse(IntegerUtil.isIntegerSingleByte("|1111111"));
        assertFalse(IntegerUtil.isIntegerSingleByte(""));
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#isIntegerMultiByte(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testIsIntegerMultiByte() {
        assertTrue(IntegerUtil.isIntegerMultiByte("|PPPPPPPPPPPPP"));
        assertFalse(IntegerUtil.isIntegerMultiByte("111111"));
        assertFalse(IntegerUtil.isIntegerMultiByte("-111111"));
        assertFalse(IntegerUtil.isIntegerMultiByte("-PPPPPPPPPPPPPPP"));
        assertFalse(IntegerUtil.isIntegerMultiByte("PPPPP1PPPPPPPPP"));
        assertFalse(IntegerUtil.isIntegerMultiByte(null));
        assertFalse(IntegerUtil.isIntegerMultiByte(""));
        assertFalse(IntegerUtil.isIntegerMultiByte("|1111111"));
        assertFalse(IntegerUtil.isIntegerMultiByte(""));
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#isNumber(char)} ̂߂̃eXgE\bhB
     */
    public void testIsNumber_Char() {
        assertTrue(IntegerUtil.isNumber('0'));
        assertTrue(IntegerUtil.isNumber('1'));
        assertTrue(IntegerUtil.isNumber('2'));
        assertTrue(IntegerUtil.isNumber('3'));
        assertTrue(IntegerUtil.isNumber('4'));
        assertTrue(IntegerUtil.isNumber('5'));
        assertTrue(IntegerUtil.isNumber('6'));
        assertTrue(IntegerUtil.isNumber('7'));
        assertTrue(IntegerUtil.isNumber('8'));
        assertTrue(IntegerUtil.isNumber('9'));
        assertTrue(IntegerUtil.isNumber('O'));
        assertTrue(IntegerUtil.isNumber('P'));
        assertTrue(IntegerUtil.isNumber('Q'));
        assertTrue(IntegerUtil.isNumber('R'));
        assertTrue(IntegerUtil.isNumber('S'));
        assertTrue(IntegerUtil.isNumber('T'));
        assertTrue(IntegerUtil.isNumber('U'));
        assertTrue(IntegerUtil.isNumber('V'));
        assertTrue(IntegerUtil.isNumber('W'));
        assertTrue(IntegerUtil.isNumber('X'));
        assertFalse(IntegerUtil.isNumber('\u0029'));
        assertFalse(IntegerUtil.isNumber('A'));
        assertFalse(IntegerUtil.isNumber('\uFF09'));
        assertFalse(IntegerUtil.isNumber('\uFF20'));
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#isNumberSingleByte(char)} ̂߂̃eXgE\bhB
     */
    public void testIsNumberSingleByte_Char() {
        assertTrue(IntegerUtil.isNumberSingleByte('0'));
        assertTrue(IntegerUtil.isNumberSingleByte('1'));
        assertTrue(IntegerUtil.isNumberSingleByte('2'));
        assertTrue(IntegerUtil.isNumberSingleByte('3'));
        assertTrue(IntegerUtil.isNumberSingleByte('4'));
        assertTrue(IntegerUtil.isNumberSingleByte('5'));
        assertTrue(IntegerUtil.isNumberSingleByte('6'));
        assertTrue(IntegerUtil.isNumberSingleByte('7'));
        assertTrue(IntegerUtil.isNumberSingleByte('8'));
        assertTrue(IntegerUtil.isNumberSingleByte('9'));
        assertFalse(IntegerUtil.isNumberSingleByte('O'));
        assertFalse(IntegerUtil.isNumberSingleByte('P'));
        assertFalse(IntegerUtil.isNumberSingleByte('Q'));
        assertFalse(IntegerUtil.isNumberSingleByte('R'));
        assertFalse(IntegerUtil.isNumberSingleByte('S'));
        assertFalse(IntegerUtil.isNumberSingleByte('T'));
        assertFalse(IntegerUtil.isNumberSingleByte('U'));
        assertFalse(IntegerUtil.isNumberSingleByte('V'));
        assertFalse(IntegerUtil.isNumberSingleByte('W'));
        assertFalse(IntegerUtil.isNumberSingleByte('X'));
        assertFalse(IntegerUtil.isNumberSingleByte('\u0029'));
        assertFalse(IntegerUtil.isNumberSingleByte('A'));
        assertFalse(IntegerUtil.isNumberSingleByte('\uFF09'));
        assertFalse(IntegerUtil.isNumberSingleByte('\uFF20'));
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#isNumberMultiByte(char)} ̂߂̃eXgE\bhB
     */
    public void testIsNumberMultiByte_Char() {
        assertFalse(IntegerUtil.isNumberMultiByte('0'));
        assertFalse(IntegerUtil.isNumberMultiByte('1'));
        assertFalse(IntegerUtil.isNumberMultiByte('2'));
        assertFalse(IntegerUtil.isNumberMultiByte('3'));
        assertFalse(IntegerUtil.isNumberMultiByte('4'));
        assertFalse(IntegerUtil.isNumberMultiByte('5'));
        assertFalse(IntegerUtil.isNumberMultiByte('6'));
        assertFalse(IntegerUtil.isNumberMultiByte('7'));
        assertFalse(IntegerUtil.isNumberMultiByte('8'));
        assertFalse(IntegerUtil.isNumberMultiByte('9'));
        assertTrue(IntegerUtil.isNumberMultiByte('O'));
        assertTrue(IntegerUtil.isNumberMultiByte('P'));
        assertTrue(IntegerUtil.isNumberMultiByte('Q'));
        assertTrue(IntegerUtil.isNumberMultiByte('R'));
        assertTrue(IntegerUtil.isNumberMultiByte('S'));
        assertTrue(IntegerUtil.isNumberMultiByte('T'));
        assertTrue(IntegerUtil.isNumberMultiByte('U'));
        assertTrue(IntegerUtil.isNumberMultiByte('V'));
        assertTrue(IntegerUtil.isNumberMultiByte('W'));
        assertTrue(IntegerUtil.isNumberMultiByte('X'));
        assertFalse(IntegerUtil.isNumberMultiByte('\u0029'));
        assertFalse(IntegerUtil.isNumberMultiByte('A'));
        assertFalse(IntegerUtil.isNumberMultiByte('\uFF09'));
        assertFalse(IntegerUtil.isNumberMultiByte('\uFF20'));
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#isNumber(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testIsNumber_String() {
        assertTrue(IntegerUtil.isNumber("000000000000"));
        assertTrue(IntegerUtil.isNumber("OOOOOOOOO"));
        assertTrue(IntegerUtil.isNumber("OOO1OOOO"));
        assertFalse(IntegerUtil.isNumber("-000000000000"));
        assertFalse(IntegerUtil.isNumber("AAAAAA"));
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#isNumberMultiByte(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testIsNumberMultiByte_String() {
        assertFalse(IntegerUtil.isNumberMultiByte("000000000000"));
        assertFalse(IntegerUtil.isNumberMultiByte("OOO1OOOO"));
        assertFalse(IntegerUtil.isNumberMultiByte("-000000000000"));
        assertFalse(IntegerUtil.isNumberMultiByte("AAAAAA"));
        assertTrue(IntegerUtil.isNumberMultiByte("OOOOOOOOO"));
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#isNumberSingleByte(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testIsNumberSingleByte_String() {
        assertTrue(IntegerUtil.isNumberSingleByte("000000000000"));
        assertFalse(IntegerUtil.isNumberSingleByte("OOOOOOOOO"));
        assertFalse(IntegerUtil.isNumberSingleByte("OOO1OOOO"));
        assertFalse(IntegerUtil.isNumberSingleByte("-000000000000"));
        assertFalse(IntegerUtil.isNumberSingleByte("AAAAAA"));
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#isInt(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testIsInt() {
        assertTrue(IntegerUtil.isInt("1111111"));
        assertTrue(IntegerUtil.isInt("PPPPPP"));
        assertFalse(IntegerUtil.isInt("11111111111111111"));
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#isIntSingleByte(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testIsIntSingleByte() {
        assertTrue(IntegerUtil.isIntSingleByte("1111111"));
        assertFalse(IntegerUtil.isIntSingleByte("PPPPPP"));
        assertFalse(IntegerUtil.isIntSingleByte("11111111111111111"));
    }

    /**
     * {@link jp.hrtdotnet.java.util.IntegerUtil#isIntMultiByte(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testIsIntMultiByte() {
        assertFalse(IntegerUtil.isIntMultiByte("1111111"));
        assertTrue(IntegerUtil.isIntMultiByte("PPPPPP"));
        assertFalse(IntegerUtil.isIntMultiByte("11111111111111111"));
    }}
