// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BoardContainer.java
//	DATE:		2003.6.9
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.view;

import java.io.File;

import java.awt.Component;
import java.awt.Container;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.SaveCanceledException;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.Command;

/**
 *	R|[lgpropertŷւ񂱂hook邽߂̍iNX
 */
 public abstract class BoardContainer implements BoardView {
	
	/** ̊Kw̐evf */
	private BoardView mParent;
	
	/** ̊Kw̎qvf */
	private BoardView mDecorated;
	
	/** Board componentŃbvĂawt container */
	private Container mContainer;
	
	/**
	 *	RXgN^
	 *
	 *	@param	inContainer	Board componentŃbvawt container
	 */
	public BoardContainer(Container inContainer) {
		mContainer = inContainer;
	}
	
	/**
	 *	Ֆʂ̏s
	 */
	public final void initialize() {
		initializeSelf();
		
		mDecorated.initialize();
	}
	
	/**
	 *	̔Ֆʂ̏s
	 */
	protected abstract void initializeSelf();

	/**
	 *	ՖʂύXĂ邩ǂ`FbNB
	 */
	public final boolean isModified() {
		return mDecorated.isModified();
	}
	
	/**
	 *	BoardKwƂÅKw̎qݒ肷
	 *
	 *	@param	inBoard	̊Kw̎qƂȂBoard
	 */
	public void addBoard(BoardView inSubBoard) {
		mContainer.add(inSubBoard.getComponent());
		
		mDecorated = inSubBoard;
		
		inSubBoard.setParent(this);
	}

	/**
	 *	BoardKwƂÅKw̐eݒ肷
	 *
	 *	@param	inBoard	̊Kw̐eƂȂBoard
	 */
	public void setParent(BoardView inParentBoard) {
		mParent = inParentBoard;
	}
	
	/**
	 *	@return	gƊ֘AtꂽComponentԂ
	 */
	public final Component getComponent() {
		return mContainer;
	}
	
	/**
	 *	Boardĕ`悷
	 */
	public final void repaint() {
		mDecorated.repaint();
	}
		
	/**
	 *	BoardɃtH[JXڂǂ߂
	 */
	public void setFocus(boolean inFocused) {
		mParent.setFocus(inFocused);
	}
	
	/**
	 *	BoardɃtH[JX݂邩ǂ`FbN
	 *
	 *	@return	tH[JXꍇtrueԂB
	 */
	public final boolean isFocused() {
		return mParent.isFocused();
	}

	/**
	 *	Commands
	 *	̎ł́ÃvZXŏłȂƂA
	 *	艺ʂ܂́AʂCommandContainerŎw肵CommandƂA
	 *	Command]
	 *
	 *	@param	inCommand	Command
	 */	
	public void processCommand(Command inCommand) {
		// w肵Command̏܂ĂȂ
		// ACommandContainerŏłꍇ
		if (! inCommand.isConsumed()) {
			processCommandImpl(inCommand);
		}
		
		// ̃vZXŏłȂƂA
		// ܂́AʂCommandContainerŎw肵CommandƂ
		if (! inCommand.isConsumed()) {
			if (inCommand instanceof AbstractTopDownCommand) {
				mDecorated.processCommand(inCommand);
			}
			else if (inCommand instanceof AbstractBottomUpCommand) {
				mParent.processCommand(inCommand);
			}
		}
	}
	
	/**
	 *	Command̎
	 *
	 *	@param	inCommand	Command
	 */
	protected abstract void processCommandImpl(Command inCommand);
}