// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		DirectionStateEventCode.java (package private class)
//	DATE:		2003.5.25	initial version
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.util;

import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

class DirectionStateEventCode implements StateEventCode {
	private static final int TYPE_ILLEGAL = Integer.MIN_VALUE;
	private static final int TYPE_SELECT = 0;
	private static final int TYPE_DETERMINE = 1;
	
	private static java.util.Map sSelectDirMap = new java.util.HashMap();
	private static java.util.Map sDetermineDirMap = new java.util.HashMap();
	
	static {
		sSelectDirMap.put(Direction.NORTH.getName(), new DirectionStateEventCode(Direction.NORTH, TYPE_SELECT));
		sSelectDirMap.put(Direction.SOUTH.getName(), new DirectionStateEventCode(Direction.SOUTH, TYPE_SELECT));
		sSelectDirMap.put(Direction.EAST.getName(), new DirectionStateEventCode(Direction.EAST, TYPE_SELECT));
		sSelectDirMap.put(Direction.WEST.getName(), new DirectionStateEventCode(Direction.WEST, TYPE_SELECT));
		sSelectDirMap.put(Direction.NO.getName(), new DirectionStateEventCode(Direction.NO, TYPE_SELECT));
		
		sDetermineDirMap.put(Direction.NORTH.getName(), new DirectionStateEventCode(Direction.NORTH, TYPE_DETERMINE));
		sDetermineDirMap.put(Direction.SOUTH.getName(), new DirectionStateEventCode(Direction.SOUTH, TYPE_DETERMINE));
		sDetermineDirMap.put(Direction.EAST.getName(), new DirectionStateEventCode(Direction.EAST, TYPE_DETERMINE));
		sDetermineDirMap.put(Direction.WEST.getName(), new DirectionStateEventCode(Direction.WEST, TYPE_DETERMINE));
		sDetermineDirMap.put(Direction.NO.getName(), new DirectionStateEventCode(Direction.NO, TYPE_DETERMINE));
	}
	
	private static final DirectionStateEventCode ILLEGAL_CODE 
			 = new DirectionStateEventCode(Direction.NO, TYPE_ILLEGAL);
			 
	public static StateEventCode createSelectDirectionCode(Direction inDirection) {
		if (sSelectDirMap.containsKey(inDirection.getName())) {
			return (StateEventCode)sSelectDirMap.get(inDirection.getName());
		}
		
		return ILLEGAL_CODE;
	}
	
	public static StateEventCode createDetermineDirectionCode(Direction inDirection) {
		if (sDetermineDirMap.containsKey(inDirection.getName())) {
			return (StateEventCode)sDetermineDirMap.get(inDirection.getName());
		}
		
		return ILLEGAL_CODE;
	}
	
	public static boolean isDeterminationType(DirectionStateEventCode inEventCode) {
		return inEventCode.mType == TYPE_DETERMINE;
	}
	
	public static boolean isSelectionType(DirectionStateEventCode inEventCode) {
		return inEventCode.mType == TYPE_SELECT;
	}
	
	private Direction mDirection; 
	private int mType;
	
	private DirectionStateEventCode(Direction inDirection, final int inType) {
		mDirection = inDirection;
		mType = inType;
	}
	
	public Direction getDirection() {
		return mDirection;
	}
	
	public String getValue() {
		return mDirection.getName();
	}
}
