//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		SolverRI_4.java
//	DATE:		2003.7.23
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SoluteSeparatedException;

public class SolverRI_4 implements SolverHandler {
	static class OppositeRecord {
		int mCount; // ݉ˋĂ鋴̐
		State mState = sStartState;
	}
	
	static class SolverRecord {
		int mQueueRef;
		
		Point mPos;
		final int mMaxBuildCount;
		int mResidue;
		int mOppositeCount;
		OppositeRecord[] mOpposite = new OppositeRecord[DIRECTIONS.length];
		State mState = sStartState;
		
		int mPenalty = 0;
		
		boolean mValied;
		boolean mMostPriority;
		
		SolverRecord(final int inQueueRef, Point inPos, final int inCount) {
			mQueueRef = inQueueRef;
			mPos = inPos;
			mMaxBuildCount = mResidue = inCount;
		}
		
		public String toString() {
			return "count = " + mOppositeCount
				+ ", residue = " + mResidue
				+ ", priority = " + mMostPriority
				+ ", pos = [x=" + mPos.x + ",y=" + mPos.y + "]";
		}
	}
	
	private static class SolverInfo {	
		SolverRecord mRec;
		int mAroundMax;
		Point[] mAroundPos;
		
		SolverInfo(SolverRecord inRec, final int inAroundMax, Point[] inAroundPos) {
			mRec = inRec;
			mAroundMax = inAroundMax;
			mAroundPos = inAroundPos;
		}
	}
	
	private static interface SolverPattern {
		public boolean build(SolverInfo inInfo);
	}
	
	private static final State sStartState = new SolverStartState();
	private static final State sProcessingState = new SolverProcessingState();
	private static final State sBuildDisableState = new DisableState();
	private static final State sFinishedState = new SolverFinishedState();

	/** ̏W */
	private static final Direction[] DIRECTIONS = new Direction[] {
		Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, 
	};
	
	private static final Direction[] DIAGONAL = new Direction[] {
		Direction.NORTH_WEST, Direction.NORTH_EAST, Direction.SOUTH_WEST, Direction.SOUTH_EAST, 
	};
	
	// ɂ邱Ƃ̂ł鋴̍ő{
	private static final int NUM_PER_DIRECTION = 2;
	
	private static final int LOOP_ONCE_LIMIT = 100;
	
	// ˋłȂƂɉyieBl
	private static final int PENALTY_WEIGHT = DIRECTIONS.length * NUM_PER_DIRECTION;

	/** Map<Point, SolverRecord> */
	private java.util.Map mRecords = new java.util.HashMap();
	
	/** QueueIF<SolverRecord> */
	private QueueIF mQueue = new Queue_2(new SolverRecordComparator());	;
//	private QueueIF mQueue = new Queue_3(new SolverRecordComparator());	;
	
	/** Map<Integer, List<SolverRecord> > */
	private java.util.Map mChainMap = new java.util.HashMap();
	
	private Model mModel;
	
	private int mLap;
	
	private int mLoopCount = 0;
	
	/** Pxˋ邱ƂȂQueueꍇON */
	private boolean mIsNotResolve;
	
	private SolverPattern[] mPatterns = new SolverPattern[] {
		new HashikakeSolverPattern1(), 
		new HashikakeSolverPattern2(), 
		new HashikakeSolverPattern3(), 
		new HashikakeSolverPattern4(), 
		new HashikakeSolverPattern5(), 
	};
	
	public SolverRI_4(Model inModel) {
		mModel = inModel;
		
		// solver pattern̓o^
		
	}
	
	public void reset() {
		initRecords();
		
		mLap = 0;
		mLoopCount = 0;
		mIsNotResolve = false;
	}
	
	private void initRecords() {
		mRecords.clear();
		mChainMap.clear();
		mQueue.clear();
		
		java.util.List aList = new java.util.ArrayList();
		
		for (int y = 0; y < mModel.getHeight(); ++y) {
			for (int x = 0; x < mModel.getWidth(); ++x) {				
				if (mModel.isNumberAt(x, y)) {					
					SolverRecord aRec = createSolverRecordAt(x, y);
					aList.add(aRec);
				}
			}
		}
		
		mQueue.addAll(aList.toArray(new SolverRecord[aList.size()]));
		mQueue.flip();
	}

	public void addSolvePosAt(final int inX, final int inY) {
		if (mModel.isNumberAt(inX, inY)) {					
			SolverRecord aRec = createSolverRecordAt(inX, inY);
			mQueue.enqueue(aRec);
			mQueue.flip();
		}
	}
	
	private SolverRecord createSolverRecordAt(final int inX, final int inY) {		
		Point aPos = new Point(inX, inY);
		
		SolverRecord aRec = getSolverRecord(aPos);
		updateSolverRecord(aRec);
		
		return aRec;
	}
	
	public boolean isSolute() {
		return mQueue.isEmpty();
	}
	
	
	public void nextSolute() {
		if (isSolute()) return;
		
		nextSoluteSub();
	}
	
	private boolean nextSoluteSub() {
		if (mLap <= 0) {
			mLap = mQueue.size();
		}
		
		SolverRecord aRec = null;
		
		do {
			--mLap;
			if (mQueue.isEmpty()) return true;
			
			aRec = (SolverRecord)mQueue.dequeue();
		}
		while (isFinishedState(aRec.mState));
		
		return attemptBuild(aRec);
	}
	
	public boolean nextSoluteAll() throws SolveDiscompleteException {
		// QueuȅꍇA𓚂ꂽƔf
		if (mQueue.isEmpty()) return true;

		// ˋłȂ
		int aCount = 0;
		
		// ̌x
		int aLimit = LOOP_ONCE_LIMIT;
		
		try {
			do {
				++mLoopCount;
				--aLimit;
				
				if (! nextSoluteSub()) {
					// ˋłȂQueueTCYɓB_
					// ȏ𓚂i߂邱ƂłȂƔf
					if (mQueue.size() == ++aCount) {
						if (mIsNotResolve) {
							throw new SolveDiscompleteException(mQueue.size());
						}
						else {
							mIsNotResolve = true;
							aCount = 0;
						}
					}
				}
				else {
					aCount = 0;
				}
			} while (mLap > 0 && aLimit > 0);	
		}
		catch (SoluteSeparatedException e) {
			System.out.println(e);
			
			throw new SolveDiscompleteException(e.getMessage());
		}
		
		if (isSolute()) {
			System.out.print("loop count : " + mLoopCount);
			
			return true;
		}
			
		return false;
	}
	
	private boolean attemptBuild(SolverRecord inRec) {
		boolean aRet = false;
		
		do {
			updateSolverRecord(inRec);
			
			if (isFinishedState(inRec.mState)) {
				return true;
			}
			
			aRet = false;
			
			Point[] aAroundPos = new Point[DIRECTIONS.length];
			final int aSum = getAroundMax(inRec, aAroundPos);
			
			SolverInfo aInfo = new SolverInfo(inRec, aSum, aAroundPos);
			
			for (int i = 0; i < mPatterns.length; ++i) {
				aRet |= mPatterns[i].build(aInfo);
				
				if (aRet) break;
			}

/*		
			// Ίp`FbN
			if (aRet) {
				Point[] aDiagonal = new Point[] {
					new Point(1, 1), new Point(-1, 1), new Point(1, -1), new Point(-1, -1), 
				};
				
				Point aDiaPos = new Point(inRec.mPos);
				for (int i = 0; i < aDiagonal.length; ++i) {
					aDiaPos.translate(aDiagonal[i].x, aDiagonal[i].y);
					if (mModel.isNumberAt(aDiaPos.x, aDiaPos.y)) {
						SolverRecord aDiaRec = getSolverRecord(aDiaPos);
						
						updateSolverRecord(aDiaRec);
						
					}
					aDiaPos.translate(-aDiagonal[i].x, -aDiagonal[i].y);
				}
			}
*/
		}
		while (aRet);
		

		if (! isFinishedState(inRec.mState)) {
			inRec.mPenalty += PENALTY_WEIGHT;
			mQueue.enqueue(inRec);
		}
		
		return aRet;
	}
	
	private SolverRecord getSolverRecord(Point inPos) {
		if (mRecords.containsKey(inPos)) {
			return (SolverRecord)mRecords.get(inPos);
		}
		else {
			if (mModel.isNumberAt(inPos.x, inPos.y)) {
				// mappingĂȂꍇArecord\zAmapperɓo^B
				// ŁA\zCX^XԂ
				int aCount = Integer.MIN_VALUE;
				Point aPos = new Point(inPos);
				
				try {
					aCount = Integer.parseInt(StateManager.getInstance().
								findIdentityOf(mModel.getCurStateAt(aPos.x, aPos.y)));
				}
				catch (NumberFormatException e) {
					throw new IllegalStateException(
						"The simbol of Number State cannot be parsed as integer."
					);
				}
					
				SolverRecord aRec = new SolverRecord(mRecords.size(), aPos, aCount);
				
				mRecords.put(aPos, aRec);
				
				return aRec;
			}
		}
		
		throw new IllegalArgumentException(
			"The state of specified position isnot NumberState"
			+ " (pos : x = " + inPos.x + ", y = " + inPos.y + ")"
		);
	}
	
	private boolean isBuild(Point inStart, Direction inDir, Point outOpposite) {
		Point aPos = new Point(inStart);
		
		Point aDiff = inDir.getDifference();
		aPos.translate(aDiff.x, aDiff.y);
		
		if (! mModel.contains(aPos.x, aPos.y)) return false;
		
		while (mModel.contains(aPos.x, aPos.y)) {
			if (mModel.isNumberAt(aPos.x, aPos.y)) {
				outOpposite.setLocation(aPos.x, aPos.y);
				
				return true;
			}
			
			StateEventCode aCode = UtilityFuncs.getDetermineDirectionEventCode(inDir);
			if (! mModel.isTransitAt(aPos.x, aPos.y, aCode)) {
				return false;
			}
			
			aPos.translate(aDiff.x, aDiff.y);
		}
		
		return false;
	}
	
	private boolean isStartState(State inState) {
		return inState == sStartState;
	}
	
	private boolean isFinishedState(State inState) {
		return inState == sFinishedState;
	}
	
	private boolean isDisableState(State inState) {
		return inState == sBuildDisableState;
	}
	
	private boolean isProcessState(State inState) {
		return inState == sProcessingState;
	}
	
	private boolean buildBridge(SolverRecord inRec, final int inCount, final int inIndex) {
		Point aPos = new Point(inRec.mPos);
		
		OppositeRecord aOppRec = inRec.mOpposite[inIndex];
		
		// ˋłȂꍇ
		if (null == aOppRec) return false;
		
		// ȏ㋴˂邱ƂoȂꍇ
		if (isFinishedState(aOppRec.mState)) return false;
		
		// ˋ{ɕωȂꍇ
		if (inCount == aOppRec.mCount) return false;
		
		Direction aDirection = DIRECTIONS[inIndex];
		
		StateEventCode aCode = UtilityFuncs.getDetermineDirectionEventCode(aDirection);
		
		Point aDiff = aDirection.getDifference();
		
		do {
			for (int aCount = aOppRec.mCount; aCount < inCount; ++aCount) {
				mModel.nextStateAt(aPos.x, aPos.y, aCode);
			}
			
			aPos.translate(aDiff.x, aDiff.y);
		} while (! mModel.isNumberAt(aPos.x, aPos.y));
		
		// Ί݂̓̉ˋԂXV
		aDirection = UtilityFuncs.inverseDirection(aDirection);
		aCode = UtilityFuncs.getDetermineDirectionEventCode(aDirection);
		for (int aCount = aOppRec.mCount; aCount < inCount; ++aCount) {
			mModel.nextStateAt(aPos.x, aPos.y, aCode);
		}
		
		// ˋ{̍XV
		aOppRec.mCount = inCount;
		
		// Ί݂̍XV
		SolverRecord aAgainstRec = getSolverRecord(aPos);
		addChainMap(inRec, aAgainstRec);
		updateSolverRecord(aAgainstRec);
		
		return true;
	}

	private void addChainMap(SolverRecord inRec, SolverRecord inAgainstRec) {
		if (inRec.mQueueRef == inAgainstRec.mQueueRef) return;
		
		java.util.List aList = getChainList(inRec);
		java.util.List aAgainstList = getChainList(inAgainstRec);
		
		Integer aRemoveRefID;
		if (inRec.mQueueRef < inAgainstRec.mQueueRef) {
			aRemoveRefID = new Integer(inAgainstRec.mQueueRef);
			mergeChainList(aList, aAgainstList, inRec.mQueueRef);
		}
		else {
			aRemoveRefID = new Integer(inRec.mQueueRef);
			mergeChainList(aAgainstList, aList, inAgainstRec.mQueueRef);
		}
		
		mChainMap.remove(aRemoveRefID);
	}
	
	private java.util.List getChainList(SolverRecord inRec) {
		Integer aKey = new Integer(inRec.mQueueRef);
	
		java.util.List aList = (java.util.List)mChainMap.get(aKey);
		if (null == aList) {
			aList = new java.util.LinkedList();
			aList.add(inRec);
			mChainMap.put(aKey, aList);
		}
		
		return aList;
	}
	
	private void mergeChainList(java.util.List inList1, java.util.List inList2, final int inRefID) {
		while (! inList2.isEmpty()) {
			SolverRecord aRec = (SolverRecord)inList2.remove(0);
			aRec.mQueueRef = inRefID;
			inList1.add(aRec);
		}

		mChainMap.put(new Integer(inRefID), inList1);
	}
	
	private void removeChainMap(SolverRecord inRec) {
		Integer aRefID = new Integer(inRec.mQueueRef);
		java.util.List aList = (java.util.List)mChainMap.get(aRefID);
		
		if (null == aList) return;
		
		aList.remove(inRec);
		
		if (mChainMap.size() > 1 && aList.isEmpty()) {
			// fꂽ
			throw new SoluteSeparatedException();
		}
	}
	
	private void updateSolverRecord(SolverRecord inRec) {
		if (isFinishedState(inRec.mState)) {
			return;
		}
		
		inRec.mValied = false;
		inRec.mMostPriority = false;
		
		int aSum =0;
		
		Point aOpposite = new Point();
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			aOpposite.setLocation(Integer.MIN_VALUE, Integer.MIN_VALUE);
			
			OppositeRecord aOppRec = inRec.mOpposite[i];
			if (isBuild(inRec.mPos, DIRECTIONS[i], aOpposite)) {
				SolverRecord aAgainstRec = getSolverRecord(aOpposite);
				
				if (null == aOppRec) {
					if (! isFinishedState(aAgainstRec.mState)) {
						initOppositeRecord(inRec, aAgainstRec, i);
					}
				}
				else {
					if (isDisableState(aOppRec.mState)) {
						if (isFinishedState(aAgainstRec.mState)) {
							inRec.mOpposite[i] = aOppRec = null;
							--inRec.mOppositeCount;
						}
						else {
							initOppositeRecord(inRec, aAgainstRec, i);
						}
					} 
					else if(isProcessState(aOppRec.mState)) {
						if (isFinishedState(aAgainstRec.mState)) {
							inRec.mResidue -= aOppRec.mCount;
							--inRec.mOppositeCount;
							
							aOppRec.mState = sFinishedState;
						}
					}
				}
			}
			else {
				if (null != aOppRec) {
					inRec.mOpposite[i] = aOppRec = null; 
					--inRec.mOppositeCount; 
				}
				
				continue;
			}
			
			SolverRecord aAgainstRec = getSolverRecord(aOpposite);
			
			if (null == aOppRec || isDisableState(aOppRec.mState)) continue;
			if (isFinishedState(aOppRec.mState)) continue;
			
			updateOppositeRecord(inRec, aAgainstRec, aOppRec);
			
			if (! isFinishedState(aOppRec.mState)) {
				aSum += aOppRec.mCount;
			}
		}
		
		if (aSum == inRec.mResidue
				|| 0 == inRec.mOppositeCount
				|| 0 == inRec.mResidue) 
		{
			finalizeOppositeRecordAll(inRec);
		}
	}
	
	private void finalizeOppositeRecordAll(SolverRecord inRec) {
		inRec.mResidue = 0;
		inRec.mState = sFinishedState;
				
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			finalizeOppositeRecord(inRec, i);
		}
		
		removeChainMap(inRec);
	}
	
	private void finalizeOppositeRecord(SolverRecord inRec, final int inIndex) {
		if (null != inRec.mOpposite[inIndex]) {
			// w肵ɉˋĂȂꍇ
			if (0 == inRec.mOpposite[inIndex].mCount) {
				// OppositeRecordˋsԂɑJڂ
				inRec.mOpposite[inIndex].mState = sBuildDisableState;
				
				inRec.mOpposite[inIndex] = null;
			}
			else if (isFinishedState(inRec.mOpposite[inIndex].mState)) {
				return;
			}
			
			--inRec.mOppositeCount;
		}
	}
	
	private void updateOppositeRecord(
						SolverRecord inRec, SolverRecord inAgainst, 
						OppositeRecord inOppRec) 
	{
		if (isFinishedState(inOppRec.mState)) return;
		
		if (NUM_PER_DIRECTION == inOppRec.mCount) {
			inOppRec.mState = sFinishedState;
			
			{
				inRec.mResidue -= inOppRec.mCount;
				--inRec.mOppositeCount;
				
				if (0 < inRec.mPenalty) inRec.mPenalty -= PENALTY_WEIGHT;
			}
			
			{
				inAgainst.mResidue -= inOppRec.mCount;
				--inAgainst.mOppositeCount;
				
				if (0 < inRec.mPenalty) inAgainst.mPenalty -= PENALTY_WEIGHT;
			}
		}
		else if (0 < inOppRec.mCount) {
			inOppRec.mState = sProcessingState;
		}
	}
	
	private void initOppositeRecord(
					SolverRecord inRec, SolverRecord inAgainst, 
					final int inIndex) 
	{
		Direction aInverse
			 = UtilityFuncs.inverseDirection(DIRECTIONS[inIndex]);
		final int aIndex = getDirectionToIndex(aInverse);
		
		OppositeRecord aOppRec = inAgainst.mOpposite[aIndex];
		
		if (null == aOppRec) {
			aOppRec = new OppositeRecord();
			
			inAgainst.mOpposite[aIndex] = aOppRec;
			++inAgainst.mOppositeCount;	
		}
		
		inRec.mOpposite[inIndex] = aOppRec;
		++inRec.mOppositeCount;	
	}
	
	private int getDirectionToIndex(Direction inDirection) {
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			if (DIRECTIONS[i] == inDirection) return i;
		}
		
		throw new IllegalArgumentException(
			"Direction, " + inDirection + "is illegal."
		);
	}
	
	private int getAroundMax(SolverRecord inRec, Point[] outAgainstPos) {
		int aSum = 0;
		
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			if (null == inRec.mOpposite[i]
					 || isFinishedState(inRec.mOpposite[i].mState))
			{
				continue;
			}
			
			Point aOpposite = new Point();
			if (isBuild(inRec.mPos, DIRECTIONS[i], aOpposite)) {
				SolverRecord aAgainstRec = getSolverRecord(aOpposite);
				
				aSum += aAgainstRec.mResidue;
				
				outAgainstPos[i] = aOpposite;
			}
		}
		
		return aSum;
	}
	
	private static class ProcessState implements State {
		public State onEnter(StateEventCode inEvent) {
			return this;
		}
	}
	
	private static class StartState implements State {
		public State onEnter(StateEventCode inEvent) {
			return this;
		}
	}
	
	private static class DisableState implements State {
		public State onEnter(StateEventCode inEvent) {
			return this;
		}
	}
	
	private static class FinishState implements State {
		public State onEnter(StateEventCode inEvent) {
			return this;
		}
	}

	private class HashikakeSolverPattern1 implements SolverPattern {
		public boolean build(SolverInfo inInfo) {
			final int aResidue = inInfo.mRec.mResidue;
			final int aOpposite = inInfo.mRec.mOppositeCount;
			int aNumPerDir = NUM_PER_DIRECTION - (aOpposite * NUM_PER_DIRECTION - aResidue);
			
			// creator̍쐬x[hłNUM_PER_DIRECTION傫Ȃ\
			// Ί݂ˋɂȂ̂h߁A{P{ɐ
			if (NUM_PER_DIRECTION < aNumPerDir) aNumPerDir = 1;
			
			boolean aRet = false;
			for (int i = 0; i < DIRECTIONS.length; ++i) {
				// w肵ɁAΊ݂Ȃꍇ
				if (null == inInfo.mRec.mOpposite[i]) continue;
				if (null == inInfo.mAroundPos[i]) continue;
				
				// P{ˋłȂꍇ
				if (0 >= aNumPerDir) continue;
				
				// Ɏw肵{ˋĂꍇ
				if (aNumPerDir <=  inInfo.mRec.mOpposite[i].mCount) continue;
				
				// Ί݂̎cȏɂȂȂ悤ɐ
				SolverRecord aAgainstRec = getSolverRecord(inInfo.mAroundPos[i]);
				if (aNumPerDir > aAgainstRec.mResidue) aNumPerDir = aAgainstRec.mResidue;
				
				aRet |= buildBridge(inInfo.mRec, aNumPerDir, i);
			}
			
			return aRet;
		}
	}
	
	private class HashikakeSolverPattern2 implements SolverPattern {
		public boolean build(SolverInfo inInfo) {
			boolean aRet = false;
			for (int i = 0; i < DIRECTIONS.length; ++i) {
				// w肵ɁAΊ݂Ȃꍇ
				if (null == inInfo.mRec.mOpposite[i]) continue;
				
				// Ɏw肵ɂP{ȏˋĂꍇ
				if (0 != inInfo.mRec.mOpposite[i].mCount) continue;
				
				SolverRecord aAgainstRec = getSolverRecord(inInfo.mAroundPos[i]);
				
				if ((inInfo.mAroundMax - aAgainstRec.mResidue < inInfo.mRec.mResidue)) {
					aRet |= buildBridge(inInfo.mRec, 1, i);
				}
			}
			
			return aRet;
		}
	}
	
	private class HashikakeSolverPattern3 implements SolverPattern {
		public boolean build(SolverInfo inInfo) {
			java.util.List aList = getChainList(inInfo.mRec);
			
			boolean aRet = false;
			for (int i = 0; i < DIRECTIONS.length; ++i) {
				// w肵ɁAΊ݂ȂꍇA܂͂ȏˋłȂꍇ
				if (null == inInfo.mAroundPos[i]) continue;
				
				SolverRecord aAgainstRec = getSolverRecord(inInfo.mAroundPos[i]);
				
				if (inInfo.mAroundMax - aAgainstRec.mResidue == inInfo.mRec.mResidue) {
					aRet |= attemptBuildLater(i, aList, inInfo);
				}
			}
			
			return aRet;
		}
	
		private boolean attemptBuildLater(
							final int inIndex, java.util.List inChainList, 
							SolverInfo inInfo) 
		{
			int aSum = 0;
			int aSize = 1; // 炩ߎgJEgĂ
			
			for (int i = 0; i < DIRECTIONS.length; ++i) {
				if (null != inInfo.mAroundPos[i] && i != inIndex) {
					
					SolverRecord aAgainstRec = getSolverRecord(inInfo.mAroundPos[i]);
					
					java.util.List aAgainstList = getChainList(aAgainstRec);
					
					if (inInfo.mRec.mQueueRef == aAgainstRec.mQueueRef
							 && inChainList.size() <= DIRECTIONS.length) 
					{
						// Ί݂ɘAĂꍇ
						++aSize;
						aSum += aAgainstRec.mResidue;
					}
					else if (aAgainstList.size() == 1) {
						aSum += aAgainstRec.mResidue;
					}
				}
			}
			
			if (inChainList.size() == aSize && aSum == inInfo.mRec.mResidue) {
				return buildBridge(inInfo.mRec, 1, inIndex);
			}	
			
			return false;
		}
	}
	
	private class HashikakeSolverPattern4 implements SolverPattern {
		public boolean build(SolverInfo inInfo) {
			boolean aRet = false;
			
			int aSum = getEffectiveAroundMax(inInfo);
			int aResidue = inInfo.mRec.mResidue;
			
			for (int i = 0; i < DIRECTIONS.length; ++i) {
				if (null == inInfo.mAroundPos[i]) continue;
				
				SolverRecord aAgainstRec = getSolverRecord(inInfo.mAroundPos[i]);
				
				int aCount = aAgainstRec.mMaxBuildCount;

				for (int j = 0; j < DIRECTIONS.length; ++j) {
					if (null == aAgainstRec.mOpposite[j]) continue;
					 
					if (inInfo.mRec.mOpposite[i] != aAgainstRec.mOpposite[j]) {
						aCount -= aAgainstRec.mOpposite[j].mCount;
					}
				}
				
				// Pɓn鋴̖{ő NUM_PER_DIRECTION {ɐ
				if (aCount > NUM_PER_DIRECTION) aCount = NUM_PER_DIRECTION;
				
				if (aSum - aCount < aResidue) {
					if (0 == inInfo.mRec.mOpposite[i].mCount) {
						aRet |= buildBridge(inInfo.mRec, 1, i);
						--aSum;
						--aResidue;
					}
				}
			}
			
			return aRet;
		}

		private int getEffectiveAroundMax(SolverInfo inInfo) {
			int aSum = 0;
			
			// ̓ۂɓnƂ̏o鋴̑Zo
			for (int i = 0; i < DIRECTIONS.length; ++i) {
				if (null == inInfo.mAroundPos[i]) continue;
				
				SolverRecord aAgainstRec = getSolverRecord(inInfo.mAroundPos[i]);
				
				int aCount = aAgainstRec.mMaxBuildCount;

				for (int j = 0; j < DIRECTIONS.length; ++j) {
					if (null != aAgainstRec.mOpposite[j] 
							&& inInfo.mRec.mOpposite[i] != aAgainstRec.mOpposite[j])
					{
						aCount -= aAgainstRec.mOpposite[j].mCount;
					}
				}
				// Pɓn鋴̖{ő NUM_PER_DIRECTION {ɐ
				if (aCount > NUM_PER_DIRECTION) aCount = NUM_PER_DIRECTION;

				aSum += aCount;
			}
			
			return aSum;
		}
	}
	
	private class HashikakeSolverPattern5 implements SolverPattern {
		public boolean build(SolverInfo inInfo) {
			boolean aRet = false;
			
			SolverRecord aRec = inInfo.mRec;
			final int aOverCount = aRec.mOppositeCount * NUM_PER_DIRECTION - aRec.mResidue;
			
			if (aRec.mOppositeCount > 2
					&& (aOverCount >= NUM_PER_DIRECTION && aOverCount < 2 * NUM_PER_DIRECTION))
			{
				Point aDiagonalPos = new Point();
				for (int i = 0; i < DIAGONAL.length; ++i) {
					if (! isBuildDiagonal(aRec, DIAGONAL[i], aDiagonalPos)) continue;
					
					Direction aInverse = UtilityFuncs.inverseDirection(DIAGONAL[i]);
					Direction[] aUnit = UtilityFuncs.getUnitDirection(aInverse);
					
					// ɑΊ݂̏XVĂ
					SolverRecord aAdjacentRec = getSolverRecord(aDiagonalPos);
					updateSolverRecord(aAdjacentRec);
					
					if (isBuildForExceptsAround(aAdjacentRec, aUnit[0], aUnit[1])) continue;
					
					for (int j = 0; j < DIRECTIONS.length; ++j) {
						if (DIRECTIONS[j] == aUnit[0] || DIRECTIONS[j] == aUnit[1]) {
							aRet |= buildBridge(aRec, 1, j);
						}
					}
				}
			}
			
			return aRet;
		}
		
		private boolean isBuildDiagonal(SolverRecord inRecord, Direction inDiagonal, Point outDiagonalPos) {
			Point aDiff = inDiagonal.getDifference();
			Point aPos = new Point(aDiff.x+inRecord.mPos.x, aDiff.y+inRecord.mPos.y);
			if (! mModel.isNumberAt(aPos.x, aPos.y)) return false;
			
			// evfɂP{ł˂邱ƂłȂꍇAˋsłƔf
			Direction[] aUnit = UtilityFuncs.getUnitDirection(inDiagonal);
			
			int aBuilt = 0;
			boolean aBuildable = true;
			for (int j = 0; j < DIRECTIONS.length; ++j) {
				if (DIRECTIONS[j] == aUnit[0] || DIRECTIONS[j] == aUnit[1]) {
					if (null == inRecord.mOpposite[j]) {
						aBuildable = false;
					}
				}
				else {
					if (null != inRecord.mOpposite[j]) {
						if (0 < inRecord.mOpposite[j].mCount) ++aBuilt;
					}
				}
			}
			
			outDiagonalPos.setLocation(aPos);
			
			return (! aBuildable || aUnit.length == aBuilt ? false : true);
		}
		
		/**
		 *	w肵ŁAˋ\ǂ`FbN
		 */
		private boolean isBuildForExceptsAround(SolverRecord inRecord, Direction inExcepts1, Direction inExcepts2) {
			if (inRecord.mOppositeCount == 0) return true;
			
			int aSum = 0;
			Point aAround = new Point();
			
			// w肵ɓnƂ̏o鋴̑Zo
			for (int i = 0; i < DIRECTIONS.length; ++i) {
				if (inExcepts1 == DIRECTIONS[i] || inExcepts2 == DIRECTIONS[i]) continue;
				if (! isBuild(inRecord.mPos, DIRECTIONS[i], aAround)) continue;
				
				SolverRecord aAgainstRec = getSolverRecord(aAround);
				
				aSum += (aAgainstRec.mResidue > NUM_PER_DIRECTION ? NUM_PER_DIRECTION : aAgainstRec.mResidue);
			}
			
			return (aSum >= inRecord.mResidue);
		}
	}
	
	private class BuildChainMap {
		private java.util.Map mChainMap;
		
		/**
		 *	w肵SolverRecordList擾
		 */
		public java.util.List getChainList(SolverRecord inRec) {
			Integer aKey = new Integer(inRec.mQueueRef);
		
			java.util.List aList = (java.util.List)mChainMap.get(aKey);
			if (null == aList) {
				aList = new java.util.LinkedList();
				aList.add(inRec);
				mChainMap.put(aKey, aList);
			}
			
			return aList;
		}
		
		public void addSolverRecordPair(SolverRecord inRec, SolverRecord inAgainstRec) {
			if (inRec.mQueueRef == inAgainstRec.mQueueRef) return;
			
			java.util.List aList = getChainList(inRec);
			java.util.List aAgainstList = getChainList(inAgainstRec);
			
			Integer aRemoveRefID;
			if (inRec.mQueueRef < inAgainstRec.mQueueRef) {
				aRemoveRefID = new Integer(inAgainstRec.mQueueRef);
				mergeChainList(aList, aAgainstList, inRec.mQueueRef);
			}
			else {
				aRemoveRefID = new Integer(inRec.mQueueRef);
				mergeChainList(aAgainstList, aList, inAgainstRec.mQueueRef);
			}
			
			mChainMap.remove(aRemoveRefID);
		}
		
		/**
		 *	queue referencȅListmarge
		 *	margȇΏۂ͊eXListŜɑ΂Ăł
		 */
		private void mergeChainList(java.util.List inList1, java.util.List inList2, final int inRefID) {
			while (! inList2.isEmpty()) {
				SolverRecord aRec = (SolverRecord)inList2.remove(0);
				aRec.mQueueRef = inRefID;
				inList1.add(aRec);
			}
			
			mChainMap.put(new Integer(inRefID), inList1);
		}
		
		public void removeSolverRecord(SolverRecord inRec) {
			Integer aRefID = new Integer(inRec.mQueueRef);
			java.util.List aList = (java.util.List)mChainMap.get(aRefID);
			
			if (null == aList) return;
			
			aList.remove(inRec);
			
			if (mChainMap.size() > 1 && aList.isEmpty()) {
				throw new IllegalStateException(
					"The building bridge has separated."
				);
			}		
		}
	}
	
	private class SolverRecordComparator implements java.util.Comparator {
		private Point[] mTemp = new Point[DIRECTIONS.length];
		
		public int compare(Object inLHS, Object inRHS) {
			if (inLHS.equals(inRHS)) return 0;
			
			SolverRecord aLHS = (SolverRecord)inLHS;
			SolverRecord aRHS = (SolverRecord)inRHS;
			
			final int aLScore = aLHS.mOppositeCount * NUM_PER_DIRECTION - aLHS.mResidue + aLHS.mPenalty;
			final int aRScore = aRHS.mOppositeCount * NUM_PER_DIRECTION - aRHS.mResidue + aRHS.mPenalty;
			
			if (aLScore >= NUM_PER_DIRECTION && aRScore >= NUM_PER_DIRECTION) {
				if (valiedPriority(aLHS)) return 1;
				if (valiedPriority(aRHS)) return -1;
			}
			
			if (aLScore == aRScore) {
//				if (aLHS.mResidue == aRHS.mResidue) return 0;
				return (aLHS.mResidue < aRHS.mResidue ? -1 : +1);
			}
			
			return (aLScore > aRScore ? -1 : +1);
		}
		
		private boolean valiedPriority(SolverRecord inRec) {
			if (! inRec.mValied) {
				Point[] aAroundPos = mTemp;
				final int aSum = getAroundMax(inRec, aAroundPos);
				
				inRec.mValied = true;
				for (int i = 0; i < aAroundPos.length; ++i) {
					if (null == aAroundPos[i]) continue;
					
					SolverRecord aAdjacent = getSolverRecord(aAroundPos[i]);
					
					aAroundPos[i] = null;
					if (aSum - aAdjacent.mResidue <= inRec.mResidue) {
						inRec.mMostPriority = true;
						break;
					}
				}
			}
			
			return inRec.mMostPriority;
		}
	}	
}