// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		BoardModel.java
//	DATE:		2003.5.25
//	CREATO:		Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.creator.model;

import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.NullState;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;


/**
 *	Ֆʂ̏ԂǗ邽߂Model
 */
public class BoardModel extends AbstractDecoratedModel {
	private static class Cell {
		State mState;
		
		Cell() {
			reset();
		}
		
		void reset() {
			mState = StateManager.getInstance().createDefaultState();
		}
		
		boolean isSpace() {
			return StateManager.getInstance().isSpaceState(mState);
		}
		
		boolean isNumber() {
			return StateManager.getInstance().isNumberState(mState);
		}
		
		State getCurState() {
			return mState;
		}
		
		void setCurState(State inState) {
			mState = inState;
		}
		
		void setCurState(String inStateID) {
			mState = StateManager.getInstance().createStateOf(inStateID);
		}
	}
	
	private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
	private static final Direction[] DIRECTIONS = {
		Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, 
	};
	
	private static final State NULL_STATE = new NullState();
	
	private Cell[] mCells;
	private int mWidth;
	private int mHeight;
	
	private java.util.Set mLastModified = new java.util.HashSet();
	/**
	 *	w肳ꂽTCỸ{[h쐬
	 *
	 *	@param	inWidth	̌
	 *	@param	inHeight	č
	 */
	public void createBoardSelf(final int inWidth, final int inHeight) {
		mWidth = inWidth;
		mHeight = inHeight;
		
		mCells = new Cell[inWidth*inHeight];

		for (int y = 0; y < mHeight; ++y) {
			for (int x = 0; x < mWidth; ++x) {
				mCells[toIndex(x, y)] = new Cell();
				mLastModified.add(new Point(x, y));
			}
		}
	}
	
	private int toIndex(final int inX, final int inY) {
		return inY*mWidth + inX;
	}
	
	/**
	 *	ݒ肷B
	 *
	 * 	@param	inProblem	̏
	 *
	 *	@return	ǂ݂񂾗vf
	 */
	public int setProblem(ProblemInfo inProblem) {
		// ̏ƃTCYقȂĂ΃{[h쐬ȂB
		if (mWidth != inProblem.getWidth() || mHeight != inProblem.getHeight()) {
			createBoard(inProblem.getWidth(), inProblem.getHeight());
		}
		
		for (int y = 0, i = 0; y < mHeight; ++y) {
			for (int x = 0; x < mWidth; ++x) {
				getCellAt(x, y).setCurState((String)inProblem.getRecordAt(i++));
				mLastModified.add(new Point(x, y));
			}
		}
		
		return mCells.length;
	}
	
	/**
	 *	݂̏Ԃǂ`FbN
	 *
	 *	@deprecated 쐬check\bh͌KvƂĂȂB
	 *	@return false
	 */
	public boolean check() {
		return false;
	}
	
	/**
	 *	Ԃɖ߂
	 */
	public void reset() {
		for (int y = 0; y < mHeight; ++y) {
			for (int x = 0; x < mWidth; ++x) {
				resetAtSelf(x, y);
			}
		}
	}
	
	protected void resetAtSelf(final int inX, final int inY) {
		if (! isSpaceAt(inX, inY)) {
			getCellAt(inX, inY).reset();
			mLastModified.add(new Point(inX, inY));
		}
	}
	
	/**
	 *	@return {[h̃TCYԂ 
	 */
	public java.awt.Dimension getSize() {
		return new java.awt.Dimension(mWidth, mHeight);
	}
	
	/**
	 *	@return {[h̕Ԃ 
	 */
	public int getWidth() {
		return mWidth;
	}
	
	/**
	 *	@return {[h̍Ԃ 
	 */
	public int getHeight() {
		return mHeight;
	}
	
	/**
	 *	w肳ꂽʒu̖ʂ̏ԂԂB
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@return 
	 */
	public State getCurStateAt(final int inX, final int inY) {
		return getCellAt(inX, inY).getCurState();
	}
	
	/**
	 *	w肳ꂽʒu̖ʂ̐ԂB
	 *	͎xȂ̂ŁÅmF͕KvȂ
	 *	̎ł́A
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@return ̏
	 */	
	public State getCorrectStateAt(final int inX, final int inY) {
		return NULL_STATE;
	}
	
	/**
	 *	w肳ꂽStateEventCodẽfŏł邩ǂ`FbNB
	 *
	 *	@param	inCode`FbNStateEventCode
	 *	@return	̃fŏł̂ł΁AtrueԂ
	 */
	public boolean isAcceptableEvent(StateEventCode inCode) {
		if (inCode == HashikakeStateEventCode.createSpaceCode()) return true;
		
		try {
			final int aVal = Integer.parseInt(inCode.getValue());
			if (aVal > 0 && aVal < 9) return true;
		}
		catch (NumberFormatException e) {
		}
		
		return false;
	}
	
	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1i߂
	 *	̎ł́AȂ
	 *	ʏnextStateAt(int, int, StateEventCode)gpB
	 * 
	 *	@param	inX	XW
	 *	@param	inY	YW
	 */
	public void nextStateAt(final int inX, final int inY) {
	}

	/**
	 *	w肵Ֆʂ̈ʒȕԂɑJڂB
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	protected void nextStateAtSelf(final int inX, final int inY, StateEventCode inCode) {
		if (inCode != HashikakeStateEventCode.createSpaceCode()) {
			if (! checkSpaceForNeighborAt(inX, inY)) return;
		}
		
		// ՊOȂJڂȂ
		if (! contains(inX, inY)) return;
		
		// JڂłȂꍇ
		if (! isTransitAt(inX, inY, inCode)) return;
		
		State aState = getCurStateAt(inX, inY);
		
		aState = StateManager.getInstance().getNextState(aState, inCode);
		getCellAt(inX, inY).setCurState(aState);
		
		mLastModified.add(new Point(inX, inY));
	}
	
	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1߂ 
	 *	̎ł́AȂ
	 *	ʏprevStateAt(int, int, StateEventCode)gpB
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 */
	public void prevStateAt(final int inX, final int inY) {
	}
	
	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1߂
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	protected void prevStateAtSelf(final int inX, final int inY, StateEventCode inCode) {
		if (inCode != HashikakeStateEventCode.createSpaceCode()) {
			if (! checkSpaceForNeighborAt(inX, inY)) return; 
		}
		
		State aState = getCurStateAt(inX, inY);
		
		aState = StateManager.getInstance().getPrevState(aState, inCode);
		getCellAt(inX, inY).setCurState(aState);
		
		mLastModified.add(new Point(inX, inY));
	}
	
	/**
	 *	אڂZɊɐĂȂ`FbN
	 *	
	 *	@param	inX SXWiBoardWnj
	 *	@param	inX SYWiBoardWnj
	 *	@return	4͂1ĂȂȂAtrueԂB
	 */
	private boolean checkSpaceForNeighborAt(final int inX, final int inY) {
		StateManager aManager = StateManager.getInstance();
		
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			Point aPos = new Point(inX, inY);
			Point aDiff = DIRECTIONS[i].getDifference();
			aPos.translate(aDiff.x, aDiff.y);
			
			if (! contains(aPos.x, aPos.y)) continue;
			
			State aState = getCellAt(aPos.x, aPos.y).getCurState();
			if (! aManager.isSpaceState(aState)) return false;
		}
		
		return true;
	}
	
	/** 
	 *	@return ŌɏCʂ̈ʒuԂ
	 */
	protected Point[] lastModifiedSelf() {
		return (Point[])mLastModified.toArray(new Point[mLastModified.size()]);
	}
	
	/**
	 *	w肳ꂽʒu{[ḧǂׂ 
	 *
	 *	@param	inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@return	{[ḧȂtrue
	 */
	public boolean contains(final int inX, final int inY) {
		if (inX >= mWidth || inX < 0 || inY >= mHeight || inY < 0) {
			return false;
		}
		
		return true;
	}
	
	private Cell getCellAt(final int inX, final int inY) {
		if (inX > mWidth || inX < 0 || inY > mHeight || inY < 0) {
			throw new IllegalArgumentException(
					"Must be 0 <= inX < " + mWidth + ", 0 <= inY < " + mHeight 
					+" (was inX = " + inX + ", inY = " + inY + ")"
			);
		}

		return mCells[toIndex(inX, inY)];
	}
	
	/**
	 *	w肳ꂽʒu̖ʂǂׂ 
	 *	̎ł́AՖʊȌꍇfalseԂ
	 *
	 *	@param	inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@return	Ȃtrue
	 */
	public boolean isNumberAt(final int inX, final int inY) {
		if (! contains(inX, inY)) return false;
		
		return getCellAt(inX, inY).isNumber();
	}
	
	/**
	 *	w肳ꂽʒu̖ʂ󔒂ǂׂB
	 *	̎ł́AՖʊȌꍇfalseԂ
	 *
	 *	@param inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@return	󔒂Ȃtrue
	 */
	public boolean isSpaceAt(final int inX, final int inY) {
		if (! contains(inX, inY)) return false;
		
		return getCellAt(inX, inY).isSpace();
	}

	/**
	 *	w肳ꂽʒu̖ʂJڂł邩ǂׂB
	 *	̎ł͎gpAisTransitAt(int, int, StateEventCode)gpB
	 *
	 *	@param inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@return	false
	 */
	public boolean isTransitAt(final int inX, final int inY) {
		return false;
	}

	/**
	 *	w肳ꂽʒu̖ʂJڂł邩ǂׂB
	 *	Jڂ܂Ŋł邩ǂׂB
	 *	̎ł́Aאڂ4͂̂ȂƂ1̃ZɐĂꍇAfalseԂB
	 *
	 *	@param	inCode JڂɊւl
	 *	@param inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@return	Jڂł̂łtrueԂB
	 */
	public boolean isTransitAt(final int inX, final int inY, StateEventCode inCode) {
		if (! checkSpaceForNeighborAt(inX, inY)) return false;
		
		State aState = getCurStateAt(inX, inY);
	
		return StateManager.getInstance().isTransit(aState, inCode);
	}

	/**
	 *	ModelύXꂽǂ𒲂ׂB
	 *
	 *	@return	ύXĂtrueԂB
	 */
	protected boolean isModifiedSelf() {
		return (mLastModified.size() > 0);
	}
	
	/**
	 *	Model̕ύXNA
	 */
	protected void flushSelf() {
		mLastModified = new java.util.HashSet();
	}
}

