// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:			OpenProblemDialog.java
//	DATE:			2003.6.2	initial version
//	CREATOR:		Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.util.gui;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.TextUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ProblemUnmarshalable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;

import jp.gr.java_conf.ktz.puzzle.hashikake.io.ProblemReader;
import jp.gr.java_conf.ktz.puzzle.hashikake.io.XMLProblemReader;

/**
 *	蕶ǂݍނ߂̃_CAO\
 */
public class OpenProblemDialog extends javax.swing.JFrame {
	private ProblemUnmarshalable mLoadOwner;
	
	private ProblemReader mReader = new XMLProblemReader();
	private javax.swing.JList mList;
	private javax.swing.JLabel mPathLabel;
	private java.io.File mCurPath = new java.io.File(new java.io.File("problem").getAbsolutePath());
	
	private static class InitHolder {
		static OpenProblemDialog sDialog;
		
		static {
			sDialog = new OpenProblemDialog();
			sDialog.init();
			sDialog.toCenter();
		}
	}
	
	public static void showLoadDialog() {
		// ݃ANeBuȃt[I[i[Ƃ
		showLoadDialog((ProblemUnmarshalable)ComponentUsher.getInstance().getActiveComponent());
	}
	
	public static void showLoadDialog(ProblemUnmarshalable inOwner) {
		InitHolder.sDialog.setLoadOwner(inOwner);
		InitHolder.sDialog.show();
	}
	
	void init() {
		setTitle("Open Problem");
		java.awt.Container aPane = getContentPane();
		
		javax.swing.JPanel aPathPanel = new javax.swing.JPanel();
		aPane.add(aPathPanel, java.awt.BorderLayout.NORTH);
		aPathPanel.setPreferredSize(new java.awt.Dimension(250, 45));
		aPathPanel.setBackground(java.awt.Color.white);
		
		javax.swing.JPanel aPanel = new javax.swing.JPanel();
		aPane.add(aPanel, java.awt.BorderLayout.CENTER);
		aPanel.setPreferredSize(new java.awt.Dimension(250, 190));
		aPanel.setBackground(java.awt.Color.white);
		
		setResizable(false);
		pack();
		
		javax.swing.SpringLayout aLayout = new javax.swing.SpringLayout();
		
		aPathPanel.setLayout(aLayout);
		
		mPathLabel = new javax.swing.JLabel(mCurPath.getAbsolutePath());
		mPathLabel.setSize(210, 35);
		mPathLabel.setBorder(new javax.swing.border.TitledBorder("File path"));
		aPathPanel.add(mPathLabel, new javax.swing.SpringLayout.Constraints(
				javax.swing.Spring.constant(5), 
				javax.swing.Spring.constant(5), 
				javax.swing.Spring.constant(210), 
				javax.swing.Spring.constant(35)
		));
		
		java.awt.Insets aInsets = mPathLabel.getInsets();
		final int aWidth = mPathLabel.getWidth() - aInsets.left - aInsets.right;
		String aText = TextUtility.truncText(
					mPathLabel.getFontMetrics(mPathLabel.getFont()), aWidth, 
					mCurPath.getAbsolutePath(), TextUtility.TRUNC_MIDDLE);
		mPathLabel.setText(aText);
					

		javax.swing.JButton aChangePath = new javax.swing.JButton("...");
		aChangePath.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent inEvent) {
				if (! mCurPath.isDirectory()) {
					mCurPath = new java.io.File(mCurPath.getParent());
				}
				
				javax.swing.JFileChooser aChooser
						 = new javax.swing.JFileChooser(mCurPath);
				
				// FileFilterZbg	 
				aChooser.setFileFilter(new javax.swing.filechooser.FileFilter() 
				{
					public boolean accept(java.io.File inFile) {
						if (inFile.isDirectory()) return true;
						
						final int aIndex = inFile.getName().toLowerCase().indexOf(".xml");

						return (0 < aIndex) ? true : false;
					}
					
					public String getDescription() {
						return "XML file (version 1.0)";
					}
				});		
				
				final int aSel = aChooser.showOpenDialog(OpenProblemDialog.this);
				
				if (aSel == javax.swing.JFileChooser.APPROVE_OPTION) {
					mCurPath = aChooser.getSelectedFile();
					
					java.awt.Insets aInsets = mPathLabel.getInsets();
					final int aWidth = mPathLabel.getWidth() - aInsets.left - aInsets.right;
					
					String aText = TextUtility.truncText(
							mPathLabel.getFontMetrics(mPathLabel.getFont()), aWidth, 
							mCurPath.getAbsolutePath(), TextUtility.TRUNC_MIDDLE);
							
					mPathLabel.setText(aText);
				}
			}
		});
		aPathPanel.add(aChangePath, new javax.swing.SpringLayout.Constraints(
				javax.swing.Spring.constant(225), 
				javax.swing.Spring.constant(15), 
				javax.swing.Spring.constant(20), 
				javax.swing.Spring.constant(20)
		));
		
		
		aPanel.setLayout(aLayout);
		
		mList = new javax.swing.JList();
		mList.setCellRenderer(new javax.swing.DefaultListCellRenderer() {
		    public java.awt.Component getListCellRendererComponent(
		        javax.swing.JList list,
				Object value,
		        int index,
		        boolean isSelected,
		        boolean cellHasFocus)
			{
				setComponentOrientation(list.getComponentOrientation());
				if (isSelected) {
				    setBackground(list.getSelectionBackground());
				    setForeground(list.getSelectionForeground());
				}
				else {
				    setBackground(list.getBackground());
				    setForeground(list.getForeground());
				}
				
				ProblemInfo aInfo = (ProblemInfo)value;
				setText("Q. " + (index+1) + " (" + aInfo.getWidth() + " X " + aInfo.getHeight() + ")");
		
				setEnabled(list.isEnabled());
				setFont(list.getFont());
				setBorder((cellHasFocus)
					 ? javax.swing.UIManager.getBorder("List.focusCellHighlightBorder")
					 : noFocusBorder
				);

				return this;			
			}
		});
		
		// Listɂă}EX̃_uNbNF邽߂MouseListner
		mList.addMouseListener(new MouseListener() {
			public void mouseClicked(MouseEvent inEvent) {
				if (2 != inEvent.getClickCount()) return;
				
				final int aIndex = mList.locationToIndex(inEvent.getPoint());
				
				if (aIndex < 0) return;
				
				setVisible(false);
				ProblemInfo aInfo = mReader.getProblemAt(aIndex);
				mLoadOwner.loadProblem(mCurPath, aInfo);
			}
			
			public void mousePressed(MouseEvent inEvent) {}
			public void mouseReleased(MouseEvent inEvent) {}
			public void mouseEntered(MouseEvent inEvent) {}
			public void mouseExited(MouseEvent inEvent) {}
		});
		
		aPanel.add(
			new javax.swing.JScrollPane(mList, 
				javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, 
				javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_NEVER
			), 
			new javax.swing.SpringLayout.Constraints(
				javax.swing.Spring.constant(5), 
				javax.swing.Spring.constant(5), 
				javax.swing.Spring.constant(150), 
				javax.swing.Spring.constant(180)
		));
		
		javax.swing.JButton aLoad = new javax.swing.JButton("Load");
		aLoad.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent inEvent) {
				if (mPathLabel.getText().equals("")) return;
				
				try {
					mReader.load(new java.io.File(mCurPath.getAbsolutePath()));
					ProblemInfo[] aInfos = mReader.getAllProblems();
					mList.setListData(aInfos);
				}
				catch (java.io.FileNotFoundException e) {
				}
				catch (java.io.IOException e) {
					System.out.println("the specified file is not a problem file");
					
					// List̕\
					mList.setListData(new ProblemInfo[0]);
				}
			}
		});
		aPanel.add(aLoad, new javax.swing.SpringLayout.Constraints(
				javax.swing.Spring.constant(165), 
				javax.swing.Spring.constant(10), 
				javax.swing.Spring.constant(75), 
				javax.swing.Spring.constant(25)
		));
		
		javax.swing.JButton aOK = new javax.swing.JButton("OK");
		aOK.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent inEvent) {
				final int aIndex = mList.getSelectedIndex();
				
				if (aIndex < 0) return;
				
				setVisible(false);
				ProblemInfo aInfo = mReader.getProblemAt(aIndex);
				mLoadOwner.loadProblem(mCurPath, aInfo);
			}
		});
		aPanel.add(aOK, new javax.swing.SpringLayout.Constraints(
				javax.swing.Spring.constant(165), 
				javax.swing.Spring.constant(45), 
				javax.swing.Spring.constant(75), 
				javax.swing.Spring.constant(25)
		));

		javax.swing.JButton aCancel = new javax.swing.JButton("Cancel");
		aCancel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent inEvent) {
				OpenProblemDialog.this.setLoadOwner(null);
				OpenProblemDialog.this.setVisible(false);
			}
		});
		aPanel.add(aCancel, new javax.swing.SpringLayout.Constraints(
				javax.swing.Spring.constant(165), 
				javax.swing.Spring.constant(75), 
				javax.swing.Spring.constant(75), 
				javax.swing.Spring.constant(25)
		));
		
	}
		
	void toCenter() {
		GUIUtility.LayoutToCenter(this);
	}
	
	public void show() {
		
		// _CAOʂ̒S
		toCenter();
		
		super.show();
	}
	
	private void setLoadOwner(ProblemUnmarshalable inLoader) {
		mLoadOwner = inLoader;
	}
	
	private OpenProblemDialog() {
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent inEvent) {
				OpenProblemDialog.this.setVisible(false);
			}
		});
	}
}

