//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		Main.java
//	DATE:		2003.7.11
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.solver;

import java.awt.Frame;
import java.awt.Button;
import java.awt.BorderLayout;
import java.awt.FlowLayout;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.Board;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.command.NextCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.command.NextAllCommand;

import jp.gr.java_conf.ktz.puzzle.hashikake.command.ResetCommand;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.OpenProblemDialog;

public class Main {
	private static Board sBoard;
	
	public static void main(String[] inArgs) {
		StateManager.initialize(new HashikakeStateManagerImpl());
		Frame aFrame = new Frame();
		aFrame.addWindowListener(new WindowListener() {
			public void windowClosing(WindowEvent inEvent) {
					System.exit(0);
			}
			
			public void windowActivated(WindowEvent inEvent) {}
			public void windowOpened(WindowEvent inEvent) {}
			public void windowClosed(WindowEvent inEvent) {}
			public void windowDeactivated(WindowEvent inEvent) {}
			public void windowDeiconified(WindowEvent inEvent) {}
			public void windowIconified(WindowEvent inEvent) {}		
		});
		
		java.awt.Panel aPanel = new java.awt.Panel();
		aFrame.add(aPanel, BorderLayout.NORTH);
		
		Button aButton;
		
		aButton = new Button("Clear");
		aButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent inEvent) {
				sBoard.processCommand(new ResetCommand(sBoard));
				sBoard.repaint();
			}
		});
		aPanel.add(aButton, FlowLayout.LEFT);
		
		aButton = new Button("next");
		aButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent inEvent) {
				sBoard.processCommand(new NextCommand(sBoard));
				sBoard.repaint();
			}
		});
		aPanel.add(aButton, FlowLayout.LEFT);

		aButton = new Button("nextAll");
		aButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent inEvent) {
				sBoard.processCommand(new NextAllCommand(sBoard));
				sBoard.repaint();
			}
		});
		aPanel.add(aButton, FlowLayout.LEFT);

		aButton = new Button("load");
		aButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent inEvent) {
				OpenProblemDialog.showLoadDialog(sBoard);
				sBoard.repaint();
			}
		});
		aPanel.add(aButton, FlowLayout.LEFT);

		sBoard = new Board();
		sBoard.initialize();
		aFrame.add(sBoard, BorderLayout.CENTER);
		
		// 
/*
		String aProblem = 
					 "s, s, 2, s, s, "
					+"s, s, s, s, s, "
					+"2, s, 8, s, 2, "
					+"s, s, s, s, s, "
					+"s, s, 2, s, s";
		final int aWidth = 5;
		final int aHeight = 5;
*/

		String aProblem = "3,s,s,s,1,s,3,s,3,s,s,2,s,s,3,s,s,s,3,s,s,s,2,s,2,s,s,s,s,s,s,s,4,s,s,6,3,s,4,s,8,s,s,3,s,s,1,s,3,s,2,s,s,s,3,s,3,s,2,s,s,1,s,s,s,s,4,s,5,s,s,3,3,s,5,s,3,s,s,2,s";
		final int aWidth = 9;
		final int aHeight = 9;
		
		sBoard.load(new ProblemInfo(aWidth, aHeight, aProblem.split(",")));
		
		aFrame.pack();
		aFrame.show();
	}
}