// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BoardScroller.java
//	DATE:		2003.5.27
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.creator.view;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.ScrollPane;

import java.awt.Component;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import java.awt.event.AdjustmentEvent;

import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardContainer;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.Command;

import jp.gr.java_conf.ktz.puzzle.hashikake.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.PieceSizeCommand;

/**
 *	Ֆʂ̃XN[tbNNX
 */
class BoardScroller extends BoardContainer {
	/**
	 *	RXgN^
	 *
	 *	@param	inContainer	R|[lg
	 */
	BoardScroller(java.awt.Container inContainer) {
		super(inContainer);
	}
	
	/**
	 *	View
	 */
	protected void initializeSelf() {

		Board aBoard = new Board();
		addBoard(aBoard);
	}
	
	/**
	 *	Board1s[X̃TCYZbg
	 *
	 *	@param	inSize ZTCY
	 */
	private int setPieceSize(final int inSize) {
		// Scroller̃XN[ʂύX
		
		ScrollPane aPane = (ScrollPane)getComponent();
		
		aPane.getHAdjustable().setUnitIncrement(inSize);
		aPane.getVAdjustable().setUnitIncrement(inSize);
		
		return inSize;
	}
	
	/**
	 *	R|[lg̃TCYύX
	 *	ƂēnĺAsubcomponent̃TCYłB
	 *	
	 *	@param	inWidth		subcomponent̕
	 *	@param	inHeight	subcomponent̍
	 *	@return	component̃TCY
	 */
	private void setComponentSize(
			final int inWidth, final int inHeight, 
			BoardSizeCommand ioCommand) 
	{
		ScrollPane aPane = (ScrollPane)getComponent();
		final int aHHeight = aPane.getHScrollbarHeight();
		final int aVWidth = aPane.getVScrollbarWidth();
		
		int aWidth = inWidth + aVWidth;
		int aHeight = inHeight + aHHeight;

		aPane.invalidate();		
		aPane.setSize(aWidth, aHeight);
		
		// TCYXN[o[̕傫w肵āACommand]
		ioCommand.setSize(aWidth, aHeight);
	}
	
	/**
	 *	J[\L[ɂXN[s
	 */
	public void processKeyScroll(KeyScrollEvent inEvent) {
		ScrollPane aPane = (ScrollPane)getComponent();
		
		java.awt.Insets aInsets = aPane.getInsets();
		Rectangle aViewBounds = new Rectangle(aPane.getViewportSize());
		aViewBounds.grow(1, 1);

/*
		System.out.println();
		System.out.println("piece : " + inEvent.mBounds);
		System.out.println("view : " + aViewBounds);
		System.out.println("bounds : " + aPane.getComponentAt(24,24).getLocation());
		System.out.println("scr-pos : " + aPane.getScrollPosition());
		System.out.println("scr-max : " + aPane.getHAdjustable().getMaximum());
*/

		if (aViewBounds.contains(inEvent.mBounds)) return;
		
		
		final int aVUnit = aPane.getVAdjustable().getUnitIncrement();
		final int aHUnit = aPane.getHAdjustable().getUnitIncrement();
		
		java.awt.Point aDiff = inEvent.mDirection.getDifference();
//		System.out.println("diff : " + aDiff);
		
		java.awt.Point aPos = aPane.getScrollPosition();
		aPane.setScrollPosition(aPos.x + aDiff.x*aHUnit, aPos.y+aDiff.y*aVUnit);
		
		
		
		repaint();
	}
	
	private static int toAdjustmentEventType(Direction inDirection) {
		if (inDirection == Direction.EAST || inDirection == Direction.SOUTH) {
			return AdjustmentEvent.UNIT_INCREMENT;
		}
		else if (inDirection == Direction.WEST || inDirection == Direction.NORTH) {
			return AdjustmentEvent.UNIT_DECREMENT;
		}
		
		return -1;
	}

	/**
	 *	Command̎
	 *
	 *	@param	inCommand	Command
	 */
	protected void processCommandImpl(Command inCommand) {
		final Class aClass = inCommand.getClass();
		
		if (aClass == PieceSizeCommand.class) {
			final int aSize = ((PieceSizeCommand)inCommand).getPieceSize();
			setPieceSize(aSize);
			inCommand.consume();
		}
		else if (aClass == BoardSizeCommand.class) {
			final int aWidth = ((BoardSizeCommand)inCommand).getWidth();
			final int aHeight = ((BoardSizeCommand)inCommand).getHeight();
			setComponentSize(aWidth, aHeight, (BoardSizeCommand)inCommand);
		}
	}
}