package jp.gr.java_conf.ktz.puzzle.hashikake.app.view;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.OpenProblemDialog;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.Usherable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ComponentUsher;

import jp.gr.java_conf.ktz.puzzle.hashikake.command.ResetCommand;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.command.CheckCommand;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.HashikakeRoot;

import jp.gr.java_conf.ktz.puzzle.hashikake.view.CommandContainer;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AWTDispatchCommandQueue;

/**
 *	j[̃nhOsNX
 */
class MenuDispatcher implements ActionListener {
	/** ̃AvŗB̃CX^X */
	private static ActionListener sInstance = new MenuDispatcher();
	
	/** 
	 *	̃AvŗB̃CX^XԂ
	 *
	 *	@return	̃AvŗB̃CX^XԂ
	 */
	public static ActionListener getInstance() {
		return sInstance;
	}
	
	public static java.awt.MenuBar createMenu() {
		java.awt.MenuBar aMenuBar = new java.awt.MenuBar();
	
		java.awt.Menu aFile = new java.awt.Menu("File");
		aMenuBar.add(aFile);
		
		{
			java.awt.MenuItem aItem;
			
			aItem = new java.awt.MenuItem("New");
			aItem.addActionListener(MenuDispatcher.getInstance());
			aFile.add(aItem);
			
			aItem = new java.awt.MenuItem("New Problem");
			aItem.addActionListener(MenuDispatcher.getInstance());
			aFile.add(aItem);
			
			aItem = new java.awt.MenuItem("Quit");
			aItem.addActionListener(MenuDispatcher.getInstance());
			aFile.add(aItem);
		}
		
		java.awt.Menu aOpetate = new java.awt.Menu("Operate");
		aMenuBar.add(aOpetate);
		{
			java.awt.MenuItem aItem;
			
			aItem = new java.awt.MenuItem("Reset");
			aItem.addActionListener(MenuDispatcher.getInstance());
			aOpetate.add(aItem);
			
			aItem = new java.awt.MenuItem("Check");
			aItem.addActionListener(MenuDispatcher.getInstance());
			aOpetate.add(aItem);
		}
		
		return aMenuBar;
	}
	
	/**
	 *	w肵MenuItemɑ΂Actions
	 */
	public void actionPerformed(ActionEvent inEvent) {
		String aSignal = inEvent.getActionCommand();
		
		if (aSignal.equals("New")) {
			HashikakeRoot.showRootBoard();		
		}
		else if (aSignal.equals("New Problem")) {
			OpenProblemDialog.showLoadDialog();
		}
		else if (aSignal.equals("Quit")) {
			System.exit(0);
		}
		else if (aSignal.equals("Reset")) {
			Usherable aUsher = ComponentUsher.getInstance().getActiveComponent();
			
			if (aUsher instanceof CommandContainer) {
				CommandContainer aCommander = (CommandContainer)aUsher;
				ResetCommand aCommand = new ResetCommand(aCommander);

				AWTDispatchCommandQueue.postCommand(aCommand);
			}
		}
		else if (aSignal.equals("Check")) { 
			Usherable aUsher = ComponentUsher.getInstance().getActiveComponent();
			
			if (aUsher instanceof CommandContainer) {
				CommandContainer aCommander = (CommandContainer)aUsher;
				CheckCommand aCommand = new CheckCommand(aCommander);

				AWTDispatchCommandQueue.postCommand(aCommand);
			}
		}
	}
}