/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.BackFillHolder;
import org.jibx.runtime.impl.BackFillReference;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class UnmarshallingContext
implements IUnmarshallingContext {
    protected static final String DEFAULT_PARSER_NAME = "org.xmlpull.mxp1.MXParserFactory";
    protected static XmlPullParserFactory s_factory;
    protected XmlPullParser m_parser;
    protected HashMap[] m_idMaps;
    protected String[] m_idClasses;
    protected String[] m_classes;
    protected String[] m_namespaces;
    protected String[] m_names;
    protected int m_globalCount;
    protected Class[] m_localClasses;
    protected IUnmarshaller[] m_unmarshallers;
    protected HashMap m_unmarshalMap;
    protected Integer[] m_indexes;
    protected String m_idref;

    public String buildNameString(String string, String string2) {
        if (string == null || "".equals(string)) {
            return "\"" + string2 + "\"";
        }
        return "\"{" + string + "}" + string2 + "\"";
    }

    public String currentNameString() {
        return this.buildNameString(this.m_parser.getNamespace(), this.m_parser.getName());
    }

    public String buildPositionString() {
        return "(line " + this.m_parser.getLineNumber() + ", col " + this.m_parser.getColumnNumber() + ')';
    }

    public void throwStartTagNameError(String string, String string2) throws JiBXException {
        throw new JiBXException("Expected " + this.buildNameString(string, string2) + " start tag, found " + this.currentNameString() + " start tag " + this.buildPositionString());
    }

    public void throwEndTagNameError(String string, String string2) throws JiBXException {
        throw new JiBXException("Expected " + this.buildNameString(string, string2) + " end tag, found " + this.currentNameString() + " end tag " + this.buildPositionString());
    }

    private void advance() throws JiBXException {
        try {
            this.m_parser.next();
        }
        catch (IOException iOException) {
            throw new JiBXException("Error accessing document", iOException);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), xmlPullParserException);
        }
    }

    private boolean verifyNamespace(String string) {
        if (string == null || "".equals(string)) {
            return this.m_parser.getNamespace().length() == 0;
        }
        return string.equals(this.m_parser.getNamespace());
    }

    private String getAttributeValue(String string, String string2) {
        if (string == null) {
            return this.m_parser.getAttributeValue("", string2);
        }
        return this.m_parser.getAttributeValue(string, string2);
    }

    public UnmarshallingContext(String[] stringArray, String[] stringArray2, String[] stringArray3, IUnmarshaller[] iUnmarshallerArray, String[] stringArray4) throws JiBXException {
        try {
            if (s_factory == null) {
                try {
                    String string = System.getProperty("org.xmlpull.v1.XmlPullParserFactory");
                    if (string != null && (string = string.trim()).length() > 0) {
                        s_factory = XmlPullParserFactory.newInstance((String)string, Thread.currentThread().getContextClassLoader().getClass());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (s_factory == null) {
                    try {
                        s_factory = XmlPullParserFactory.newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (s_factory == null) {
                        try {
                            s_factory = XmlPullParserFactory.newInstance((String)DEFAULT_PARSER_NAME, Thread.currentThread().getContextClassLoader().getClass());
                        }
                        catch (Exception exception) {
                            throw new JiBXException("Unable to create parser", exception);
                        }
                    }
                }
                s_factory.setNamespaceAware(true);
            }
            this.m_parser = s_factory.newPullParser();
            int n = stringArray.length;
            this.m_classes = stringArray;
            this.m_globalCount = stringArray2.length;
            this.m_namespaces = new String[n];
            this.m_names = new String[n];
            this.m_unmarshallers = new IUnmarshaller[n];
            int n2 = 0;
            while (n2 < stringArray2.length) {
                this.addUnmarshalling(n2, stringArray2[n2], stringArray3[n2], iUnmarshallerArray[n2]);
                ++n2;
            }
            this.m_idClasses = stringArray4;
            int n3 = stringArray4 == null ? 1 : stringArray4.length;
            this.m_idMaps = new HashMap[n3];
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new JiBXException("Error creating parser", xmlPullParserException);
        }
    }

    public void setDocument(InputStream inputStream, String string) throws JiBXException {
        try {
            this.m_parser.setInput(inputStream, string);
            this.reset();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new JiBXException("Error setting document", xmlPullParserException);
        }
    }

    public void setDocument(Reader reader) throws JiBXException {
        try {
            this.m_parser.setInput(reader);
            this.reset();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new JiBXException("Error setting document", xmlPullParserException);
        }
    }

    public void reset() {
        int n = 0;
        while (n < this.m_idMaps.length) {
            this.m_idMaps[n] = null;
            ++n;
        }
        int n2 = this.m_globalCount;
        while (n2 < this.m_unmarshallers.length) {
            this.m_namespaces[n2] = null;
            this.m_names[n2] = null;
            this.m_unmarshallers[n2] = null;
            ++n2;
        }
        this.m_unmarshalMap = null;
        this.m_idref = null;
    }

    public String toStart() throws JiBXException {
        try {
            if (this.m_parser.getEventType() == 2) {
                return this.m_parser.getName();
            }
            while (true) {
                this.m_parser.next();
                switch (this.m_parser.getEventType()) {
                    case 2: {
                        return this.m_parser.getName();
                    }
                    case 3: {
                        throw new JiBXException("Expected start tag, found end tag " + this.currentNameString() + " " + this.buildPositionString());
                    }
                    case 1: {
                        throw new JiBXException("Expected start tag, found end of document " + this.buildPositionString());
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new JiBXException("Error accessing document", iOException);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), xmlPullParserException);
        }
    }

    public String toEnd() throws JiBXException {
        try {
            if (this.m_parser.getEventType() == 3) {
                return this.m_parser.getName();
            }
            while (true) {
                this.m_parser.next();
                switch (this.m_parser.getEventType()) {
                    case 2: {
                        throw new JiBXException("Expected end tag, found start tag " + this.currentNameString() + " " + this.buildPositionString());
                    }
                    case 3: {
                        return this.m_parser.getName();
                    }
                    case 1: {
                        throw new JiBXException("Expected end tag, found end of document " + this.buildPositionString());
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new JiBXException("Error accessing document", iOException);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), xmlPullParserException);
        }
    }

    public boolean isAt(String string, String string2) throws JiBXException {
        try {
            int n = this.m_parser.getEventType();
            while (n != 2 && n != 3) {
                n = this.m_parser.next();
            }
            return this.m_parser.getEventType() == 2 && this.m_parser.getName().equals(string2) && this.verifyNamespace(string);
        }
        catch (IOException iOException) {
            throw new JiBXException("Error accessing document", iOException);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), xmlPullParserException);
        }
    }

    public boolean hasAttribute(String string, String string2) throws JiBXException {
        try {
            if (this.m_parser.getEventType() == 2) {
                return this.getAttributeValue(string, string2) != null;
            }
            throw new JiBXException("Error parsing document " + this.buildPositionString());
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), xmlPullParserException);
        }
    }

    public void parseToStartTag(String string, String string2) throws JiBXException {
        if (this.toStart().equals(string2) && this.verifyNamespace(string)) {
            return;
        }
        this.throwStartTagNameError(string, string2);
    }

    public void parsePastStartTag(String string, String string2) throws JiBXException {
        if (this.toStart().equals(string2) && this.verifyNamespace(string)) {
            this.advance();
        } else {
            this.throwStartTagNameError(string, string2);
        }
    }

    public boolean parseIfStartTag(String string, String string2) throws JiBXException {
        if (this.isAt(string, string2)) {
            this.advance();
            return true;
        }
        return false;
    }

    public void parsePastEndTag(String string, String string2) throws JiBXException {
        if (this.toEnd().equals(string2) && this.verifyNamespace(string)) {
            this.advance();
        } else {
            this.throwEndTagNameError(string, string2);
        }
    }

    public boolean isEnd() throws JiBXException {
        try {
            int n = this.m_parser.getEventType();
            while (n != 2 && n != 3) {
                n = this.m_parser.next();
            }
            return this.m_parser.getEventType() == 3;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error accessing document", iOException);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), xmlPullParserException);
        }
    }

    public String parseContentText(String string, String string2, String string3) throws JiBXException {
        String string4 = string3;
        try {
            while (true) {
                switch (this.m_parser.getEventType()) {
                    case 4: {
                        string4 = this.m_parser.getText();
                        break;
                    }
                    case 3: {
                        if (this.m_parser.getName().equals(string2) && this.verifyNamespace(string)) {
                            this.m_parser.next();
                            return string4;
                        }
                        this.throwEndTagNameError(string, string2);
                    }
                    case 2: {
                        throw new JiBXException("Expected " + this.buildNameString(string, string2) + " end tag, " + "found " + this.currentNameString() + " start tag " + this.buildPositionString());
                    }
                    case 1: {
                        throw new JiBXException("Expected " + this.buildNameString(string, string2) + " end tag, " + "found end of document " + this.buildPositionString());
                    }
                }
                this.m_parser.next();
            }
        }
        catch (IOException iOException) {
            throw new JiBXException("Error accessing document", iOException);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), xmlPullParserException);
        }
    }

    public String parseContentText(String string, String string2) throws JiBXException {
        String string3 = this.parseContentText(string, string2, null);
        if (string3 == null) {
            this.throwException("Missing required content for element " + this.buildNameString(string, string2) + ' ' + this.buildPositionString());
        }
        return string3;
    }

    public int parseContentInt(String string, String string2) throws JiBXException {
        String string3 = this.parseContentText(string, string2);
        try {
            return Utility.parseInt(string3);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public int parseContentInt(String string, String string2, int n) throws JiBXException {
        String string3 = this.parseContentText(string, string2);
        if (string3 == null) {
            return n;
        }
        try {
            return Utility.parseInt(string3);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public String parseElementText(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.parseContentText(string, string2);
    }

    public String parseElementText(String string, String string2, String string3) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            return this.parseContentText(string, string2, string3);
        }
        return string3;
    }

    public String attributeText(String string, String string2) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            throw new JiBXException("Missing required attribute " + this.buildNameString(string, string2) + " " + this.buildPositionString());
        }
        return string3;
    }

    protected Object findID(String string, int n) throws JiBXException {
        HashMap hashMap = this.m_idMaps[n];
        if (hashMap != null) {
            Object v = hashMap.get(string);
            if (v == null || this.m_idClasses == null || this.m_idClasses[n].equals(v.getClass().getName())) {
                return v;
            }
            this.throwStartTagException("IDREF element content mapped to wrong type");
        }
        return null;
    }

    public Object findDefinedID(String string, int n) throws JiBXException {
        Object object = this.findID(string, n);
        if (object == null) {
            this.throwStartTagException("IDREF element content mapped to wrong type");
        }
        return object;
    }

    public Object parseElementForwardIDREF(String string, String string2, int n) throws JiBXException {
        this.parsePastStartTag(string, string2);
        String string3 = this.parseContentText(string, string2);
        return this.findID(string3, n);
    }

    public Object attributeForwardIDREF(String string, String string2, int n) throws JiBXException {
        String string3 = this.attributeText(string, string2);
        return this.findID(string3, n);
    }

    public Object parseElementExistingIDREF(String string, String string2, int n) throws JiBXException {
        this.parsePastStartTag(string, string2);
        this.m_idref = this.parseContentText(string, string2);
        return this.findDefinedID(this.m_idref, n);
    }

    public Object attributeExistingIDREF(String string, String string2, int n) throws JiBXException {
        this.m_idref = this.attributeText(string, string2);
        return this.findDefinedID(this.m_idref, n);
    }

    public String attributeText(String string, String string2, String string3) {
        String string4 = this.getAttributeValue(string, string2);
        if (string4 == null) {
            return string3;
        }
        return string4;
    }

    public int attributeInt(String string, String string2) throws JiBXException {
        String string3 = this.attributeText(string, string2);
        try {
            return Utility.parseInt(string3);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public int attributeInt(String string, String string2, int n) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return n;
        }
        try {
            return Utility.parseInt(string3);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public int parseElementInt(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.parseContentInt(string, string2);
    }

    public int parseElementInt(String string, String string2, int n) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            return this.parseContentInt(string, string2, n);
        }
        return n;
    }

    public byte convertByte(String string) throws JiBXException {
        try {
            return Utility.parseByte(string);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public byte attributeByte(String string, String string2) throws JiBXException {
        return this.convertByte(this.attributeText(string, string2));
    }

    public byte attributeByte(String string, String string2, byte by) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return by;
        }
        return this.convertByte(string3);
    }

    public byte parseContentByte(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.convertByte(this.parseContentText(string, string2));
    }

    public byte parseElementByte(String string, String string2, byte by) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            String string3 = this.parseContentText(string, string2, null);
            if (string3 == null) {
                return by;
            }
            return this.convertByte(string3);
        }
        return by;
    }

    public short convertShort(String string) throws JiBXException {
        try {
            return Utility.parseShort(string);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public short attributeShort(String string, String string2) throws JiBXException {
        return this.convertShort(this.attributeText(string, string2));
    }

    public short attributeShort(String string, String string2, short s) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return s;
        }
        return this.convertShort(string3);
    }

    public short parseContentShort(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.convertShort(this.parseContentText(string, string2));
    }

    public short parseElementShort(String string, String string2, short s) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            String string3 = this.parseContentText(string, string2, null);
            if (string3 == null) {
                return s;
            }
            return this.convertShort(string3);
        }
        return s;
    }

    public char convertChar(String string) throws JiBXException {
        try {
            return Utility.parseChar(string);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public char attributeChar(String string, String string2) throws JiBXException {
        return this.convertChar(this.attributeText(string, string2));
    }

    public char attributeChar(String string, String string2, char c) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return c;
        }
        return this.convertChar(string3);
    }

    public char parseContentChar(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.convertChar(this.parseContentText(string, string2));
    }

    public char parseElementChar(String string, String string2, char c) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            String string3 = this.parseContentText(string, string2, null);
            if (string3 == null) {
                return c;
            }
            return this.convertChar(string3);
        }
        return c;
    }

    public long convertLong(String string) throws JiBXException {
        try {
            return Utility.parseLong(string);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public long attributeLong(String string, String string2) throws JiBXException {
        return this.convertLong(this.attributeText(string, string2));
    }

    public long attributeLong(String string, String string2, long l) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return l;
        }
        return this.convertLong(string3);
    }

    public long parseElementLong(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.convertLong(this.parseContentText(string, string2));
    }

    public long parseElementLong(String string, String string2, long l) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            String string3 = this.parseContentText(string, string2, null);
            if (string3 == null) {
                return l;
            }
            return this.convertLong(string3);
        }
        return l;
    }

    public boolean convertBoolean(String string) throws JiBXException {
        if ("true".equals(string) || "1".equals(string)) {
            return true;
        }
        if ("false".equals(string) || "0".equals(string)) {
            return false;
        }
        throw new JiBXException("Invalid boolean value " + this.buildPositionString());
    }

    public boolean attributeBoolean(String string, String string2) throws JiBXException {
        return this.convertBoolean(this.attributeText(string, string2));
    }

    public boolean attributeBoolean(String string, String string2, boolean bl) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return bl;
        }
        return this.convertBoolean(string3);
    }

    public boolean parseElementBoolean(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.convertBoolean(this.parseContentText(string, string2));
    }

    public boolean parseElementBoolean(String string, String string2, boolean bl) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            String string3 = this.parseContentText(string, string2, null);
            if (string3 == null) {
                return bl;
            }
            return this.convertBoolean(string3);
        }
        return bl;
    }

    public float convertFloat(String string) throws JiBXException {
        try {
            return Utility.parseFloat(string);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public float attributeFloat(String string, String string2) throws JiBXException {
        return this.convertFloat(this.attributeText(string, string2));
    }

    public float attributeFloat(String string, String string2, float f) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return f;
        }
        return this.convertFloat(string3);
    }

    public float parseElementFloat(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.convertFloat(this.parseContentText(string, string2));
    }

    public float parseElementFloat(String string, String string2, float f) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            String string3 = this.parseContentText(string, string2, null);
            if (string3 == null) {
                return f;
            }
            return this.convertFloat(string3);
        }
        return f;
    }

    public double convertDouble(String string) throws JiBXException {
        try {
            return Utility.parseDouble(string);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public double attributeDouble(String string, String string2) throws JiBXException {
        return this.convertDouble(this.attributeText(string, string2));
    }

    public double attributeDouble(String string, String string2, double d) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return d;
        }
        return this.convertDouble(string3);
    }

    public double parseElementDouble(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.convertDouble(this.parseContentText(string, string2));
    }

    public double parseElementDouble(String string, String string2, double d) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            String string3 = this.parseContentText(string, string2, null);
            if (string3 == null) {
                return d;
            }
            return this.convertDouble(string3);
        }
        return d;
    }

    public Date convertDate(String string) throws JiBXException {
        try {
            return new Date(Utility.parseDateTime(string));
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public Date attributeDate(String string, String string2) throws JiBXException {
        return this.convertDate(this.attributeText(string, string2));
    }

    public Date attributeDate(String string, String string2, Date date) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return date;
        }
        return this.convertDate(string3);
    }

    public Date parseElementDate(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.convertDate(this.parseContentText(string, string2));
    }

    public Date parseElementDate(String string, String string2, Date date) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            String string3 = this.parseContentText(string, string2, null);
            if (string3 == null) {
                return date;
            }
            return this.convertDate(string3);
        }
        return date;
    }

    public void registerBackFill(int n, BackFillReference backFillReference) throws JiBXException {
        Object v;
        HashMap<String, BackFillHolder> hashMap = this.m_idMaps[n];
        if (hashMap == null) {
            this.m_idMaps[n] = hashMap = new HashMap<String, BackFillHolder>();
        }
        if ((v = hashMap.get(this.m_idref)) == null) {
            BackFillHolder backFillHolder = new BackFillHolder(this.m_idClasses[n]);
            hashMap.put(this.m_idref, backFillHolder);
            backFillHolder.addBackFill(backFillReference);
        } else if (v instanceof BackFillHolder) {
            ((BackFillHolder)v).addBackFill(backFillReference);
        } else {
            throw new JiBXException("Internal operation error (back fill error) " + this.buildPositionString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void defineID(String string, int n, Object object) throws JiBXException {
        Object object2;
        HashMap<String, Object> hashMap = this.m_idMaps[n];
        if (hashMap == null) {
            this.m_idMaps[n] = hashMap = new HashMap<String, Object>();
        }
        if ((object2 = hashMap.put(string, object)) instanceof BackFillHolder) {
            BackFillHolder backFillHolder = (BackFillHolder)object2;
            if (!backFillHolder.getExpectedClass().equals(object.getClass().getName())) throw new JiBXException("ID object has wrong type " + this.buildPositionString());
            backFillHolder.defineValue(object);
            return;
        } else {
            if (object2 == null) return;
            throw new JiBXException("Duplicate ID definition " + this.buildPositionString());
        }
    }

    protected void mapUnmarshalling(int n) {
        Object v = this.m_unmarshalMap.get(this.m_names[n]);
        if (v instanceof Integer) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(v);
            arrayList.add(this.m_indexes[n]);
            this.m_unmarshalMap.put(this.m_names[n], arrayList);
        } else if (v instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)v;
            arrayList.add(this.m_indexes[n]);
        } else {
            this.m_unmarshalMap.put(this.m_names[n], this.m_indexes[n]);
        }
    }

    public void addUnmarshalling(int n, String string, String string2, IUnmarshaller iUnmarshaller) {
        this.m_namespaces[n] = string;
        this.m_names[n] = string2;
        this.m_unmarshallers[n] = iUnmarshaller;
        if (this.m_unmarshalMap != null && string2 != null) {
            this.mapUnmarshalling(n);
        }
    }

    public void removeUnmarshalling(int n) {
        if (this.m_unmarshalMap != null && this.m_names[n] != null) {
            Object v = this.m_unmarshalMap.get(this.m_names[n]);
            if (v instanceof Integer) {
                this.m_unmarshalMap.remove(this.m_names[n]);
            } else if (v instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)v;
                arrayList.remove(arrayList.indexOf(this.m_indexes[n]));
            }
        }
        this.m_namespaces[n] = null;
        this.m_names[n] = null;
        this.m_unmarshallers[n] = null;
    }

    public IUnmarshaller getUnmarshaller(int n, Class clazz) throws JiBXException {
        if (n > this.m_classes.length || !clazz.getName().equals(this.m_classes[n])) {
            throw new JiBXException("Unmarshalling not defined for class " + clazz.getName());
        }
        return this.m_unmarshallers[n];
    }

    public IUnmarshaller getUnmarshaller(String string, String string2) {
        Object v;
        if (this.m_unmarshalMap == null) {
            this.m_unmarshalMap = new HashMap();
            this.m_indexes = new Integer[this.m_names.length];
            int n = 0;
            while (n < this.m_names.length) {
                this.m_indexes[n] = new Integer(n);
                if (this.m_names[n] != null) {
                    this.mapUnmarshalling(n);
                }
                ++n;
            }
        }
        if ((v = this.m_unmarshalMap.get(string2)) instanceof Integer) {
            int n = (Integer)v;
            String string3 = this.m_namespaces[n];
            if (string == string3 || string == null && string3.length() == 0 || string3 == null && string.length() == 0 || string != null && string.equals(string3)) {
                return this.m_unmarshallers[n];
            }
        } else if (v instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)v;
            int n = 0;
            while (n < arrayList.size()) {
                int n2 = (Integer)arrayList.get(n);
                String string4 = this.m_namespaces[n2];
                if (string == string4 || string == null && string4.length() == 0 || string4 == null && string.length() == 0 || string != null && string.equals(string4)) {
                    return this.m_unmarshallers[n2];
                }
                ++n;
            }
        }
        return null;
    }

    public Object unmarshalElement() throws JiBXException {
        String string = this.toStart();
        String string2 = this.m_parser.getNamespace();
        IUnmarshaller iUnmarshaller = this.getUnmarshaller(string2, string);
        if (iUnmarshaller == null) {
            throw new JiBXException("No unmarshaller for element " + this.buildNameString(string2, string) + " " + this.buildPositionString());
        }
        return iUnmarshaller.unmarshal(this);
    }

    public void parsePastElement(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        int n = 0;
        try {
            while (true) {
                switch (this.m_parser.getEventType()) {
                    case 3: {
                        if (n == 0) {
                            if (this.m_parser.getName().equals(string2) && this.verifyNamespace(string)) {
                                this.m_parser.next();
                                return;
                            }
                            this.throwEndTagNameError(string, string2);
                            break;
                        }
                        --n;
                        break;
                    }
                    case 2: {
                        ++n;
                        break;
                    }
                }
                this.m_parser.next();
            }
        }
        catch (IOException iOException) {
            throw new JiBXException("Error accessing document", iOException);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), xmlPullParserException);
        }
    }

    public void throwStartTagException(String string) throws JiBXException {
        throw new JiBXException(string + " at tag " + this.currentNameString() + this.buildPositionString());
    }

    public void throwStartTagException(String string, Exception exception) throws JiBXException {
        throw new JiBXException(string + " at tag " + this.currentNameString() + this.buildPositionString(), exception);
    }

    public void throwException(String string) throws JiBXException {
        throw new JiBXException(string + " " + this.buildPositionString());
    }

    public void throwException(String string, Exception exception) throws JiBXException {
        throw new JiBXException(string + " " + this.buildPositionString(), exception);
    }

    public Object unmarshalDocument(InputStream inputStream, String string) throws JiBXException {
        this.setDocument(inputStream, string);
        return this.unmarshalElement();
    }

    public Object unmarshalDocument(Reader reader) throws JiBXException {
        this.setDocument(reader);
        return this.unmarshalElement();
    }
}

