/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

import java.util.Date;
import org.jibx.runtime.JiBXException;

public abstract class Utility {
    public static final int MSPERMINUTE = 60000;
    public static final int MSPERHOUR = 3600000;
    public static final int MSPERDAY = 86400000;
    public static final long LMSPERDAY = 86400000L;
    public static final long MSPERYEAR = 31536000000L;
    public static final long MSPERAVGYEAR = 31557600000L;
    public static final long MSPERCENTURY = 3155695200000L;
    public static final long TIME_BASE = 62135596800000L;
    public static final int[] MONTHS_NONLEAP = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    public static final int[] MONTHS_LEAP = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
    public static final long[] BIAS_MONTHMS = new long[]{0L, 0L, 0L, 0L, 2678400000L, 5270400000L, 7948800000L, 10540800000L, 13219200000L, 15897600000L, 18489600000L, 21168000000L, 23760000000L, 26438400000L, 29116800000L};

    private static int parseDigits(String string, int n, int n2) throws JiBXException {
        int n3 = 0;
        if (n2 > 9) {
            try {
                n3 = Integer.parseInt(string.substring(n, n + n2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new JiBXException(numberFormatException.getMessage());
            }
        } else {
            int n4 = n + n2;
            while (n < n4) {
                char c;
                if ((c = string.charAt(n++)) >= '0' && c <= '9') {
                    n3 = n3 * 10 + (c - 48);
                    continue;
                }
                throw new JiBXException("Non-digit in number value");
            }
        }
        return n3;
    }

    public static int parseInt(String string) throws JiBXException {
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            throw new JiBXException("Empty number value");
        }
        boolean bl = false;
        char c = string.charAt(0);
        if (c == '-') {
            if (n2 > 9) {
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JiBXException(numberFormatException.getMessage());
                }
            }
            bl = true;
            ++n;
        } else if (c == '+') {
            ++n;
        }
        if (n >= n2) {
            throw new JiBXException("Invalid number format");
        }
        int n3 = Utility.parseDigits(string, n, n2 - n);
        if (bl) {
            return -n3;
        }
        return n3;
    }

    public static String serializeInt(int n) {
        return Integer.toString(n);
    }

    /*
     * Unable to fully structure code
     */
    public static long parseLong(String var0) throws JiBXException {
        var1_1 = 0;
        var2_2 = var0.length();
        if (var2_2 == 0) {
            throw new JiBXException("Empty number value");
        }
        var3_3 = false;
        var4_4 = var0.charAt(0);
        if (var4_4 == '-') {
            var3_3 = true;
            ++var1_1;
        } else if (var4_4 == '+') {
            ++var1_1;
        }
        if (var1_1 >= var2_2) {
            throw new JiBXException("Invalid number format");
        }
        var5_5 = 0L;
        if (var2_2 - var1_1 <= 18) ** GOTO lbl28
        if (var4_4 == '+') {
            var0 = var0.substring(1);
        }
        try {
            var5_5 = Long.parseLong(var0);
        }
        catch (NumberFormatException var7_6) {
            throw new JiBXException(var7_6.getMessage());
        }
lbl-1000:
        // 1 sources

        {
            if ((var4_4 = var0.charAt(var1_1++)) >= '0' && var4_4 <= '9') {
                var5_5 = var5_5 * 10L + (long)(var4_4 - 48);
                continue;
            }
            throw new JiBXException("Non-digit in number value");
lbl28:
            // 2 sources

            ** while (var1_1 < var2_2)
        }
lbl29:
        // 1 sources

        if (var3_3) {
            var5_5 = -var5_5;
        }
        return var5_5;
    }

    public static String serializeLong(long l) {
        return Long.toString(l);
    }

    public static short parseShort(String string) throws JiBXException {
        int n = Utility.parseInt(string);
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new JiBXException("Value out of range");
        }
        return (short)n;
    }

    public static String serializeShort(short s) {
        return Short.toString(s);
    }

    public static byte parseByte(String string) throws JiBXException {
        int n = Utility.parseInt(string);
        if (n < -128 || n > 127) {
            throw new JiBXException("Value out of range");
        }
        return (byte)n;
    }

    public static String serializeByte(byte by) {
        return Byte.toString(by);
    }

    public static boolean parseBoolean(String string) throws JiBXException {
        if ("true".equals(string) || "1".equals(string)) {
            return true;
        }
        if ("false".equals(string) || "0".equals(string)) {
            return false;
        }
        throw new JiBXException("Invalid boolean value");
    }

    public static String serializeBoolean(boolean bl) {
        return bl ? "true" : "false";
    }

    public static char parseChar(String string) throws JiBXException {
        int n = Utility.parseInt(string);
        if (n < 0 || n > 65535) {
            throw new JiBXException("Value out of range");
        }
        return (char)n;
    }

    public static String serializeChar(char c) {
        return Integer.toString(c);
    }

    public static float parseFloat(String string) throws JiBXException {
        if ("-INF".equals(string)) {
            return Float.NEGATIVE_INFINITY;
        }
        if ("INF".equals(string)) {
            return Float.POSITIVE_INFINITY;
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JiBXException(numberFormatException.getMessage());
        }
    }

    public static String serializeFloat(float f) {
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-INF" : "INF";
        }
        return Float.toString(f);
    }

    public static double parseDouble(String string) throws JiBXException {
        if ("-INF".equals(string)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("INF".equals(string)) {
            return Double.POSITIVE_INFINITY;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JiBXException(numberFormatException.getMessage());
        }
    }

    public static String serializeDouble(double d) {
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-INF" : "INF";
        }
        return Double.toString(d);
    }

    public static long parseYear(String string) throws JiBXException {
        boolean bl = true;
        int n = 4;
        char c = string.charAt(0);
        if (c == '-') {
            n = 5;
        } else if (c == '+') {
            bl = false;
        }
        if (string.length() < n) {
            bl = false;
        }
        if (!bl) {
            throw new JiBXException("Invalid year format");
        }
        int n2 = Utility.parseInt(string);
        if (n2 == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        if (n2 > 0) {
            --n2;
        }
        long l = (long)n2 * 365L + (long)(n2 / 4) - (long)(n2 / 100) + (long)(n2 / 400);
        return l * 86400000L - 62135596800000L;
    }

    public static long parseYearMonth(String string) throws JiBXException {
        boolean bl;
        boolean bl2 = true;
        int n = 7;
        char c = string.charAt(0);
        if (c == '-') {
            n = 8;
        } else if (c == '+') {
            bl2 = false;
        }
        int n2 = string.length() - 3;
        if (string.length() < n) {
            bl2 = false;
        } else if (string.charAt(n2) != '-') {
            bl2 = false;
        }
        if (!bl2) {
            throw new JiBXException("Invalid date format");
        }
        int n3 = Utility.parseInt(string.substring(0, n2));
        if (n3 == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        int n4 = Utility.parseDigits(string, n2 + 1, 2) - 1;
        if (n4 < 0 || n4 > 11) {
            throw new JiBXException("Month value out of range");
        }
        boolean bl3 = bl = n3 % 4 == 0 && (n3 % 100 != 0 || n3 % 400 == 0);
        if (n3 > 0) {
            --n3;
        }
        long l = (long)n3 * 365L + (long)(n3 / 4) - (long)(n3 / 100) + (long)(n3 / 400) + (long)(bl ? MONTHS_LEAP : MONTHS_NONLEAP)[n4];
        return l * 86400000L - 62135596800000L;
    }

    public static long parseDate(String string) throws JiBXException {
        int[] nArray;
        boolean bl = true;
        int n = 10;
        char c = string.charAt(0);
        if (c == '-') {
            n = 11;
        } else if (c == '+') {
            bl = false;
        }
        int n2 = string.length() - 6;
        if (string.length() < n) {
            bl = false;
        } else if (string.charAt(n2) != '-' || string.charAt(n2 + 3) != '-') {
            bl = false;
        }
        if (!bl) {
            throw new JiBXException("Invalid date format");
        }
        int n3 = Utility.parseInt(string.substring(0, n2));
        if (n3 == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        int n4 = Utility.parseDigits(string, n2 + 1, 2) - 1;
        if (n4 < 0 || n4 > 11) {
            throw new JiBXException("Month value out of range");
        }
        long l = Utility.parseDigits(string, n2 + 4, 2) - 1;
        boolean bl2 = n3 % 4 == 0 && (n3 % 100 != 0 || n3 % 400 == 0);
        int[] nArray2 = nArray = bl2 ? MONTHS_LEAP : MONTHS_NONLEAP;
        if (l < 0L || l >= (long)(nArray[n4 + 1] - nArray[n4])) {
            throw new JiBXException("Day value out of range");
        }
        if (n3 > 0) {
            --n3;
        }
        return (l += (long)n3 * 365L + (long)(n3 / 4) - (long)(n3 / 100) + (long)(n3 / 400) + (long)nArray[n4]) * 86400000L - 62135596800000L;
    }

    public static Date deserializeDate(String string) throws JiBXException {
        if (string == null) {
            return null;
        }
        return new Date(Utility.parseDate(string));
    }

    public static long parseDateTime(String string) throws JiBXException {
        boolean bl;
        int n = string.indexOf(84);
        if (n < 0) {
            throw new JiBXException("Missing 'T' separator in dateTime");
        }
        long l = Utility.parseDate(string.substring(0, n));
        int n2 = string.length();
        boolean bl2 = bl = n2 > n + 8 && string.charAt(n + 3) == ':' && string.charAt(n + 6) == ':';
        if (bl) {
            int n3 = Utility.parseDigits(string, n + 1, 2);
            int n4 = Utility.parseDigits(string, n + 4, 2);
            int n5 = Utility.parseDigits(string, n + 7, 2);
            if (n3 > 23 || n4 > 59 || n5 > 60) {
                bl = false;
            } else {
                int n6 = ((n3 * 60 + n4) * 60 + n5) * 1000;
                if (n2 > (n += 9)) {
                    if (string.charAt(n2 - 1) == 'Z') {
                        --n2;
                    } else {
                        char c = string.charAt(n2 - 6);
                        if (c == '-' || c == '+') {
                            n3 = Utility.parseDigits(string, n2 - 5, 2);
                            n4 = Utility.parseDigits(string, n2 - 2, 2);
                            if (n3 > 23 || n4 > 59) {
                                bl = false;
                            } else {
                                int n7 = (n3 * 60 + n4) * 60 * 1000;
                                n6 = c == '-' ? (n6 += n7) : (n6 -= n7);
                            }
                            n2 -= 6;
                        }
                    }
                    if (string.charAt(n) == '.') {
                        double d = Double.parseDouble(string.substring(n, n2));
                        n6 = (int)((double)n6 + d * 1000.0);
                    } else if (n2 > n) {
                        bl = false;
                    }
                }
                l += (long)n6;
            }
        }
        if (bl) {
            return l;
        }
        throw new JiBXException("Invalid dateTime format");
    }

    public static Date deserializeDateTime(String string) throws JiBXException {
        if (string == null) {
            return null;
        }
        return new Date(Utility.parseDateTime(string));
    }

    protected static void formatYearNumber(long l, StringBuffer stringBuffer) {
        if (l <= 0L) {
            stringBuffer.append('-');
            l = -(l - 1L);
        }
        if (l < 1000L) {
            stringBuffer.append('0');
            if (l < 100L) {
                stringBuffer.append('0');
                if (l < 10L) {
                    stringBuffer.append('0');
                }
            }
        }
        stringBuffer.append(l);
    }

    protected static void formatTwoDigits(int n, StringBuffer stringBuffer) {
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
    }

    protected static void formatYear(long l, StringBuffer stringBuffer) {
        long l2;
        int n;
        int n2;
        long l3 = l + 26438400000L + 64800000L;
        long l4 = l3 / 3155695200000L;
        long l5 = l3 + (l4 - l4 / 4L) * 86400000L;
        int n3 = (int)(l5 / 31557600000L);
        if (l5 < 0L) {
            --n3;
        }
        if ((n2 = (5 * (n = (int)((l2 = l5 + 21600000L - (long)(n3 * 365 + n3 / 4) * 86400000L) / 86400000L)) + 456) / 153) > 12) {
            ++n3;
        }
        Utility.formatYearNumber(n3, stringBuffer);
    }

    protected static long formatYearMonth(long l, StringBuffer stringBuffer) {
        int n;
        long l2;
        int n2;
        long l3 = l + 26438400000L + 64800000L;
        long l4 = l3 / 3155695200000L;
        long l5 = l3 + (l4 - l4 / 4L) * 86400000L;
        int n3 = (int)(l5 / 31557600000L);
        if (l5 < 0L) {
            --n3;
        }
        if ((n2 = (int)((l2 = l5 + 21600000L - (long)(n3 * 365 + n3 / 4) * 86400000L) / 86400000L)) == 0) {
            n = --n3 % 4 == 0 ? 366 : 365;
            l2 += (long)n * 86400000L;
            n2 += n;
        }
        n = (5 * n2 + 456) / 153;
        long l6 = l2 - BIAS_MONTHMS[n] - 86400000L;
        if (n > 12) {
            ++n3;
            n -= 12;
        }
        Utility.formatYearNumber(n3, stringBuffer);
        stringBuffer.append('-');
        Utility.formatTwoDigits(n, stringBuffer);
        return l6;
    }

    protected static int formatYearMonthDay(long l, StringBuffer stringBuffer) {
        long l2 = Utility.formatYearMonth(l, stringBuffer);
        int n = (int)(l2 / 86400000L) + 1;
        stringBuffer.append('-');
        Utility.formatTwoDigits(n, stringBuffer);
        return (int)(l2 % 86400000L);
    }

    public static String serializeYear(long l) throws JiBXException {
        StringBuffer stringBuffer = new StringBuffer(6);
        Utility.formatYear(l + 62135596800000L, stringBuffer);
        return stringBuffer.toString();
    }

    public static String serializeYear(Date date) throws JiBXException {
        return Utility.serializeYear(date.getTime());
    }

    public static String serializeYearMonth(long l) throws JiBXException {
        StringBuffer stringBuffer = new StringBuffer(12);
        Utility.formatYearMonth(l + 62135596800000L, stringBuffer);
        return stringBuffer.toString();
    }

    public static String serializeYearMonth(Date date) throws JiBXException {
        return Utility.serializeYearMonth(date.getTime());
    }

    public static String serializeDate(long l) throws JiBXException {
        StringBuffer stringBuffer = new StringBuffer(12);
        Utility.formatYearMonthDay(l + 62135596800000L, stringBuffer);
        return stringBuffer.toString();
    }

    public static String serializeDate(Date date) throws JiBXException {
        return Utility.serializeDate(date.getTime());
    }

    public static String serializeDateTime(long l) throws JiBXException {
        StringBuffer stringBuffer = new StringBuffer(24);
        int n = Utility.formatYearMonthDay(l + 62135596800000L, stringBuffer);
        stringBuffer.append('T');
        Utility.formatTwoDigits(n / 3600000, stringBuffer);
        stringBuffer.append(':');
        Utility.formatTwoDigits((n %= 3600000) / 60000, stringBuffer);
        stringBuffer.append(':');
        Utility.formatTwoDigits((n %= 60000) / 1000, stringBuffer);
        if ((n %= 1000) > 0) {
            stringBuffer.append('.');
            stringBuffer.append(n / 100);
            if ((n %= 100) > 0) {
                stringBuffer.append(n / 10);
                if ((n %= 10) > 0) {
                    stringBuffer.append(n);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String serializeDateTime(Date date) throws JiBXException {
        return Utility.serializeDateTime(date.getTime());
    }

    public static boolean isEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }
}

