/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.view;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.Command;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.SaveCanceledException;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AbstractBottomUpCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AbstractTopDownCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;

public abstract class BoardContainer
implements BoardView {
    private BoardView mParent;
    private BoardView mDecorated;
    private Container mContainer;

    public BoardContainer(Container inContainer) {
        this.mContainer = inContainer;
    }

    public final void initialize() {
        this.initializeSelf();
        this.mDecorated.initialize();
    }

    protected abstract void initializeSelf();

    public final boolean isModified() {
        return this.mDecorated.isModified();
    }

    public final void save(File inFile) throws SaveCanceledException {
        this.mDecorated.save(inFile);
    }

    public final void load(ProblemInfo inInfo) {
        this.mDecorated.load(inInfo);
    }

    public final void clear() {
        this.mDecorated.clear();
    }

    public void addBoard(BoardView inSubBoard) {
        this.mContainer.add(inSubBoard.getComponent());
        this.mDecorated = inSubBoard;
        inSubBoard.setParent(this);
    }

    public void setParent(BoardView inParentBoard) {
        this.mParent = inParentBoard;
    }

    public final Component getComponent() {
        return this.mContainer;
    }

    public final void setTitle(String inTitle) {
        this.mParent.setTitle(inTitle);
    }

    public final void repaint() {
        this.mDecorated.repaint();
    }

    public void setFocus(boolean inFocused) {
        this.mParent.setFocus(inFocused);
    }

    public final boolean isFocused() {
        return this.mParent.isFocused();
    }

    public void processCommand(Command inCommand) {
        if (!inCommand.isConsumed()) {
            this.processCommandImpl(inCommand);
        }
        if (!inCommand.isConsumed()) {
            if (inCommand instanceof AbstractTopDownCommand) {
                this.mDecorated.processCommand(inCommand);
            } else if (inCommand instanceof AbstractBottomUpCommand) {
                this.mParent.processCommand(inCommand);
            }
        }
    }

    protected abstract void processCommandImpl(Command var1);
}

