/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFNULL;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.MarshalUnmarshalBuilder;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.def.BindingConstants;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IParent;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;

public class PropertyDefinition
implements BindingConstants {
    protected static final String USAGE_OPTIONAL = "optional";
    protected static final String USAGE_REQUIRED = "required";
    protected IParent m_parent;
    protected String m_typeName;
    protected String m_valueType;
    protected boolean m_isOptional;
    protected ClassItem m_fieldItem;
    protected ClassItem m_testMethod;
    protected ClassItem m_getMethod;
    protected ClassItem m_setMethod;

    public PropertyDefinition(IParent iParent) {
        this.m_parent = iParent;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    public String getName() {
        if (this.m_fieldItem != null) {
            return this.m_fieldItem.getName();
        }
        if (this.m_getMethod != null) {
            String string = this.m_getMethod.getName();
            if (string.startsWith("get") && string.length() > 3) {
                string = string.substring(3);
            }
            return string;
        }
        String string = this.m_setMethod.getName();
        if (string.startsWith("set") && string.length() > 3) {
            string = string.substring(3);
        }
        return string;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public String getValueType() {
        return this.m_valueType;
    }

    public BranchHandle genTest(MarshalUnmarshalBuilder marshalUnmarshalBuilder) throws JiBXException {
        if (this.m_getMethod == null) {
            marshalUnmarshalBuilder.appendGetField(this.m_fieldItem);
            return marshalUnmarshalBuilder.append((BranchInstruction)new IFNULL(null));
        }
        marshalUnmarshalBuilder.addMethodExceptions(this.m_getMethod);
        marshalUnmarshalBuilder.appendCallVirtual(this.m_getMethod);
        return marshalUnmarshalBuilder.append((BranchInstruction)new IFEQ(null));
    }

    public void genLoad(MethodBuilder methodBuilder) throws JiBXException {
        ClassFile classFile = methodBuilder.getClassFile();
        ClassItem classItem = this.m_getMethod;
        if (classItem == null) {
            classItem = this.m_fieldItem;
        }
        if (!classFile.isAccessible(classItem)) {
            classItem = this.m_parent.getBoundClass().getLoadMethod(classItem, methodBuilder.getClassFile());
        }
        if (classItem.isMethod()) {
            methodBuilder.addMethodExceptions(classItem);
            methodBuilder.appendCallVirtual(classItem);
        } else {
            methodBuilder.appendGetField(classItem);
        }
    }

    public void genStore(MethodBuilder methodBuilder) throws JiBXException {
        ClassFile classFile = methodBuilder.getClassFile();
        ClassItem classItem = this.m_setMethod;
        if (classItem == null) {
            classItem = this.m_fieldItem;
        }
        if (!classFile.isAccessible(classItem)) {
            classItem = this.m_parent.getBoundClass().getStoreMethod(classItem, methodBuilder.getClassFile());
        }
        if (classItem.isMethod()) {
            methodBuilder.addMethodExceptions(classItem);
            methodBuilder.appendCallVirtual(classItem);
        } else {
            methodBuilder.appendPutField(classItem);
        }
    }

    protected void matchType(String string) throws JiBXException {
        if (this.m_typeName == null) {
            this.m_typeName = string;
        } else if (!this.m_typeName.equals(string)) {
            throw new JiBXException("Conflicting types for property: \"" + this.m_typeName + "\" vs \"" + string + '\"');
        }
    }

    public void unmarshal(UnmarshallingContext unmarshallingContext) throws JiBXException {
        Object object;
        this.m_typeName = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "type", null);
        String string = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "usage", USAGE_REQUIRED);
        if (USAGE_OPTIONAL.equals(string)) {
            this.m_isOptional = true;
        } else if (!USAGE_REQUIRED.equals(string)) {
            unmarshallingContext.throwStartTagException("Illegal value for \"usage\" attribute");
        }
        try {
            object = this.m_parent.getBoundClass().getClassFile();
            string = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "field", null);
            if (string != null) {
                this.m_fieldItem = ((ClassFile)object).getField(string);
                this.m_valueType = this.m_fieldItem.getTypeName();
                this.matchType(this.m_valueType);
            }
            if ((string = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "test-method", null)) != null) {
                this.m_testMethod = ((ClassFile)object).getMethod(string, "()");
            }
            if ((string = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "get-method", null)) != null) {
                this.m_getMethod = ((ClassFile)object).getMethod(string, "()");
                this.m_valueType = this.m_getMethod.getTypeName();
                this.matchType(this.m_valueType);
            }
            if ((string = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "set-method", null)) != null) {
                this.m_setMethod = ((ClassFile)object).getMethod(string, "(L");
                String string2 = this.m_setMethod.getSignature();
                String[] stringArray = Utility.methodSignatureArgumentTypes((String)string2, (boolean)false);
                String string3 = Utility.methodSignatureReturnType((String)string2, (boolean)false);
                if (stringArray.length > 1 || !string3.equals("void")) {
                    throw new JiBXException("Method \"" + this.m_setMethod.getName() + "\" not a valid set-method");
                }
                this.matchType(stringArray[0]);
            }
        }
        catch (JiBXException jiBXException) {
            unmarshallingContext.throwStartTagException(jiBXException.getMessage());
        }
        if (this.m_fieldItem == null) {
            object = this.m_parent.getBindingRoot();
            if (((BindingDefinition)object).isInput() && this.m_setMethod == null) {
                unmarshallingContext.throwStartTagException("Missing way to set value for input binding");
            }
            if (((BindingDefinition)object).isOutput() && this.m_getMethod == null) {
                unmarshallingContext.throwStartTagException("Missing way to get value for output binding");
            }
        }
    }

    public static boolean isPropertyPresent(UnmarshallingContext unmarshallingContext) throws JiBXException {
        return unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "field", null) != null || unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "get-method", null) != null || unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "set-method", null) != null;
    }
}

