/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.MarshalBuilder;
import org.jibx.binding.classes.UnmarshalBuilder;
import org.jibx.binding.def.StringConversion;
import org.jibx.runtime.JiBXException;

public class ObjectStringConversion
extends StringConversion {
    protected static final String TOSTRING_METHOD = "toString";
    protected static final String TOSTRING_SIGNATURE = "()Ljava/lang/String;";
    protected static final String FROMSTRING_SIGNATURE = "(Ljava/lang/String;)V";
    protected static final String UNMARSHAL_ISATMETHOD = "org.jibx.runtime.impl.UnmarshallingContext.isAt";
    protected static final String UNMARSHAL_ISATSIGNATURE = "(Ljava/lang/String;Ljava/lang/String;)Z";
    protected boolean m_needDeserialize;
    protected ClassItem m_initFromString;
    protected boolean m_needSerialize;
    protected ClassItem m_instToString;

    protected ObjectStringConversion(String string, StringConversion stringConversion) throws JiBXException {
        super(string, stringConversion);
        if (!string.equals(stringConversion.m_typeName)) {
            this.initMethods();
        }
    }

    public ObjectStringConversion(Object object, String string, String string2, String string3) throws JiBXException {
        super(object, string, string2, string3);
        this.initMethods();
    }

    protected void initMethods() throws JiBXException {
        block2: {
            if ("java.lang.String".equals(this.m_typeName)) break block2;
            this.m_needSerialize = true;
            this.m_needDeserialize = !"java.lang.Object".equals(this.m_typeName);
            try {
                ClassFile classFile = ClassCache.getInstance().getClass(this.m_typeName, false);
                this.m_initFromString = classFile.getInitializerMethod(FROMSTRING_SIGNATURE);
                this.m_instToString = classFile.getMethod(TOSTRING_METHOD, TOSTRING_SIGNATURE);
            }
            catch (JiBXException jiBXException) {}
        }
    }

    protected void genDeserialize(UnmarshalBuilder unmarshalBuilder) throws JiBXException {
        if (this.m_deserializer != null) {
            unmarshalBuilder.addMethodExceptions(this.m_deserializer);
            unmarshalBuilder.appendCallStatic(this.m_deserializer);
        } else if (this.m_needDeserialize) {
            if (this.m_initFromString == null) {
                throw new JiBXException("No deserializer for " + this.m_typeName + "; define deserializer or constructor from String");
            }
            unmarshalBuilder.appendCreateNew(this.m_typeName);
            unmarshalBuilder.append((Instruction)InstructionConstants.DUP_X1);
            unmarshalBuilder.append((Instruction)InstructionConstants.SWAP);
            unmarshalBuilder.addMethodExceptions(this.m_initFromString);
            unmarshalBuilder.appendCallInit(this.m_typeName, FROMSTRING_SIGNATURE);
        }
    }

    public void genParseOptional(boolean bl, UnmarshalBuilder unmarshalBuilder) throws JiBXException {
        unmarshalBuilder.appendLoadConstant((String)this.m_default);
        String string = bl ? "org.jibx.runtime.impl.UnmarshallingContext.attributeText" : "org.jibx.runtime.impl.UnmarshallingContext.parseElementText";
        unmarshalBuilder.appendCallVirtual(string, "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        this.genDeserialize(unmarshalBuilder);
    }

    public void genParseRequired(boolean bl, UnmarshalBuilder unmarshalBuilder) throws JiBXException {
        String string = bl ? "org.jibx.runtime.impl.UnmarshallingContext.attributeText" : "org.jibx.runtime.impl.UnmarshallingContext.parseElementText";
        unmarshalBuilder.appendCallVirtual(string, "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        this.genDeserialize(unmarshalBuilder);
    }

    protected void genSerialize(String string, MarshalBuilder marshalBuilder) throws JiBXException {
        if (this.m_serializer != null) {
            marshalBuilder.appendCreateCast(string, this.m_serializer.getArgumentType(0));
            marshalBuilder.addMethodExceptions(this.m_serializer);
            marshalBuilder.appendCallStatic(this.m_serializer);
        } else if (this.m_needSerialize) {
            if (this.m_instToString == null) {
                throw new JiBXException("No serializer for " + this.m_typeName + "; define serializer or toString() method");
            }
            marshalBuilder.addMethodExceptions(this.m_instToString);
            marshalBuilder.appendCallVirtual(this.m_instToString);
        }
    }

    public void genWriteOptional(boolean bl, String string, MarshalBuilder marshalBuilder) throws JiBXException {
        marshalBuilder.append((Instruction)InstructionConstants.DUP);
        BranchHandle branchHandle = marshalBuilder.append((BranchInstruction)new IFNULL(null));
        this.genSerialize(string, marshalBuilder);
        BranchHandle branchHandle2 = null;
        if (this.m_default != null) {
            marshalBuilder.append((Instruction)InstructionConstants.DUP);
            marshalBuilder.appendLoadConstant((String)this.m_default);
            marshalBuilder.appendCallStatic("org.jibx.runtime.Utility.isEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z");
            branchHandle2 = marshalBuilder.append((BranchInstruction)new IFNE(null));
        }
        String string2 = bl ? "org.jibx.runtime.impl.MarshallingContext.attribute" : "org.jibx.runtime.impl.MarshallingContext.textElement";
        marshalBuilder.appendCallVirtual(string2, "(ILjava/lang/String;Ljava/lang/String;)Lorg/jibx/runtime/impl/MarshallingContext;");
        BranchHandle branchHandle3 = marshalBuilder.append((BranchInstruction)new GOTO(null));
        InstructionHandle instructionHandle = marshalBuilder.append((Instruction)InstructionConstants.POP);
        branchHandle.setTarget(instructionHandle);
        if (branchHandle2 != null) {
            branchHandle2.setTarget(instructionHandle);
        }
        marshalBuilder.append((Instruction)InstructionConstants.POP2);
        marshalBuilder.targetNext(branchHandle3);
    }

    public void genWriteRequired(boolean bl, String string, MarshalBuilder marshalBuilder) throws JiBXException {
        this.genSerialize(string, marshalBuilder);
        String string2 = bl ? "org.jibx.runtime.impl.MarshallingContext.attribute" : "org.jibx.runtime.impl.MarshallingContext.textElement";
        marshalBuilder.appendCallVirtual(string2, "(ILjava/lang/String;Ljava/lang/String;)Lorg/jibx/runtime/impl/MarshallingContext;");
    }

    public boolean isPrimitive() {
        return false;
    }

    protected Object convertDefault(String string) throws JiBXException {
        return string;
    }

    public StringConversion derive(String string, String string2, String string3, String string4) throws JiBXException {
        if (string == null) {
            string = this.m_typeName;
        }
        ObjectStringConversion objectStringConversion = new ObjectStringConversion(string, this);
        if (string2 != null) {
            objectStringConversion.setSerializer(string2);
        }
        if (string3 != null) {
            objectStringConversion.setDeserializer(string3);
        }
        if (string4 != null) {
            objectStringConversion.m_default = ((StringConversion)objectStringConversion).convertDefault(string4);
        }
        return objectStringConversion;
    }
}

