/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.def.ArrayMap;
import org.jibx.binding.def.BindingConstants;
import org.jibx.binding.def.IParent;
import org.jibx.binding.def.MappingDefinition;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.StringConversion;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;

public class DefinitionContext
implements BindingConstants {
    protected IParent m_parent;
    protected DefinitionContext m_wrappingContext;
    protected boolean m_isAllowNamespaces;
    protected NamespaceDefinition m_attributeDefault;
    protected NamespaceDefinition m_elementDefault;
    protected ArrayList m_namespaces;
    protected HashMap m_prefixMap;
    protected HashMap m_uriMap;
    protected ArrayMap m_classMap;
    protected ArrayList m_mappings;
    protected boolean m_referenceSeen;
    protected boolean[] m_referenceFlags;
    protected int[] m_generateOrder;
    protected HashMap m_convertMap;
    protected HashMap m_formatMap;

    public DefinitionContext(IParent iParent, DefinitionContext definitionContext, boolean bl) {
        this.m_parent = iParent;
        this.m_wrappingContext = definitionContext;
        this.m_convertMap = new HashMap();
        this.m_formatMap = new HashMap();
        this.m_isAllowNamespaces = bl;
    }

    public void addNamespace(NamespaceDefinition namespaceDefinition) throws JiBXException {
        String string;
        if (this.m_namespaces == null) {
            this.m_namespaces = new ArrayList();
            this.m_prefixMap = new HashMap();
            this.m_uriMap = new HashMap();
        }
        if (namespaceDefinition.isAttributeDefault()) {
            if (this.m_attributeDefault == null) {
                this.m_attributeDefault = namespaceDefinition;
            } else {
                throw new JiBXException("Multiple default attribute namespaces at level");
            }
        }
        if (namespaceDefinition.isElementDefault()) {
            if (this.m_elementDefault == null) {
                this.m_elementDefault = namespaceDefinition;
            } else {
                throw new JiBXException("Multiple default element namespaces at level");
            }
        }
        if (this.m_prefixMap.get(string = namespaceDefinition.getPrefix()) != null) {
            throw new JiBXException("Namespace prefix conflict");
        }
        String string2 = namespaceDefinition.getUri();
        Object v = this.m_uriMap.get(string2);
        if (v != null && ((NamespaceDefinition)v).getPrefix() != null) {
            return;
        }
        namespaceDefinition.setIndex(this.m_parent.getBindingRoot().getNamespaceUriIndex(namespaceDefinition.getUri()));
        this.m_namespaces.add(namespaceDefinition);
        this.m_prefixMap.put(string, namespaceDefinition);
        this.m_uriMap.put(string2, namespaceDefinition);
    }

    public void addMapping(MappingDefinition mappingDefinition) throws JiBXException {
        int n;
        if (this.m_mappings == null) {
            this.m_classMap = new ArrayMap();
            this.m_mappings = new ArrayList();
        }
        if ((n = this.m_classMap.findOrAdd(mappingDefinition.getClassName())) < this.m_mappings.size()) {
            throw new JiBXException("Conflicting mappings for class " + mappingDefinition.getClassName());
        }
        this.m_mappings.add(mappingDefinition);
    }

    private NamespaceDefinition getDefaultNamespace(boolean bl) {
        NamespaceDefinition namespaceDefinition = bl ? this.m_attributeDefault : this.m_elementDefault;
        if (namespaceDefinition == null && this.m_wrappingContext != null) {
            namespaceDefinition = this.m_wrappingContext.getDefaultNamespace(bl);
        }
        return namespaceDefinition;
    }

    public String getDefaultURI(boolean bl) {
        NamespaceDefinition namespaceDefinition = this.getDefaultNamespace(bl);
        if (namespaceDefinition == null) {
            return null;
        }
        return namespaceDefinition.getUri();
    }

    public int getDefaultIndex(boolean bl) {
        NamespaceDefinition namespaceDefinition = this.getDefaultNamespace(bl);
        if (namespaceDefinition == null) {
            return 0;
        }
        return namespaceDefinition.getIndex();
    }

    public int getNamespaceIndex(String string, boolean bl) throws JiBXException {
        Object v = this.m_uriMap.get(string);
        if (!(v == null || bl && ((NamespaceDefinition)v).getPrefix() == null)) {
            return ((NamespaceDefinition)v).getIndex();
        }
        if (this.m_wrappingContext == null) {
            throw new JiBXException("Namespace URI \"" + string + "\" not defined or not usable");
        }
        return this.m_wrappingContext.getNamespaceIndex(string, bl);
    }

    public MappingDefinition getClassMapping(String string) throws JiBXException {
        Object var2_2 = null;
        if (this.m_classMap != null) {
            if (this.m_referenceFlags == null) {
                throw new IllegalStateException("Map access outside of linkage phase");
            }
            int n = this.m_classMap.find(string);
            if (n >= 0) {
                this.m_referenceSeen = true;
                this.m_referenceFlags[n] = true;
                return (MappingDefinition)this.m_mappings.get(n);
            }
        }
        if (this.m_wrappingContext == null) {
            throw new JiBXException("Mapping for class " + string + " not defined");
        }
        return this.m_wrappingContext.getClassMapping(string);
    }

    public ArrayList getMappings() {
        return this.m_mappings;
    }

    public StringConversion getSpecificConversion(String string) {
        StringConversion stringConversion = (StringConversion)this.m_convertMap.get(string);
        if (stringConversion == null && this.m_wrappingContext != null) {
            stringConversion = this.m_wrappingContext.getSpecificConversion(string);
        }
        return stringConversion;
    }

    public StringConversion getConversion(ClassFile classFile) {
        StringConversion stringConversion;
        while ((stringConversion = this.getSpecificConversion(classFile.getName())) == null) {
            classFile = classFile.getSuperFile();
        }
        return stringConversion;
    }

    public StringConversion getNamedConversion(String string) {
        StringConversion stringConversion = (StringConversion)this.m_formatMap.get(string);
        if (stringConversion == null && this.m_wrappingContext != null) {
            stringConversion = this.m_wrappingContext.getNamedConversion(string);
        }
        return stringConversion;
    }

    public void addConversion(String string, StringConversion stringConversion) throws JiBXException {
        if (this.m_formatMap.put(string, stringConversion) != null) {
            throw new JiBXException("Duplicate conversion defined with name " + string);
        }
    }

    public void setConversion(StringConversion stringConversion) throws JiBXException {
        if (this.m_convertMap.put(stringConversion.getTypeName(), stringConversion) != null) {
            throw new JiBXException("Duplicate conversion defined for type " + stringConversion.getTypeName());
        }
    }

    public void setNamedConversion(String string, StringConversion stringConversion) throws JiBXException {
        this.addConversion(string, stringConversion);
        this.setConversion(stringConversion);
    }

    public boolean hasNamespace(boolean bl) {
        if (this.m_namespaces != null && this.m_namespaces.size() > 0) {
            return true;
        }
        if (bl) {
            ArrayList arrayList = this.m_wrappingContext.m_namespaces;
            return arrayList != null && arrayList.size() > 0;
        }
        return false;
    }

    private int genFillNamespaceIndexes(ArrayList arrayList, int n, MethodBuilder methodBuilder) throws JiBXException {
        if (arrayList != null) {
            int n2 = 0;
            while (n2 < arrayList.size()) {
                methodBuilder.append((Instruction)InstructionConstants.DUP);
                methodBuilder.appendLoadConstant(n++);
                methodBuilder.appendLoadConstant(((NamespaceDefinition)arrayList.get(n2)).getIndex());
                methodBuilder.append((Instruction)InstructionConstants.IASTORE);
                ++n2;
            }
        }
        return n;
    }

    private int genFillNamespacePrefixes(ArrayList arrayList, int n, MethodBuilder methodBuilder) throws JiBXException {
        if (arrayList != null) {
            int n2 = 0;
            while (n2 < arrayList.size()) {
                methodBuilder.append((Instruction)InstructionConstants.DUP);
                methodBuilder.appendLoadConstant(n++);
                String string = ((NamespaceDefinition)arrayList.get(n2)).getPrefix();
                string = string == null ? "" : string + ":";
                methodBuilder.appendLoadConstant(string);
                methodBuilder.append((Instruction)InstructionConstants.AASTORE);
                ++n2;
            }
        }
        return n;
    }

    public void genLoadNamespaces(MethodBuilder methodBuilder, boolean bl) throws JiBXException {
        int n = this.m_namespaces == null ? 0 : this.m_namespaces.size();
        ArrayList arrayList = null;
        if (bl && (arrayList = this.m_wrappingContext.m_namespaces) != null) {
            n += arrayList.size();
        }
        methodBuilder.appendLoadConstant(n);
        methodBuilder.appendCreateArray("int");
        int n2 = this.genFillNamespaceIndexes(this.m_namespaces, 0, methodBuilder);
        this.genFillNamespaceIndexes(arrayList, n2, methodBuilder);
        methodBuilder.appendLoadConstant(n);
        methodBuilder.appendCreateArray("java.lang.String");
        n2 = this.genFillNamespacePrefixes(this.m_namespaces, 0, methodBuilder);
        this.genFillNamespacePrefixes(arrayList, n2, methodBuilder);
    }

    public void generateCode() throws JiBXException {
        if (this.m_mappings != null) {
            int n = 0;
            while (n < this.m_generateOrder.length) {
                int n2 = this.m_generateOrder[n];
                ((MappingDefinition)this.m_mappings.get(n2)).generateCode();
                ++n;
            }
        }
    }

    public void unmarshal(UnmarshallingContext unmarshallingContext) throws JiBXException {
        Object object;
        if (this.m_isAllowNamespaces) {
            while (unmarshallingContext.isAt(BindingConstants.URI_ELEMENTS, "namespace")) {
                object = new NamespaceDefinition();
                ((NamespaceDefinition)object).unmarshal(unmarshallingContext);
                this.addNamespace((NamespaceDefinition)object);
            }
        } else if (unmarshallingContext.isAt(BindingConstants.URI_ELEMENTS, "namespace")) {
            unmarshallingContext.throwException("Namespace definitions not allowed in this context");
        }
        while (unmarshallingContext.isAt(BindingConstants.URI_ELEMENTS, "format")) {
            Object object2;
            object = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "type");
            String string = Utility.getSignature((String)object);
            StringConversion stringConversion = null;
            if (string.length() == 1) {
                stringConversion = this.getSpecificConversion((String)object);
                if (stringConversion == null) {
                    unmarshallingContext.throwStartTagException("Unsupported \"type\" value");
                }
            } else {
                object2 = ClassCache.getInstance().getClass((String)object, false);
                stringConversion = this.getConversion((ClassFile)object2);
            }
            object2 = stringConversion.derive((String)object, null, null, null);
            ((StringConversion)object2).unmarshal(unmarshallingContext);
            String string2 = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "name", null);
            if (string2 == null) {
                this.setConversion((StringConversion)object2);
            } else if (this.m_formatMap.put(string2, object2) != null) {
                unmarshallingContext.throwStartTagException("Multiple definitions with \"name\" values of \"" + string2 + "\"");
            }
            unmarshallingContext.parsePastEndTag(BindingConstants.URI_ELEMENTS, "format");
        }
        while (unmarshallingContext.isAt(BindingConstants.URI_ELEMENTS, "mapping")) {
            object = new MappingDefinition(this.m_parent);
            ((MappingDefinition)object).unmarshal(unmarshallingContext);
            this.addMapping((MappingDefinition)object);
        }
    }

    public void setLinkages() throws JiBXException {
        if (this.m_mappings != null) {
            int n;
            int n2 = this.m_mappings.size();
            boolean[][] blArrayArray = new boolean[n2][];
            boolean[] blArray = new boolean[n2];
            this.m_generateOrder = new int[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                this.m_referenceFlags = new boolean[n2];
                this.m_referenceSeen = false;
                MappingDefinition mappingDefinition = (MappingDefinition)this.m_mappings.get(n4);
                mappingDefinition.setLinkages();
                n = 1;
                if (this.m_referenceSeen) {
                    int n5 = 0;
                    while (n5 < n2) {
                        if (this.m_referenceFlags[n5]) {
                            if (n5 == n4) {
                                throw new JiBXException("Child of mapping for class " + mappingDefinition.getClassName() + " cannot reference that mapping");
                            }
                            if (!blArray[n5]) {
                                n = 0;
                                break;
                            }
                        }
                        ++n5;
                    }
                }
                if (n != 0) {
                    this.m_generateOrder[n3++] = n4;
                    blArray[n4] = true;
                } else {
                    blArrayArray[n4] = this.m_referenceFlags;
                }
                ++n4;
            }
            boolean bl = true;
            while (n3 < n2 && bl) {
                bl = false;
                n = 0;
                while (n < n2) {
                    if (!blArray[n]) {
                        boolean[] blArray2 = blArrayArray[n];
                        boolean bl2 = true;
                        int n6 = 0;
                        while (n6 < n2) {
                            if (blArray2[n6] && !blArray[n6]) {
                                bl2 = false;
                                break;
                            }
                            ++n6;
                        }
                        if (bl2) {
                            this.m_generateOrder[n3++] = n;
                            blArray[n] = true;
                            bl = true;
                        }
                    }
                    ++n;
                }
            }
            if (!bl) {
                throw new JiBXException("Circular mapping dependency now allowed");
            }
        }
    }
}

