/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.util.ArrayList;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BindingMethod;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.InstructionBuilder;
import org.jibx.runtime.JiBXException;

public abstract class MethodBuilder
extends BindingMethod {
    protected static final String FRAMEWORK_EXCEPTION_CLASS = "org.jibx.runtime.JiBXException";
    protected static ArrayList s_argNameLists = new ArrayList();
    protected InstructionBuilder m_instructionBuilder;
    protected InstructionList m_instructionList;
    protected MethodGen m_generator;
    protected Method m_method;
    protected ClassItem m_item;
    protected ArrayList m_exceptions;
    protected ArrayList m_locals;
    protected int m_hashCode;
    protected BranchHandle m_targetBranch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected MethodBuilder(String string, Type type, Type[] typeArray, ClassFile classFile, short s) throws JiBXException {
        super(classFile);
        String[] stringArray;
        if (typeArray.length >= s_argNameLists.size()) {
            stringArray = s_argNameLists;
            // MONITORENTER : s_argNameLists
            int n = s_argNameLists.size();
            while (n <= typeArray.length) {
                String[] stringArray2 = new String[n];
                if (n > 0) {
                    Object e = s_argNameLists.get(n - 1);
                    System.arraycopy(e, 0, stringArray2, 0, n - 1);
                    stringArray2[n - 1] = "arg" + n;
                }
                s_argNameLists.add(stringArray2);
                ++n;
            }
            // MONITOREXIT : stringArray
        }
        stringArray = (String[])s_argNameLists.get(typeArray.length);
        this.m_instructionList = new InstructionList();
        this.m_instructionBuilder = classFile.getInstructionBuilder();
        this.m_generator = new MethodGen((int)s, type, typeArray, stringArray, string, classFile.getName(), this.m_instructionList, classFile.getConstPoolGen());
    }

    public String getName() {
        return this.m_generator.getName();
    }

    public String getSignature() {
        return this.m_generator.getSignature();
    }

    public int getAccessFlags() {
        return this.m_generator.getAccessFlags();
    }

    public void setAccessFlags(int n) {
        this.m_generator.setAccessFlags(n);
    }

    public Method getMethod() {
        if (this.m_method == null) {
            throw new IllegalStateException("Method still under construction");
        }
        return this.m_method;
    }

    public void addException(String string) {
        if (this.m_exceptions == null) {
            this.m_exceptions = new ArrayList();
        }
        if (!this.m_exceptions.contains(string)) {
            this.m_exceptions.add(string);
        }
    }

    public void addMethodExceptions(ClassItem classItem) {
        String[] stringArray = classItem.getExceptions();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.addException(stringArray[n]);
                ++n;
            }
        }
    }

    public InstructionHandle getFirstInstruction() {
        return this.m_instructionList.getStart();
    }

    public InstructionHandle getLastInstruction() {
        return this.m_instructionList.getEnd();
    }

    protected final void setTarget(InstructionHandle instructionHandle) {
        if (this.m_targetBranch != null) {
            this.m_targetBranch.setTarget(instructionHandle);
            this.m_targetBranch = null;
        }
    }

    public BranchHandle append(BranchInstruction branchInstruction) {
        BranchHandle branchHandle = this.m_instructionList.append(branchInstruction);
        this.setTarget((InstructionHandle)branchHandle);
        return branchHandle;
    }

    public InstructionHandle append(CompoundInstruction compoundInstruction) {
        InstructionHandle instructionHandle = this.m_instructionList.append(compoundInstruction);
        this.setTarget(instructionHandle);
        return instructionHandle;
    }

    public InstructionHandle append(Instruction instruction) {
        InstructionHandle instructionHandle = this.m_instructionList.append(instruction);
        this.setTarget(instructionHandle);
        return instructionHandle;
    }

    public InstructionHandle appendLoadConstant(int n) {
        return this.append(this.m_instructionBuilder.createLoadConstant(n));
    }

    public InstructionHandle appendLoadConstant(String string) {
        return this.append(this.m_instructionBuilder.createLoadConstant(string));
    }

    public InstructionHandle appendLoadConstant(Object object) {
        return this.append(this.m_instructionBuilder.createLoadConstant(object));
    }

    public InstructionHandle appendGetField(ClassItem classItem) {
        return this.append((Instruction)this.m_instructionBuilder.createGetField(classItem));
    }

    public InstructionHandle appendPutField(ClassItem classItem) {
        return this.append((Instruction)this.m_instructionBuilder.createPutField(classItem));
    }

    public InstructionHandle appendGetStatic(ClassItem classItem) {
        return this.append((Instruction)this.m_instructionBuilder.createGetStatic(classItem));
    }

    public InstructionHandle appendPutStatic(ClassItem classItem) {
        return this.append((Instruction)this.m_instructionBuilder.createPutStatic(classItem));
    }

    public InstructionHandle appendCallStatic(ClassItem classItem) {
        return this.append((Instruction)this.m_instructionBuilder.createCallStatic(classItem));
    }

    public InstructionHandle appendCallVirtual(ClassItem classItem) {
        return this.append((Instruction)this.m_instructionBuilder.createCallVirtual(classItem));
    }

    public InstructionHandle appendCallStatic(String string, String string2) {
        return this.append((Instruction)this.m_instructionBuilder.createCallStatic(string, string2));
    }

    public InstructionHandle appendCallVirtual(String string, String string2) {
        return this.append((Instruction)this.m_instructionBuilder.createCallVirtual(string, string2));
    }

    public InstructionHandle appendCallInterface(String string, String string2) {
        return this.append((Instruction)this.m_instructionBuilder.createCallInterface(string, string2));
    }

    public InstructionHandle appendCreateNew(String string) {
        return this.append((Instruction)this.m_instructionBuilder.createNew(string));
    }

    public InstructionHandle appendCallInit(String string, String string2) {
        return this.append((Instruction)this.m_instructionBuilder.createCallInit(string, string2));
    }

    public InstructionHandle appendCreateArray(String string) {
        if (ClassItem.isPrimitive(string)) {
            String string2 = Utility.getSignature((String)string);
            return this.append((Instruction)new NEWARRAY(Utility.typeOfSignature((String)string2)));
        }
        return this.append((Instruction)new ANEWARRAY(this.m_instructionBuilder.getConstantPoolGen().addClass(string)));
    }

    public InstructionHandle appendCreateCast(String string, String string2) {
        return this.append(this.m_instructionBuilder.createCast((Type)new ObjectType(string), (Type)new ObjectType(string2)));
    }

    public InstructionHandle appendCreateCast(String string) {
        return this.append(this.m_instructionBuilder.createCast((Type)Type.OBJECT, (Type)new ObjectType(string)));
    }

    public int addLocal(String string, Type type) {
        if (this.m_locals == null) {
            this.m_locals = new ArrayList();
        }
        LocalVariableGen localVariableGen = this.m_generator.addLocalVariable(string, type, this.getLastInstruction(), null);
        this.m_locals.add(localVariableGen);
        this.append((Instruction)InstructionFactory.createStore((Type)type, (int)localVariableGen.getIndex()));
        return localVariableGen.getIndex();
    }

    public void targetNext(BranchHandle branchHandle) {
        if (this.m_targetBranch != null) {
            throw new IllegalStateException("Attempt to target multiple branches");
        }
        this.m_targetBranch = branchHandle;
    }

    protected abstract void handleExceptions() throws JiBXException;

    public void codeComplete() throws JiBXException {
        if (this.m_targetBranch != null) {
            throw new IllegalStateException("Method complete with pending branch target");
        }
        if (this.m_locals != null) {
            InstructionHandle instructionHandle = this.getLastInstruction();
            int n = 0;
            while (n < this.m_locals.size()) {
                ((LocalVariableGen)this.m_locals.get(n)).setEnd(instructionHandle);
                ++n;
            }
        }
        if (this.m_exceptions != null) {
            this.handleExceptions();
        }
        this.m_generator.setMaxStack();
        this.m_generator.setMaxLocals();
        this.m_instructionList.setPositions(true);
        this.m_method = this.m_generator.getMethod();
        this.m_instructionList.dispose();
        this.m_hashCode = BindingMethod.computeMethodHash(this.m_method);
    }

    public ClassItem getItem() {
        if (this.m_item == null) {
            throw new IllegalStateException("Method not added to class");
        }
        return this.m_item;
    }

    public int hashCode() {
        if (this.m_method == null) {
            throw new IllegalStateException("Method still under construction");
        }
        return this.m_hashCode;
    }

    public ClassItem addMethod() throws JiBXException {
        if (this.m_method == null) {
            throw new IllegalStateException("Method not finalized.");
        }
        this.m_classFile.getClassGen().addMethod(this.m_method);
        this.m_classFile.setModified();
        this.m_item = new ClassItem(this.m_method.getName(), this.m_classFile, (FieldOrMethod)this.m_method);
        return this.m_item;
    }
}

